/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.riskdef;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.riskdef.PricingMethod;
import fpml.consolidated.riskdef.PricingStructureValuation;
import fpml.consolidated.riskdef.QuotedAssetSet;
import fpml.consolidated.riskdef.meta.MarketMeta;
import fpml.consolidated.shared.PricingStructure;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Market", builder=MarketBuilderImpl.class, version="1.2.2")
@RuneDataType(value="Market", model="fpml", builder=MarketBuilderImpl.class, version="1.2.2")
public interface Market
extends RosettaModelObject {
    public static final MarketMeta metaData = new MarketMeta();

    public String getName();

    public QuotedAssetSet getBenchmarkQuotes();

    public List<? extends PricingStructure> getPricingStructure();

    public List<? extends PricingStructureValuation> getPricingStructureValuation();

    public List<? extends PricingMethod> getBenchmarkPricingMethod();

    public String getId();

    public Market build();

    public MarketBuilder toBuilder();

    public static MarketBuilder builder() {
        return new MarketBuilderImpl();
    }

    default public RosettaMetaData<? extends Market> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Market> getType() {
        return Market.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("benchmarkQuotes"), processor, QuotedAssetSet.class, this.getBenchmarkQuotes(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("pricingStructure"), processor, PricingStructure.class, this.getPricingStructure(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("pricingStructureValuation"), processor, PricingStructureValuation.class, this.getPricingStructureValuation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("benchmarkPricingMethod"), processor, PricingMethod.class, this.getBenchmarkPricingMethod(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class MarketBuilderImpl
    implements MarketBuilder {
        protected String name;
        protected QuotedAssetSet.QuotedAssetSetBuilder benchmarkQuotes;
        protected List<PricingStructure.PricingStructureBuilder> pricingStructure = new ArrayList<PricingStructure.PricingStructureBuilder>();
        protected List<PricingStructureValuation.PricingStructureValuationBuilder> pricingStructureValuation = new ArrayList<PricingStructureValuation.PricingStructureValuationBuilder>();
        protected List<PricingMethod.PricingMethodBuilder> benchmarkPricingMethod = new ArrayList<PricingMethod.PricingMethodBuilder>();
        protected String id;

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public String getName() {
            return this.name;
        }

        @Override
        @RosettaAttribute(value="benchmarkQuotes")
        @RuneAttribute(value="benchmarkQuotes")
        public QuotedAssetSet.QuotedAssetSetBuilder getBenchmarkQuotes() {
            return this.benchmarkQuotes;
        }

        @Override
        public QuotedAssetSet.QuotedAssetSetBuilder getOrCreateBenchmarkQuotes() {
            QuotedAssetSet.QuotedAssetSetBuilder result = this.benchmarkQuotes != null ? this.benchmarkQuotes : (this.benchmarkQuotes = QuotedAssetSet.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="pricingStructure")
        @RuneAttribute(value="pricingStructure")
        public List<? extends PricingStructure.PricingStructureBuilder> getPricingStructure() {
            return this.pricingStructure;
        }

        @Override
        public PricingStructure.PricingStructureBuilder getOrCreatePricingStructure(int index) {
            if (this.pricingStructure == null) {
                this.pricingStructure = new ArrayList<PricingStructure.PricingStructureBuilder>();
            }
            return (PricingStructure.PricingStructureBuilder)this.getIndex(this.pricingStructure, index, () -> {
                PricingStructure.PricingStructureBuilder newPricingStructure = PricingStructure.builder();
                return newPricingStructure;
            });
        }

        @Override
        @RosettaAttribute(value="pricingStructureValuation")
        @RuneAttribute(value="pricingStructureValuation")
        public List<? extends PricingStructureValuation.PricingStructureValuationBuilder> getPricingStructureValuation() {
            return this.pricingStructureValuation;
        }

        @Override
        public PricingStructureValuation.PricingStructureValuationBuilder getOrCreatePricingStructureValuation(int index) {
            if (this.pricingStructureValuation == null) {
                this.pricingStructureValuation = new ArrayList<PricingStructureValuation.PricingStructureValuationBuilder>();
            }
            return (PricingStructureValuation.PricingStructureValuationBuilder)this.getIndex(this.pricingStructureValuation, index, () -> {
                PricingStructureValuation.PricingStructureValuationBuilder newPricingStructureValuation = PricingStructureValuation.builder();
                return newPricingStructureValuation;
            });
        }

        @Override
        @RosettaAttribute(value="benchmarkPricingMethod")
        @RuneAttribute(value="benchmarkPricingMethod")
        public List<? extends PricingMethod.PricingMethodBuilder> getBenchmarkPricingMethod() {
            return this.benchmarkPricingMethod;
        }

        @Override
        public PricingMethod.PricingMethodBuilder getOrCreateBenchmarkPricingMethod(int index) {
            if (this.benchmarkPricingMethod == null) {
                this.benchmarkPricingMethod = new ArrayList<PricingMethod.PricingMethodBuilder>();
            }
            return (PricingMethod.PricingMethodBuilder)this.getIndex(this.benchmarkPricingMethod, index, () -> {
                PricingMethod.PricingMethodBuilder newBenchmarkPricingMethod = PricingMethod.builder();
                return newBenchmarkPricingMethod;
            });
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public MarketBuilder setName(String _name) {
            this.name = _name == null ? null : _name;
            return this;
        }

        @Override
        @RosettaAttribute(value="benchmarkQuotes")
        @RuneAttribute(value="benchmarkQuotes")
        public MarketBuilder setBenchmarkQuotes(QuotedAssetSet _benchmarkQuotes) {
            this.benchmarkQuotes = _benchmarkQuotes == null ? null : _benchmarkQuotes.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="pricingStructure")
        @RuneAttribute(value="pricingStructure")
        public MarketBuilder addPricingStructure(PricingStructure _pricingStructure) {
            if (_pricingStructure != null) {
                this.pricingStructure.add(_pricingStructure.toBuilder());
            }
            return this;
        }

        @Override
        public MarketBuilder addPricingStructure(PricingStructure _pricingStructure, int idx) {
            this.getIndex(this.pricingStructure, idx, () -> _pricingStructure.toBuilder());
            return this;
        }

        @Override
        public MarketBuilder addPricingStructure(List<? extends PricingStructure> pricingStructures) {
            if (pricingStructures != null) {
                for (PricingStructure pricingStructure : pricingStructures) {
                    this.pricingStructure.add(pricingStructure.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="pricingStructure")
        public MarketBuilder setPricingStructure(List<? extends PricingStructure> pricingStructures) {
            this.pricingStructure = pricingStructures == null ? new ArrayList<PricingStructure.PricingStructureBuilder>() : (List)pricingStructures.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="pricingStructureValuation")
        @RuneAttribute(value="pricingStructureValuation")
        public MarketBuilder addPricingStructureValuation(PricingStructureValuation _pricingStructureValuation) {
            if (_pricingStructureValuation != null) {
                this.pricingStructureValuation.add(_pricingStructureValuation.toBuilder());
            }
            return this;
        }

        @Override
        public MarketBuilder addPricingStructureValuation(PricingStructureValuation _pricingStructureValuation, int idx) {
            this.getIndex(this.pricingStructureValuation, idx, () -> _pricingStructureValuation.toBuilder());
            return this;
        }

        @Override
        public MarketBuilder addPricingStructureValuation(List<? extends PricingStructureValuation> pricingStructureValuations) {
            if (pricingStructureValuations != null) {
                for (PricingStructureValuation pricingStructureValuation : pricingStructureValuations) {
                    this.pricingStructureValuation.add(pricingStructureValuation.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="pricingStructureValuation")
        public MarketBuilder setPricingStructureValuation(List<? extends PricingStructureValuation> pricingStructureValuations) {
            this.pricingStructureValuation = pricingStructureValuations == null ? new ArrayList<PricingStructureValuation.PricingStructureValuationBuilder>() : (List)pricingStructureValuations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="benchmarkPricingMethod")
        @RuneAttribute(value="benchmarkPricingMethod")
        public MarketBuilder addBenchmarkPricingMethod(PricingMethod _benchmarkPricingMethod) {
            if (_benchmarkPricingMethod != null) {
                this.benchmarkPricingMethod.add(_benchmarkPricingMethod.toBuilder());
            }
            return this;
        }

        @Override
        public MarketBuilder addBenchmarkPricingMethod(PricingMethod _benchmarkPricingMethod, int idx) {
            this.getIndex(this.benchmarkPricingMethod, idx, () -> _benchmarkPricingMethod.toBuilder());
            return this;
        }

        @Override
        public MarketBuilder addBenchmarkPricingMethod(List<? extends PricingMethod> benchmarkPricingMethods) {
            if (benchmarkPricingMethods != null) {
                for (PricingMethod pricingMethod : benchmarkPricingMethods) {
                    this.benchmarkPricingMethod.add(pricingMethod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="benchmarkPricingMethod")
        public MarketBuilder setBenchmarkPricingMethod(List<? extends PricingMethod> benchmarkPricingMethods) {
            this.benchmarkPricingMethod = benchmarkPricingMethods == null ? new ArrayList<PricingMethod.PricingMethodBuilder>() : (List)benchmarkPricingMethods.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public MarketBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        public Market build() {
            return new MarketImpl(this);
        }

        @Override
        public MarketBuilder toBuilder() {
            return this;
        }

        @Override
        public MarketBuilder prune() {
            if (this.benchmarkQuotes != null && !this.benchmarkQuotes.prune().hasData()) {
                this.benchmarkQuotes = null;
            }
            this.pricingStructure = this.pricingStructure.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.pricingStructureValuation = this.pricingStructureValuation.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.benchmarkPricingMethod = this.benchmarkPricingMethod.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getName() != null) {
                return true;
            }
            if (this.getBenchmarkQuotes() != null && this.getBenchmarkQuotes().hasData()) {
                return true;
            }
            if (this.getPricingStructure() != null && this.getPricingStructure().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPricingStructureValuation() != null && this.getPricingStructureValuation().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getBenchmarkPricingMethod() != null && this.getBenchmarkPricingMethod().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getId() != null;
        }

        public MarketBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            MarketBuilder o = (MarketBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBenchmarkQuotes(), (RosettaModelObjectBuilder)o.getBenchmarkQuotes(), this::setBenchmarkQuotes);
            merger.mergeRosetta(this.getPricingStructure(), o.getPricingStructure(), this::getOrCreatePricingStructure);
            merger.mergeRosetta(this.getPricingStructureValuation(), o.getPricingStructureValuation(), this::getOrCreatePricingStructureValuation);
            merger.mergeRosetta(this.getBenchmarkPricingMethod(), o.getBenchmarkPricingMethod(), this::getOrCreateBenchmarkPricingMethod);
            merger.mergeBasic((Object)this.getName(), (Object)o.getName(), this::setName, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Market _that = this.getType().cast(o);
            if (!Objects.equals(this.name, _that.getName())) {
                return false;
            }
            if (!Objects.equals(this.benchmarkQuotes, _that.getBenchmarkQuotes())) {
                return false;
            }
            if (!ListEquals.listEquals(this.pricingStructure, _that.getPricingStructure())) {
                return false;
            }
            if (!ListEquals.listEquals(this.pricingStructureValuation, _that.getPricingStructureValuation())) {
                return false;
            }
            if (!ListEquals.listEquals(this.benchmarkPricingMethod, _that.getBenchmarkPricingMethod())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            _result = 31 * _result + (this.benchmarkQuotes != null ? this.benchmarkQuotes.hashCode() : 0);
            _result = 31 * _result + (this.pricingStructure != null ? this.pricingStructure.hashCode() : 0);
            _result = 31 * _result + (this.pricingStructureValuation != null ? this.pricingStructureValuation.hashCode() : 0);
            _result = 31 * _result + (this.benchmarkPricingMethod != null ? this.benchmarkPricingMethod.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "MarketBuilder {name=" + this.name + ", benchmarkQuotes=" + String.valueOf(this.benchmarkQuotes) + ", pricingStructure=" + String.valueOf(this.pricingStructure) + ", pricingStructureValuation=" + String.valueOf(this.pricingStructureValuation) + ", benchmarkPricingMethod=" + String.valueOf(this.benchmarkPricingMethod) + ", id=" + this.id + "}";
        }
    }

    public static interface MarketBuilder
    extends Market,
    RosettaModelObjectBuilder {
        public QuotedAssetSet.QuotedAssetSetBuilder getOrCreateBenchmarkQuotes();

        @Override
        public QuotedAssetSet.QuotedAssetSetBuilder getBenchmarkQuotes();

        public PricingStructure.PricingStructureBuilder getOrCreatePricingStructure(int var1);

        public List<? extends PricingStructure.PricingStructureBuilder> getPricingStructure();

        public PricingStructureValuation.PricingStructureValuationBuilder getOrCreatePricingStructureValuation(int var1);

        public List<? extends PricingStructureValuation.PricingStructureValuationBuilder> getPricingStructureValuation();

        public PricingMethod.PricingMethodBuilder getOrCreateBenchmarkPricingMethod(int var1);

        public List<? extends PricingMethod.PricingMethodBuilder> getBenchmarkPricingMethod();

        public MarketBuilder setName(String var1);

        public MarketBuilder setBenchmarkQuotes(QuotedAssetSet var1);

        public MarketBuilder addPricingStructure(PricingStructure var1);

        public MarketBuilder addPricingStructure(PricingStructure var1, int var2);

        public MarketBuilder addPricingStructure(List<? extends PricingStructure> var1);

        public MarketBuilder setPricingStructure(List<? extends PricingStructure> var1);

        public MarketBuilder addPricingStructureValuation(PricingStructureValuation var1);

        public MarketBuilder addPricingStructureValuation(PricingStructureValuation var1, int var2);

        public MarketBuilder addPricingStructureValuation(List<? extends PricingStructureValuation> var1);

        public MarketBuilder setPricingStructureValuation(List<? extends PricingStructureValuation> var1);

        public MarketBuilder addBenchmarkPricingMethod(PricingMethod var1);

        public MarketBuilder addBenchmarkPricingMethod(PricingMethod var1, int var2);

        public MarketBuilder addBenchmarkPricingMethod(List<? extends PricingMethod> var1);

        public MarketBuilder setBenchmarkPricingMethod(List<? extends PricingMethod> var1);

        public MarketBuilder setId(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("benchmarkQuotes"), processor, QuotedAssetSet.QuotedAssetSetBuilder.class, this.getBenchmarkQuotes(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("pricingStructure"), processor, PricingStructure.PricingStructureBuilder.class, this.getPricingStructure(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("pricingStructureValuation"), processor, PricingStructureValuation.PricingStructureValuationBuilder.class, this.getPricingStructureValuation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("benchmarkPricingMethod"), processor, PricingMethod.PricingMethodBuilder.class, this.getBenchmarkPricingMethod(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public MarketBuilder prune();
    }

    public static class MarketImpl
    implements Market {
        private final String name;
        private final QuotedAssetSet benchmarkQuotes;
        private final List<? extends PricingStructure> pricingStructure;
        private final List<? extends PricingStructureValuation> pricingStructureValuation;
        private final List<? extends PricingMethod> benchmarkPricingMethod;
        private final String id;

        protected MarketImpl(MarketBuilder builder) {
            this.name = builder.getName();
            this.benchmarkQuotes = Optional.ofNullable(builder.getBenchmarkQuotes()).map(f -> f.build()).orElse(null);
            this.pricingStructure = Optional.ofNullable(builder.getPricingStructure()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.pricingStructureValuation = Optional.ofNullable(builder.getPricingStructureValuation()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.benchmarkPricingMethod = Optional.ofNullable(builder.getBenchmarkPricingMethod()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.id = builder.getId();
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public String getName() {
            return this.name;
        }

        @Override
        @RosettaAttribute(value="benchmarkQuotes")
        @RuneAttribute(value="benchmarkQuotes")
        public QuotedAssetSet getBenchmarkQuotes() {
            return this.benchmarkQuotes;
        }

        @Override
        @RosettaAttribute(value="pricingStructure")
        @RuneAttribute(value="pricingStructure")
        public List<? extends PricingStructure> getPricingStructure() {
            return this.pricingStructure;
        }

        @Override
        @RosettaAttribute(value="pricingStructureValuation")
        @RuneAttribute(value="pricingStructureValuation")
        public List<? extends PricingStructureValuation> getPricingStructureValuation() {
            return this.pricingStructureValuation;
        }

        @Override
        @RosettaAttribute(value="benchmarkPricingMethod")
        @RuneAttribute(value="benchmarkPricingMethod")
        public List<? extends PricingMethod> getBenchmarkPricingMethod() {
            return this.benchmarkPricingMethod;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        public Market build() {
            return this;
        }

        @Override
        public MarketBuilder toBuilder() {
            MarketBuilder builder = Market.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MarketBuilder builder) {
            Optional.ofNullable(this.getName()).ifPresent(builder::setName);
            Optional.ofNullable(this.getBenchmarkQuotes()).ifPresent(builder::setBenchmarkQuotes);
            Optional.ofNullable(this.getPricingStructure()).ifPresent(builder::setPricingStructure);
            Optional.ofNullable(this.getPricingStructureValuation()).ifPresent(builder::setPricingStructureValuation);
            Optional.ofNullable(this.getBenchmarkPricingMethod()).ifPresent(builder::setBenchmarkPricingMethod);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Market _that = this.getType().cast(o);
            if (!Objects.equals(this.name, _that.getName())) {
                return false;
            }
            if (!Objects.equals(this.benchmarkQuotes, _that.getBenchmarkQuotes())) {
                return false;
            }
            if (!ListEquals.listEquals(this.pricingStructure, _that.getPricingStructure())) {
                return false;
            }
            if (!ListEquals.listEquals(this.pricingStructureValuation, _that.getPricingStructureValuation())) {
                return false;
            }
            if (!ListEquals.listEquals(this.benchmarkPricingMethod, _that.getBenchmarkPricingMethod())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            _result = 31 * _result + (this.benchmarkQuotes != null ? this.benchmarkQuotes.hashCode() : 0);
            _result = 31 * _result + (this.pricingStructure != null ? this.pricingStructure.hashCode() : 0);
            _result = 31 * _result + (this.pricingStructureValuation != null ? this.pricingStructureValuation.hashCode() : 0);
            _result = 31 * _result + (this.benchmarkPricingMethod != null ? this.benchmarkPricingMethod.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Market {name=" + this.name + ", benchmarkQuotes=" + String.valueOf(this.benchmarkQuotes) + ", pricingStructure=" + String.valueOf(this.pricingStructure) + ", pricingStructureValuation=" + String.valueOf(this.pricingStructureValuation) + ", benchmarkPricingMethod=" + String.valueOf(this.benchmarkPricingMethod) + ", id=" + this.id + "}";
        }
    }
}

