/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.reg.fpmlreporting.shared;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.reg.fpmlreporting.shared.CollateralPortfolioChoice;
import fpml.consolidated.reg.fpmlreporting.shared.meta.CollateralPortfolioMeta;
import fpml.consolidated.shared.PositiveMoney;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CollateralPortfolio", builder=CollateralPortfolioBuilderImpl.class, version="1.2.2")
@RuneDataType(value="CollateralPortfolio", model="fpml", builder=CollateralPortfolioBuilderImpl.class, version="1.2.2")
public interface CollateralPortfolio
extends RosettaModelObject {
    public static final CollateralPortfolioMeta metaData = new CollateralPortfolioMeta();

    public ZonedDateTime getValueDate();

    public List<? extends CollateralPortfolioChoice> getCollateralPortfolioChoice();

    public List<? extends PositiveMoney> getTotalValuationAmount();

    public CollateralPortfolio build();

    public CollateralPortfolioBuilder toBuilder();

    public static CollateralPortfolioBuilder builder() {
        return new CollateralPortfolioBuilderImpl();
    }

    default public RosettaMetaData<? extends CollateralPortfolio> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CollateralPortfolio> getType() {
        return CollateralPortfolio.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("valueDate"), ZonedDateTime.class, (Object)this.getValueDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateralPortfolioChoice"), processor, CollateralPortfolioChoice.class, this.getCollateralPortfolioChoice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("totalValuationAmount"), processor, PositiveMoney.class, this.getTotalValuationAmount(), new AttributeMeta[0]);
    }

    public static class CollateralPortfolioBuilderImpl
    implements CollateralPortfolioBuilder {
        protected ZonedDateTime valueDate;
        protected List<CollateralPortfolioChoice.CollateralPortfolioChoiceBuilder> collateralPortfolioChoice = new ArrayList<CollateralPortfolioChoice.CollateralPortfolioChoiceBuilder>();
        protected List<PositiveMoney.PositiveMoneyBuilder> totalValuationAmount = new ArrayList<PositiveMoney.PositiveMoneyBuilder>();

        @Override
        @RosettaAttribute(value="valueDate", isRequired=true)
        @RuneAttribute(value="valueDate", isRequired=true)
        public ZonedDateTime getValueDate() {
            return this.valueDate;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioChoice")
        @RuneAttribute(value="collateralPortfolioChoice")
        public List<? extends CollateralPortfolioChoice.CollateralPortfolioChoiceBuilder> getCollateralPortfolioChoice() {
            return this.collateralPortfolioChoice;
        }

        @Override
        public CollateralPortfolioChoice.CollateralPortfolioChoiceBuilder getOrCreateCollateralPortfolioChoice(int index) {
            if (this.collateralPortfolioChoice == null) {
                this.collateralPortfolioChoice = new ArrayList<CollateralPortfolioChoice.CollateralPortfolioChoiceBuilder>();
            }
            return (CollateralPortfolioChoice.CollateralPortfolioChoiceBuilder)this.getIndex(this.collateralPortfolioChoice, index, () -> {
                CollateralPortfolioChoice.CollateralPortfolioChoiceBuilder newCollateralPortfolioChoice = CollateralPortfolioChoice.builder();
                return newCollateralPortfolioChoice;
            });
        }

        @Override
        @RosettaAttribute(value="totalValuationAmount")
        @RuneAttribute(value="totalValuationAmount")
        public List<? extends PositiveMoney.PositiveMoneyBuilder> getTotalValuationAmount() {
            return this.totalValuationAmount;
        }

        @Override
        public PositiveMoney.PositiveMoneyBuilder getOrCreateTotalValuationAmount(int index) {
            if (this.totalValuationAmount == null) {
                this.totalValuationAmount = new ArrayList<PositiveMoney.PositiveMoneyBuilder>();
            }
            return (PositiveMoney.PositiveMoneyBuilder)this.getIndex(this.totalValuationAmount, index, () -> {
                PositiveMoney.PositiveMoneyBuilder newTotalValuationAmount = PositiveMoney.builder();
                return newTotalValuationAmount;
            });
        }

        @Override
        @RosettaAttribute(value="valueDate", isRequired=true)
        @RuneAttribute(value="valueDate", isRequired=true)
        public CollateralPortfolioBuilder setValueDate(ZonedDateTime _valueDate) {
            this.valueDate = _valueDate == null ? null : _valueDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioChoice")
        @RuneAttribute(value="collateralPortfolioChoice")
        public CollateralPortfolioBuilder addCollateralPortfolioChoice(CollateralPortfolioChoice _collateralPortfolioChoice) {
            if (_collateralPortfolioChoice != null) {
                this.collateralPortfolioChoice.add(_collateralPortfolioChoice.toBuilder());
            }
            return this;
        }

        @Override
        public CollateralPortfolioBuilder addCollateralPortfolioChoice(CollateralPortfolioChoice _collateralPortfolioChoice, int idx) {
            this.getIndex(this.collateralPortfolioChoice, idx, () -> _collateralPortfolioChoice.toBuilder());
            return this;
        }

        @Override
        public CollateralPortfolioBuilder addCollateralPortfolioChoice(List<? extends CollateralPortfolioChoice> collateralPortfolioChoices) {
            if (collateralPortfolioChoices != null) {
                for (CollateralPortfolioChoice collateralPortfolioChoice : collateralPortfolioChoices) {
                    this.collateralPortfolioChoice.add(collateralPortfolioChoice.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="collateralPortfolioChoice")
        public CollateralPortfolioBuilder setCollateralPortfolioChoice(List<? extends CollateralPortfolioChoice> collateralPortfolioChoices) {
            this.collateralPortfolioChoice = collateralPortfolioChoices == null ? new ArrayList<CollateralPortfolioChoice.CollateralPortfolioChoiceBuilder>() : (List)collateralPortfolioChoices.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="totalValuationAmount")
        @RuneAttribute(value="totalValuationAmount")
        public CollateralPortfolioBuilder addTotalValuationAmount(PositiveMoney _totalValuationAmount) {
            if (_totalValuationAmount != null) {
                this.totalValuationAmount.add(_totalValuationAmount.toBuilder());
            }
            return this;
        }

        @Override
        public CollateralPortfolioBuilder addTotalValuationAmount(PositiveMoney _totalValuationAmount, int idx) {
            this.getIndex(this.totalValuationAmount, idx, () -> _totalValuationAmount.toBuilder());
            return this;
        }

        @Override
        public CollateralPortfolioBuilder addTotalValuationAmount(List<? extends PositiveMoney> totalValuationAmounts) {
            if (totalValuationAmounts != null) {
                for (PositiveMoney positiveMoney : totalValuationAmounts) {
                    this.totalValuationAmount.add(positiveMoney.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="totalValuationAmount")
        public CollateralPortfolioBuilder setTotalValuationAmount(List<? extends PositiveMoney> totalValuationAmounts) {
            this.totalValuationAmount = totalValuationAmounts == null ? new ArrayList<PositiveMoney.PositiveMoneyBuilder>() : (List)totalValuationAmounts.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CollateralPortfolio build() {
            return new CollateralPortfolioImpl(this);
        }

        @Override
        public CollateralPortfolioBuilder toBuilder() {
            return this;
        }

        @Override
        public CollateralPortfolioBuilder prune() {
            this.collateralPortfolioChoice = this.collateralPortfolioChoice.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.totalValuationAmount = this.totalValuationAmount.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getValueDate() != null) {
                return true;
            }
            if (this.getCollateralPortfolioChoice() != null && this.getCollateralPortfolioChoice().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getTotalValuationAmount() != null && this.getTotalValuationAmount().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public CollateralPortfolioBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CollateralPortfolioBuilder o = (CollateralPortfolioBuilder)other;
            merger.mergeRosetta(this.getCollateralPortfolioChoice(), o.getCollateralPortfolioChoice(), this::getOrCreateCollateralPortfolioChoice);
            merger.mergeRosetta(this.getTotalValuationAmount(), o.getTotalValuationAmount(), this::getOrCreateTotalValuationAmount);
            merger.mergeBasic((Object)this.getValueDate(), (Object)o.getValueDate(), this::setValueDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralPortfolio _that = this.getType().cast(o);
            if (!Objects.equals(this.valueDate, _that.getValueDate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.collateralPortfolioChoice, _that.getCollateralPortfolioChoice())) {
                return false;
            }
            return ListEquals.listEquals(this.totalValuationAmount, _that.getTotalValuationAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.valueDate != null ? this.valueDate.hashCode() : 0);
            _result = 31 * _result + (this.collateralPortfolioChoice != null ? this.collateralPortfolioChoice.hashCode() : 0);
            _result = 31 * _result + (this.totalValuationAmount != null ? this.totalValuationAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralPortfolioBuilder {valueDate=" + String.valueOf(this.valueDate) + ", collateralPortfolioChoice=" + String.valueOf(this.collateralPortfolioChoice) + ", totalValuationAmount=" + String.valueOf(this.totalValuationAmount) + "}";
        }
    }

    public static interface CollateralPortfolioBuilder
    extends CollateralPortfolio,
    RosettaModelObjectBuilder {
        public CollateralPortfolioChoice.CollateralPortfolioChoiceBuilder getOrCreateCollateralPortfolioChoice(int var1);

        public List<? extends CollateralPortfolioChoice.CollateralPortfolioChoiceBuilder> getCollateralPortfolioChoice();

        public PositiveMoney.PositiveMoneyBuilder getOrCreateTotalValuationAmount(int var1);

        public List<? extends PositiveMoney.PositiveMoneyBuilder> getTotalValuationAmount();

        public CollateralPortfolioBuilder setValueDate(ZonedDateTime var1);

        public CollateralPortfolioBuilder addCollateralPortfolioChoice(CollateralPortfolioChoice var1);

        public CollateralPortfolioBuilder addCollateralPortfolioChoice(CollateralPortfolioChoice var1, int var2);

        public CollateralPortfolioBuilder addCollateralPortfolioChoice(List<? extends CollateralPortfolioChoice> var1);

        public CollateralPortfolioBuilder setCollateralPortfolioChoice(List<? extends CollateralPortfolioChoice> var1);

        public CollateralPortfolioBuilder addTotalValuationAmount(PositiveMoney var1);

        public CollateralPortfolioBuilder addTotalValuationAmount(PositiveMoney var1, int var2);

        public CollateralPortfolioBuilder addTotalValuationAmount(List<? extends PositiveMoney> var1);

        public CollateralPortfolioBuilder setTotalValuationAmount(List<? extends PositiveMoney> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("valueDate"), ZonedDateTime.class, (Object)this.getValueDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateralPortfolioChoice"), processor, CollateralPortfolioChoice.CollateralPortfolioChoiceBuilder.class, this.getCollateralPortfolioChoice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("totalValuationAmount"), processor, PositiveMoney.PositiveMoneyBuilder.class, this.getTotalValuationAmount(), new AttributeMeta[0]);
        }

        public CollateralPortfolioBuilder prune();
    }

    public static class CollateralPortfolioImpl
    implements CollateralPortfolio {
        private final ZonedDateTime valueDate;
        private final List<? extends CollateralPortfolioChoice> collateralPortfolioChoice;
        private final List<? extends PositiveMoney> totalValuationAmount;

        protected CollateralPortfolioImpl(CollateralPortfolioBuilder builder) {
            this.valueDate = builder.getValueDate();
            this.collateralPortfolioChoice = Optional.ofNullable(builder.getCollateralPortfolioChoice()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.totalValuationAmount = Optional.ofNullable(builder.getTotalValuationAmount()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="valueDate", isRequired=true)
        @RuneAttribute(value="valueDate", isRequired=true)
        public ZonedDateTime getValueDate() {
            return this.valueDate;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioChoice")
        @RuneAttribute(value="collateralPortfolioChoice")
        public List<? extends CollateralPortfolioChoice> getCollateralPortfolioChoice() {
            return this.collateralPortfolioChoice;
        }

        @Override
        @RosettaAttribute(value="totalValuationAmount")
        @RuneAttribute(value="totalValuationAmount")
        public List<? extends PositiveMoney> getTotalValuationAmount() {
            return this.totalValuationAmount;
        }

        @Override
        public CollateralPortfolio build() {
            return this;
        }

        @Override
        public CollateralPortfolioBuilder toBuilder() {
            CollateralPortfolioBuilder builder = CollateralPortfolio.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CollateralPortfolioBuilder builder) {
            Optional.ofNullable(this.getValueDate()).ifPresent(builder::setValueDate);
            Optional.ofNullable(this.getCollateralPortfolioChoice()).ifPresent(builder::setCollateralPortfolioChoice);
            Optional.ofNullable(this.getTotalValuationAmount()).ifPresent(builder::setTotalValuationAmount);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralPortfolio _that = this.getType().cast(o);
            if (!Objects.equals(this.valueDate, _that.getValueDate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.collateralPortfolioChoice, _that.getCollateralPortfolioChoice())) {
                return false;
            }
            return ListEquals.listEquals(this.totalValuationAmount, _that.getTotalValuationAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.valueDate != null ? this.valueDate.hashCode() : 0);
            _result = 31 * _result + (this.collateralPortfolioChoice != null ? this.collateralPortfolioChoice.hashCode() : 0);
            _result = 31 * _result + (this.totalValuationAmount != null ? this.totalValuationAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralPortfolio {valueDate=" + String.valueOf(this.valueDate) + ", collateralPortfolioChoice=" + String.valueOf(this.collateralPortfolioChoice) + ", totalValuationAmount=" + String.valueOf(this.totalValuationAmount) + "}";
        }
    }
}

