/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.reg.fpmlreporting.product;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.reg.fpmlreporting.product.RegulatoryReportingNonCDECalculationTermsModel;
import fpml.consolidated.reg.fpmlreporting.product.meta.RegulatoryReportingProductCalculationTermsMeta;
import fpml.consolidated.shared.DayCountFraction;
import fpml.consolidated.shared.Frequency;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="RegulatoryReportingProductCalculationTerms", builder=RegulatoryReportingProductCalculationTermsBuilderImpl.class, version="1.2.2")
@RuneDataType(value="RegulatoryReportingProductCalculationTerms", model="fpml", builder=RegulatoryReportingProductCalculationTermsBuilderImpl.class, version="1.2.2")
public interface RegulatoryReportingProductCalculationTerms
extends RosettaModelObject {
    public static final RegulatoryReportingProductCalculationTermsMeta metaData = new RegulatoryReportingProductCalculationTermsMeta();

    public List<? extends DayCountFraction> getDayCountFraction();

    public List<? extends Frequency> getPaymentFrequency();

    public RegulatoryReportingNonCDECalculationTermsModel getRegulatoryReportingNonCDECalculationTermsModel();

    public RegulatoryReportingProductCalculationTerms build();

    public RegulatoryReportingProductCalculationTermsBuilder toBuilder();

    public static RegulatoryReportingProductCalculationTermsBuilder builder() {
        return new RegulatoryReportingProductCalculationTermsBuilderImpl();
    }

    default public RosettaMetaData<? extends RegulatoryReportingProductCalculationTerms> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RegulatoryReportingProductCalculationTerms> getType() {
        return RegulatoryReportingProductCalculationTerms.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.class, this.getDayCountFraction(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentFrequency"), processor, Frequency.class, this.getPaymentFrequency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("regulatoryReportingNonCDECalculationTermsModel"), processor, RegulatoryReportingNonCDECalculationTermsModel.class, this.getRegulatoryReportingNonCDECalculationTermsModel(), new AttributeMeta[0]);
    }

    public static class RegulatoryReportingProductCalculationTermsBuilderImpl
    implements RegulatoryReportingProductCalculationTermsBuilder {
        protected List<DayCountFraction.DayCountFractionBuilder> dayCountFraction = new ArrayList<DayCountFraction.DayCountFractionBuilder>();
        protected List<Frequency.FrequencyBuilder> paymentFrequency = new ArrayList<Frequency.FrequencyBuilder>();
        protected RegulatoryReportingNonCDECalculationTermsModel.RegulatoryReportingNonCDECalculationTermsModelBuilder regulatoryReportingNonCDECalculationTermsModel;

        @Override
        @RosettaAttribute(value="dayCountFraction")
        @RuneAttribute(value="dayCountFraction")
        public List<? extends DayCountFraction.DayCountFractionBuilder> getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        public DayCountFraction.DayCountFractionBuilder getOrCreateDayCountFraction(int index) {
            if (this.dayCountFraction == null) {
                this.dayCountFraction = new ArrayList<DayCountFraction.DayCountFractionBuilder>();
            }
            return (DayCountFraction.DayCountFractionBuilder)this.getIndex(this.dayCountFraction, index, () -> {
                DayCountFraction.DayCountFractionBuilder newDayCountFraction = DayCountFraction.builder();
                return newDayCountFraction;
            });
        }

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public List<? extends Frequency.FrequencyBuilder> getPaymentFrequency() {
            return this.paymentFrequency;
        }

        @Override
        public Frequency.FrequencyBuilder getOrCreatePaymentFrequency(int index) {
            if (this.paymentFrequency == null) {
                this.paymentFrequency = new ArrayList<Frequency.FrequencyBuilder>();
            }
            return (Frequency.FrequencyBuilder)this.getIndex(this.paymentFrequency, index, () -> {
                Frequency.FrequencyBuilder newPaymentFrequency = Frequency.builder();
                return newPaymentFrequency;
            });
        }

        @Override
        @RosettaAttribute(value="regulatoryReportingNonCDECalculationTermsModel", isRequired=true)
        @RuneAttribute(value="regulatoryReportingNonCDECalculationTermsModel", isRequired=true)
        public RegulatoryReportingNonCDECalculationTermsModel.RegulatoryReportingNonCDECalculationTermsModelBuilder getRegulatoryReportingNonCDECalculationTermsModel() {
            return this.regulatoryReportingNonCDECalculationTermsModel;
        }

        @Override
        public RegulatoryReportingNonCDECalculationTermsModel.RegulatoryReportingNonCDECalculationTermsModelBuilder getOrCreateRegulatoryReportingNonCDECalculationTermsModel() {
            RegulatoryReportingNonCDECalculationTermsModel.RegulatoryReportingNonCDECalculationTermsModelBuilder result = this.regulatoryReportingNonCDECalculationTermsModel != null ? this.regulatoryReportingNonCDECalculationTermsModel : (this.regulatoryReportingNonCDECalculationTermsModel = RegulatoryReportingNonCDECalculationTermsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction")
        @RuneAttribute(value="dayCountFraction")
        public RegulatoryReportingProductCalculationTermsBuilder addDayCountFraction(DayCountFraction _dayCountFraction) {
            if (_dayCountFraction != null) {
                this.dayCountFraction.add(_dayCountFraction.toBuilder());
            }
            return this;
        }

        @Override
        public RegulatoryReportingProductCalculationTermsBuilder addDayCountFraction(DayCountFraction _dayCountFraction, int idx) {
            this.getIndex(this.dayCountFraction, idx, () -> _dayCountFraction.toBuilder());
            return this;
        }

        @Override
        public RegulatoryReportingProductCalculationTermsBuilder addDayCountFraction(List<? extends DayCountFraction> dayCountFractions) {
            if (dayCountFractions != null) {
                for (DayCountFraction dayCountFraction : dayCountFractions) {
                    this.dayCountFraction.add(dayCountFraction.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="dayCountFraction")
        public RegulatoryReportingProductCalculationTermsBuilder setDayCountFraction(List<? extends DayCountFraction> dayCountFractions) {
            this.dayCountFraction = dayCountFractions == null ? new ArrayList<DayCountFraction.DayCountFractionBuilder>() : (List)dayCountFractions.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public RegulatoryReportingProductCalculationTermsBuilder addPaymentFrequency(Frequency _paymentFrequency) {
            if (_paymentFrequency != null) {
                this.paymentFrequency.add(_paymentFrequency.toBuilder());
            }
            return this;
        }

        @Override
        public RegulatoryReportingProductCalculationTermsBuilder addPaymentFrequency(Frequency _paymentFrequency, int idx) {
            this.getIndex(this.paymentFrequency, idx, () -> _paymentFrequency.toBuilder());
            return this;
        }

        @Override
        public RegulatoryReportingProductCalculationTermsBuilder addPaymentFrequency(List<? extends Frequency> paymentFrequencys) {
            if (paymentFrequencys != null) {
                for (Frequency frequency : paymentFrequencys) {
                    this.paymentFrequency.add(frequency.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="paymentFrequency")
        public RegulatoryReportingProductCalculationTermsBuilder setPaymentFrequency(List<? extends Frequency> paymentFrequencys) {
            this.paymentFrequency = paymentFrequencys == null ? new ArrayList<Frequency.FrequencyBuilder>() : (List)paymentFrequencys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="regulatoryReportingNonCDECalculationTermsModel", isRequired=true)
        @RuneAttribute(value="regulatoryReportingNonCDECalculationTermsModel", isRequired=true)
        public RegulatoryReportingProductCalculationTermsBuilder setRegulatoryReportingNonCDECalculationTermsModel(RegulatoryReportingNonCDECalculationTermsModel _regulatoryReportingNonCDECalculationTermsModel) {
            this.regulatoryReportingNonCDECalculationTermsModel = _regulatoryReportingNonCDECalculationTermsModel == null ? null : _regulatoryReportingNonCDECalculationTermsModel.toBuilder();
            return this;
        }

        @Override
        public RegulatoryReportingProductCalculationTerms build() {
            return new RegulatoryReportingProductCalculationTermsImpl(this);
        }

        @Override
        public RegulatoryReportingProductCalculationTermsBuilder toBuilder() {
            return this;
        }

        @Override
        public RegulatoryReportingProductCalculationTermsBuilder prune() {
            this.dayCountFraction = this.dayCountFraction.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.paymentFrequency = this.paymentFrequency.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.regulatoryReportingNonCDECalculationTermsModel != null && !this.regulatoryReportingNonCDECalculationTermsModel.prune().hasData()) {
                this.regulatoryReportingNonCDECalculationTermsModel = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getDayCountFraction() != null && this.getDayCountFraction().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPaymentFrequency() != null && this.getPaymentFrequency().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getRegulatoryReportingNonCDECalculationTermsModel() != null && this.getRegulatoryReportingNonCDECalculationTermsModel().hasData();
        }

        public RegulatoryReportingProductCalculationTermsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            RegulatoryReportingProductCalculationTermsBuilder o = (RegulatoryReportingProductCalculationTermsBuilder)other;
            merger.mergeRosetta(this.getDayCountFraction(), o.getDayCountFraction(), this::getOrCreateDayCountFraction);
            merger.mergeRosetta(this.getPaymentFrequency(), o.getPaymentFrequency(), this::getOrCreatePaymentFrequency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRegulatoryReportingNonCDECalculationTermsModel(), (RosettaModelObjectBuilder)o.getRegulatoryReportingNonCDECalculationTermsModel(), this::setRegulatoryReportingNonCDECalculationTermsModel);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RegulatoryReportingProductCalculationTerms _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.dayCountFraction, _that.getDayCountFraction())) {
                return false;
            }
            if (!ListEquals.listEquals(this.paymentFrequency, _that.getPaymentFrequency())) {
                return false;
            }
            return Objects.equals(this.regulatoryReportingNonCDECalculationTermsModel, _that.getRegulatoryReportingNonCDECalculationTermsModel());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.dayCountFraction != null ? this.dayCountFraction.hashCode() : 0);
            _result = 31 * _result + (this.paymentFrequency != null ? this.paymentFrequency.hashCode() : 0);
            _result = 31 * _result + (this.regulatoryReportingNonCDECalculationTermsModel != null ? this.regulatoryReportingNonCDECalculationTermsModel.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RegulatoryReportingProductCalculationTermsBuilder {dayCountFraction=" + String.valueOf(this.dayCountFraction) + ", paymentFrequency=" + String.valueOf(this.paymentFrequency) + ", regulatoryReportingNonCDECalculationTermsModel=" + String.valueOf(this.regulatoryReportingNonCDECalculationTermsModel) + "}";
        }
    }

    public static interface RegulatoryReportingProductCalculationTermsBuilder
    extends RegulatoryReportingProductCalculationTerms,
    RosettaModelObjectBuilder {
        public DayCountFraction.DayCountFractionBuilder getOrCreateDayCountFraction(int var1);

        public List<? extends DayCountFraction.DayCountFractionBuilder> getDayCountFraction();

        public Frequency.FrequencyBuilder getOrCreatePaymentFrequency(int var1);

        public List<? extends Frequency.FrequencyBuilder> getPaymentFrequency();

        public RegulatoryReportingNonCDECalculationTermsModel.RegulatoryReportingNonCDECalculationTermsModelBuilder getOrCreateRegulatoryReportingNonCDECalculationTermsModel();

        @Override
        public RegulatoryReportingNonCDECalculationTermsModel.RegulatoryReportingNonCDECalculationTermsModelBuilder getRegulatoryReportingNonCDECalculationTermsModel();

        public RegulatoryReportingProductCalculationTermsBuilder addDayCountFraction(DayCountFraction var1);

        public RegulatoryReportingProductCalculationTermsBuilder addDayCountFraction(DayCountFraction var1, int var2);

        public RegulatoryReportingProductCalculationTermsBuilder addDayCountFraction(List<? extends DayCountFraction> var1);

        public RegulatoryReportingProductCalculationTermsBuilder setDayCountFraction(List<? extends DayCountFraction> var1);

        public RegulatoryReportingProductCalculationTermsBuilder addPaymentFrequency(Frequency var1);

        public RegulatoryReportingProductCalculationTermsBuilder addPaymentFrequency(Frequency var1, int var2);

        public RegulatoryReportingProductCalculationTermsBuilder addPaymentFrequency(List<? extends Frequency> var1);

        public RegulatoryReportingProductCalculationTermsBuilder setPaymentFrequency(List<? extends Frequency> var1);

        public RegulatoryReportingProductCalculationTermsBuilder setRegulatoryReportingNonCDECalculationTermsModel(RegulatoryReportingNonCDECalculationTermsModel var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.DayCountFractionBuilder.class, this.getDayCountFraction(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentFrequency"), processor, Frequency.FrequencyBuilder.class, this.getPaymentFrequency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("regulatoryReportingNonCDECalculationTermsModel"), processor, RegulatoryReportingNonCDECalculationTermsModel.RegulatoryReportingNonCDECalculationTermsModelBuilder.class, this.getRegulatoryReportingNonCDECalculationTermsModel(), new AttributeMeta[0]);
        }

        public RegulatoryReportingProductCalculationTermsBuilder prune();
    }

    public static class RegulatoryReportingProductCalculationTermsImpl
    implements RegulatoryReportingProductCalculationTerms {
        private final List<? extends DayCountFraction> dayCountFraction;
        private final List<? extends Frequency> paymentFrequency;
        private final RegulatoryReportingNonCDECalculationTermsModel regulatoryReportingNonCDECalculationTermsModel;

        protected RegulatoryReportingProductCalculationTermsImpl(RegulatoryReportingProductCalculationTermsBuilder builder) {
            this.dayCountFraction = Optional.ofNullable(builder.getDayCountFraction()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.paymentFrequency = Optional.ofNullable(builder.getPaymentFrequency()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.regulatoryReportingNonCDECalculationTermsModel = Optional.ofNullable(builder.getRegulatoryReportingNonCDECalculationTermsModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="dayCountFraction")
        @RuneAttribute(value="dayCountFraction")
        public List<? extends DayCountFraction> getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public List<? extends Frequency> getPaymentFrequency() {
            return this.paymentFrequency;
        }

        @Override
        @RosettaAttribute(value="regulatoryReportingNonCDECalculationTermsModel", isRequired=true)
        @RuneAttribute(value="regulatoryReportingNonCDECalculationTermsModel", isRequired=true)
        public RegulatoryReportingNonCDECalculationTermsModel getRegulatoryReportingNonCDECalculationTermsModel() {
            return this.regulatoryReportingNonCDECalculationTermsModel;
        }

        @Override
        public RegulatoryReportingProductCalculationTerms build() {
            return this;
        }

        @Override
        public RegulatoryReportingProductCalculationTermsBuilder toBuilder() {
            RegulatoryReportingProductCalculationTermsBuilder builder = RegulatoryReportingProductCalculationTerms.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RegulatoryReportingProductCalculationTermsBuilder builder) {
            Optional.ofNullable(this.getDayCountFraction()).ifPresent(builder::setDayCountFraction);
            Optional.ofNullable(this.getPaymentFrequency()).ifPresent(builder::setPaymentFrequency);
            Optional.ofNullable(this.getRegulatoryReportingNonCDECalculationTermsModel()).ifPresent(builder::setRegulatoryReportingNonCDECalculationTermsModel);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RegulatoryReportingProductCalculationTerms _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.dayCountFraction, _that.getDayCountFraction())) {
                return false;
            }
            if (!ListEquals.listEquals(this.paymentFrequency, _that.getPaymentFrequency())) {
                return false;
            }
            return Objects.equals(this.regulatoryReportingNonCDECalculationTermsModel, _that.getRegulatoryReportingNonCDECalculationTermsModel());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.dayCountFraction != null ? this.dayCountFraction.hashCode() : 0);
            _result = 31 * _result + (this.paymentFrequency != null ? this.paymentFrequency.hashCode() : 0);
            _result = 31 * _result + (this.regulatoryReportingNonCDECalculationTermsModel != null ? this.regulatoryReportingNonCDECalculationTermsModel.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RegulatoryReportingProductCalculationTerms {dayCountFraction=" + String.valueOf(this.dayCountFraction) + ", paymentFrequency=" + String.valueOf(this.paymentFrequency) + ", regulatoryReportingNonCDECalculationTermsModel=" + String.valueOf(this.regulatoryReportingNonCDECalculationTermsModel) + "}";
        }
    }
}

