/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.recordkeeping.processes.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import fpml.consolidated.recordkeeping.processes.ESMALevel3Model;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ESMALevel3ModelOnlyExistsValidator
implements ValidatorWithArg<ESMALevel3Model, Set<String>> {
    public <T2 extends ESMALevel3Model> ValidationResult<ESMALevel3Model> validate(RosettaPath path, T2 o, Set<String> fields) {
        ImmutableMap fieldExistenceMap = ImmutableMap.builder().put((Object)"contractType", (Object)ExistenceChecker.isSet((Object)o.getContractType())).put((Object)"deliveryType", (Object)ExistenceChecker.isSet((Object)o.getDeliveryType())).put((Object)"creditDetails", (Object)ExistenceChecker.isSet((Object)o.getCreditDetails())).put((Object)"underlyer", (Object)ExistenceChecker.isSet((Object)o.getUnderlyer())).build();
        Set setFields = fieldExistenceMap.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (setFields.equals(fields)) {
            return ValidationResult.success((String)"ESMALevel3Model", (ValidationResult.ValidationType)ValidationResult.ValidationType.ONLY_EXISTS, (String)"ESMALevel3Model", (RosettaPath)path, (String)"");
        }
        return ValidationResult.failure((String)"ESMALevel3Model", (ValidationResult.ValidationType)ValidationResult.ValidationType.ONLY_EXISTS, (String)"ESMALevel3Model", (RosettaPath)path, (String)"", (String)String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
    }
}

