/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.recordkeeping.processes.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.recordkeeping.processes.ESMAIndexIdentification;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ESMAIndexIdentificationChoice")
@ImplementedBy(value=Default.class)
public interface ESMAIndexIdentificationChoice
extends Validator<ESMAIndexIdentification> {
    public static final String NAME = "ESMAIndexIdentificationChoice";
    public static final String DEFINITION = "one-of";

    public static class NoOp
    implements ESMAIndexIdentificationChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAIndexIdentification eSMAIndexIdentification) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ESMAIndexIdentificationChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAIndexIdentification eSMAIndexIdentification) {
            ComparisonResult result = this.executeDataRule(eSMAIndexIdentification);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ESMAIndexIdentificationChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ESMAIndexIdentification", (RosettaPath)path, (String)ESMAIndexIdentificationChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ESMAIndexIdentificationChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ESMAIndexIdentification", (RosettaPath)path, (String)ESMAIndexIdentificationChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ESMAIndexIdentification eSMAIndexIdentification) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)eSMAIndexIdentification), Arrays.asList("code", "name"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

