/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.recordkeeping.processes;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.PartyTradeIdentifier;
import fpml.consolidated.msg.AddressedMessage;
import fpml.consolidated.msg.NotificationMessageHeader;
import fpml.consolidated.recordkeeping.processes.InapplicableRegulation;
import fpml.consolidated.recordkeeping.processes.meta.RegulatoryWithdrawalMeta;
import fpml.consolidated.shared.AssetClass;
import fpml.consolidated.shared.OnBehalfOf;
import fpml.consolidated.shared.Party;
import fpml.consolidated.shared.RelatedParty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="RegulatoryWithdrawal", builder=RegulatoryWithdrawalBuilderImpl.class, version="1.2.2")
@RuneDataType(value="RegulatoryWithdrawal", model="fpml", builder=RegulatoryWithdrawalBuilderImpl.class, version="1.2.2")
public interface RegulatoryWithdrawal
extends AddressedMessage {
    public static final RegulatoryWithdrawalMeta metaData = new RegulatoryWithdrawalMeta();

    public List<? extends OnBehalfOf> getOnBehalfOf();

    public PartyTradeIdentifier getTradeIdentifier();

    public AssetClass getPrimaryAssetClass();

    public List<? extends InapplicableRegulation> getInapplicableRegulation();

    public String getWithdrawalReason();

    public Boolean getFullyWithdrawn();

    public List<? extends RelatedParty> getRelatedParty();

    public List<? extends Party> getParty();

    @Override
    public RegulatoryWithdrawal build();

    @Override
    public RegulatoryWithdrawalBuilder toBuilder();

    public static RegulatoryWithdrawalBuilder builder() {
        return new RegulatoryWithdrawalBuilderImpl();
    }

    default public RosettaMetaData<? extends RegulatoryWithdrawal> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RegulatoryWithdrawal> getType() {
        return RegulatoryWithdrawal.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, NotificationMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOf"), processor, OnBehalfOf.class, this.getOnBehalfOf(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeIdentifier"), processor, PartyTradeIdentifier.class, this.getTradeIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("primaryAssetClass"), processor, AssetClass.class, this.getPrimaryAssetClass(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("inapplicableRegulation"), processor, InapplicableRegulation.class, this.getInapplicableRegulation(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("withdrawalReason"), String.class, (Object)this.getWithdrawalReason(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fullyWithdrawn"), Boolean.class, (Object)this.getFullyWithdrawn(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("relatedParty"), processor, RelatedParty.class, this.getRelatedParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("party"), processor, Party.class, this.getParty(), new AttributeMeta[0]);
    }

    public static class RegulatoryWithdrawalBuilderImpl
    extends AddressedMessage.AddressedMessageBuilderImpl
    implements RegulatoryWithdrawalBuilder {
        protected List<OnBehalfOf.OnBehalfOfBuilder> onBehalfOf = new ArrayList<OnBehalfOf.OnBehalfOfBuilder>();
        protected PartyTradeIdentifier.PartyTradeIdentifierBuilder tradeIdentifier;
        protected AssetClass.AssetClassBuilder primaryAssetClass;
        protected List<InapplicableRegulation.InapplicableRegulationBuilder> inapplicableRegulation = new ArrayList<InapplicableRegulation.InapplicableRegulationBuilder>();
        protected String withdrawalReason;
        protected Boolean fullyWithdrawn;
        protected List<RelatedParty.RelatedPartyBuilder> relatedParty = new ArrayList<RelatedParty.RelatedPartyBuilder>();
        protected List<Party.PartyBuilder> party = new ArrayList<Party.PartyBuilder>();

        @Override
        @RosettaAttribute(value="onBehalfOf")
        @RuneAttribute(value="onBehalfOf")
        public List<? extends OnBehalfOf.OnBehalfOfBuilder> getOnBehalfOf() {
            return this.onBehalfOf;
        }

        @Override
        public OnBehalfOf.OnBehalfOfBuilder getOrCreateOnBehalfOf(int index) {
            if (this.onBehalfOf == null) {
                this.onBehalfOf = new ArrayList<OnBehalfOf.OnBehalfOfBuilder>();
            }
            return (OnBehalfOf.OnBehalfOfBuilder)this.getIndex(this.onBehalfOf, index, () -> {
                OnBehalfOf.OnBehalfOfBuilder newOnBehalfOf = OnBehalfOf.builder();
                return newOnBehalfOf;
            });
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreateTradeIdentifier() {
            PartyTradeIdentifier.PartyTradeIdentifierBuilder result = this.tradeIdentifier != null ? this.tradeIdentifier : (this.tradeIdentifier = PartyTradeIdentifier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="primaryAssetClass")
        @RuneAttribute(value="primaryAssetClass")
        public AssetClass.AssetClassBuilder getPrimaryAssetClass() {
            return this.primaryAssetClass;
        }

        @Override
        public AssetClass.AssetClassBuilder getOrCreatePrimaryAssetClass() {
            AssetClass.AssetClassBuilder result = this.primaryAssetClass != null ? this.primaryAssetClass : (this.primaryAssetClass = AssetClass.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="inapplicableRegulation", isRequired=true)
        @RuneAttribute(value="inapplicableRegulation", isRequired=true)
        public List<? extends InapplicableRegulation.InapplicableRegulationBuilder> getInapplicableRegulation() {
            return this.inapplicableRegulation;
        }

        @Override
        public InapplicableRegulation.InapplicableRegulationBuilder getOrCreateInapplicableRegulation(int index) {
            if (this.inapplicableRegulation == null) {
                this.inapplicableRegulation = new ArrayList<InapplicableRegulation.InapplicableRegulationBuilder>();
            }
            return (InapplicableRegulation.InapplicableRegulationBuilder)this.getIndex(this.inapplicableRegulation, index, () -> {
                InapplicableRegulation.InapplicableRegulationBuilder newInapplicableRegulation = InapplicableRegulation.builder();
                return newInapplicableRegulation;
            });
        }

        @Override
        @RosettaAttribute(value="withdrawalReason")
        @RuneAttribute(value="withdrawalReason")
        public String getWithdrawalReason() {
            return this.withdrawalReason;
        }

        @Override
        @RosettaAttribute(value="fullyWithdrawn", isRequired=true)
        @RuneAttribute(value="fullyWithdrawn", isRequired=true)
        public Boolean getFullyWithdrawn() {
            return this.fullyWithdrawn;
        }

        @Override
        @RosettaAttribute(value="relatedParty")
        @RuneAttribute(value="relatedParty")
        public List<? extends RelatedParty.RelatedPartyBuilder> getRelatedParty() {
            return this.relatedParty;
        }

        @Override
        public RelatedParty.RelatedPartyBuilder getOrCreateRelatedParty(int index) {
            if (this.relatedParty == null) {
                this.relatedParty = new ArrayList<RelatedParty.RelatedPartyBuilder>();
            }
            return (RelatedParty.RelatedPartyBuilder)this.getIndex(this.relatedParty, index, () -> {
                RelatedParty.RelatedPartyBuilder newRelatedParty = RelatedParty.builder();
                return newRelatedParty;
            });
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public List<? extends Party.PartyBuilder> getParty() {
            return this.party;
        }

        @Override
        public Party.PartyBuilder getOrCreateParty(int index) {
            if (this.party == null) {
                this.party = new ArrayList<Party.PartyBuilder>();
            }
            return (Party.PartyBuilder)this.getIndex(this.party, index, () -> {
                Party.PartyBuilder newParty = Party.builder();
                return newParty;
            });
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public RegulatoryWithdrawalBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public RegulatoryWithdrawalBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public RegulatoryWithdrawalBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public RegulatoryWithdrawalBuilder setHeader(NotificationMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOf")
        @RuneAttribute(value="onBehalfOf")
        public RegulatoryWithdrawalBuilder addOnBehalfOf(OnBehalfOf _onBehalfOf) {
            if (_onBehalfOf != null) {
                this.onBehalfOf.add(_onBehalfOf.toBuilder());
            }
            return this;
        }

        @Override
        public RegulatoryWithdrawalBuilder addOnBehalfOf(OnBehalfOf _onBehalfOf, int idx) {
            this.getIndex(this.onBehalfOf, idx, () -> _onBehalfOf.toBuilder());
            return this;
        }

        @Override
        public RegulatoryWithdrawalBuilder addOnBehalfOf(List<? extends OnBehalfOf> onBehalfOfs) {
            if (onBehalfOfs != null) {
                for (OnBehalfOf onBehalfOf : onBehalfOfs) {
                    this.onBehalfOf.add(onBehalfOf.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="onBehalfOf")
        public RegulatoryWithdrawalBuilder setOnBehalfOf(List<? extends OnBehalfOf> onBehalfOfs) {
            this.onBehalfOf = onBehalfOfs == null ? new ArrayList<OnBehalfOf.OnBehalfOfBuilder>() : (List)onBehalfOfs.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public RegulatoryWithdrawalBuilder setTradeIdentifier(PartyTradeIdentifier _tradeIdentifier) {
            this.tradeIdentifier = _tradeIdentifier == null ? null : _tradeIdentifier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="primaryAssetClass")
        @RuneAttribute(value="primaryAssetClass")
        public RegulatoryWithdrawalBuilder setPrimaryAssetClass(AssetClass _primaryAssetClass) {
            this.primaryAssetClass = _primaryAssetClass == null ? null : _primaryAssetClass.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="inapplicableRegulation", isRequired=true)
        @RuneAttribute(value="inapplicableRegulation", isRequired=true)
        public RegulatoryWithdrawalBuilder addInapplicableRegulation(InapplicableRegulation _inapplicableRegulation) {
            if (_inapplicableRegulation != null) {
                this.inapplicableRegulation.add(_inapplicableRegulation.toBuilder());
            }
            return this;
        }

        @Override
        public RegulatoryWithdrawalBuilder addInapplicableRegulation(InapplicableRegulation _inapplicableRegulation, int idx) {
            this.getIndex(this.inapplicableRegulation, idx, () -> _inapplicableRegulation.toBuilder());
            return this;
        }

        @Override
        public RegulatoryWithdrawalBuilder addInapplicableRegulation(List<? extends InapplicableRegulation> inapplicableRegulations) {
            if (inapplicableRegulations != null) {
                for (InapplicableRegulation inapplicableRegulation : inapplicableRegulations) {
                    this.inapplicableRegulation.add(inapplicableRegulation.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="inapplicableRegulation")
        public RegulatoryWithdrawalBuilder setInapplicableRegulation(List<? extends InapplicableRegulation> inapplicableRegulations) {
            this.inapplicableRegulation = inapplicableRegulations == null ? new ArrayList<InapplicableRegulation.InapplicableRegulationBuilder>() : (List)inapplicableRegulations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="withdrawalReason")
        @RuneAttribute(value="withdrawalReason")
        public RegulatoryWithdrawalBuilder setWithdrawalReason(String _withdrawalReason) {
            this.withdrawalReason = _withdrawalReason == null ? null : _withdrawalReason;
            return this;
        }

        @Override
        @RosettaAttribute(value="fullyWithdrawn", isRequired=true)
        @RuneAttribute(value="fullyWithdrawn", isRequired=true)
        public RegulatoryWithdrawalBuilder setFullyWithdrawn(Boolean _fullyWithdrawn) {
            this.fullyWithdrawn = _fullyWithdrawn == null ? null : _fullyWithdrawn;
            return this;
        }

        @Override
        @RosettaAttribute(value="relatedParty")
        @RuneAttribute(value="relatedParty")
        public RegulatoryWithdrawalBuilder addRelatedParty(RelatedParty _relatedParty) {
            if (_relatedParty != null) {
                this.relatedParty.add(_relatedParty.toBuilder());
            }
            return this;
        }

        @Override
        public RegulatoryWithdrawalBuilder addRelatedParty(RelatedParty _relatedParty, int idx) {
            this.getIndex(this.relatedParty, idx, () -> _relatedParty.toBuilder());
            return this;
        }

        @Override
        public RegulatoryWithdrawalBuilder addRelatedParty(List<? extends RelatedParty> relatedPartys) {
            if (relatedPartys != null) {
                for (RelatedParty relatedParty : relatedPartys) {
                    this.relatedParty.add(relatedParty.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="relatedParty")
        public RegulatoryWithdrawalBuilder setRelatedParty(List<? extends RelatedParty> relatedPartys) {
            this.relatedParty = relatedPartys == null ? new ArrayList<RelatedParty.RelatedPartyBuilder>() : (List)relatedPartys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public RegulatoryWithdrawalBuilder addParty(Party _party) {
            if (_party != null) {
                this.party.add(_party.toBuilder());
            }
            return this;
        }

        @Override
        public RegulatoryWithdrawalBuilder addParty(Party _party, int idx) {
            this.getIndex(this.party, idx, () -> _party.toBuilder());
            return this;
        }

        @Override
        public RegulatoryWithdrawalBuilder addParty(List<? extends Party> partys) {
            if (partys != null) {
                for (Party party : partys) {
                    this.party.add(party.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="party")
        public RegulatoryWithdrawalBuilder setParty(List<? extends Party> partys) {
            this.party = partys == null ? new ArrayList<Party.PartyBuilder>() : (List)partys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public RegulatoryWithdrawal build() {
            return new RegulatoryWithdrawalImpl(this);
        }

        @Override
        public RegulatoryWithdrawalBuilder toBuilder() {
            return this;
        }

        @Override
        public RegulatoryWithdrawalBuilder prune() {
            super.prune();
            this.onBehalfOf = this.onBehalfOf.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.tradeIdentifier != null && !this.tradeIdentifier.prune().hasData()) {
                this.tradeIdentifier = null;
            }
            if (this.primaryAssetClass != null && !this.primaryAssetClass.prune().hasData()) {
                this.primaryAssetClass = null;
            }
            this.inapplicableRegulation = this.inapplicableRegulation.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.relatedParty = this.relatedParty.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.party = this.party.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getOnBehalfOf() != null && this.getOnBehalfOf().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getTradeIdentifier() != null && this.getTradeIdentifier().hasData()) {
                return true;
            }
            if (this.getPrimaryAssetClass() != null && this.getPrimaryAssetClass().hasData()) {
                return true;
            }
            if (this.getInapplicableRegulation() != null && this.getInapplicableRegulation().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getWithdrawalReason() != null) {
                return true;
            }
            if (this.getFullyWithdrawn() != null) {
                return true;
            }
            if (this.getRelatedParty() != null && this.getRelatedParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getParty() != null && this.getParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public RegulatoryWithdrawalBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            RegulatoryWithdrawalBuilder o = (RegulatoryWithdrawalBuilder)other;
            merger.mergeRosetta(this.getOnBehalfOf(), o.getOnBehalfOf(), this::getOrCreateOnBehalfOf);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradeIdentifier(), (RosettaModelObjectBuilder)o.getTradeIdentifier(), this::setTradeIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrimaryAssetClass(), (RosettaModelObjectBuilder)o.getPrimaryAssetClass(), this::setPrimaryAssetClass);
            merger.mergeRosetta(this.getInapplicableRegulation(), o.getInapplicableRegulation(), this::getOrCreateInapplicableRegulation);
            merger.mergeRosetta(this.getRelatedParty(), o.getRelatedParty(), this::getOrCreateRelatedParty);
            merger.mergeRosetta(this.getParty(), o.getParty(), this::getOrCreateParty);
            merger.mergeBasic((Object)this.getWithdrawalReason(), (Object)o.getWithdrawalReason(), this::setWithdrawalReason, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFullyWithdrawn(), (Object)o.getFullyWithdrawn(), this::setFullyWithdrawn, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RegulatoryWithdrawal _that = (RegulatoryWithdrawal)this.getType().cast(o);
            if (!ListEquals.listEquals(this.onBehalfOf, _that.getOnBehalfOf())) {
                return false;
            }
            if (!Objects.equals(this.tradeIdentifier, _that.getTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.primaryAssetClass, _that.getPrimaryAssetClass())) {
                return false;
            }
            if (!ListEquals.listEquals(this.inapplicableRegulation, _that.getInapplicableRegulation())) {
                return false;
            }
            if (!Objects.equals(this.withdrawalReason, _that.getWithdrawalReason())) {
                return false;
            }
            if (!Objects.equals(this.fullyWithdrawn, _that.getFullyWithdrawn())) {
                return false;
            }
            if (!ListEquals.listEquals(this.relatedParty, _that.getRelatedParty())) {
                return false;
            }
            return ListEquals.listEquals(this.party, _that.getParty());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.onBehalfOf != null ? this.onBehalfOf.hashCode() : 0);
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.primaryAssetClass != null ? this.primaryAssetClass.hashCode() : 0);
            _result = 31 * _result + (this.inapplicableRegulation != null ? this.inapplicableRegulation.hashCode() : 0);
            _result = 31 * _result + (this.withdrawalReason != null ? this.withdrawalReason.hashCode() : 0);
            _result = 31 * _result + (this.fullyWithdrawn != null ? this.fullyWithdrawn.hashCode() : 0);
            _result = 31 * _result + (this.relatedParty != null ? this.relatedParty.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RegulatoryWithdrawalBuilder {onBehalfOf=" + String.valueOf(this.onBehalfOf) + ", tradeIdentifier=" + String.valueOf(this.tradeIdentifier) + ", primaryAssetClass=" + String.valueOf(this.primaryAssetClass) + ", inapplicableRegulation=" + String.valueOf(this.inapplicableRegulation) + ", withdrawalReason=" + this.withdrawalReason + ", fullyWithdrawn=" + this.fullyWithdrawn + ", relatedParty=" + String.valueOf(this.relatedParty) + ", party=" + String.valueOf(this.party) + "} " + super.toString();
        }
    }

    public static interface RegulatoryWithdrawalBuilder
    extends RegulatoryWithdrawal,
    AddressedMessage.AddressedMessageBuilder {
        public OnBehalfOf.OnBehalfOfBuilder getOrCreateOnBehalfOf(int var1);

        public List<? extends OnBehalfOf.OnBehalfOfBuilder> getOnBehalfOf();

        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreateTradeIdentifier();

        @Override
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getTradeIdentifier();

        public AssetClass.AssetClassBuilder getOrCreatePrimaryAssetClass();

        @Override
        public AssetClass.AssetClassBuilder getPrimaryAssetClass();

        public InapplicableRegulation.InapplicableRegulationBuilder getOrCreateInapplicableRegulation(int var1);

        public List<? extends InapplicableRegulation.InapplicableRegulationBuilder> getInapplicableRegulation();

        public RelatedParty.RelatedPartyBuilder getOrCreateRelatedParty(int var1);

        public List<? extends RelatedParty.RelatedPartyBuilder> getRelatedParty();

        public Party.PartyBuilder getOrCreateParty(int var1);

        public List<? extends Party.PartyBuilder> getParty();

        @Override
        public RegulatoryWithdrawalBuilder setFpmlVersion(String var1);

        @Override
        public RegulatoryWithdrawalBuilder setExpectedBuild(Integer var1);

        @Override
        public RegulatoryWithdrawalBuilder setActualBuild(Integer var1);

        @Override
        public RegulatoryWithdrawalBuilder setHeader(NotificationMessageHeader var1);

        public RegulatoryWithdrawalBuilder addOnBehalfOf(OnBehalfOf var1);

        public RegulatoryWithdrawalBuilder addOnBehalfOf(OnBehalfOf var1, int var2);

        public RegulatoryWithdrawalBuilder addOnBehalfOf(List<? extends OnBehalfOf> var1);

        public RegulatoryWithdrawalBuilder setOnBehalfOf(List<? extends OnBehalfOf> var1);

        public RegulatoryWithdrawalBuilder setTradeIdentifier(PartyTradeIdentifier var1);

        public RegulatoryWithdrawalBuilder setPrimaryAssetClass(AssetClass var1);

        public RegulatoryWithdrawalBuilder addInapplicableRegulation(InapplicableRegulation var1);

        public RegulatoryWithdrawalBuilder addInapplicableRegulation(InapplicableRegulation var1, int var2);

        public RegulatoryWithdrawalBuilder addInapplicableRegulation(List<? extends InapplicableRegulation> var1);

        public RegulatoryWithdrawalBuilder setInapplicableRegulation(List<? extends InapplicableRegulation> var1);

        public RegulatoryWithdrawalBuilder setWithdrawalReason(String var1);

        public RegulatoryWithdrawalBuilder setFullyWithdrawn(Boolean var1);

        public RegulatoryWithdrawalBuilder addRelatedParty(RelatedParty var1);

        public RegulatoryWithdrawalBuilder addRelatedParty(RelatedParty var1, int var2);

        public RegulatoryWithdrawalBuilder addRelatedParty(List<? extends RelatedParty> var1);

        public RegulatoryWithdrawalBuilder setRelatedParty(List<? extends RelatedParty> var1);

        public RegulatoryWithdrawalBuilder addParty(Party var1);

        public RegulatoryWithdrawalBuilder addParty(Party var1, int var2);

        public RegulatoryWithdrawalBuilder addParty(List<? extends Party> var1);

        public RegulatoryWithdrawalBuilder setParty(List<? extends Party> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, NotificationMessageHeader.NotificationMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOf"), processor, OnBehalfOf.OnBehalfOfBuilder.class, this.getOnBehalfOf(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeIdentifier"), processor, PartyTradeIdentifier.PartyTradeIdentifierBuilder.class, this.getTradeIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("primaryAssetClass"), processor, AssetClass.AssetClassBuilder.class, this.getPrimaryAssetClass(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("inapplicableRegulation"), processor, InapplicableRegulation.InapplicableRegulationBuilder.class, this.getInapplicableRegulation(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("withdrawalReason"), String.class, (Object)this.getWithdrawalReason(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fullyWithdrawn"), Boolean.class, (Object)this.getFullyWithdrawn(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("relatedParty"), processor, RelatedParty.RelatedPartyBuilder.class, this.getRelatedParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("party"), processor, Party.PartyBuilder.class, this.getParty(), new AttributeMeta[0]);
        }

        @Override
        public RegulatoryWithdrawalBuilder prune();
    }

    public static class RegulatoryWithdrawalImpl
    extends AddressedMessage.AddressedMessageImpl
    implements RegulatoryWithdrawal {
        private final List<? extends OnBehalfOf> onBehalfOf;
        private final PartyTradeIdentifier tradeIdentifier;
        private final AssetClass primaryAssetClass;
        private final List<? extends InapplicableRegulation> inapplicableRegulation;
        private final String withdrawalReason;
        private final Boolean fullyWithdrawn;
        private final List<? extends RelatedParty> relatedParty;
        private final List<? extends Party> party;

        protected RegulatoryWithdrawalImpl(RegulatoryWithdrawalBuilder builder) {
            super(builder);
            this.onBehalfOf = Optional.ofNullable(builder.getOnBehalfOf()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.tradeIdentifier = Optional.ofNullable(builder.getTradeIdentifier()).map(f -> f.build()).orElse(null);
            this.primaryAssetClass = Optional.ofNullable(builder.getPrimaryAssetClass()).map(f -> f.build()).orElse(null);
            this.inapplicableRegulation = Optional.ofNullable(builder.getInapplicableRegulation()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.withdrawalReason = builder.getWithdrawalReason();
            this.fullyWithdrawn = builder.getFullyWithdrawn();
            this.relatedParty = Optional.ofNullable(builder.getRelatedParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.party = Optional.ofNullable(builder.getParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="onBehalfOf")
        @RuneAttribute(value="onBehalfOf")
        public List<? extends OnBehalfOf> getOnBehalfOf() {
            return this.onBehalfOf;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public PartyTradeIdentifier getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        @RosettaAttribute(value="primaryAssetClass")
        @RuneAttribute(value="primaryAssetClass")
        public AssetClass getPrimaryAssetClass() {
            return this.primaryAssetClass;
        }

        @Override
        @RosettaAttribute(value="inapplicableRegulation", isRequired=true)
        @RuneAttribute(value="inapplicableRegulation", isRequired=true)
        public List<? extends InapplicableRegulation> getInapplicableRegulation() {
            return this.inapplicableRegulation;
        }

        @Override
        @RosettaAttribute(value="withdrawalReason")
        @RuneAttribute(value="withdrawalReason")
        public String getWithdrawalReason() {
            return this.withdrawalReason;
        }

        @Override
        @RosettaAttribute(value="fullyWithdrawn", isRequired=true)
        @RuneAttribute(value="fullyWithdrawn", isRequired=true)
        public Boolean getFullyWithdrawn() {
            return this.fullyWithdrawn;
        }

        @Override
        @RosettaAttribute(value="relatedParty")
        @RuneAttribute(value="relatedParty")
        public List<? extends RelatedParty> getRelatedParty() {
            return this.relatedParty;
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public List<? extends Party> getParty() {
            return this.party;
        }

        @Override
        public RegulatoryWithdrawal build() {
            return this;
        }

        @Override
        public RegulatoryWithdrawalBuilder toBuilder() {
            RegulatoryWithdrawalBuilder builder = RegulatoryWithdrawal.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RegulatoryWithdrawalBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getOnBehalfOf()).ifPresent(builder::setOnBehalfOf);
            Optional.ofNullable(this.getTradeIdentifier()).ifPresent(builder::setTradeIdentifier);
            Optional.ofNullable(this.getPrimaryAssetClass()).ifPresent(builder::setPrimaryAssetClass);
            Optional.ofNullable(this.getInapplicableRegulation()).ifPresent(builder::setInapplicableRegulation);
            Optional.ofNullable(this.getWithdrawalReason()).ifPresent(builder::setWithdrawalReason);
            Optional.ofNullable(this.getFullyWithdrawn()).ifPresent(builder::setFullyWithdrawn);
            Optional.ofNullable(this.getRelatedParty()).ifPresent(builder::setRelatedParty);
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RegulatoryWithdrawal _that = (RegulatoryWithdrawal)this.getType().cast(o);
            if (!ListEquals.listEquals(this.onBehalfOf, _that.getOnBehalfOf())) {
                return false;
            }
            if (!Objects.equals(this.tradeIdentifier, _that.getTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.primaryAssetClass, _that.getPrimaryAssetClass())) {
                return false;
            }
            if (!ListEquals.listEquals(this.inapplicableRegulation, _that.getInapplicableRegulation())) {
                return false;
            }
            if (!Objects.equals(this.withdrawalReason, _that.getWithdrawalReason())) {
                return false;
            }
            if (!Objects.equals(this.fullyWithdrawn, _that.getFullyWithdrawn())) {
                return false;
            }
            if (!ListEquals.listEquals(this.relatedParty, _that.getRelatedParty())) {
                return false;
            }
            return ListEquals.listEquals(this.party, _that.getParty());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.onBehalfOf != null ? this.onBehalfOf.hashCode() : 0);
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.primaryAssetClass != null ? this.primaryAssetClass.hashCode() : 0);
            _result = 31 * _result + (this.inapplicableRegulation != null ? this.inapplicableRegulation.hashCode() : 0);
            _result = 31 * _result + (this.withdrawalReason != null ? this.withdrawalReason.hashCode() : 0);
            _result = 31 * _result + (this.fullyWithdrawn != null ? this.fullyWithdrawn.hashCode() : 0);
            _result = 31 * _result + (this.relatedParty != null ? this.relatedParty.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RegulatoryWithdrawal {onBehalfOf=" + String.valueOf(this.onBehalfOf) + ", tradeIdentifier=" + String.valueOf(this.tradeIdentifier) + ", primaryAssetClass=" + String.valueOf(this.primaryAssetClass) + ", inapplicableRegulation=" + String.valueOf(this.inapplicableRegulation) + ", withdrawalReason=" + this.withdrawalReason + ", fullyWithdrawn=" + this.fullyWithdrawn + ", relatedParty=" + String.valueOf(this.relatedParty) + ", party=" + String.valueOf(this.party) + "} " + super.toString();
        }
    }
}

