/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.option.shared.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.option.shared.FxFeature;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="FxFeatureChoice")
@ImplementedBy(value=Default.class)
public interface FxFeatureChoice
extends Validator<FxFeature> {
    public static final String NAME = "FxFeatureChoice";
    public static final String DEFINITION = "optional choice composite, quanto , crossCurrency";

    public static class NoOp
    implements FxFeatureChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, FxFeature fxFeature) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements FxFeatureChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, FxFeature fxFeature) {
            ComparisonResult result = this.executeDataRule(fxFeature);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)FxFeatureChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"FxFeature", (RosettaPath)path, (String)FxFeatureChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)FxFeatureChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"FxFeature", (RosettaPath)path, (String)FxFeatureChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(FxFeature fxFeature) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)fxFeature), Arrays.asList("composite", "quanto", "crossCurrency"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

