/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.option.shared;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.option.shared.meta.AveragingScheduleMeta;
import fpml.consolidated.shared.CalculationPeriodFrequency;
import fpml.consolidated.shared.PeriodModel;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="AveragingSchedule", builder=AveragingScheduleBuilderImpl.class, version="1.2.2")
@RuneDataType(value="AveragingSchedule", model="fpml", builder=AveragingScheduleBuilderImpl.class, version="1.2.2")
public interface AveragingSchedule
extends RosettaModelObject {
    public static final AveragingScheduleMeta metaData = new AveragingScheduleMeta();

    public PeriodModel getPeriodModel();

    public CalculationPeriodFrequency getAveragingPeriodFrequency();

    public AveragingSchedule build();

    public AveragingScheduleBuilder toBuilder();

    public static AveragingScheduleBuilder builder() {
        return new AveragingScheduleBuilderImpl();
    }

    default public RosettaMetaData<? extends AveragingSchedule> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AveragingSchedule> getType() {
        return AveragingSchedule.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("periodModel"), processor, PeriodModel.class, this.getPeriodModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("averagingPeriodFrequency"), processor, CalculationPeriodFrequency.class, this.getAveragingPeriodFrequency(), new AttributeMeta[0]);
    }

    public static class AveragingScheduleBuilderImpl
    implements AveragingScheduleBuilder {
        protected PeriodModel.PeriodModelBuilder periodModel;
        protected CalculationPeriodFrequency.CalculationPeriodFrequencyBuilder averagingPeriodFrequency;

        @Override
        @RosettaAttribute(value="periodModel", isRequired=true)
        @RuneAttribute(value="periodModel", isRequired=true)
        public PeriodModel.PeriodModelBuilder getPeriodModel() {
            return this.periodModel;
        }

        @Override
        public PeriodModel.PeriodModelBuilder getOrCreatePeriodModel() {
            PeriodModel.PeriodModelBuilder result = this.periodModel != null ? this.periodModel : (this.periodModel = PeriodModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="averagingPeriodFrequency")
        @RuneAttribute(value="averagingPeriodFrequency")
        public CalculationPeriodFrequency.CalculationPeriodFrequencyBuilder getAveragingPeriodFrequency() {
            return this.averagingPeriodFrequency;
        }

        @Override
        public CalculationPeriodFrequency.CalculationPeriodFrequencyBuilder getOrCreateAveragingPeriodFrequency() {
            CalculationPeriodFrequency.CalculationPeriodFrequencyBuilder result = this.averagingPeriodFrequency != null ? this.averagingPeriodFrequency : (this.averagingPeriodFrequency = CalculationPeriodFrequency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="periodModel", isRequired=true)
        @RuneAttribute(value="periodModel", isRequired=true)
        public AveragingScheduleBuilder setPeriodModel(PeriodModel _periodModel) {
            this.periodModel = _periodModel == null ? null : _periodModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="averagingPeriodFrequency")
        @RuneAttribute(value="averagingPeriodFrequency")
        public AveragingScheduleBuilder setAveragingPeriodFrequency(CalculationPeriodFrequency _averagingPeriodFrequency) {
            this.averagingPeriodFrequency = _averagingPeriodFrequency == null ? null : _averagingPeriodFrequency.toBuilder();
            return this;
        }

        @Override
        public AveragingSchedule build() {
            return new AveragingScheduleImpl(this);
        }

        @Override
        public AveragingScheduleBuilder toBuilder() {
            return this;
        }

        @Override
        public AveragingScheduleBuilder prune() {
            if (this.periodModel != null && !this.periodModel.prune().hasData()) {
                this.periodModel = null;
            }
            if (this.averagingPeriodFrequency != null && !this.averagingPeriodFrequency.prune().hasData()) {
                this.averagingPeriodFrequency = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPeriodModel() != null && this.getPeriodModel().hasData()) {
                return true;
            }
            return this.getAveragingPeriodFrequency() != null && this.getAveragingPeriodFrequency().hasData();
        }

        public AveragingScheduleBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AveragingScheduleBuilder o = (AveragingScheduleBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPeriodModel(), (RosettaModelObjectBuilder)o.getPeriodModel(), this::setPeriodModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAveragingPeriodFrequency(), (RosettaModelObjectBuilder)o.getAveragingPeriodFrequency(), this::setAveragingPeriodFrequency);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AveragingSchedule _that = this.getType().cast(o);
            if (!Objects.equals(this.periodModel, _that.getPeriodModel())) {
                return false;
            }
            return Objects.equals(this.averagingPeriodFrequency, _that.getAveragingPeriodFrequency());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.periodModel != null ? this.periodModel.hashCode() : 0);
            _result = 31 * _result + (this.averagingPeriodFrequency != null ? this.averagingPeriodFrequency.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AveragingScheduleBuilder {periodModel=" + String.valueOf(this.periodModel) + ", averagingPeriodFrequency=" + String.valueOf(this.averagingPeriodFrequency) + "}";
        }
    }

    public static interface AveragingScheduleBuilder
    extends AveragingSchedule,
    RosettaModelObjectBuilder {
        public PeriodModel.PeriodModelBuilder getOrCreatePeriodModel();

        @Override
        public PeriodModel.PeriodModelBuilder getPeriodModel();

        public CalculationPeriodFrequency.CalculationPeriodFrequencyBuilder getOrCreateAveragingPeriodFrequency();

        @Override
        public CalculationPeriodFrequency.CalculationPeriodFrequencyBuilder getAveragingPeriodFrequency();

        public AveragingScheduleBuilder setPeriodModel(PeriodModel var1);

        public AveragingScheduleBuilder setAveragingPeriodFrequency(CalculationPeriodFrequency var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("periodModel"), processor, PeriodModel.PeriodModelBuilder.class, this.getPeriodModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("averagingPeriodFrequency"), processor, CalculationPeriodFrequency.CalculationPeriodFrequencyBuilder.class, this.getAveragingPeriodFrequency(), new AttributeMeta[0]);
        }

        public AveragingScheduleBuilder prune();
    }

    public static class AveragingScheduleImpl
    implements AveragingSchedule {
        private final PeriodModel periodModel;
        private final CalculationPeriodFrequency averagingPeriodFrequency;

        protected AveragingScheduleImpl(AveragingScheduleBuilder builder) {
            this.periodModel = Optional.ofNullable(builder.getPeriodModel()).map(f -> f.build()).orElse(null);
            this.averagingPeriodFrequency = Optional.ofNullable(builder.getAveragingPeriodFrequency()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="periodModel", isRequired=true)
        @RuneAttribute(value="periodModel", isRequired=true)
        public PeriodModel getPeriodModel() {
            return this.periodModel;
        }

        @Override
        @RosettaAttribute(value="averagingPeriodFrequency")
        @RuneAttribute(value="averagingPeriodFrequency")
        public CalculationPeriodFrequency getAveragingPeriodFrequency() {
            return this.averagingPeriodFrequency;
        }

        @Override
        public AveragingSchedule build() {
            return this;
        }

        @Override
        public AveragingScheduleBuilder toBuilder() {
            AveragingScheduleBuilder builder = AveragingSchedule.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AveragingScheduleBuilder builder) {
            Optional.ofNullable(this.getPeriodModel()).ifPresent(builder::setPeriodModel);
            Optional.ofNullable(this.getAveragingPeriodFrequency()).ifPresent(builder::setAveragingPeriodFrequency);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AveragingSchedule _that = this.getType().cast(o);
            if (!Objects.equals(this.periodModel, _that.getPeriodModel())) {
                return false;
            }
            return Objects.equals(this.averagingPeriodFrequency, _that.getAveragingPeriodFrequency());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.periodModel != null ? this.periodModel.hashCode() : 0);
            _result = 31 * _result + (this.averagingPeriodFrequency != null ? this.averagingPeriodFrequency.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AveragingSchedule {periodModel=" + String.valueOf(this.periodModel) + ", averagingPeriodFrequency=" + String.valueOf(this.averagingPeriodFrequency) + "}";
        }
    }
}

