/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.msg;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.PartyTradeIdentifier;
import fpml.consolidated.doc.Reason;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.msg.CorrelationAndSequenceModel;
import fpml.consolidated.msg.NonCorrectableRequestMessage;
import fpml.consolidated.msg.RequestMessageHeader;
import fpml.consolidated.msg.VerificationStatus;
import fpml.consolidated.msg.meta.VerificationStatusNotificationMeta;
import fpml.consolidated.shared.OnBehalfOfModel;
import fpml.consolidated.shared.PartiesAndAccountsModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="VerificationStatusNotification", builder=VerificationStatusNotificationBuilderImpl.class, version="1.2.2")
@RuneDataType(value="VerificationStatusNotification", model="fpml", builder=VerificationStatusNotificationBuilderImpl.class, version="1.2.2")
public interface VerificationStatusNotification
extends NonCorrectableRequestMessage {
    public static final VerificationStatusNotificationMeta metaData = new VerificationStatusNotificationMeta();

    public VerificationStatus getStatus();

    public List<? extends Reason> getReason();

    public PartyTradeIdentifier getPartyTradeIdentifier();

    public PartiesAndAccountsModel getPartiesAndAccountsModel();

    @Override
    public VerificationStatusNotification build();

    @Override
    public VerificationStatusNotificationBuilder toBuilder();

    public static VerificationStatusNotificationBuilder builder() {
        return new VerificationStatusNotificationBuilderImpl();
    }

    default public RosettaMetaData<? extends VerificationStatusNotification> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends VerificationStatusNotification> getType() {
        return VerificationStatusNotification.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.class, this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("status"), processor, VerificationStatus.class, this.getStatus(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reason"), processor, Reason.class, this.getReason(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyTradeIdentifier"), processor, PartyTradeIdentifier.class, this.getPartyTradeIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
    }

    public static class VerificationStatusNotificationBuilderImpl
    extends NonCorrectableRequestMessage.NonCorrectableRequestMessageBuilderImpl
    implements VerificationStatusNotificationBuilder {
        protected VerificationStatus.VerificationStatusBuilder status;
        protected List<Reason.ReasonBuilder> reason = new ArrayList<Reason.ReasonBuilder>();
        protected PartyTradeIdentifier.PartyTradeIdentifierBuilder partyTradeIdentifier;
        protected PartiesAndAccountsModel.PartiesAndAccountsModelBuilder partiesAndAccountsModel;

        @Override
        @RosettaAttribute(value="status", isRequired=true)
        @RuneAttribute(value="status", isRequired=true)
        public VerificationStatus.VerificationStatusBuilder getStatus() {
            return this.status;
        }

        @Override
        public VerificationStatus.VerificationStatusBuilder getOrCreateStatus() {
            VerificationStatus.VerificationStatusBuilder result = this.status != null ? this.status : (this.status = VerificationStatus.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="reason")
        @RuneAttribute(value="reason")
        public List<? extends Reason.ReasonBuilder> getReason() {
            return this.reason;
        }

        @Override
        public Reason.ReasonBuilder getOrCreateReason(int index) {
            if (this.reason == null) {
                this.reason = new ArrayList<Reason.ReasonBuilder>();
            }
            return (Reason.ReasonBuilder)this.getIndex(this.reason, index, () -> {
                Reason.ReasonBuilder newReason = Reason.builder();
                return newReason;
            });
        }

        @Override
        @RosettaAttribute(value="partyTradeIdentifier", isRequired=true)
        @RuneAttribute(value="partyTradeIdentifier", isRequired=true)
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getPartyTradeIdentifier() {
            return this.partyTradeIdentifier;
        }

        @Override
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreatePartyTradeIdentifier() {
            PartyTradeIdentifier.PartyTradeIdentifierBuilder result = this.partyTradeIdentifier != null ? this.partyTradeIdentifier : (this.partyTradeIdentifier = PartyTradeIdentifier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel() {
            PartiesAndAccountsModel.PartiesAndAccountsModelBuilder result = this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel : (this.partiesAndAccountsModel = PartiesAndAccountsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public VerificationStatusNotificationBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public VerificationStatusNotificationBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public VerificationStatusNotificationBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public VerificationStatusNotificationBuilder setHeader(RequestMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public VerificationStatusNotificationBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndSequenceModel")
        @RuneAttribute(value="correlationAndSequenceModel")
        public VerificationStatusNotificationBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel _correlationAndSequenceModel) {
            this.correlationAndSequenceModel = _correlationAndSequenceModel == null ? null : _correlationAndSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public VerificationStatusNotificationBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="status", isRequired=true)
        @RuneAttribute(value="status", isRequired=true)
        public VerificationStatusNotificationBuilder setStatus(VerificationStatus _status) {
            this.status = _status == null ? null : _status.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reason")
        @RuneAttribute(value="reason")
        public VerificationStatusNotificationBuilder addReason(Reason _reason) {
            if (_reason != null) {
                this.reason.add(_reason.toBuilder());
            }
            return this;
        }

        @Override
        public VerificationStatusNotificationBuilder addReason(Reason _reason, int idx) {
            this.getIndex(this.reason, idx, () -> _reason.toBuilder());
            return this;
        }

        @Override
        public VerificationStatusNotificationBuilder addReason(List<? extends Reason> reasons) {
            if (reasons != null) {
                for (Reason reason : reasons) {
                    this.reason.add(reason.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="reason")
        public VerificationStatusNotificationBuilder setReason(List<? extends Reason> reasons) {
            this.reason = reasons == null ? new ArrayList<Reason.ReasonBuilder>() : (List)reasons.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="partyTradeIdentifier", isRequired=true)
        @RuneAttribute(value="partyTradeIdentifier", isRequired=true)
        public VerificationStatusNotificationBuilder setPartyTradeIdentifier(PartyTradeIdentifier _partyTradeIdentifier) {
            this.partyTradeIdentifier = _partyTradeIdentifier == null ? null : _partyTradeIdentifier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public VerificationStatusNotificationBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel _partiesAndAccountsModel) {
            this.partiesAndAccountsModel = _partiesAndAccountsModel == null ? null : _partiesAndAccountsModel.toBuilder();
            return this;
        }

        @Override
        public VerificationStatusNotification build() {
            return new VerificationStatusNotificationImpl(this);
        }

        @Override
        public VerificationStatusNotificationBuilder toBuilder() {
            return this;
        }

        @Override
        public VerificationStatusNotificationBuilder prune() {
            super.prune();
            if (this.status != null && !this.status.prune().hasData()) {
                this.status = null;
            }
            this.reason = this.reason.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.partyTradeIdentifier != null && !this.partyTradeIdentifier.prune().hasData()) {
                this.partyTradeIdentifier = null;
            }
            if (this.partiesAndAccountsModel != null && !this.partiesAndAccountsModel.prune().hasData()) {
                this.partiesAndAccountsModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getStatus() != null && this.getStatus().hasData()) {
                return true;
            }
            if (this.getReason() != null && this.getReason().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPartyTradeIdentifier() != null && this.getPartyTradeIdentifier().hasData()) {
                return true;
            }
            return this.getPartiesAndAccountsModel() != null && this.getPartiesAndAccountsModel().hasData();
        }

        @Override
        public VerificationStatusNotificationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            VerificationStatusNotificationBuilder o = (VerificationStatusNotificationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStatus(), (RosettaModelObjectBuilder)o.getStatus(), this::setStatus);
            merger.mergeRosetta(this.getReason(), o.getReason(), this::getOrCreateReason);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartyTradeIdentifier(), (RosettaModelObjectBuilder)o.getPartyTradeIdentifier(), this::setPartyTradeIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartiesAndAccountsModel(), (RosettaModelObjectBuilder)o.getPartiesAndAccountsModel(), this::setPartiesAndAccountsModel);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VerificationStatusNotification _that = (VerificationStatusNotification)this.getType().cast(o);
            if (!Objects.equals(this.status, _that.getStatus())) {
                return false;
            }
            if (!ListEquals.listEquals(this.reason, _that.getReason())) {
                return false;
            }
            if (!Objects.equals(this.partyTradeIdentifier, _that.getPartyTradeIdentifier())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.status != null ? this.status.hashCode() : 0);
            _result = 31 * _result + (this.reason != null ? this.reason.hashCode() : 0);
            _result = 31 * _result + (this.partyTradeIdentifier != null ? this.partyTradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "VerificationStatusNotificationBuilder {status=" + String.valueOf(this.status) + ", reason=" + String.valueOf(this.reason) + ", partyTradeIdentifier=" + String.valueOf(this.partyTradeIdentifier) + ", partiesAndAccountsModel=" + String.valueOf(this.partiesAndAccountsModel) + "} " + super.toString();
        }
    }

    public static interface VerificationStatusNotificationBuilder
    extends VerificationStatusNotification,
    NonCorrectableRequestMessage.NonCorrectableRequestMessageBuilder {
        public VerificationStatus.VerificationStatusBuilder getOrCreateStatus();

        @Override
        public VerificationStatus.VerificationStatusBuilder getStatus();

        public Reason.ReasonBuilder getOrCreateReason(int var1);

        public List<? extends Reason.ReasonBuilder> getReason();

        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreatePartyTradeIdentifier();

        @Override
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getPartyTradeIdentifier();

        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel();

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel();

        @Override
        public VerificationStatusNotificationBuilder setFpmlVersion(String var1);

        @Override
        public VerificationStatusNotificationBuilder setExpectedBuild(Integer var1);

        @Override
        public VerificationStatusNotificationBuilder setActualBuild(Integer var1);

        @Override
        public VerificationStatusNotificationBuilder setHeader(RequestMessageHeader var1);

        @Override
        public VerificationStatusNotificationBuilder setValidationModel(ValidationModel var1);

        @Override
        public VerificationStatusNotificationBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel var1);

        @Override
        public VerificationStatusNotificationBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        public VerificationStatusNotificationBuilder setStatus(VerificationStatus var1);

        public VerificationStatusNotificationBuilder addReason(Reason var1);

        public VerificationStatusNotificationBuilder addReason(Reason var1, int var2);

        public VerificationStatusNotificationBuilder addReason(List<? extends Reason> var1);

        public VerificationStatusNotificationBuilder setReason(List<? extends Reason> var1);

        public VerificationStatusNotificationBuilder setPartyTradeIdentifier(PartyTradeIdentifier var1);

        public VerificationStatusNotificationBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.RequestMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.CorrelationAndSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("status"), processor, VerificationStatus.VerificationStatusBuilder.class, this.getStatus(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reason"), processor, Reason.ReasonBuilder.class, this.getReason(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyTradeIdentifier"), processor, PartyTradeIdentifier.PartyTradeIdentifierBuilder.class, this.getPartyTradeIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.PartiesAndAccountsModelBuilder.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
        }

        @Override
        public VerificationStatusNotificationBuilder prune();
    }

    public static class VerificationStatusNotificationImpl
    extends NonCorrectableRequestMessage.NonCorrectableRequestMessageImpl
    implements VerificationStatusNotification {
        private final VerificationStatus status;
        private final List<? extends Reason> reason;
        private final PartyTradeIdentifier partyTradeIdentifier;
        private final PartiesAndAccountsModel partiesAndAccountsModel;

        protected VerificationStatusNotificationImpl(VerificationStatusNotificationBuilder builder) {
            super(builder);
            this.status = Optional.ofNullable(builder.getStatus()).map(f -> f.build()).orElse(null);
            this.reason = Optional.ofNullable(builder.getReason()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.partyTradeIdentifier = Optional.ofNullable(builder.getPartyTradeIdentifier()).map(f -> f.build()).orElse(null);
            this.partiesAndAccountsModel = Optional.ofNullable(builder.getPartiesAndAccountsModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="status", isRequired=true)
        @RuneAttribute(value="status", isRequired=true)
        public VerificationStatus getStatus() {
            return this.status;
        }

        @Override
        @RosettaAttribute(value="reason")
        @RuneAttribute(value="reason")
        public List<? extends Reason> getReason() {
            return this.reason;
        }

        @Override
        @RosettaAttribute(value="partyTradeIdentifier", isRequired=true)
        @RuneAttribute(value="partyTradeIdentifier", isRequired=true)
        public PartyTradeIdentifier getPartyTradeIdentifier() {
            return this.partyTradeIdentifier;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public PartiesAndAccountsModel getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public VerificationStatusNotification build() {
            return this;
        }

        @Override
        public VerificationStatusNotificationBuilder toBuilder() {
            VerificationStatusNotificationBuilder builder = VerificationStatusNotification.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(VerificationStatusNotificationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getStatus()).ifPresent(builder::setStatus);
            Optional.ofNullable(this.getReason()).ifPresent(builder::setReason);
            Optional.ofNullable(this.getPartyTradeIdentifier()).ifPresent(builder::setPartyTradeIdentifier);
            Optional.ofNullable(this.getPartiesAndAccountsModel()).ifPresent(builder::setPartiesAndAccountsModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VerificationStatusNotification _that = (VerificationStatusNotification)this.getType().cast(o);
            if (!Objects.equals(this.status, _that.getStatus())) {
                return false;
            }
            if (!ListEquals.listEquals(this.reason, _that.getReason())) {
                return false;
            }
            if (!Objects.equals(this.partyTradeIdentifier, _that.getPartyTradeIdentifier())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.status != null ? this.status.hashCode() : 0);
            _result = 31 * _result + (this.reason != null ? this.reason.hashCode() : 0);
            _result = 31 * _result + (this.partyTradeIdentifier != null ? this.partyTradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "VerificationStatusNotification {status=" + String.valueOf(this.status) + ", reason=" + String.valueOf(this.reason) + ", partyTradeIdentifier=" + String.valueOf(this.partyTradeIdentifier) + ", partiesAndAccountsModel=" + String.valueOf(this.partiesAndAccountsModel) + "} " + super.toString();
        }
    }
}

