/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.msg;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.msg.BusinessProcess;
import fpml.consolidated.msg.CorrelationAndSequenceModel;
import fpml.consolidated.msg.EventIdentifier;
import fpml.consolidated.msg.NonCorrectableRequestMessage;
import fpml.consolidated.msg.RequestMessageHeader;
import fpml.consolidated.msg.meta.RequestEventStatusMeta;
import fpml.consolidated.shared.OnBehalfOfModel;
import fpml.consolidated.shared.PartiesAndAccountsModel;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="RequestEventStatus", builder=RequestEventStatusBuilderImpl.class, version="1.2.2")
@RuneDataType(value="RequestEventStatus", model="fpml", builder=RequestEventStatusBuilderImpl.class, version="1.2.2")
public interface RequestEventStatus
extends NonCorrectableRequestMessage {
    public static final RequestEventStatusMeta metaData = new RequestEventStatusMeta();

    public BusinessProcess getBusinessProcess();

    public EventIdentifier getEventIdentifier();

    public PartiesAndAccountsModel getPartiesAndAccountsModel();

    @Override
    public RequestEventStatus build();

    @Override
    public RequestEventStatusBuilder toBuilder();

    public static RequestEventStatusBuilder builder() {
        return new RequestEventStatusBuilderImpl();
    }

    default public RosettaMetaData<? extends RequestEventStatus> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RequestEventStatus> getType() {
        return RequestEventStatus.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.class, this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessProcess"), processor, BusinessProcess.class, this.getBusinessProcess(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, EventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
    }

    public static class RequestEventStatusBuilderImpl
    extends NonCorrectableRequestMessage.NonCorrectableRequestMessageBuilderImpl
    implements RequestEventStatusBuilder {
        protected BusinessProcess.BusinessProcessBuilder businessProcess;
        protected EventIdentifier.EventIdentifierBuilder eventIdentifier;
        protected PartiesAndAccountsModel.PartiesAndAccountsModelBuilder partiesAndAccountsModel;

        @Override
        @RosettaAttribute(value="businessProcess")
        @RuneAttribute(value="businessProcess")
        public BusinessProcess.BusinessProcessBuilder getBusinessProcess() {
            return this.businessProcess;
        }

        @Override
        public BusinessProcess.BusinessProcessBuilder getOrCreateBusinessProcess() {
            BusinessProcess.BusinessProcessBuilder result = this.businessProcess != null ? this.businessProcess : (this.businessProcess = BusinessProcess.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public EventIdentifier.EventIdentifierBuilder getEventIdentifier() {
            return this.eventIdentifier;
        }

        @Override
        public EventIdentifier.EventIdentifierBuilder getOrCreateEventIdentifier() {
            EventIdentifier.EventIdentifierBuilder result = this.eventIdentifier != null ? this.eventIdentifier : (this.eventIdentifier = EventIdentifier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel() {
            PartiesAndAccountsModel.PartiesAndAccountsModelBuilder result = this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel : (this.partiesAndAccountsModel = PartiesAndAccountsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public RequestEventStatusBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public RequestEventStatusBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public RequestEventStatusBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public RequestEventStatusBuilder setHeader(RequestMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public RequestEventStatusBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndSequenceModel")
        @RuneAttribute(value="correlationAndSequenceModel")
        public RequestEventStatusBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel _correlationAndSequenceModel) {
            this.correlationAndSequenceModel = _correlationAndSequenceModel == null ? null : _correlationAndSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public RequestEventStatusBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="businessProcess")
        @RuneAttribute(value="businessProcess")
        public RequestEventStatusBuilder setBusinessProcess(BusinessProcess _businessProcess) {
            this.businessProcess = _businessProcess == null ? null : _businessProcess.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public RequestEventStatusBuilder setEventIdentifier(EventIdentifier _eventIdentifier) {
            this.eventIdentifier = _eventIdentifier == null ? null : _eventIdentifier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public RequestEventStatusBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel _partiesAndAccountsModel) {
            this.partiesAndAccountsModel = _partiesAndAccountsModel == null ? null : _partiesAndAccountsModel.toBuilder();
            return this;
        }

        @Override
        public RequestEventStatus build() {
            return new RequestEventStatusImpl(this);
        }

        @Override
        public RequestEventStatusBuilder toBuilder() {
            return this;
        }

        @Override
        public RequestEventStatusBuilder prune() {
            super.prune();
            if (this.businessProcess != null && !this.businessProcess.prune().hasData()) {
                this.businessProcess = null;
            }
            if (this.eventIdentifier != null && !this.eventIdentifier.prune().hasData()) {
                this.eventIdentifier = null;
            }
            if (this.partiesAndAccountsModel != null && !this.partiesAndAccountsModel.prune().hasData()) {
                this.partiesAndAccountsModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getBusinessProcess() != null && this.getBusinessProcess().hasData()) {
                return true;
            }
            if (this.getEventIdentifier() != null && this.getEventIdentifier().hasData()) {
                return true;
            }
            return this.getPartiesAndAccountsModel() != null && this.getPartiesAndAccountsModel().hasData();
        }

        @Override
        public RequestEventStatusBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            RequestEventStatusBuilder o = (RequestEventStatusBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBusinessProcess(), (RosettaModelObjectBuilder)o.getBusinessProcess(), this::setBusinessProcess);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEventIdentifier(), (RosettaModelObjectBuilder)o.getEventIdentifier(), this::setEventIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartiesAndAccountsModel(), (RosettaModelObjectBuilder)o.getPartiesAndAccountsModel(), this::setPartiesAndAccountsModel);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RequestEventStatus _that = (RequestEventStatus)this.getType().cast(o);
            if (!Objects.equals(this.businessProcess, _that.getBusinessProcess())) {
                return false;
            }
            if (!Objects.equals(this.eventIdentifier, _that.getEventIdentifier())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.businessProcess != null ? this.businessProcess.hashCode() : 0);
            _result = 31 * _result + (this.eventIdentifier != null ? this.eventIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RequestEventStatusBuilder {businessProcess=" + String.valueOf(this.businessProcess) + ", eventIdentifier=" + String.valueOf(this.eventIdentifier) + ", partiesAndAccountsModel=" + String.valueOf(this.partiesAndAccountsModel) + "} " + super.toString();
        }
    }

    public static interface RequestEventStatusBuilder
    extends RequestEventStatus,
    NonCorrectableRequestMessage.NonCorrectableRequestMessageBuilder {
        public BusinessProcess.BusinessProcessBuilder getOrCreateBusinessProcess();

        @Override
        public BusinessProcess.BusinessProcessBuilder getBusinessProcess();

        public EventIdentifier.EventIdentifierBuilder getOrCreateEventIdentifier();

        @Override
        public EventIdentifier.EventIdentifierBuilder getEventIdentifier();

        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel();

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel();

        @Override
        public RequestEventStatusBuilder setFpmlVersion(String var1);

        @Override
        public RequestEventStatusBuilder setExpectedBuild(Integer var1);

        @Override
        public RequestEventStatusBuilder setActualBuild(Integer var1);

        @Override
        public RequestEventStatusBuilder setHeader(RequestMessageHeader var1);

        @Override
        public RequestEventStatusBuilder setValidationModel(ValidationModel var1);

        @Override
        public RequestEventStatusBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel var1);

        @Override
        public RequestEventStatusBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        public RequestEventStatusBuilder setBusinessProcess(BusinessProcess var1);

        public RequestEventStatusBuilder setEventIdentifier(EventIdentifier var1);

        public RequestEventStatusBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.RequestMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.CorrelationAndSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessProcess"), processor, BusinessProcess.BusinessProcessBuilder.class, this.getBusinessProcess(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, EventIdentifier.EventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.PartiesAndAccountsModelBuilder.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
        }

        @Override
        public RequestEventStatusBuilder prune();
    }

    public static class RequestEventStatusImpl
    extends NonCorrectableRequestMessage.NonCorrectableRequestMessageImpl
    implements RequestEventStatus {
        private final BusinessProcess businessProcess;
        private final EventIdentifier eventIdentifier;
        private final PartiesAndAccountsModel partiesAndAccountsModel;

        protected RequestEventStatusImpl(RequestEventStatusBuilder builder) {
            super(builder);
            this.businessProcess = Optional.ofNullable(builder.getBusinessProcess()).map(f -> f.build()).orElse(null);
            this.eventIdentifier = Optional.ofNullable(builder.getEventIdentifier()).map(f -> f.build()).orElse(null);
            this.partiesAndAccountsModel = Optional.ofNullable(builder.getPartiesAndAccountsModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="businessProcess")
        @RuneAttribute(value="businessProcess")
        public BusinessProcess getBusinessProcess() {
            return this.businessProcess;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public EventIdentifier getEventIdentifier() {
            return this.eventIdentifier;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public PartiesAndAccountsModel getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public RequestEventStatus build() {
            return this;
        }

        @Override
        public RequestEventStatusBuilder toBuilder() {
            RequestEventStatusBuilder builder = RequestEventStatus.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RequestEventStatusBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getBusinessProcess()).ifPresent(builder::setBusinessProcess);
            Optional.ofNullable(this.getEventIdentifier()).ifPresent(builder::setEventIdentifier);
            Optional.ofNullable(this.getPartiesAndAccountsModel()).ifPresent(builder::setPartiesAndAccountsModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RequestEventStatus _that = (RequestEventStatus)this.getType().cast(o);
            if (!Objects.equals(this.businessProcess, _that.getBusinessProcess())) {
                return false;
            }
            if (!Objects.equals(this.eventIdentifier, _that.getEventIdentifier())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.businessProcess != null ? this.businessProcess.hashCode() : 0);
            _result = 31 * _result + (this.eventIdentifier != null ? this.eventIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RequestEventStatus {businessProcess=" + String.valueOf(this.businessProcess) + ", eventIdentifier=" + String.valueOf(this.eventIdentifier) + ", partiesAndAccountsModel=" + String.valueOf(this.partiesAndAccountsModel) + "} " + super.toString();
        }
    }
}

