/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.loan.SimplePayerReceiverModel;
import fpml.consolidated.loan.meta.LoanSimplePaymentMeta;
import fpml.consolidated.shared.AdjustableDate;
import fpml.consolidated.shared.NonNegativeMoney;
import fpml.consolidated.shared.PaymentBase;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="LoanSimplePayment", builder=LoanSimplePaymentBuilderImpl.class, version="1.2.2")
@RuneDataType(value="LoanSimplePayment", model="fpml", builder=LoanSimplePaymentBuilderImpl.class, version="1.2.2")
public interface LoanSimplePayment
extends PaymentBase {
    public static final LoanSimplePaymentMeta metaData = new LoanSimplePaymentMeta();

    public SimplePayerReceiverModel getSimplePayerReceiverModel();

    public NonNegativeMoney getPaymentAmount();

    public AdjustableDate getPaymentDate();

    @Override
    public LoanSimplePayment build();

    @Override
    public LoanSimplePaymentBuilder toBuilder();

    public static LoanSimplePaymentBuilder builder() {
        return new LoanSimplePaymentBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanSimplePayment> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanSimplePayment> getType() {
        return LoanSimplePayment.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("simplePayerReceiverModel"), processor, SimplePayerReceiverModel.class, this.getSimplePayerReceiverModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentAmount"), processor, NonNegativeMoney.class, this.getPaymentAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableDate.class, this.getPaymentDate(), new AttributeMeta[0]);
    }

    public static class LoanSimplePaymentBuilderImpl
    extends PaymentBase.PaymentBaseBuilderImpl
    implements LoanSimplePaymentBuilder {
        protected SimplePayerReceiverModel.SimplePayerReceiverModelBuilder simplePayerReceiverModel;
        protected NonNegativeMoney.NonNegativeMoneyBuilder paymentAmount;
        protected AdjustableDate.AdjustableDateBuilder paymentDate;

        @Override
        @RosettaAttribute(value="simplePayerReceiverModel", isRequired=true)
        @RuneAttribute(value="simplePayerReceiverModel", isRequired=true)
        public SimplePayerReceiverModel.SimplePayerReceiverModelBuilder getSimplePayerReceiverModel() {
            return this.simplePayerReceiverModel;
        }

        @Override
        public SimplePayerReceiverModel.SimplePayerReceiverModelBuilder getOrCreateSimplePayerReceiverModel() {
            SimplePayerReceiverModel.SimplePayerReceiverModelBuilder result = this.simplePayerReceiverModel != null ? this.simplePayerReceiverModel : (this.simplePayerReceiverModel = SimplePayerReceiverModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paymentAmount", isRequired=true)
        @RuneAttribute(value="paymentAmount", isRequired=true)
        public NonNegativeMoney.NonNegativeMoneyBuilder getPaymentAmount() {
            return this.paymentAmount;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreatePaymentAmount() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.paymentAmount != null ? this.paymentAmount : (this.paymentAmount = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paymentDate", isRequired=true)
        @RuneAttribute(value="paymentDate", isRequired=true)
        public AdjustableDate.AdjustableDateBuilder getPaymentDate() {
            return this.paymentDate;
        }

        @Override
        public AdjustableDate.AdjustableDateBuilder getOrCreatePaymentDate() {
            AdjustableDate.AdjustableDateBuilder result = this.paymentDate != null ? this.paymentDate : (this.paymentDate = AdjustableDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public LoanSimplePaymentBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="simplePayerReceiverModel", isRequired=true)
        @RuneAttribute(value="simplePayerReceiverModel", isRequired=true)
        public LoanSimplePaymentBuilder setSimplePayerReceiverModel(SimplePayerReceiverModel _simplePayerReceiverModel) {
            this.simplePayerReceiverModel = _simplePayerReceiverModel == null ? null : _simplePayerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentAmount", isRequired=true)
        @RuneAttribute(value="paymentAmount", isRequired=true)
        public LoanSimplePaymentBuilder setPaymentAmount(NonNegativeMoney _paymentAmount) {
            this.paymentAmount = _paymentAmount == null ? null : _paymentAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentDate", isRequired=true)
        @RuneAttribute(value="paymentDate", isRequired=true)
        public LoanSimplePaymentBuilder setPaymentDate(AdjustableDate _paymentDate) {
            this.paymentDate = _paymentDate == null ? null : _paymentDate.toBuilder();
            return this;
        }

        @Override
        public LoanSimplePayment build() {
            return new LoanSimplePaymentImpl(this);
        }

        @Override
        public LoanSimplePaymentBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanSimplePaymentBuilder prune() {
            super.prune();
            if (this.simplePayerReceiverModel != null && !this.simplePayerReceiverModel.prune().hasData()) {
                this.simplePayerReceiverModel = null;
            }
            if (this.paymentAmount != null && !this.paymentAmount.prune().hasData()) {
                this.paymentAmount = null;
            }
            if (this.paymentDate != null && !this.paymentDate.prune().hasData()) {
                this.paymentDate = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getSimplePayerReceiverModel() != null && this.getSimplePayerReceiverModel().hasData()) {
                return true;
            }
            if (this.getPaymentAmount() != null && this.getPaymentAmount().hasData()) {
                return true;
            }
            return this.getPaymentDate() != null && this.getPaymentDate().hasData();
        }

        @Override
        public LoanSimplePaymentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LoanSimplePaymentBuilder o = (LoanSimplePaymentBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSimplePayerReceiverModel(), (RosettaModelObjectBuilder)o.getSimplePayerReceiverModel(), this::setSimplePayerReceiverModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentAmount(), (RosettaModelObjectBuilder)o.getPaymentAmount(), this::setPaymentAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentDate(), (RosettaModelObjectBuilder)o.getPaymentDate(), this::setPaymentDate);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanSimplePayment _that = (LoanSimplePayment)this.getType().cast(o);
            if (!Objects.equals(this.simplePayerReceiverModel, _that.getSimplePayerReceiverModel())) {
                return false;
            }
            if (!Objects.equals(this.paymentAmount, _that.getPaymentAmount())) {
                return false;
            }
            return Objects.equals(this.paymentDate, _that.getPaymentDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.simplePayerReceiverModel != null ? this.simplePayerReceiverModel.hashCode() : 0);
            _result = 31 * _result + (this.paymentAmount != null ? this.paymentAmount.hashCode() : 0);
            _result = 31 * _result + (this.paymentDate != null ? this.paymentDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanSimplePaymentBuilder {simplePayerReceiverModel=" + String.valueOf(this.simplePayerReceiverModel) + ", paymentAmount=" + String.valueOf(this.paymentAmount) + ", paymentDate=" + String.valueOf(this.paymentDate) + "} " + super.toString();
        }
    }

    public static interface LoanSimplePaymentBuilder
    extends LoanSimplePayment,
    PaymentBase.PaymentBaseBuilder {
        public SimplePayerReceiverModel.SimplePayerReceiverModelBuilder getOrCreateSimplePayerReceiverModel();

        @Override
        public SimplePayerReceiverModel.SimplePayerReceiverModelBuilder getSimplePayerReceiverModel();

        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreatePaymentAmount();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getPaymentAmount();

        public AdjustableDate.AdjustableDateBuilder getOrCreatePaymentDate();

        @Override
        public AdjustableDate.AdjustableDateBuilder getPaymentDate();

        @Override
        public LoanSimplePaymentBuilder setId(String var1);

        public LoanSimplePaymentBuilder setSimplePayerReceiverModel(SimplePayerReceiverModel var1);

        public LoanSimplePaymentBuilder setPaymentAmount(NonNegativeMoney var1);

        public LoanSimplePaymentBuilder setPaymentDate(AdjustableDate var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("simplePayerReceiverModel"), processor, SimplePayerReceiverModel.SimplePayerReceiverModelBuilder.class, this.getSimplePayerReceiverModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentAmount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getPaymentAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableDate.AdjustableDateBuilder.class, this.getPaymentDate(), new AttributeMeta[0]);
        }

        @Override
        public LoanSimplePaymentBuilder prune();
    }

    public static class LoanSimplePaymentImpl
    extends PaymentBase.PaymentBaseImpl
    implements LoanSimplePayment {
        private final SimplePayerReceiverModel simplePayerReceiverModel;
        private final NonNegativeMoney paymentAmount;
        private final AdjustableDate paymentDate;

        protected LoanSimplePaymentImpl(LoanSimplePaymentBuilder builder) {
            super(builder);
            this.simplePayerReceiverModel = Optional.ofNullable(builder.getSimplePayerReceiverModel()).map(f -> f.build()).orElse(null);
            this.paymentAmount = Optional.ofNullable(builder.getPaymentAmount()).map(f -> f.build()).orElse(null);
            this.paymentDate = Optional.ofNullable(builder.getPaymentDate()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="simplePayerReceiverModel", isRequired=true)
        @RuneAttribute(value="simplePayerReceiverModel", isRequired=true)
        public SimplePayerReceiverModel getSimplePayerReceiverModel() {
            return this.simplePayerReceiverModel;
        }

        @Override
        @RosettaAttribute(value="paymentAmount", isRequired=true)
        @RuneAttribute(value="paymentAmount", isRequired=true)
        public NonNegativeMoney getPaymentAmount() {
            return this.paymentAmount;
        }

        @Override
        @RosettaAttribute(value="paymentDate", isRequired=true)
        @RuneAttribute(value="paymentDate", isRequired=true)
        public AdjustableDate getPaymentDate() {
            return this.paymentDate;
        }

        @Override
        public LoanSimplePayment build() {
            return this;
        }

        @Override
        public LoanSimplePaymentBuilder toBuilder() {
            LoanSimplePaymentBuilder builder = LoanSimplePayment.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanSimplePaymentBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getSimplePayerReceiverModel()).ifPresent(builder::setSimplePayerReceiverModel);
            Optional.ofNullable(this.getPaymentAmount()).ifPresent(builder::setPaymentAmount);
            Optional.ofNullable(this.getPaymentDate()).ifPresent(builder::setPaymentDate);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanSimplePayment _that = (LoanSimplePayment)this.getType().cast(o);
            if (!Objects.equals(this.simplePayerReceiverModel, _that.getSimplePayerReceiverModel())) {
                return false;
            }
            if (!Objects.equals(this.paymentAmount, _that.getPaymentAmount())) {
                return false;
            }
            return Objects.equals(this.paymentDate, _that.getPaymentDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.simplePayerReceiverModel != null ? this.simplePayerReceiverModel.hashCode() : 0);
            _result = 31 * _result + (this.paymentAmount != null ? this.paymentAmount.hashCode() : 0);
            _result = 31 * _result + (this.paymentDate != null ? this.paymentDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanSimplePayment {simplePayerReceiverModel=" + String.valueOf(this.simplePayerReceiverModel) + ", paymentAmount=" + String.valueOf(this.paymentAmount) + ", paymentDate=" + String.valueOf(this.paymentDate) + "} " + super.toString();
        }
    }
}

