/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.loan.AbstractLoanCovenantObligation;
import fpml.consolidated.loan.CovenantObligationId;
import fpml.consolidated.loan.DealReference;
import fpml.consolidated.loan.FacilityReference;
import fpml.consolidated.loan.LoanCovenantObligationReference;
import fpml.consolidated.loan.LoanCovenantObligationSequence;
import fpml.consolidated.loan.VersionedCovenantObligationId;
import fpml.consolidated.loan.meta.LoanCovenantObligationMeta;
import fpml.consolidated.shared.PartyReference;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LoanCovenantObligation", builder=LoanCovenantObligationBuilderImpl.class, version="1.2.2")
@RuneDataType(value="LoanCovenantObligation", model="fpml", builder=LoanCovenantObligationBuilderImpl.class, version="1.2.2")
public interface LoanCovenantObligation
extends AbstractLoanCovenantObligation {
    public static final LoanCovenantObligationMeta metaData = new LoanCovenantObligationMeta();

    public LoanCovenantObligationReference getDeemedCovenantReference();

    public LoanCovenantObligationSequence getLoanCovenantObligationSequence();

    @Override
    public LoanCovenantObligation build();

    @Override
    public LoanCovenantObligationBuilder toBuilder();

    public static LoanCovenantObligationBuilder builder() {
        return new LoanCovenantObligationBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanCovenantObligation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanCovenantObligation> getType() {
        return LoanCovenantObligation.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.class, this.getPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("covenantObligationId"), processor, CovenantObligationId.class, this.getCovenantObligationId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("versionedCovenantObligationId"), processor, VersionedCovenantObligationId.class, this.getVersionedCovenantObligationId(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("obligatedParty"), processor, PartyReference.class, this.getObligatedParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dealReference"), processor, DealReference.class, this.getDealReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.class, this.getFacilityReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deemedCovenantReference"), processor, LoanCovenantObligationReference.class, this.getDeemedCovenantReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanCovenantObligationSequence"), processor, LoanCovenantObligationSequence.class, this.getLoanCovenantObligationSequence(), new AttributeMeta[0]);
    }

    public static class LoanCovenantObligationBuilderImpl
    extends AbstractLoanCovenantObligation.AbstractLoanCovenantObligationBuilderImpl
    implements LoanCovenantObligationBuilder {
        protected LoanCovenantObligationReference.LoanCovenantObligationReferenceBuilder deemedCovenantReference;
        protected LoanCovenantObligationSequence.LoanCovenantObligationSequenceBuilder loanCovenantObligationSequence;

        @Override
        @RosettaAttribute(value="deemedCovenantReference")
        @RuneAttribute(value="deemedCovenantReference")
        public LoanCovenantObligationReference.LoanCovenantObligationReferenceBuilder getDeemedCovenantReference() {
            return this.deemedCovenantReference;
        }

        @Override
        public LoanCovenantObligationReference.LoanCovenantObligationReferenceBuilder getOrCreateDeemedCovenantReference() {
            LoanCovenantObligationReference.LoanCovenantObligationReferenceBuilder result = this.deemedCovenantReference != null ? this.deemedCovenantReference : (this.deemedCovenantReference = LoanCovenantObligationReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="loanCovenantObligationSequence")
        @RuneAttribute(value="loanCovenantObligationSequence")
        public LoanCovenantObligationSequence.LoanCovenantObligationSequenceBuilder getLoanCovenantObligationSequence() {
            return this.loanCovenantObligationSequence;
        }

        @Override
        public LoanCovenantObligationSequence.LoanCovenantObligationSequenceBuilder getOrCreateLoanCovenantObligationSequence() {
            LoanCovenantObligationSequence.LoanCovenantObligationSequenceBuilder result = this.loanCovenantObligationSequence != null ? this.loanCovenantObligationSequence : (this.loanCovenantObligationSequence = LoanCovenantObligationSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public LoanCovenantObligationBuilder setName(String _name) {
            this.name = _name == null ? null : _name;
            return this;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public LoanCovenantObligationBuilder setPartyReference(PartyReference _partyReference) {
            this.partyReference = _partyReference == null ? null : _partyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="covenantObligationId")
        @RuneAttribute(value="covenantObligationId")
        public LoanCovenantObligationBuilder addCovenantObligationId(CovenantObligationId _covenantObligationId) {
            if (_covenantObligationId != null) {
                this.covenantObligationId.add(_covenantObligationId.toBuilder());
            }
            return this;
        }

        @Override
        public LoanCovenantObligationBuilder addCovenantObligationId(CovenantObligationId _covenantObligationId, int idx) {
            this.getIndex(this.covenantObligationId, idx, () -> _covenantObligationId.toBuilder());
            return this;
        }

        @Override
        public LoanCovenantObligationBuilder addCovenantObligationId(List<? extends CovenantObligationId> covenantObligationIds) {
            if (covenantObligationIds != null) {
                for (CovenantObligationId covenantObligationId : covenantObligationIds) {
                    this.covenantObligationId.add(covenantObligationId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="covenantObligationId")
        public LoanCovenantObligationBuilder setCovenantObligationId(List<? extends CovenantObligationId> covenantObligationIds) {
            this.covenantObligationId = covenantObligationIds == null ? new ArrayList() : (List)covenantObligationIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="versionedCovenantObligationId")
        @RuneAttribute(value="versionedCovenantObligationId")
        public LoanCovenantObligationBuilder addVersionedCovenantObligationId(VersionedCovenantObligationId _versionedCovenantObligationId) {
            if (_versionedCovenantObligationId != null) {
                this.versionedCovenantObligationId.add(_versionedCovenantObligationId.toBuilder());
            }
            return this;
        }

        @Override
        public LoanCovenantObligationBuilder addVersionedCovenantObligationId(VersionedCovenantObligationId _versionedCovenantObligationId, int idx) {
            this.getIndex(this.versionedCovenantObligationId, idx, () -> _versionedCovenantObligationId.toBuilder());
            return this;
        }

        @Override
        public LoanCovenantObligationBuilder addVersionedCovenantObligationId(List<? extends VersionedCovenantObligationId> versionedCovenantObligationIds) {
            if (versionedCovenantObligationIds != null) {
                for (VersionedCovenantObligationId versionedCovenantObligationId : versionedCovenantObligationIds) {
                    this.versionedCovenantObligationId.add(versionedCovenantObligationId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="versionedCovenantObligationId")
        public LoanCovenantObligationBuilder setVersionedCovenantObligationId(List<? extends VersionedCovenantObligationId> versionedCovenantObligationIds) {
            this.versionedCovenantObligationId = versionedCovenantObligationIds == null ? new ArrayList() : (List)versionedCovenantObligationIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public LoanCovenantObligationBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public LoanCovenantObligationBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="obligatedParty", isRequired=true)
        @RuneAttribute(value="obligatedParty", isRequired=true)
        public LoanCovenantObligationBuilder setObligatedParty(PartyReference _obligatedParty) {
            this.obligatedParty = _obligatedParty == null ? null : _obligatedParty.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dealReference")
        @RuneAttribute(value="dealReference")
        public LoanCovenantObligationBuilder setDealReference(DealReference _dealReference) {
            this.dealReference = _dealReference == null ? null : _dealReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityReference")
        @RuneAttribute(value="facilityReference")
        public LoanCovenantObligationBuilder addFacilityReference(FacilityReference _facilityReference) {
            if (_facilityReference != null) {
                this.facilityReference.add(_facilityReference.toBuilder());
            }
            return this;
        }

        @Override
        public LoanCovenantObligationBuilder addFacilityReference(FacilityReference _facilityReference, int idx) {
            this.getIndex(this.facilityReference, idx, () -> _facilityReference.toBuilder());
            return this;
        }

        @Override
        public LoanCovenantObligationBuilder addFacilityReference(List<? extends FacilityReference> facilityReferences) {
            if (facilityReferences != null) {
                for (FacilityReference facilityReference : facilityReferences) {
                    this.facilityReference.add(facilityReference.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="facilityReference")
        public LoanCovenantObligationBuilder setFacilityReference(List<? extends FacilityReference> facilityReferences) {
            this.facilityReference = facilityReferences == null ? new ArrayList() : (List)facilityReferences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="deemedCovenantReference")
        @RuneAttribute(value="deemedCovenantReference")
        public LoanCovenantObligationBuilder setDeemedCovenantReference(LoanCovenantObligationReference _deemedCovenantReference) {
            this.deemedCovenantReference = _deemedCovenantReference == null ? null : _deemedCovenantReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="loanCovenantObligationSequence")
        @RuneAttribute(value="loanCovenantObligationSequence")
        public LoanCovenantObligationBuilder setLoanCovenantObligationSequence(LoanCovenantObligationSequence _loanCovenantObligationSequence) {
            this.loanCovenantObligationSequence = _loanCovenantObligationSequence == null ? null : _loanCovenantObligationSequence.toBuilder();
            return this;
        }

        @Override
        public LoanCovenantObligation build() {
            return new LoanCovenantObligationImpl(this);
        }

        @Override
        public LoanCovenantObligationBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanCovenantObligationBuilder prune() {
            super.prune();
            if (this.deemedCovenantReference != null && !this.deemedCovenantReference.prune().hasData()) {
                this.deemedCovenantReference = null;
            }
            if (this.loanCovenantObligationSequence != null && !this.loanCovenantObligationSequence.prune().hasData()) {
                this.loanCovenantObligationSequence = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getDeemedCovenantReference() != null && this.getDeemedCovenantReference().hasData()) {
                return true;
            }
            return this.getLoanCovenantObligationSequence() != null && this.getLoanCovenantObligationSequence().hasData();
        }

        @Override
        public LoanCovenantObligationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LoanCovenantObligationBuilder o = (LoanCovenantObligationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeemedCovenantReference(), (RosettaModelObjectBuilder)o.getDeemedCovenantReference(), this::setDeemedCovenantReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLoanCovenantObligationSequence(), (RosettaModelObjectBuilder)o.getLoanCovenantObligationSequence(), this::setLoanCovenantObligationSequence);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanCovenantObligation _that = (LoanCovenantObligation)this.getType().cast(o);
            if (!Objects.equals(this.deemedCovenantReference, _that.getDeemedCovenantReference())) {
                return false;
            }
            return Objects.equals(this.loanCovenantObligationSequence, _that.getLoanCovenantObligationSequence());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.deemedCovenantReference != null ? this.deemedCovenantReference.hashCode() : 0);
            _result = 31 * _result + (this.loanCovenantObligationSequence != null ? this.loanCovenantObligationSequence.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanCovenantObligationBuilder {deemedCovenantReference=" + String.valueOf(this.deemedCovenantReference) + ", loanCovenantObligationSequence=" + String.valueOf(this.loanCovenantObligationSequence) + "} " + super.toString();
        }
    }

    public static interface LoanCovenantObligationBuilder
    extends LoanCovenantObligation,
    AbstractLoanCovenantObligation.AbstractLoanCovenantObligationBuilder {
        public LoanCovenantObligationReference.LoanCovenantObligationReferenceBuilder getOrCreateDeemedCovenantReference();

        @Override
        public LoanCovenantObligationReference.LoanCovenantObligationReferenceBuilder getDeemedCovenantReference();

        public LoanCovenantObligationSequence.LoanCovenantObligationSequenceBuilder getOrCreateLoanCovenantObligationSequence();

        @Override
        public LoanCovenantObligationSequence.LoanCovenantObligationSequenceBuilder getLoanCovenantObligationSequence();

        @Override
        public LoanCovenantObligationBuilder setName(String var1);

        @Override
        public LoanCovenantObligationBuilder setPartyReference(PartyReference var1);

        @Override
        public LoanCovenantObligationBuilder addCovenantObligationId(CovenantObligationId var1);

        @Override
        public LoanCovenantObligationBuilder addCovenantObligationId(CovenantObligationId var1, int var2);

        @Override
        public LoanCovenantObligationBuilder addCovenantObligationId(List<? extends CovenantObligationId> var1);

        @Override
        public LoanCovenantObligationBuilder setCovenantObligationId(List<? extends CovenantObligationId> var1);

        @Override
        public LoanCovenantObligationBuilder addVersionedCovenantObligationId(VersionedCovenantObligationId var1);

        @Override
        public LoanCovenantObligationBuilder addVersionedCovenantObligationId(VersionedCovenantObligationId var1, int var2);

        @Override
        public LoanCovenantObligationBuilder addVersionedCovenantObligationId(List<? extends VersionedCovenantObligationId> var1);

        @Override
        public LoanCovenantObligationBuilder setVersionedCovenantObligationId(List<? extends VersionedCovenantObligationId> var1);

        @Override
        public LoanCovenantObligationBuilder setId(String var1);

        @Override
        public LoanCovenantObligationBuilder setEffectiveDate(ZonedDateTime var1);

        @Override
        public LoanCovenantObligationBuilder setObligatedParty(PartyReference var1);

        @Override
        public LoanCovenantObligationBuilder setDealReference(DealReference var1);

        @Override
        public LoanCovenantObligationBuilder addFacilityReference(FacilityReference var1);

        @Override
        public LoanCovenantObligationBuilder addFacilityReference(FacilityReference var1, int var2);

        @Override
        public LoanCovenantObligationBuilder addFacilityReference(List<? extends FacilityReference> var1);

        @Override
        public LoanCovenantObligationBuilder setFacilityReference(List<? extends FacilityReference> var1);

        public LoanCovenantObligationBuilder setDeemedCovenantReference(LoanCovenantObligationReference var1);

        public LoanCovenantObligationBuilder setLoanCovenantObligationSequence(LoanCovenantObligationSequence var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.PartyReferenceBuilder.class, (RosettaModelObjectBuilder)this.getPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("covenantObligationId"), processor, CovenantObligationId.CovenantObligationIdBuilder.class, this.getCovenantObligationId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("versionedCovenantObligationId"), processor, VersionedCovenantObligationId.VersionedCovenantObligationIdBuilder.class, this.getVersionedCovenantObligationId(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("obligatedParty"), processor, PartyReference.PartyReferenceBuilder.class, (RosettaModelObjectBuilder)this.getObligatedParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dealReference"), processor, DealReference.DealReferenceBuilder.class, (RosettaModelObjectBuilder)this.getDealReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.FacilityReferenceBuilder.class, this.getFacilityReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deemedCovenantReference"), processor, LoanCovenantObligationReference.LoanCovenantObligationReferenceBuilder.class, this.getDeemedCovenantReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanCovenantObligationSequence"), processor, LoanCovenantObligationSequence.LoanCovenantObligationSequenceBuilder.class, this.getLoanCovenantObligationSequence(), new AttributeMeta[0]);
        }

        @Override
        public LoanCovenantObligationBuilder prune();
    }

    public static class LoanCovenantObligationImpl
    extends AbstractLoanCovenantObligation.AbstractLoanCovenantObligationImpl
    implements LoanCovenantObligation {
        private final LoanCovenantObligationReference deemedCovenantReference;
        private final LoanCovenantObligationSequence loanCovenantObligationSequence;

        protected LoanCovenantObligationImpl(LoanCovenantObligationBuilder builder) {
            super(builder);
            this.deemedCovenantReference = Optional.ofNullable(builder.getDeemedCovenantReference()).map(f -> f.build()).orElse(null);
            this.loanCovenantObligationSequence = Optional.ofNullable(builder.getLoanCovenantObligationSequence()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="deemedCovenantReference")
        @RuneAttribute(value="deemedCovenantReference")
        public LoanCovenantObligationReference getDeemedCovenantReference() {
            return this.deemedCovenantReference;
        }

        @Override
        @RosettaAttribute(value="loanCovenantObligationSequence")
        @RuneAttribute(value="loanCovenantObligationSequence")
        public LoanCovenantObligationSequence getLoanCovenantObligationSequence() {
            return this.loanCovenantObligationSequence;
        }

        @Override
        public LoanCovenantObligation build() {
            return this;
        }

        @Override
        public LoanCovenantObligationBuilder toBuilder() {
            LoanCovenantObligationBuilder builder = LoanCovenantObligation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanCovenantObligationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getDeemedCovenantReference()).ifPresent(builder::setDeemedCovenantReference);
            Optional.ofNullable(this.getLoanCovenantObligationSequence()).ifPresent(builder::setLoanCovenantObligationSequence);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanCovenantObligation _that = (LoanCovenantObligation)this.getType().cast(o);
            if (!Objects.equals(this.deemedCovenantReference, _that.getDeemedCovenantReference())) {
                return false;
            }
            return Objects.equals(this.loanCovenantObligationSequence, _that.getLoanCovenantObligationSequence());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.deemedCovenantReference != null ? this.deemedCovenantReference.hashCode() : 0);
            _result = 31 * _result + (this.loanCovenantObligationSequence != null ? this.loanCovenantObligationSequence.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanCovenantObligation {deemedCovenantReference=" + String.valueOf(this.deemedCovenantReference) + ", loanCovenantObligationSequence=" + String.valueOf(this.loanCovenantObligationSequence) + "} " + super.toString();
        }
    }
}

