/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.doc.TradeIdentifierSequence;
import fpml.consolidated.loan.LoanAllocationIdentifier;
import fpml.consolidated.loan.LoanTradeReference;
import fpml.consolidated.loan.meta.LoanAllocationSummaryMeta;
import fpml.consolidated.shared.IssuerTradeIdModel;
import fpml.consolidated.shared.NonNegativeMoney;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="LoanAllocationSummary", builder=LoanAllocationSummaryBuilderImpl.class, version="1.2.2")
@RuneDataType(value="LoanAllocationSummary", model="fpml", builder=LoanAllocationSummaryBuilderImpl.class, version="1.2.2")
public interface LoanAllocationSummary
extends LoanAllocationIdentifier {
    public static final LoanAllocationSummaryMeta metaData = new LoanAllocationSummaryMeta();

    public NonNegativeMoney getAmount();

    public String getComment();

    @Override
    public LoanAllocationSummary build();

    @Override
    public LoanAllocationSummaryBuilder toBuilder();

    public static LoanAllocationSummaryBuilder builder() {
        return new LoanAllocationSummaryBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanAllocationSummary> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanAllocationSummary> getType() {
        return LoanAllocationSummary.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("issuerTradeIdModel"), processor, IssuerTradeIdModel.class, this.getIssuerTradeIdModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeIdentifierSequence"), processor, TradeIdentifierSequence.class, this.getTradeIdentifierSequence(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanTradeReference"), processor, LoanTradeReference.class, this.getLoanTradeReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("amount"), processor, NonNegativeMoney.class, this.getAmount(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class LoanAllocationSummaryBuilderImpl
    extends LoanAllocationIdentifier.LoanAllocationIdentifierBuilderImpl
    implements LoanAllocationSummaryBuilder {
        protected NonNegativeMoney.NonNegativeMoneyBuilder amount;
        protected String comment;

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public NonNegativeMoney.NonNegativeMoneyBuilder getAmount() {
            return this.amount;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateAmount() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.amount != null ? this.amount : (this.amount = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public String getComment() {
            return this.comment;
        }

        @Override
        @RosettaAttribute(value="issuerTradeIdModel")
        @RuneAttribute(value="issuerTradeIdModel")
        public LoanAllocationSummaryBuilder setIssuerTradeIdModel(IssuerTradeIdModel _issuerTradeIdModel) {
            this.issuerTradeIdModel = _issuerTradeIdModel == null ? null : _issuerTradeIdModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifierSequence")
        @RuneAttribute(value="tradeIdentifierSequence")
        public LoanAllocationSummaryBuilder setTradeIdentifierSequence(TradeIdentifierSequence _tradeIdentifierSequence) {
            this.tradeIdentifierSequence = _tradeIdentifierSequence == null ? null : _tradeIdentifierSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public LoanAllocationSummaryBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="loanTradeReference", isRequired=true)
        @RuneAttribute(value="loanTradeReference", isRequired=true)
        public LoanAllocationSummaryBuilder setLoanTradeReference(LoanTradeReference _loanTradeReference) {
            this.loanTradeReference = _loanTradeReference == null ? null : _loanTradeReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public LoanAllocationSummaryBuilder setAmount(NonNegativeMoney _amount) {
            this.amount = _amount == null ? null : _amount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public LoanAllocationSummaryBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        public LoanAllocationSummary build() {
            return new LoanAllocationSummaryImpl(this);
        }

        @Override
        public LoanAllocationSummaryBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanAllocationSummaryBuilder prune() {
            super.prune();
            if (this.amount != null && !this.amount.prune().hasData()) {
                this.amount = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getAmount() != null && this.getAmount().hasData()) {
                return true;
            }
            return this.getComment() != null;
        }

        @Override
        public LoanAllocationSummaryBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LoanAllocationSummaryBuilder o = (LoanAllocationSummaryBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmount(), (RosettaModelObjectBuilder)o.getAmount(), this::setAmount);
            merger.mergeBasic((Object)this.getComment(), (Object)o.getComment(), this::setComment, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanAllocationSummary _that = (LoanAllocationSummary)this.getType().cast(o);
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            return Objects.equals(this.comment, _that.getComment());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.comment != null ? this.comment.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanAllocationSummaryBuilder {amount=" + String.valueOf(this.amount) + ", comment=" + this.comment + "} " + super.toString();
        }
    }

    public static interface LoanAllocationSummaryBuilder
    extends LoanAllocationSummary,
    LoanAllocationIdentifier.LoanAllocationIdentifierBuilder {
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateAmount();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getAmount();

        @Override
        public LoanAllocationSummaryBuilder setIssuerTradeIdModel(IssuerTradeIdModel var1);

        @Override
        public LoanAllocationSummaryBuilder setTradeIdentifierSequence(TradeIdentifierSequence var1);

        @Override
        public LoanAllocationSummaryBuilder setId(String var1);

        @Override
        public LoanAllocationSummaryBuilder setLoanTradeReference(LoanTradeReference var1);

        public LoanAllocationSummaryBuilder setAmount(NonNegativeMoney var1);

        public LoanAllocationSummaryBuilder setComment(String var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("issuerTradeIdModel"), processor, IssuerTradeIdModel.IssuerTradeIdModelBuilder.class, (RosettaModelObjectBuilder)this.getIssuerTradeIdModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeIdentifierSequence"), processor, TradeIdentifierSequence.TradeIdentifierSequenceBuilder.class, (RosettaModelObjectBuilder)this.getTradeIdentifierSequence(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanTradeReference"), processor, LoanTradeReference.LoanTradeReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLoanTradeReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("amount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getAmount(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public LoanAllocationSummaryBuilder prune();
    }

    public static class LoanAllocationSummaryImpl
    extends LoanAllocationIdentifier.LoanAllocationIdentifierImpl
    implements LoanAllocationSummary {
        private final NonNegativeMoney amount;
        private final String comment;

        protected LoanAllocationSummaryImpl(LoanAllocationSummaryBuilder builder) {
            super(builder);
            this.amount = Optional.ofNullable(builder.getAmount()).map(f -> f.build()).orElse(null);
            this.comment = builder.getComment();
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public NonNegativeMoney getAmount() {
            return this.amount;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public String getComment() {
            return this.comment;
        }

        @Override
        public LoanAllocationSummary build() {
            return this;
        }

        @Override
        public LoanAllocationSummaryBuilder toBuilder() {
            LoanAllocationSummaryBuilder builder = LoanAllocationSummary.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanAllocationSummaryBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
            Optional.ofNullable(this.getComment()).ifPresent(builder::setComment);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanAllocationSummary _that = (LoanAllocationSummary)this.getType().cast(o);
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            return Objects.equals(this.comment, _that.getComment());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.comment != null ? this.comment.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanAllocationSummary {amount=" + String.valueOf(this.amount) + ", comment=" + this.comment + "} " + super.toString();
        }
    }
}

