/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.business.events.BusinessEventIdentifier;
import fpml.consolidated.fpmlenum.ConditionsPrecedentMetEnum;
import fpml.consolidated.loan.AbstractLoanContractEvent;
import fpml.consolidated.loan.AbstractLoanEventSequence;
import fpml.consolidated.loan.BusinessEventPartiesModel;
import fpml.consolidated.loan.LenderAndCashDetailsModel;
import fpml.consolidated.loan.LoanContractReference;
import fpml.consolidated.loan.LoanLegalActionReference;
import fpml.consolidated.loan.MoneyWithParticipantShare;
import fpml.consolidated.loan.meta.BorrowingMeta;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Borrowing", builder=BorrowingBuilderImpl.class, version="1.2.2")
@RuneDataType(value="Borrowing", model="fpml", builder=BorrowingBuilderImpl.class, version="1.2.2")
public interface Borrowing
extends AbstractLoanContractEvent {
    public static final BorrowingMeta metaData = new BorrowingMeta();

    public MoneyWithParticipantShare getAmount();

    public ConditionsPrecedentMetEnum getConditionsPrecedentMet();

    @Override
    public Borrowing build();

    @Override
    public BorrowingBuilder toBuilder();

    public static BorrowingBuilder builder() {
        return new BorrowingBuilderImpl();
    }

    default public RosettaMetaData<? extends Borrowing> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Borrowing> getType() {
        return Borrowing.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.class, this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.class, this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.class, this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.class, this.getLegalActionReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanContractReference"), processor, LoanContractReference.class, this.getLoanContractReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("amount"), processor, MoneyWithParticipantShare.class, this.getAmount(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("conditionsPrecedentMet"), ConditionsPrecedentMetEnum.class, (Object)this.getConditionsPrecedentMet(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class BorrowingBuilderImpl
    extends AbstractLoanContractEvent.AbstractLoanContractEventBuilderImpl
    implements BorrowingBuilder {
        protected MoneyWithParticipantShare.MoneyWithParticipantShareBuilder amount;
        protected ConditionsPrecedentMetEnum conditionsPrecedentMet;

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getAmount() {
            return this.amount;
        }

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateAmount() {
            MoneyWithParticipantShare.MoneyWithParticipantShareBuilder result = this.amount != null ? this.amount : (this.amount = MoneyWithParticipantShare.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="conditionsPrecedentMet")
        @RuneAttribute(value="conditionsPrecedentMet")
        public ConditionsPrecedentMetEnum getConditionsPrecedentMet() {
            return this.conditionsPrecedentMet;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier", isRequired=true)
        @RuneAttribute(value="eventIdentifier", isRequired=true)
        public BorrowingBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public BorrowingBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public BorrowingBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public BorrowingBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="abstractLoanEventSequence")
        @RuneAttribute(value="abstractLoanEventSequence")
        public BorrowingBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence _abstractLoanEventSequence) {
            this.abstractLoanEventSequence = _abstractLoanEventSequence == null ? null : _abstractLoanEventSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lenderAndCashDetailsModel")
        @RuneAttribute(value="lenderAndCashDetailsModel")
        public BorrowingBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel _lenderAndCashDetailsModel) {
            this.lenderAndCashDetailsModel = _lenderAndCashDetailsModel == null ? null : _lenderAndCashDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public BorrowingBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        @RosettaAttribute(value="businessEventPartiesModel", isRequired=true)
        @RuneAttribute(value="businessEventPartiesModel", isRequired=true)
        public BorrowingBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel _businessEventPartiesModel) {
            this.businessEventPartiesModel = _businessEventPartiesModel == null ? null : _businessEventPartiesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public BorrowingBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="legalActionReference")
        @RuneAttribute(value="legalActionReference")
        public BorrowingBuilder setLegalActionReference(LoanLegalActionReference _legalActionReference) {
            this.legalActionReference = _legalActionReference == null ? null : _legalActionReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="loanContractReference", isRequired=true)
        @RuneAttribute(value="loanContractReference", isRequired=true)
        public BorrowingBuilder setLoanContractReference(LoanContractReference _loanContractReference) {
            this.loanContractReference = _loanContractReference == null ? null : _loanContractReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public BorrowingBuilder setAmount(MoneyWithParticipantShare _amount) {
            this.amount = _amount == null ? null : _amount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="conditionsPrecedentMet")
        @RuneAttribute(value="conditionsPrecedentMet")
        public BorrowingBuilder setConditionsPrecedentMet(ConditionsPrecedentMetEnum _conditionsPrecedentMet) {
            this.conditionsPrecedentMet = _conditionsPrecedentMet == null ? null : _conditionsPrecedentMet;
            return this;
        }

        @Override
        public Borrowing build() {
            return new BorrowingImpl(this);
        }

        @Override
        public BorrowingBuilder toBuilder() {
            return this;
        }

        @Override
        public BorrowingBuilder prune() {
            super.prune();
            if (this.amount != null && !this.amount.prune().hasData()) {
                this.amount = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getAmount() != null && this.getAmount().hasData()) {
                return true;
            }
            return this.getConditionsPrecedentMet() != null;
        }

        @Override
        public BorrowingBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            BorrowingBuilder o = (BorrowingBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmount(), (RosettaModelObjectBuilder)o.getAmount(), this::setAmount);
            merger.mergeBasic((Object)this.getConditionsPrecedentMet(), (Object)o.getConditionsPrecedentMet(), this::setConditionsPrecedentMet, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Borrowing _that = (Borrowing)this.getType().cast(o);
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            return Objects.equals((Object)this.conditionsPrecedentMet, (Object)_that.getConditionsPrecedentMet());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.conditionsPrecedentMet != null ? ((Object)((Object)this.conditionsPrecedentMet)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "BorrowingBuilder {amount=" + String.valueOf(this.amount) + ", conditionsPrecedentMet=" + String.valueOf((Object)this.conditionsPrecedentMet) + "} " + super.toString();
        }
    }

    public static interface BorrowingBuilder
    extends Borrowing,
    AbstractLoanContractEvent.AbstractLoanContractEventBuilder {
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateAmount();

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getAmount();

        @Override
        public BorrowingBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public BorrowingBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public BorrowingBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public BorrowingBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public BorrowingBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence var1);

        @Override
        public BorrowingBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel var1);

        @Override
        public BorrowingBuilder setComment(String var1);

        @Override
        public BorrowingBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel var1);

        @Override
        public BorrowingBuilder setEffectiveDate(ZonedDateTime var1);

        @Override
        public BorrowingBuilder setLegalActionReference(LoanLegalActionReference var1);

        @Override
        public BorrowingBuilder setLoanContractReference(LoanContractReference var1);

        public BorrowingBuilder setAmount(MoneyWithParticipantShare var1);

        public BorrowingBuilder setConditionsPrecedentMet(ConditionsPrecedentMetEnum var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder.class, (RosettaModelObjectBuilder)this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder.class, (RosettaModelObjectBuilder)this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.BusinessEventPartiesModelBuilder.class, (RosettaModelObjectBuilder)this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.LoanLegalActionReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLegalActionReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanContractReference"), processor, LoanContractReference.LoanContractReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLoanContractReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("amount"), processor, MoneyWithParticipantShare.MoneyWithParticipantShareBuilder.class, this.getAmount(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("conditionsPrecedentMet"), ConditionsPrecedentMetEnum.class, (Object)this.getConditionsPrecedentMet(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public BorrowingBuilder prune();
    }

    public static class BorrowingImpl
    extends AbstractLoanContractEvent.AbstractLoanContractEventImpl
    implements Borrowing {
        private final MoneyWithParticipantShare amount;
        private final ConditionsPrecedentMetEnum conditionsPrecedentMet;

        protected BorrowingImpl(BorrowingBuilder builder) {
            super(builder);
            this.amount = Optional.ofNullable(builder.getAmount()).map(f -> f.build()).orElse(null);
            this.conditionsPrecedentMet = builder.getConditionsPrecedentMet();
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public MoneyWithParticipantShare getAmount() {
            return this.amount;
        }

        @Override
        @RosettaAttribute(value="conditionsPrecedentMet")
        @RuneAttribute(value="conditionsPrecedentMet")
        public ConditionsPrecedentMetEnum getConditionsPrecedentMet() {
            return this.conditionsPrecedentMet;
        }

        @Override
        public Borrowing build() {
            return this;
        }

        @Override
        public BorrowingBuilder toBuilder() {
            BorrowingBuilder builder = Borrowing.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BorrowingBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
            Optional.ofNullable(this.getConditionsPrecedentMet()).ifPresent(builder::setConditionsPrecedentMet);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Borrowing _that = (Borrowing)this.getType().cast(o);
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            return Objects.equals((Object)this.conditionsPrecedentMet, (Object)_that.getConditionsPrecedentMet());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.conditionsPrecedentMet != null ? ((Object)((Object)this.conditionsPrecedentMet)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Borrowing {amount=" + String.valueOf(this.amount) + ", conditionsPrecedentMet=" + String.valueOf((Object)this.conditionsPrecedentMet) + "} " + super.toString();
        }
    }
}

