/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.fpmlenum.AccrualReferenceAmountTypeEnum;
import fpml.consolidated.loan.AccrualPeriodSequence;
import fpml.consolidated.loan.MoneyWithParticipantShare;
import fpml.consolidated.loan.PeriodWithDaysModel;
import fpml.consolidated.loan.meta.AccrualPeriodMeta;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="AccrualPeriod", builder=AccrualPeriodBuilderImpl.class, version="1.2.2")
@RuneDataType(value="AccrualPeriod", model="fpml", builder=AccrualPeriodBuilderImpl.class, version="1.2.2")
public interface AccrualPeriod
extends RosettaModelObject {
    public static final AccrualPeriodMeta metaData = new AccrualPeriodMeta();

    public PeriodWithDaysModel getPeriodWithDaysModel();

    public MoneyWithParticipantShare getReferenceAmount();

    public AccrualReferenceAmountTypeEnum getReferenceAmountType();

    public BigDecimal getRate();

    public AccrualPeriodSequence getAccrualPeriodSequence();

    public MoneyWithParticipantShare getAccrualAmount();

    public AccrualPeriod build();

    public AccrualPeriodBuilder toBuilder();

    public static AccrualPeriodBuilder builder() {
        return new AccrualPeriodBuilderImpl();
    }

    default public RosettaMetaData<? extends AccrualPeriod> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AccrualPeriod> getType() {
        return AccrualPeriod.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("periodWithDaysModel"), processor, PeriodWithDaysModel.class, this.getPeriodWithDaysModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("referenceAmount"), processor, MoneyWithParticipantShare.class, this.getReferenceAmount(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("referenceAmountType"), AccrualReferenceAmountTypeEnum.class, (Object)this.getReferenceAmountType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("rate"), BigDecimal.class, (Object)this.getRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("accrualPeriodSequence"), processor, AccrualPeriodSequence.class, this.getAccrualPeriodSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("accrualAmount"), processor, MoneyWithParticipantShare.class, this.getAccrualAmount(), new AttributeMeta[0]);
    }

    public static class AccrualPeriodBuilderImpl
    implements AccrualPeriodBuilder {
        protected PeriodWithDaysModel.PeriodWithDaysModelBuilder periodWithDaysModel;
        protected MoneyWithParticipantShare.MoneyWithParticipantShareBuilder referenceAmount;
        protected AccrualReferenceAmountTypeEnum referenceAmountType;
        protected BigDecimal rate;
        protected AccrualPeriodSequence.AccrualPeriodSequenceBuilder accrualPeriodSequence;
        protected MoneyWithParticipantShare.MoneyWithParticipantShareBuilder accrualAmount;

        @Override
        @RosettaAttribute(value="periodWithDaysModel", isRequired=true)
        @RuneAttribute(value="periodWithDaysModel", isRequired=true)
        public PeriodWithDaysModel.PeriodWithDaysModelBuilder getPeriodWithDaysModel() {
            return this.periodWithDaysModel;
        }

        @Override
        public PeriodWithDaysModel.PeriodWithDaysModelBuilder getOrCreatePeriodWithDaysModel() {
            PeriodWithDaysModel.PeriodWithDaysModelBuilder result = this.periodWithDaysModel != null ? this.periodWithDaysModel : (this.periodWithDaysModel = PeriodWithDaysModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="referenceAmount", isRequired=true)
        @RuneAttribute(value="referenceAmount", isRequired=true)
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getReferenceAmount() {
            return this.referenceAmount;
        }

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateReferenceAmount() {
            MoneyWithParticipantShare.MoneyWithParticipantShareBuilder result = this.referenceAmount != null ? this.referenceAmount : (this.referenceAmount = MoneyWithParticipantShare.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="referenceAmountType")
        @RuneAttribute(value="referenceAmountType")
        public AccrualReferenceAmountTypeEnum getReferenceAmountType() {
            return this.referenceAmountType;
        }

        @Override
        @RosettaAttribute(value="rate", isRequired=true)
        @RuneAttribute(value="rate", isRequired=true)
        public BigDecimal getRate() {
            return this.rate;
        }

        @Override
        @RosettaAttribute(value="accrualPeriodSequence")
        @RuneAttribute(value="accrualPeriodSequence")
        public AccrualPeriodSequence.AccrualPeriodSequenceBuilder getAccrualPeriodSequence() {
            return this.accrualPeriodSequence;
        }

        @Override
        public AccrualPeriodSequence.AccrualPeriodSequenceBuilder getOrCreateAccrualPeriodSequence() {
            AccrualPeriodSequence.AccrualPeriodSequenceBuilder result = this.accrualPeriodSequence != null ? this.accrualPeriodSequence : (this.accrualPeriodSequence = AccrualPeriodSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="accrualAmount", isRequired=true)
        @RuneAttribute(value="accrualAmount", isRequired=true)
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getAccrualAmount() {
            return this.accrualAmount;
        }

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateAccrualAmount() {
            MoneyWithParticipantShare.MoneyWithParticipantShareBuilder result = this.accrualAmount != null ? this.accrualAmount : (this.accrualAmount = MoneyWithParticipantShare.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="periodWithDaysModel", isRequired=true)
        @RuneAttribute(value="periodWithDaysModel", isRequired=true)
        public AccrualPeriodBuilder setPeriodWithDaysModel(PeriodWithDaysModel _periodWithDaysModel) {
            this.periodWithDaysModel = _periodWithDaysModel == null ? null : _periodWithDaysModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="referenceAmount", isRequired=true)
        @RuneAttribute(value="referenceAmount", isRequired=true)
        public AccrualPeriodBuilder setReferenceAmount(MoneyWithParticipantShare _referenceAmount) {
            this.referenceAmount = _referenceAmount == null ? null : _referenceAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="referenceAmountType")
        @RuneAttribute(value="referenceAmountType")
        public AccrualPeriodBuilder setReferenceAmountType(AccrualReferenceAmountTypeEnum _referenceAmountType) {
            this.referenceAmountType = _referenceAmountType == null ? null : _referenceAmountType;
            return this;
        }

        @Override
        @RosettaAttribute(value="rate", isRequired=true)
        @RuneAttribute(value="rate", isRequired=true)
        public AccrualPeriodBuilder setRate(BigDecimal _rate) {
            this.rate = _rate == null ? null : _rate;
            return this;
        }

        @Override
        @RosettaAttribute(value="accrualPeriodSequence")
        @RuneAttribute(value="accrualPeriodSequence")
        public AccrualPeriodBuilder setAccrualPeriodSequence(AccrualPeriodSequence _accrualPeriodSequence) {
            this.accrualPeriodSequence = _accrualPeriodSequence == null ? null : _accrualPeriodSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="accrualAmount", isRequired=true)
        @RuneAttribute(value="accrualAmount", isRequired=true)
        public AccrualPeriodBuilder setAccrualAmount(MoneyWithParticipantShare _accrualAmount) {
            this.accrualAmount = _accrualAmount == null ? null : _accrualAmount.toBuilder();
            return this;
        }

        @Override
        public AccrualPeriod build() {
            return new AccrualPeriodImpl(this);
        }

        @Override
        public AccrualPeriodBuilder toBuilder() {
            return this;
        }

        @Override
        public AccrualPeriodBuilder prune() {
            if (this.periodWithDaysModel != null && !this.periodWithDaysModel.prune().hasData()) {
                this.periodWithDaysModel = null;
            }
            if (this.referenceAmount != null && !this.referenceAmount.prune().hasData()) {
                this.referenceAmount = null;
            }
            if (this.accrualPeriodSequence != null && !this.accrualPeriodSequence.prune().hasData()) {
                this.accrualPeriodSequence = null;
            }
            if (this.accrualAmount != null && !this.accrualAmount.prune().hasData()) {
                this.accrualAmount = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPeriodWithDaysModel() != null && this.getPeriodWithDaysModel().hasData()) {
                return true;
            }
            if (this.getReferenceAmount() != null && this.getReferenceAmount().hasData()) {
                return true;
            }
            if (this.getReferenceAmountType() != null) {
                return true;
            }
            if (this.getRate() != null) {
                return true;
            }
            if (this.getAccrualPeriodSequence() != null && this.getAccrualPeriodSequence().hasData()) {
                return true;
            }
            return this.getAccrualAmount() != null && this.getAccrualAmount().hasData();
        }

        public AccrualPeriodBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AccrualPeriodBuilder o = (AccrualPeriodBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPeriodWithDaysModel(), (RosettaModelObjectBuilder)o.getPeriodWithDaysModel(), this::setPeriodWithDaysModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReferenceAmount(), (RosettaModelObjectBuilder)o.getReferenceAmount(), this::setReferenceAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAccrualPeriodSequence(), (RosettaModelObjectBuilder)o.getAccrualPeriodSequence(), this::setAccrualPeriodSequence);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAccrualAmount(), (RosettaModelObjectBuilder)o.getAccrualAmount(), this::setAccrualAmount);
            merger.mergeBasic((Object)this.getReferenceAmountType(), (Object)o.getReferenceAmountType(), this::setReferenceAmountType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRate(), (Object)o.getRate(), this::setRate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AccrualPeriod _that = this.getType().cast(o);
            if (!Objects.equals(this.periodWithDaysModel, _that.getPeriodWithDaysModel())) {
                return false;
            }
            if (!Objects.equals(this.referenceAmount, _that.getReferenceAmount())) {
                return false;
            }
            if (!Objects.equals((Object)this.referenceAmountType, (Object)_that.getReferenceAmountType())) {
                return false;
            }
            if (!Objects.equals(this.rate, _that.getRate())) {
                return false;
            }
            if (!Objects.equals(this.accrualPeriodSequence, _that.getAccrualPeriodSequence())) {
                return false;
            }
            return Objects.equals(this.accrualAmount, _that.getAccrualAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.periodWithDaysModel != null ? this.periodWithDaysModel.hashCode() : 0);
            _result = 31 * _result + (this.referenceAmount != null ? this.referenceAmount.hashCode() : 0);
            _result = 31 * _result + (this.referenceAmountType != null ? ((Object)((Object)this.referenceAmountType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.rate != null ? this.rate.hashCode() : 0);
            _result = 31 * _result + (this.accrualPeriodSequence != null ? this.accrualPeriodSequence.hashCode() : 0);
            _result = 31 * _result + (this.accrualAmount != null ? this.accrualAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AccrualPeriodBuilder {periodWithDaysModel=" + String.valueOf(this.periodWithDaysModel) + ", referenceAmount=" + String.valueOf(this.referenceAmount) + ", referenceAmountType=" + String.valueOf((Object)this.referenceAmountType) + ", rate=" + String.valueOf(this.rate) + ", accrualPeriodSequence=" + String.valueOf(this.accrualPeriodSequence) + ", accrualAmount=" + String.valueOf(this.accrualAmount) + "}";
        }
    }

    public static interface AccrualPeriodBuilder
    extends AccrualPeriod,
    RosettaModelObjectBuilder {
        public PeriodWithDaysModel.PeriodWithDaysModelBuilder getOrCreatePeriodWithDaysModel();

        @Override
        public PeriodWithDaysModel.PeriodWithDaysModelBuilder getPeriodWithDaysModel();

        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateReferenceAmount();

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getReferenceAmount();

        public AccrualPeriodSequence.AccrualPeriodSequenceBuilder getOrCreateAccrualPeriodSequence();

        @Override
        public AccrualPeriodSequence.AccrualPeriodSequenceBuilder getAccrualPeriodSequence();

        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateAccrualAmount();

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getAccrualAmount();

        public AccrualPeriodBuilder setPeriodWithDaysModel(PeriodWithDaysModel var1);

        public AccrualPeriodBuilder setReferenceAmount(MoneyWithParticipantShare var1);

        public AccrualPeriodBuilder setReferenceAmountType(AccrualReferenceAmountTypeEnum var1);

        public AccrualPeriodBuilder setRate(BigDecimal var1);

        public AccrualPeriodBuilder setAccrualPeriodSequence(AccrualPeriodSequence var1);

        public AccrualPeriodBuilder setAccrualAmount(MoneyWithParticipantShare var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("periodWithDaysModel"), processor, PeriodWithDaysModel.PeriodWithDaysModelBuilder.class, this.getPeriodWithDaysModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("referenceAmount"), processor, MoneyWithParticipantShare.MoneyWithParticipantShareBuilder.class, this.getReferenceAmount(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("referenceAmountType"), AccrualReferenceAmountTypeEnum.class, (Object)this.getReferenceAmountType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("rate"), BigDecimal.class, (Object)this.getRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("accrualPeriodSequence"), processor, AccrualPeriodSequence.AccrualPeriodSequenceBuilder.class, this.getAccrualPeriodSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("accrualAmount"), processor, MoneyWithParticipantShare.MoneyWithParticipantShareBuilder.class, this.getAccrualAmount(), new AttributeMeta[0]);
        }

        public AccrualPeriodBuilder prune();
    }

    public static class AccrualPeriodImpl
    implements AccrualPeriod {
        private final PeriodWithDaysModel periodWithDaysModel;
        private final MoneyWithParticipantShare referenceAmount;
        private final AccrualReferenceAmountTypeEnum referenceAmountType;
        private final BigDecimal rate;
        private final AccrualPeriodSequence accrualPeriodSequence;
        private final MoneyWithParticipantShare accrualAmount;

        protected AccrualPeriodImpl(AccrualPeriodBuilder builder) {
            this.periodWithDaysModel = Optional.ofNullable(builder.getPeriodWithDaysModel()).map(f -> f.build()).orElse(null);
            this.referenceAmount = Optional.ofNullable(builder.getReferenceAmount()).map(f -> f.build()).orElse(null);
            this.referenceAmountType = builder.getReferenceAmountType();
            this.rate = builder.getRate();
            this.accrualPeriodSequence = Optional.ofNullable(builder.getAccrualPeriodSequence()).map(f -> f.build()).orElse(null);
            this.accrualAmount = Optional.ofNullable(builder.getAccrualAmount()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="periodWithDaysModel", isRequired=true)
        @RuneAttribute(value="periodWithDaysModel", isRequired=true)
        public PeriodWithDaysModel getPeriodWithDaysModel() {
            return this.periodWithDaysModel;
        }

        @Override
        @RosettaAttribute(value="referenceAmount", isRequired=true)
        @RuneAttribute(value="referenceAmount", isRequired=true)
        public MoneyWithParticipantShare getReferenceAmount() {
            return this.referenceAmount;
        }

        @Override
        @RosettaAttribute(value="referenceAmountType")
        @RuneAttribute(value="referenceAmountType")
        public AccrualReferenceAmountTypeEnum getReferenceAmountType() {
            return this.referenceAmountType;
        }

        @Override
        @RosettaAttribute(value="rate", isRequired=true)
        @RuneAttribute(value="rate", isRequired=true)
        public BigDecimal getRate() {
            return this.rate;
        }

        @Override
        @RosettaAttribute(value="accrualPeriodSequence")
        @RuneAttribute(value="accrualPeriodSequence")
        public AccrualPeriodSequence getAccrualPeriodSequence() {
            return this.accrualPeriodSequence;
        }

        @Override
        @RosettaAttribute(value="accrualAmount", isRequired=true)
        @RuneAttribute(value="accrualAmount", isRequired=true)
        public MoneyWithParticipantShare getAccrualAmount() {
            return this.accrualAmount;
        }

        @Override
        public AccrualPeriod build() {
            return this;
        }

        @Override
        public AccrualPeriodBuilder toBuilder() {
            AccrualPeriodBuilder builder = AccrualPeriod.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AccrualPeriodBuilder builder) {
            Optional.ofNullable(this.getPeriodWithDaysModel()).ifPresent(builder::setPeriodWithDaysModel);
            Optional.ofNullable(this.getReferenceAmount()).ifPresent(builder::setReferenceAmount);
            Optional.ofNullable(this.getReferenceAmountType()).ifPresent(builder::setReferenceAmountType);
            Optional.ofNullable(this.getRate()).ifPresent(builder::setRate);
            Optional.ofNullable(this.getAccrualPeriodSequence()).ifPresent(builder::setAccrualPeriodSequence);
            Optional.ofNullable(this.getAccrualAmount()).ifPresent(builder::setAccrualAmount);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AccrualPeriod _that = this.getType().cast(o);
            if (!Objects.equals(this.periodWithDaysModel, _that.getPeriodWithDaysModel())) {
                return false;
            }
            if (!Objects.equals(this.referenceAmount, _that.getReferenceAmount())) {
                return false;
            }
            if (!Objects.equals((Object)this.referenceAmountType, (Object)_that.getReferenceAmountType())) {
                return false;
            }
            if (!Objects.equals(this.rate, _that.getRate())) {
                return false;
            }
            if (!Objects.equals(this.accrualPeriodSequence, _that.getAccrualPeriodSequence())) {
                return false;
            }
            return Objects.equals(this.accrualAmount, _that.getAccrualAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.periodWithDaysModel != null ? this.periodWithDaysModel.hashCode() : 0);
            _result = 31 * _result + (this.referenceAmount != null ? this.referenceAmount.hashCode() : 0);
            _result = 31 * _result + (this.referenceAmountType != null ? ((Object)((Object)this.referenceAmountType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.rate != null ? this.rate.hashCode() : 0);
            _result = 31 * _result + (this.accrualPeriodSequence != null ? this.accrualPeriodSequence.hashCode() : 0);
            _result = 31 * _result + (this.accrualAmount != null ? this.accrualAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AccrualPeriod {periodWithDaysModel=" + String.valueOf(this.periodWithDaysModel) + ", referenceAmount=" + String.valueOf(this.referenceAmount) + ", referenceAmountType=" + String.valueOf((Object)this.referenceAmountType) + ", rate=" + String.valueOf(this.rate) + ", accrualPeriodSequence=" + String.valueOf(this.accrualPeriodSequence) + ", accrualAmount=" + String.valueOf(this.accrualAmount) + "}";
        }
    }
}

