/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.ird;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.fpmlenum.SwaptionTypeEnum;
import fpml.consolidated.ird.CashSettlement;
import fpml.consolidated.ird.EarlyTerminationProvision;
import fpml.consolidated.ird.Swap;
import fpml.consolidated.ird.SwaptionAdjustedDates;
import fpml.consolidated.ird.meta.SwaptionMeta;
import fpml.consolidated.shared.BuyerSellerModel;
import fpml.consolidated.shared.CalculationAgent;
import fpml.consolidated.shared.Exercise;
import fpml.consolidated.shared.ExerciseProcedure;
import fpml.consolidated.shared.Payment;
import fpml.consolidated.shared.Product;
import fpml.consolidated.shared.ProductModel;
import fpml.consolidated.shared.SwaptionPhysicalSettlement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Swaption", builder=SwaptionBuilderImpl.class, version="1.2.2")
@RuneDataType(value="Swaption", model="fpml", builder=SwaptionBuilderImpl.class, version="1.2.2")
public interface Swaption
extends Product {
    public static final SwaptionMeta metaData = new SwaptionMeta();

    public BuyerSellerModel getBuyerSellerModel();

    public List<? extends Payment> getPremium();

    public SwaptionTypeEnum getOptionType();

    public Exercise getExercise();

    public ExerciseProcedure getExerciseProcedure();

    public CalculationAgent getCalculationAgent();

    public CashSettlement getCashSettlement();

    public SwaptionPhysicalSettlement getPhysicalSettlement();

    public Boolean getSwaptionStraddle();

    public EarlyTerminationProvision getEarlyTerminationProvision();

    public SwaptionAdjustedDates getSwaptionAdjustedDates();

    public Swap getSwap();

    @Override
    public Swaption build();

    @Override
    public SwaptionBuilder toBuilder();

    public static SwaptionBuilder builder() {
        return new SwaptionBuilderImpl();
    }

    default public RosettaMetaData<? extends Swaption> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Swaption> getType() {
        return Swaption.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("premium"), processor, Payment.class, this.getPremium(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionType"), SwaptionTypeEnum.class, (Object)this.getOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exercise"), processor, Exercise.class, this.getExercise(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exerciseProcedure"), processor, ExerciseProcedure.class, this.getExerciseProcedure(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("calculationAgent"), processor, CalculationAgent.class, this.getCalculationAgent(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cashSettlement"), processor, CashSettlement.class, this.getCashSettlement(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("physicalSettlement"), processor, SwaptionPhysicalSettlement.class, this.getPhysicalSettlement(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("swaptionStraddle"), Boolean.class, (Object)this.getSwaptionStraddle(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("earlyTerminationProvision"), processor, EarlyTerminationProvision.class, this.getEarlyTerminationProvision(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("swaptionAdjustedDates"), processor, SwaptionAdjustedDates.class, this.getSwaptionAdjustedDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("swap"), processor, Swap.class, this.getSwap(), new AttributeMeta[0]);
    }

    public static class SwaptionBuilderImpl
    extends Product.ProductBuilderImpl
    implements SwaptionBuilder {
        protected BuyerSellerModel.BuyerSellerModelBuilder buyerSellerModel;
        protected List<Payment.PaymentBuilder> premium = new ArrayList<Payment.PaymentBuilder>();
        protected SwaptionTypeEnum optionType;
        protected Exercise.ExerciseBuilder exercise;
        protected ExerciseProcedure.ExerciseProcedureBuilder exerciseProcedure;
        protected CalculationAgent.CalculationAgentBuilder calculationAgent;
        protected CashSettlement.CashSettlementBuilder cashSettlement;
        protected SwaptionPhysicalSettlement.SwaptionPhysicalSettlementBuilder physicalSettlement;
        protected Boolean swaptionStraddle;
        protected EarlyTerminationProvision.EarlyTerminationProvisionBuilder earlyTerminationProvision;
        protected SwaptionAdjustedDates.SwaptionAdjustedDatesBuilder swaptionAdjustedDates;
        protected Swap.SwapBuilder swap;

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public BuyerSellerModel.BuyerSellerModelBuilder getBuyerSellerModel() {
            return this.buyerSellerModel;
        }

        @Override
        public BuyerSellerModel.BuyerSellerModelBuilder getOrCreateBuyerSellerModel() {
            BuyerSellerModel.BuyerSellerModelBuilder result = this.buyerSellerModel != null ? this.buyerSellerModel : (this.buyerSellerModel = BuyerSellerModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public List<? extends Payment.PaymentBuilder> getPremium() {
            return this.premium;
        }

        @Override
        public Payment.PaymentBuilder getOrCreatePremium(int index) {
            if (this.premium == null) {
                this.premium = new ArrayList<Payment.PaymentBuilder>();
            }
            return (Payment.PaymentBuilder)this.getIndex(this.premium, index, () -> {
                Payment.PaymentBuilder newPremium = Payment.builder();
                return newPremium;
            });
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public SwaptionTypeEnum getOptionType() {
            return this.optionType;
        }

        @Override
        @RosettaAttribute(value="exercise", isRequired=true)
        @RuneAttribute(value="exercise", isRequired=true)
        public Exercise.ExerciseBuilder getExercise() {
            return this.exercise;
        }

        @Override
        public Exercise.ExerciseBuilder getOrCreateExercise() {
            Exercise.ExerciseBuilder result = this.exercise != null ? this.exercise : (this.exercise = Exercise.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exerciseProcedure")
        @RuneAttribute(value="exerciseProcedure")
        public ExerciseProcedure.ExerciseProcedureBuilder getExerciseProcedure() {
            return this.exerciseProcedure;
        }

        @Override
        public ExerciseProcedure.ExerciseProcedureBuilder getOrCreateExerciseProcedure() {
            ExerciseProcedure.ExerciseProcedureBuilder result = this.exerciseProcedure != null ? this.exerciseProcedure : (this.exerciseProcedure = ExerciseProcedure.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="calculationAgent")
        @RuneAttribute(value="calculationAgent")
        public CalculationAgent.CalculationAgentBuilder getCalculationAgent() {
            return this.calculationAgent;
        }

        @Override
        public CalculationAgent.CalculationAgentBuilder getOrCreateCalculationAgent() {
            CalculationAgent.CalculationAgentBuilder result = this.calculationAgent != null ? this.calculationAgent : (this.calculationAgent = CalculationAgent.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="cashSettlement")
        @RuneAttribute(value="cashSettlement")
        public CashSettlement.CashSettlementBuilder getCashSettlement() {
            return this.cashSettlement;
        }

        @Override
        public CashSettlement.CashSettlementBuilder getOrCreateCashSettlement() {
            CashSettlement.CashSettlementBuilder result = this.cashSettlement != null ? this.cashSettlement : (this.cashSettlement = CashSettlement.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="physicalSettlement")
        @RuneAttribute(value="physicalSettlement")
        public SwaptionPhysicalSettlement.SwaptionPhysicalSettlementBuilder getPhysicalSettlement() {
            return this.physicalSettlement;
        }

        @Override
        public SwaptionPhysicalSettlement.SwaptionPhysicalSettlementBuilder getOrCreatePhysicalSettlement() {
            SwaptionPhysicalSettlement.SwaptionPhysicalSettlementBuilder result = this.physicalSettlement != null ? this.physicalSettlement : (this.physicalSettlement = SwaptionPhysicalSettlement.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="swaptionStraddle", isRequired=true)
        @RuneAttribute(value="swaptionStraddle", isRequired=true)
        public Boolean getSwaptionStraddle() {
            return this.swaptionStraddle;
        }

        @Override
        @RosettaAttribute(value="earlyTerminationProvision")
        @RuneAttribute(value="earlyTerminationProvision")
        public EarlyTerminationProvision.EarlyTerminationProvisionBuilder getEarlyTerminationProvision() {
            return this.earlyTerminationProvision;
        }

        @Override
        public EarlyTerminationProvision.EarlyTerminationProvisionBuilder getOrCreateEarlyTerminationProvision() {
            EarlyTerminationProvision.EarlyTerminationProvisionBuilder result = this.earlyTerminationProvision != null ? this.earlyTerminationProvision : (this.earlyTerminationProvision = EarlyTerminationProvision.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="swaptionAdjustedDates")
        @RuneAttribute(value="swaptionAdjustedDates")
        public SwaptionAdjustedDates.SwaptionAdjustedDatesBuilder getSwaptionAdjustedDates() {
            return this.swaptionAdjustedDates;
        }

        @Override
        public SwaptionAdjustedDates.SwaptionAdjustedDatesBuilder getOrCreateSwaptionAdjustedDates() {
            SwaptionAdjustedDates.SwaptionAdjustedDatesBuilder result = this.swaptionAdjustedDates != null ? this.swaptionAdjustedDates : (this.swaptionAdjustedDates = SwaptionAdjustedDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="swap", isRequired=true)
        @RuneAttribute(value="swap", isRequired=true)
        public Swap.SwapBuilder getSwap() {
            return this.swap;
        }

        @Override
        public Swap.SwapBuilder getOrCreateSwap() {
            Swap.SwapBuilder result = this.swap != null ? this.swap : (this.swap = Swap.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public SwaptionBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public SwaptionBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public SwaptionBuilder setBuyerSellerModel(BuyerSellerModel _buyerSellerModel) {
            this.buyerSellerModel = _buyerSellerModel == null ? null : _buyerSellerModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public SwaptionBuilder addPremium(Payment _premium) {
            if (_premium != null) {
                this.premium.add(_premium.toBuilder());
            }
            return this;
        }

        @Override
        public SwaptionBuilder addPremium(Payment _premium, int idx) {
            this.getIndex(this.premium, idx, () -> _premium.toBuilder());
            return this;
        }

        @Override
        public SwaptionBuilder addPremium(List<? extends Payment> premiums) {
            if (premiums != null) {
                for (Payment payment : premiums) {
                    this.premium.add(payment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="premium")
        public SwaptionBuilder setPremium(List<? extends Payment> premiums) {
            this.premium = premiums == null ? new ArrayList<Payment.PaymentBuilder>() : (List)premiums.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public SwaptionBuilder setOptionType(SwaptionTypeEnum _optionType) {
            this.optionType = _optionType == null ? null : _optionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="exercise", isRequired=true)
        @RuneAttribute(value="exercise", isRequired=true)
        public SwaptionBuilder setExercise(Exercise _exercise) {
            this.exercise = _exercise == null ? null : _exercise.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exerciseProcedure")
        @RuneAttribute(value="exerciseProcedure")
        public SwaptionBuilder setExerciseProcedure(ExerciseProcedure _exerciseProcedure) {
            this.exerciseProcedure = _exerciseProcedure == null ? null : _exerciseProcedure.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="calculationAgent")
        @RuneAttribute(value="calculationAgent")
        public SwaptionBuilder setCalculationAgent(CalculationAgent _calculationAgent) {
            this.calculationAgent = _calculationAgent == null ? null : _calculationAgent.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="cashSettlement")
        @RuneAttribute(value="cashSettlement")
        public SwaptionBuilder setCashSettlement(CashSettlement _cashSettlement) {
            this.cashSettlement = _cashSettlement == null ? null : _cashSettlement.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="physicalSettlement")
        @RuneAttribute(value="physicalSettlement")
        public SwaptionBuilder setPhysicalSettlement(SwaptionPhysicalSettlement _physicalSettlement) {
            this.physicalSettlement = _physicalSettlement == null ? null : _physicalSettlement.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="swaptionStraddle", isRequired=true)
        @RuneAttribute(value="swaptionStraddle", isRequired=true)
        public SwaptionBuilder setSwaptionStraddle(Boolean _swaptionStraddle) {
            this.swaptionStraddle = _swaptionStraddle == null ? null : _swaptionStraddle;
            return this;
        }

        @Override
        @RosettaAttribute(value="earlyTerminationProvision")
        @RuneAttribute(value="earlyTerminationProvision")
        public SwaptionBuilder setEarlyTerminationProvision(EarlyTerminationProvision _earlyTerminationProvision) {
            this.earlyTerminationProvision = _earlyTerminationProvision == null ? null : _earlyTerminationProvision.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="swaptionAdjustedDates")
        @RuneAttribute(value="swaptionAdjustedDates")
        public SwaptionBuilder setSwaptionAdjustedDates(SwaptionAdjustedDates _swaptionAdjustedDates) {
            this.swaptionAdjustedDates = _swaptionAdjustedDates == null ? null : _swaptionAdjustedDates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="swap", isRequired=true)
        @RuneAttribute(value="swap", isRequired=true)
        public SwaptionBuilder setSwap(Swap _swap) {
            this.swap = _swap == null ? null : _swap.toBuilder();
            return this;
        }

        @Override
        public Swaption build() {
            return new SwaptionImpl(this);
        }

        @Override
        public SwaptionBuilder toBuilder() {
            return this;
        }

        @Override
        public SwaptionBuilder prune() {
            super.prune();
            if (this.buyerSellerModel != null && !this.buyerSellerModel.prune().hasData()) {
                this.buyerSellerModel = null;
            }
            this.premium = this.premium.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.exercise != null && !this.exercise.prune().hasData()) {
                this.exercise = null;
            }
            if (this.exerciseProcedure != null && !this.exerciseProcedure.prune().hasData()) {
                this.exerciseProcedure = null;
            }
            if (this.calculationAgent != null && !this.calculationAgent.prune().hasData()) {
                this.calculationAgent = null;
            }
            if (this.cashSettlement != null && !this.cashSettlement.prune().hasData()) {
                this.cashSettlement = null;
            }
            if (this.physicalSettlement != null && !this.physicalSettlement.prune().hasData()) {
                this.physicalSettlement = null;
            }
            if (this.earlyTerminationProvision != null && !this.earlyTerminationProvision.prune().hasData()) {
                this.earlyTerminationProvision = null;
            }
            if (this.swaptionAdjustedDates != null && !this.swaptionAdjustedDates.prune().hasData()) {
                this.swaptionAdjustedDates = null;
            }
            if (this.swap != null && !this.swap.prune().hasData()) {
                this.swap = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getBuyerSellerModel() != null && this.getBuyerSellerModel().hasData()) {
                return true;
            }
            if (this.getPremium() != null && this.getPremium().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getOptionType() != null) {
                return true;
            }
            if (this.getExercise() != null && this.getExercise().hasData()) {
                return true;
            }
            if (this.getExerciseProcedure() != null && this.getExerciseProcedure().hasData()) {
                return true;
            }
            if (this.getCalculationAgent() != null && this.getCalculationAgent().hasData()) {
                return true;
            }
            if (this.getCashSettlement() != null && this.getCashSettlement().hasData()) {
                return true;
            }
            if (this.getPhysicalSettlement() != null && this.getPhysicalSettlement().hasData()) {
                return true;
            }
            if (this.getSwaptionStraddle() != null) {
                return true;
            }
            if (this.getEarlyTerminationProvision() != null && this.getEarlyTerminationProvision().hasData()) {
                return true;
            }
            if (this.getSwaptionAdjustedDates() != null && this.getSwaptionAdjustedDates().hasData()) {
                return true;
            }
            return this.getSwap() != null && this.getSwap().hasData();
        }

        @Override
        public SwaptionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            SwaptionBuilder o = (SwaptionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBuyerSellerModel(), (RosettaModelObjectBuilder)o.getBuyerSellerModel(), this::setBuyerSellerModel);
            merger.mergeRosetta(this.getPremium(), o.getPremium(), this::getOrCreatePremium);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExercise(), (RosettaModelObjectBuilder)o.getExercise(), this::setExercise);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExerciseProcedure(), (RosettaModelObjectBuilder)o.getExerciseProcedure(), this::setExerciseProcedure);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCalculationAgent(), (RosettaModelObjectBuilder)o.getCalculationAgent(), this::setCalculationAgent);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCashSettlement(), (RosettaModelObjectBuilder)o.getCashSettlement(), this::setCashSettlement);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPhysicalSettlement(), (RosettaModelObjectBuilder)o.getPhysicalSettlement(), this::setPhysicalSettlement);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEarlyTerminationProvision(), (RosettaModelObjectBuilder)o.getEarlyTerminationProvision(), this::setEarlyTerminationProvision);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSwaptionAdjustedDates(), (RosettaModelObjectBuilder)o.getSwaptionAdjustedDates(), this::setSwaptionAdjustedDates);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSwap(), (RosettaModelObjectBuilder)o.getSwap(), this::setSwap);
            merger.mergeBasic((Object)this.getOptionType(), (Object)o.getOptionType(), this::setOptionType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSwaptionStraddle(), (Object)o.getSwaptionStraddle(), this::setSwaptionStraddle, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Swaption _that = (Swaption)this.getType().cast(o);
            if (!Objects.equals(this.buyerSellerModel, _that.getBuyerSellerModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.premium, _that.getPremium())) {
                return false;
            }
            if (!Objects.equals((Object)this.optionType, (Object)_that.getOptionType())) {
                return false;
            }
            if (!Objects.equals(this.exercise, _that.getExercise())) {
                return false;
            }
            if (!Objects.equals(this.exerciseProcedure, _that.getExerciseProcedure())) {
                return false;
            }
            if (!Objects.equals(this.calculationAgent, _that.getCalculationAgent())) {
                return false;
            }
            if (!Objects.equals(this.cashSettlement, _that.getCashSettlement())) {
                return false;
            }
            if (!Objects.equals(this.physicalSettlement, _that.getPhysicalSettlement())) {
                return false;
            }
            if (!Objects.equals(this.swaptionStraddle, _that.getSwaptionStraddle())) {
                return false;
            }
            if (!Objects.equals(this.earlyTerminationProvision, _that.getEarlyTerminationProvision())) {
                return false;
            }
            if (!Objects.equals(this.swaptionAdjustedDates, _that.getSwaptionAdjustedDates())) {
                return false;
            }
            return Objects.equals(this.swap, _that.getSwap());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.buyerSellerModel != null ? this.buyerSellerModel.hashCode() : 0);
            _result = 31 * _result + (this.premium != null ? this.premium.hashCode() : 0);
            _result = 31 * _result + (this.optionType != null ? ((Object)((Object)this.optionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.exercise != null ? this.exercise.hashCode() : 0);
            _result = 31 * _result + (this.exerciseProcedure != null ? this.exerciseProcedure.hashCode() : 0);
            _result = 31 * _result + (this.calculationAgent != null ? this.calculationAgent.hashCode() : 0);
            _result = 31 * _result + (this.cashSettlement != null ? this.cashSettlement.hashCode() : 0);
            _result = 31 * _result + (this.physicalSettlement != null ? this.physicalSettlement.hashCode() : 0);
            _result = 31 * _result + (this.swaptionStraddle != null ? this.swaptionStraddle.hashCode() : 0);
            _result = 31 * _result + (this.earlyTerminationProvision != null ? this.earlyTerminationProvision.hashCode() : 0);
            _result = 31 * _result + (this.swaptionAdjustedDates != null ? this.swaptionAdjustedDates.hashCode() : 0);
            _result = 31 * _result + (this.swap != null ? this.swap.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "SwaptionBuilder {buyerSellerModel=" + String.valueOf(this.buyerSellerModel) + ", premium=" + String.valueOf(this.premium) + ", optionType=" + String.valueOf((Object)this.optionType) + ", exercise=" + String.valueOf(this.exercise) + ", exerciseProcedure=" + String.valueOf(this.exerciseProcedure) + ", calculationAgent=" + String.valueOf(this.calculationAgent) + ", cashSettlement=" + String.valueOf(this.cashSettlement) + ", physicalSettlement=" + String.valueOf(this.physicalSettlement) + ", swaptionStraddle=" + this.swaptionStraddle + ", earlyTerminationProvision=" + String.valueOf(this.earlyTerminationProvision) + ", swaptionAdjustedDates=" + String.valueOf(this.swaptionAdjustedDates) + ", swap=" + String.valueOf(this.swap) + "} " + super.toString();
        }
    }

    public static interface SwaptionBuilder
    extends Swaption,
    Product.ProductBuilder {
        public BuyerSellerModel.BuyerSellerModelBuilder getOrCreateBuyerSellerModel();

        @Override
        public BuyerSellerModel.BuyerSellerModelBuilder getBuyerSellerModel();

        public Payment.PaymentBuilder getOrCreatePremium(int var1);

        public List<? extends Payment.PaymentBuilder> getPremium();

        public Exercise.ExerciseBuilder getOrCreateExercise();

        @Override
        public Exercise.ExerciseBuilder getExercise();

        public ExerciseProcedure.ExerciseProcedureBuilder getOrCreateExerciseProcedure();

        @Override
        public ExerciseProcedure.ExerciseProcedureBuilder getExerciseProcedure();

        public CalculationAgent.CalculationAgentBuilder getOrCreateCalculationAgent();

        @Override
        public CalculationAgent.CalculationAgentBuilder getCalculationAgent();

        public CashSettlement.CashSettlementBuilder getOrCreateCashSettlement();

        @Override
        public CashSettlement.CashSettlementBuilder getCashSettlement();

        public SwaptionPhysicalSettlement.SwaptionPhysicalSettlementBuilder getOrCreatePhysicalSettlement();

        @Override
        public SwaptionPhysicalSettlement.SwaptionPhysicalSettlementBuilder getPhysicalSettlement();

        public EarlyTerminationProvision.EarlyTerminationProvisionBuilder getOrCreateEarlyTerminationProvision();

        @Override
        public EarlyTerminationProvision.EarlyTerminationProvisionBuilder getEarlyTerminationProvision();

        public SwaptionAdjustedDates.SwaptionAdjustedDatesBuilder getOrCreateSwaptionAdjustedDates();

        @Override
        public SwaptionAdjustedDates.SwaptionAdjustedDatesBuilder getSwaptionAdjustedDates();

        public Swap.SwapBuilder getOrCreateSwap();

        @Override
        public Swap.SwapBuilder getSwap();

        @Override
        public SwaptionBuilder setProductModel(ProductModel var1);

        @Override
        public SwaptionBuilder setId(String var1);

        public SwaptionBuilder setBuyerSellerModel(BuyerSellerModel var1);

        public SwaptionBuilder addPremium(Payment var1);

        public SwaptionBuilder addPremium(Payment var1, int var2);

        public SwaptionBuilder addPremium(List<? extends Payment> var1);

        public SwaptionBuilder setPremium(List<? extends Payment> var1);

        public SwaptionBuilder setOptionType(SwaptionTypeEnum var1);

        public SwaptionBuilder setExercise(Exercise var1);

        public SwaptionBuilder setExerciseProcedure(ExerciseProcedure var1);

        public SwaptionBuilder setCalculationAgent(CalculationAgent var1);

        public SwaptionBuilder setCashSettlement(CashSettlement var1);

        public SwaptionBuilder setPhysicalSettlement(SwaptionPhysicalSettlement var1);

        public SwaptionBuilder setSwaptionStraddle(Boolean var1);

        public SwaptionBuilder setEarlyTerminationProvision(EarlyTerminationProvision var1);

        public SwaptionBuilder setSwaptionAdjustedDates(SwaptionAdjustedDates var1);

        public SwaptionBuilder setSwap(Swap var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.BuyerSellerModelBuilder.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("premium"), processor, Payment.PaymentBuilder.class, this.getPremium(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionType"), SwaptionTypeEnum.class, (Object)this.getOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exercise"), processor, Exercise.ExerciseBuilder.class, this.getExercise(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exerciseProcedure"), processor, ExerciseProcedure.ExerciseProcedureBuilder.class, this.getExerciseProcedure(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("calculationAgent"), processor, CalculationAgent.CalculationAgentBuilder.class, this.getCalculationAgent(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cashSettlement"), processor, CashSettlement.CashSettlementBuilder.class, this.getCashSettlement(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("physicalSettlement"), processor, SwaptionPhysicalSettlement.SwaptionPhysicalSettlementBuilder.class, this.getPhysicalSettlement(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("swaptionStraddle"), Boolean.class, (Object)this.getSwaptionStraddle(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("earlyTerminationProvision"), processor, EarlyTerminationProvision.EarlyTerminationProvisionBuilder.class, this.getEarlyTerminationProvision(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("swaptionAdjustedDates"), processor, SwaptionAdjustedDates.SwaptionAdjustedDatesBuilder.class, this.getSwaptionAdjustedDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("swap"), processor, Swap.SwapBuilder.class, this.getSwap(), new AttributeMeta[0]);
        }

        @Override
        public SwaptionBuilder prune();
    }

    public static class SwaptionImpl
    extends Product.ProductImpl
    implements Swaption {
        private final BuyerSellerModel buyerSellerModel;
        private final List<? extends Payment> premium;
        private final SwaptionTypeEnum optionType;
        private final Exercise exercise;
        private final ExerciseProcedure exerciseProcedure;
        private final CalculationAgent calculationAgent;
        private final CashSettlement cashSettlement;
        private final SwaptionPhysicalSettlement physicalSettlement;
        private final Boolean swaptionStraddle;
        private final EarlyTerminationProvision earlyTerminationProvision;
        private final SwaptionAdjustedDates swaptionAdjustedDates;
        private final Swap swap;

        protected SwaptionImpl(SwaptionBuilder builder) {
            super(builder);
            this.buyerSellerModel = Optional.ofNullable(builder.getBuyerSellerModel()).map(f -> f.build()).orElse(null);
            this.premium = Optional.ofNullable(builder.getPremium()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.optionType = builder.getOptionType();
            this.exercise = Optional.ofNullable(builder.getExercise()).map(f -> f.build()).orElse(null);
            this.exerciseProcedure = Optional.ofNullable(builder.getExerciseProcedure()).map(f -> f.build()).orElse(null);
            this.calculationAgent = Optional.ofNullable(builder.getCalculationAgent()).map(f -> f.build()).orElse(null);
            this.cashSettlement = Optional.ofNullable(builder.getCashSettlement()).map(f -> f.build()).orElse(null);
            this.physicalSettlement = Optional.ofNullable(builder.getPhysicalSettlement()).map(f -> f.build()).orElse(null);
            this.swaptionStraddle = builder.getSwaptionStraddle();
            this.earlyTerminationProvision = Optional.ofNullable(builder.getEarlyTerminationProvision()).map(f -> f.build()).orElse(null);
            this.swaptionAdjustedDates = Optional.ofNullable(builder.getSwaptionAdjustedDates()).map(f -> f.build()).orElse(null);
            this.swap = Optional.ofNullable(builder.getSwap()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public BuyerSellerModel getBuyerSellerModel() {
            return this.buyerSellerModel;
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public List<? extends Payment> getPremium() {
            return this.premium;
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public SwaptionTypeEnum getOptionType() {
            return this.optionType;
        }

        @Override
        @RosettaAttribute(value="exercise", isRequired=true)
        @RuneAttribute(value="exercise", isRequired=true)
        public Exercise getExercise() {
            return this.exercise;
        }

        @Override
        @RosettaAttribute(value="exerciseProcedure")
        @RuneAttribute(value="exerciseProcedure")
        public ExerciseProcedure getExerciseProcedure() {
            return this.exerciseProcedure;
        }

        @Override
        @RosettaAttribute(value="calculationAgent")
        @RuneAttribute(value="calculationAgent")
        public CalculationAgent getCalculationAgent() {
            return this.calculationAgent;
        }

        @Override
        @RosettaAttribute(value="cashSettlement")
        @RuneAttribute(value="cashSettlement")
        public CashSettlement getCashSettlement() {
            return this.cashSettlement;
        }

        @Override
        @RosettaAttribute(value="physicalSettlement")
        @RuneAttribute(value="physicalSettlement")
        public SwaptionPhysicalSettlement getPhysicalSettlement() {
            return this.physicalSettlement;
        }

        @Override
        @RosettaAttribute(value="swaptionStraddle", isRequired=true)
        @RuneAttribute(value="swaptionStraddle", isRequired=true)
        public Boolean getSwaptionStraddle() {
            return this.swaptionStraddle;
        }

        @Override
        @RosettaAttribute(value="earlyTerminationProvision")
        @RuneAttribute(value="earlyTerminationProvision")
        public EarlyTerminationProvision getEarlyTerminationProvision() {
            return this.earlyTerminationProvision;
        }

        @Override
        @RosettaAttribute(value="swaptionAdjustedDates")
        @RuneAttribute(value="swaptionAdjustedDates")
        public SwaptionAdjustedDates getSwaptionAdjustedDates() {
            return this.swaptionAdjustedDates;
        }

        @Override
        @RosettaAttribute(value="swap", isRequired=true)
        @RuneAttribute(value="swap", isRequired=true)
        public Swap getSwap() {
            return this.swap;
        }

        @Override
        public Swaption build() {
            return this;
        }

        @Override
        public SwaptionBuilder toBuilder() {
            SwaptionBuilder builder = Swaption.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SwaptionBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getBuyerSellerModel()).ifPresent(builder::setBuyerSellerModel);
            Optional.ofNullable(this.getPremium()).ifPresent(builder::setPremium);
            Optional.ofNullable(this.getOptionType()).ifPresent(builder::setOptionType);
            Optional.ofNullable(this.getExercise()).ifPresent(builder::setExercise);
            Optional.ofNullable(this.getExerciseProcedure()).ifPresent(builder::setExerciseProcedure);
            Optional.ofNullable(this.getCalculationAgent()).ifPresent(builder::setCalculationAgent);
            Optional.ofNullable(this.getCashSettlement()).ifPresent(builder::setCashSettlement);
            Optional.ofNullable(this.getPhysicalSettlement()).ifPresent(builder::setPhysicalSettlement);
            Optional.ofNullable(this.getSwaptionStraddle()).ifPresent(builder::setSwaptionStraddle);
            Optional.ofNullable(this.getEarlyTerminationProvision()).ifPresent(builder::setEarlyTerminationProvision);
            Optional.ofNullable(this.getSwaptionAdjustedDates()).ifPresent(builder::setSwaptionAdjustedDates);
            Optional.ofNullable(this.getSwap()).ifPresent(builder::setSwap);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Swaption _that = (Swaption)this.getType().cast(o);
            if (!Objects.equals(this.buyerSellerModel, _that.getBuyerSellerModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.premium, _that.getPremium())) {
                return false;
            }
            if (!Objects.equals((Object)this.optionType, (Object)_that.getOptionType())) {
                return false;
            }
            if (!Objects.equals(this.exercise, _that.getExercise())) {
                return false;
            }
            if (!Objects.equals(this.exerciseProcedure, _that.getExerciseProcedure())) {
                return false;
            }
            if (!Objects.equals(this.calculationAgent, _that.getCalculationAgent())) {
                return false;
            }
            if (!Objects.equals(this.cashSettlement, _that.getCashSettlement())) {
                return false;
            }
            if (!Objects.equals(this.physicalSettlement, _that.getPhysicalSettlement())) {
                return false;
            }
            if (!Objects.equals(this.swaptionStraddle, _that.getSwaptionStraddle())) {
                return false;
            }
            if (!Objects.equals(this.earlyTerminationProvision, _that.getEarlyTerminationProvision())) {
                return false;
            }
            if (!Objects.equals(this.swaptionAdjustedDates, _that.getSwaptionAdjustedDates())) {
                return false;
            }
            return Objects.equals(this.swap, _that.getSwap());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.buyerSellerModel != null ? this.buyerSellerModel.hashCode() : 0);
            _result = 31 * _result + (this.premium != null ? this.premium.hashCode() : 0);
            _result = 31 * _result + (this.optionType != null ? ((Object)((Object)this.optionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.exercise != null ? this.exercise.hashCode() : 0);
            _result = 31 * _result + (this.exerciseProcedure != null ? this.exerciseProcedure.hashCode() : 0);
            _result = 31 * _result + (this.calculationAgent != null ? this.calculationAgent.hashCode() : 0);
            _result = 31 * _result + (this.cashSettlement != null ? this.cashSettlement.hashCode() : 0);
            _result = 31 * _result + (this.physicalSettlement != null ? this.physicalSettlement.hashCode() : 0);
            _result = 31 * _result + (this.swaptionStraddle != null ? this.swaptionStraddle.hashCode() : 0);
            _result = 31 * _result + (this.earlyTerminationProvision != null ? this.earlyTerminationProvision.hashCode() : 0);
            _result = 31 * _result + (this.swaptionAdjustedDates != null ? this.swaptionAdjustedDates.hashCode() : 0);
            _result = 31 * _result + (this.swap != null ? this.swap.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Swaption {buyerSellerModel=" + String.valueOf(this.buyerSellerModel) + ", premium=" + String.valueOf(this.premium) + ", optionType=" + String.valueOf((Object)this.optionType) + ", exercise=" + String.valueOf(this.exercise) + ", exerciseProcedure=" + String.valueOf(this.exerciseProcedure) + ", calculationAgent=" + String.valueOf(this.calculationAgent) + ", cashSettlement=" + String.valueOf(this.cashSettlement) + ", physicalSettlement=" + String.valueOf(this.physicalSettlement) + ", swaptionStraddle=" + this.swaptionStraddle + ", earlyTerminationProvision=" + String.valueOf(this.earlyTerminationProvision) + ", swaptionAdjustedDates=" + String.valueOf(this.swaptionAdjustedDates) + ", swap=" + String.valueOf(this.swap) + "} " + super.toString();
        }
    }
}

