/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.fx.targets;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.fx.targets.SettlementPeriodFixingDatesSequence;
import fpml.consolidated.fx.targets.meta.SettlementPeriodFixingDatesMeta;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="SettlementPeriodFixingDates", builder=SettlementPeriodFixingDatesBuilderImpl.class, version="1.2.2")
@RuneDataType(value="SettlementPeriodFixingDates", model="fpml", builder=SettlementPeriodFixingDatesBuilderImpl.class, version="1.2.2")
public interface SettlementPeriodFixingDates
extends RosettaModelObject {
    public static final SettlementPeriodFixingDatesMeta metaData = new SettlementPeriodFixingDatesMeta();

    public List<ZonedDateTime> getFixingDate();

    public SettlementPeriodFixingDatesSequence getSettlementPeriodFixingDatesSequence();

    public Integer getNumberOfFixings();

    public SettlementPeriodFixingDates build();

    public SettlementPeriodFixingDatesBuilder toBuilder();

    public static SettlementPeriodFixingDatesBuilder builder() {
        return new SettlementPeriodFixingDatesBuilderImpl();
    }

    default public RosettaMetaData<? extends SettlementPeriodFixingDates> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends SettlementPeriodFixingDates> getType() {
        return SettlementPeriodFixingDates.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fixingDate"), ZonedDateTime.class, this.getFixingDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementPeriodFixingDatesSequence"), processor, SettlementPeriodFixingDatesSequence.class, this.getSettlementPeriodFixingDatesSequence(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("numberOfFixings"), Integer.class, (Object)this.getNumberOfFixings(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class SettlementPeriodFixingDatesBuilderImpl
    implements SettlementPeriodFixingDatesBuilder {
        protected List<ZonedDateTime> fixingDate = new ArrayList<ZonedDateTime>();
        protected SettlementPeriodFixingDatesSequence.SettlementPeriodFixingDatesSequenceBuilder settlementPeriodFixingDatesSequence;
        protected Integer numberOfFixings;

        @Override
        @RosettaAttribute(value="fixingDate")
        @RuneAttribute(value="fixingDate")
        public List<ZonedDateTime> getFixingDate() {
            return this.fixingDate;
        }

        @Override
        @RosettaAttribute(value="settlementPeriodFixingDatesSequence")
        @RuneAttribute(value="settlementPeriodFixingDatesSequence")
        public SettlementPeriodFixingDatesSequence.SettlementPeriodFixingDatesSequenceBuilder getSettlementPeriodFixingDatesSequence() {
            return this.settlementPeriodFixingDatesSequence;
        }

        @Override
        public SettlementPeriodFixingDatesSequence.SettlementPeriodFixingDatesSequenceBuilder getOrCreateSettlementPeriodFixingDatesSequence() {
            SettlementPeriodFixingDatesSequence.SettlementPeriodFixingDatesSequenceBuilder result = this.settlementPeriodFixingDatesSequence != null ? this.settlementPeriodFixingDatesSequence : (this.settlementPeriodFixingDatesSequence = SettlementPeriodFixingDatesSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="numberOfFixings")
        @RuneAttribute(value="numberOfFixings")
        public Integer getNumberOfFixings() {
            return this.numberOfFixings;
        }

        @Override
        @RosettaAttribute(value="fixingDate")
        @RuneAttribute(value="fixingDate")
        public SettlementPeriodFixingDatesBuilder addFixingDate(ZonedDateTime _fixingDate) {
            if (_fixingDate != null) {
                this.fixingDate.add(_fixingDate);
            }
            return this;
        }

        @Override
        public SettlementPeriodFixingDatesBuilder addFixingDate(ZonedDateTime _fixingDate, int idx) {
            this.getIndex(this.fixingDate, idx, () -> _fixingDate);
            return this;
        }

        @Override
        public SettlementPeriodFixingDatesBuilder addFixingDate(List<ZonedDateTime> fixingDates) {
            if (fixingDates != null) {
                for (ZonedDateTime toAdd : fixingDates) {
                    this.fixingDate.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="fixingDate")
        public SettlementPeriodFixingDatesBuilder setFixingDate(List<ZonedDateTime> fixingDates) {
            this.fixingDate = fixingDates == null ? new ArrayList<ZonedDateTime>() : (List)fixingDates.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementPeriodFixingDatesSequence")
        @RuneAttribute(value="settlementPeriodFixingDatesSequence")
        public SettlementPeriodFixingDatesBuilder setSettlementPeriodFixingDatesSequence(SettlementPeriodFixingDatesSequence _settlementPeriodFixingDatesSequence) {
            this.settlementPeriodFixingDatesSequence = _settlementPeriodFixingDatesSequence == null ? null : _settlementPeriodFixingDatesSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="numberOfFixings")
        @RuneAttribute(value="numberOfFixings")
        public SettlementPeriodFixingDatesBuilder setNumberOfFixings(Integer _numberOfFixings) {
            this.numberOfFixings = _numberOfFixings == null ? null : _numberOfFixings;
            return this;
        }

        @Override
        public SettlementPeriodFixingDates build() {
            return new SettlementPeriodFixingDatesImpl(this);
        }

        @Override
        public SettlementPeriodFixingDatesBuilder toBuilder() {
            return this;
        }

        @Override
        public SettlementPeriodFixingDatesBuilder prune() {
            if (this.settlementPeriodFixingDatesSequence != null && !this.settlementPeriodFixingDatesSequence.prune().hasData()) {
                this.settlementPeriodFixingDatesSequence = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getFixingDate() != null && !this.getFixingDate().isEmpty()) {
                return true;
            }
            if (this.getSettlementPeriodFixingDatesSequence() != null && this.getSettlementPeriodFixingDatesSequence().hasData()) {
                return true;
            }
            return this.getNumberOfFixings() != null;
        }

        public SettlementPeriodFixingDatesBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            SettlementPeriodFixingDatesBuilder o = (SettlementPeriodFixingDatesBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementPeriodFixingDatesSequence(), (RosettaModelObjectBuilder)o.getSettlementPeriodFixingDatesSequence(), this::setSettlementPeriodFixingDatesSequence);
            merger.mergeBasic(this.getFixingDate(), o.getFixingDate(), this::addFixingDate);
            merger.mergeBasic((Object)this.getNumberOfFixings(), (Object)o.getNumberOfFixings(), this::setNumberOfFixings, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SettlementPeriodFixingDates _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.fixingDate, _that.getFixingDate())) {
                return false;
            }
            if (!Objects.equals(this.settlementPeriodFixingDatesSequence, _that.getSettlementPeriodFixingDatesSequence())) {
                return false;
            }
            return Objects.equals(this.numberOfFixings, _that.getNumberOfFixings());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.fixingDate != null ? this.fixingDate.hashCode() : 0);
            _result = 31 * _result + (this.settlementPeriodFixingDatesSequence != null ? this.settlementPeriodFixingDatesSequence.hashCode() : 0);
            _result = 31 * _result + (this.numberOfFixings != null ? this.numberOfFixings.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SettlementPeriodFixingDatesBuilder {fixingDate=" + String.valueOf(this.fixingDate) + ", settlementPeriodFixingDatesSequence=" + String.valueOf(this.settlementPeriodFixingDatesSequence) + ", numberOfFixings=" + this.numberOfFixings + "}";
        }
    }

    public static interface SettlementPeriodFixingDatesBuilder
    extends SettlementPeriodFixingDates,
    RosettaModelObjectBuilder {
        public SettlementPeriodFixingDatesSequence.SettlementPeriodFixingDatesSequenceBuilder getOrCreateSettlementPeriodFixingDatesSequence();

        @Override
        public SettlementPeriodFixingDatesSequence.SettlementPeriodFixingDatesSequenceBuilder getSettlementPeriodFixingDatesSequence();

        public SettlementPeriodFixingDatesBuilder addFixingDate(ZonedDateTime var1);

        public SettlementPeriodFixingDatesBuilder addFixingDate(ZonedDateTime var1, int var2);

        public SettlementPeriodFixingDatesBuilder addFixingDate(List<ZonedDateTime> var1);

        public SettlementPeriodFixingDatesBuilder setFixingDate(List<ZonedDateTime> var1);

        public SettlementPeriodFixingDatesBuilder setSettlementPeriodFixingDatesSequence(SettlementPeriodFixingDatesSequence var1);

        public SettlementPeriodFixingDatesBuilder setNumberOfFixings(Integer var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fixingDate"), ZonedDateTime.class, this.getFixingDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementPeriodFixingDatesSequence"), processor, SettlementPeriodFixingDatesSequence.SettlementPeriodFixingDatesSequenceBuilder.class, this.getSettlementPeriodFixingDatesSequence(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("numberOfFixings"), Integer.class, (Object)this.getNumberOfFixings(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public SettlementPeriodFixingDatesBuilder prune();
    }

    public static class SettlementPeriodFixingDatesImpl
    implements SettlementPeriodFixingDates {
        private final List<ZonedDateTime> fixingDate;
        private final SettlementPeriodFixingDatesSequence settlementPeriodFixingDatesSequence;
        private final Integer numberOfFixings;

        protected SettlementPeriodFixingDatesImpl(SettlementPeriodFixingDatesBuilder builder) {
            this.fixingDate = Optional.ofNullable(builder.getFixingDate()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.settlementPeriodFixingDatesSequence = Optional.ofNullable(builder.getSettlementPeriodFixingDatesSequence()).map(f -> f.build()).orElse(null);
            this.numberOfFixings = builder.getNumberOfFixings();
        }

        @Override
        @RosettaAttribute(value="fixingDate")
        @RuneAttribute(value="fixingDate")
        public List<ZonedDateTime> getFixingDate() {
            return this.fixingDate;
        }

        @Override
        @RosettaAttribute(value="settlementPeriodFixingDatesSequence")
        @RuneAttribute(value="settlementPeriodFixingDatesSequence")
        public SettlementPeriodFixingDatesSequence getSettlementPeriodFixingDatesSequence() {
            return this.settlementPeriodFixingDatesSequence;
        }

        @Override
        @RosettaAttribute(value="numberOfFixings")
        @RuneAttribute(value="numberOfFixings")
        public Integer getNumberOfFixings() {
            return this.numberOfFixings;
        }

        @Override
        public SettlementPeriodFixingDates build() {
            return this;
        }

        @Override
        public SettlementPeriodFixingDatesBuilder toBuilder() {
            SettlementPeriodFixingDatesBuilder builder = SettlementPeriodFixingDates.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SettlementPeriodFixingDatesBuilder builder) {
            Optional.ofNullable(this.getFixingDate()).ifPresent(builder::setFixingDate);
            Optional.ofNullable(this.getSettlementPeriodFixingDatesSequence()).ifPresent(builder::setSettlementPeriodFixingDatesSequence);
            Optional.ofNullable(this.getNumberOfFixings()).ifPresent(builder::setNumberOfFixings);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SettlementPeriodFixingDates _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.fixingDate, _that.getFixingDate())) {
                return false;
            }
            if (!Objects.equals(this.settlementPeriodFixingDatesSequence, _that.getSettlementPeriodFixingDatesSequence())) {
                return false;
            }
            return Objects.equals(this.numberOfFixings, _that.getNumberOfFixings());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.fixingDate != null ? this.fixingDate.hashCode() : 0);
            _result = 31 * _result + (this.settlementPeriodFixingDatesSequence != null ? this.settlementPeriodFixingDatesSequence.hashCode() : 0);
            _result = 31 * _result + (this.numberOfFixings != null ? this.numberOfFixings.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SettlementPeriodFixingDates {fixingDate=" + String.valueOf(this.fixingDate) + ", settlementPeriodFixingDatesSequence=" + String.valueOf(this.settlementPeriodFixingDatesSequence) + ", numberOfFixings=" + this.numberOfFixings + "}";
        }
    }
}

