/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.fx.accruals;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.fx.accruals.FxAdjustedDateAndDateAdjustments;
import fpml.consolidated.fx.accruals.meta.FxExpiryDateMeta;
import fpml.consolidated.shared.BusinessCenterTime;
import fpml.consolidated.shared.BusinessDayAdjustments;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="FxExpiryDate", builder=FxExpiryDateBuilderImpl.class, version="1.2.2")
@RuneDataType(value="FxExpiryDate", model="fpml", builder=FxExpiryDateBuilderImpl.class, version="1.2.2")
public interface FxExpiryDate
extends FxAdjustedDateAndDateAdjustments {
    public static final FxExpiryDateMeta metaData = new FxExpiryDateMeta();

    public BusinessCenterTime getExpiryTime();

    @Override
    public FxExpiryDate build();

    @Override
    public FxExpiryDateBuilder toBuilder();

    public static FxExpiryDateBuilder builder() {
        return new FxExpiryDateBuilderImpl();
    }

    default public RosettaMetaData<? extends FxExpiryDate> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxExpiryDate> getType() {
        return FxExpiryDate.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("dateAdjustments"), processor, BusinessDayAdjustments.class, this.getDateAdjustments(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("adjustedDate"), ZonedDateTime.class, (Object)this.getAdjustedDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("expiryTime"), processor, BusinessCenterTime.class, this.getExpiryTime(), new AttributeMeta[0]);
    }

    public static class FxExpiryDateBuilderImpl
    extends FxAdjustedDateAndDateAdjustments.FxAdjustedDateAndDateAdjustmentsBuilderImpl
    implements FxExpiryDateBuilder {
        protected BusinessCenterTime.BusinessCenterTimeBuilder expiryTime;

        @Override
        @RosettaAttribute(value="expiryTime")
        @RuneAttribute(value="expiryTime")
        public BusinessCenterTime.BusinessCenterTimeBuilder getExpiryTime() {
            return this.expiryTime;
        }

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateExpiryTime() {
            BusinessCenterTime.BusinessCenterTimeBuilder result = this.expiryTime != null ? this.expiryTime : (this.expiryTime = BusinessCenterTime.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dateAdjustments")
        @RuneAttribute(value="dateAdjustments")
        public FxExpiryDateBuilder setDateAdjustments(BusinessDayAdjustments _dateAdjustments) {
            this.dateAdjustments = _dateAdjustments == null ? null : _dateAdjustments.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="adjustedDate", isRequired=true)
        @RuneAttribute(value="adjustedDate", isRequired=true)
        public FxExpiryDateBuilder setAdjustedDate(ZonedDateTime _adjustedDate) {
            this.adjustedDate = _adjustedDate == null ? null : _adjustedDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="expiryTime")
        @RuneAttribute(value="expiryTime")
        public FxExpiryDateBuilder setExpiryTime(BusinessCenterTime _expiryTime) {
            this.expiryTime = _expiryTime == null ? null : _expiryTime.toBuilder();
            return this;
        }

        @Override
        public FxExpiryDate build() {
            return new FxExpiryDateImpl(this);
        }

        @Override
        public FxExpiryDateBuilder toBuilder() {
            return this;
        }

        @Override
        public FxExpiryDateBuilder prune() {
            super.prune();
            if (this.expiryTime != null && !this.expiryTime.prune().hasData()) {
                this.expiryTime = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getExpiryTime() != null && this.getExpiryTime().hasData();
        }

        @Override
        public FxExpiryDateBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FxExpiryDateBuilder o = (FxExpiryDateBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExpiryTime(), (RosettaModelObjectBuilder)o.getExpiryTime(), this::setExpiryTime);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxExpiryDate _that = (FxExpiryDate)this.getType().cast(o);
            return Objects.equals(this.expiryTime, _that.getExpiryTime());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.expiryTime != null ? this.expiryTime.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxExpiryDateBuilder {expiryTime=" + String.valueOf(this.expiryTime) + "} " + super.toString();
        }
    }

    public static interface FxExpiryDateBuilder
    extends FxExpiryDate,
    FxAdjustedDateAndDateAdjustments.FxAdjustedDateAndDateAdjustmentsBuilder {
        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateExpiryTime();

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getExpiryTime();

        @Override
        public FxExpiryDateBuilder setDateAdjustments(BusinessDayAdjustments var1);

        @Override
        public FxExpiryDateBuilder setAdjustedDate(ZonedDateTime var1);

        public FxExpiryDateBuilder setExpiryTime(BusinessCenterTime var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("dateAdjustments"), processor, BusinessDayAdjustments.BusinessDayAdjustmentsBuilder.class, (RosettaModelObjectBuilder)this.getDateAdjustments(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("adjustedDate"), ZonedDateTime.class, (Object)this.getAdjustedDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("expiryTime"), processor, BusinessCenterTime.BusinessCenterTimeBuilder.class, this.getExpiryTime(), new AttributeMeta[0]);
        }

        @Override
        public FxExpiryDateBuilder prune();
    }

    public static class FxExpiryDateImpl
    extends FxAdjustedDateAndDateAdjustments.FxAdjustedDateAndDateAdjustmentsImpl
    implements FxExpiryDate {
        private final BusinessCenterTime expiryTime;

        protected FxExpiryDateImpl(FxExpiryDateBuilder builder) {
            super(builder);
            this.expiryTime = Optional.ofNullable(builder.getExpiryTime()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="expiryTime")
        @RuneAttribute(value="expiryTime")
        public BusinessCenterTime getExpiryTime() {
            return this.expiryTime;
        }

        @Override
        public FxExpiryDate build() {
            return this;
        }

        @Override
        public FxExpiryDateBuilder toBuilder() {
            FxExpiryDateBuilder builder = FxExpiryDate.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxExpiryDateBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getExpiryTime()).ifPresent(builder::setExpiryTime);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxExpiryDate _that = (FxExpiryDate)this.getType().cast(o);
            return Objects.equals(this.expiryTime, _that.getExpiryTime());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.expiryTime != null ? this.expiryTime.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxExpiryDate {expiryTime=" + String.valueOf(this.expiryTime) + "} " + super.toString();
        }
    }
}

