/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.fx;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.fpmlenum.TouchConditionEnum;
import fpml.consolidated.fpmlenum.TriggerConditionEnum;
import fpml.consolidated.fx.FxBusinessCenterDateTime;
import fpml.consolidated.fx.FxTouchSequence;
import fpml.consolidated.fx.meta.FxTouchMeta;
import fpml.consolidated.shared.InformationSource;
import fpml.consolidated.shared.QuotedCurrencyPair;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FxTouch", builder=FxTouchBuilderImpl.class, version="1.2.2")
@RuneDataType(value="FxTouch", model="fpml", builder=FxTouchBuilderImpl.class, version="1.2.2")
public interface FxTouch
extends RosettaModelObject {
    public static final FxTouchMeta metaData = new FxTouchMeta();

    public TouchConditionEnum getTouchCondition();

    public TriggerConditionEnum getDirection();

    public QuotedCurrencyPair getQuotedCurrencyPair();

    public BigDecimal getTriggerRate();

    public BigDecimal getSpotRate();

    public List<? extends InformationSource> getInformationSource();

    public FxTouchSequence getFxTouchSequence();

    public List<? extends FxBusinessCenterDateTime> getObservationPoint();

    public FxTouch build();

    public FxTouchBuilder toBuilder();

    public static FxTouchBuilder builder() {
        return new FxTouchBuilderImpl();
    }

    default public RosettaMetaData<? extends FxTouch> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxTouch> getType() {
        return FxTouch.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("touchCondition"), TouchConditionEnum.class, (Object)this.getTouchCondition(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("direction"), TriggerConditionEnum.class, (Object)this.getDirection(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("quotedCurrencyPair"), processor, QuotedCurrencyPair.class, this.getQuotedCurrencyPair(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("triggerRate"), BigDecimal.class, (Object)this.getTriggerRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spotRate"), BigDecimal.class, (Object)this.getSpotRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("informationSource"), processor, InformationSource.class, this.getInformationSource(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxTouchSequence"), processor, FxTouchSequence.class, this.getFxTouchSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("observationPoint"), processor, FxBusinessCenterDateTime.class, this.getObservationPoint(), new AttributeMeta[0]);
    }

    public static class FxTouchBuilderImpl
    implements FxTouchBuilder {
        protected TouchConditionEnum touchCondition;
        protected TriggerConditionEnum direction;
        protected QuotedCurrencyPair.QuotedCurrencyPairBuilder quotedCurrencyPair;
        protected BigDecimal triggerRate;
        protected BigDecimal spotRate;
        protected List<InformationSource.InformationSourceBuilder> informationSource = new ArrayList<InformationSource.InformationSourceBuilder>();
        protected FxTouchSequence.FxTouchSequenceBuilder fxTouchSequence;
        protected List<FxBusinessCenterDateTime.FxBusinessCenterDateTimeBuilder> observationPoint = new ArrayList<FxBusinessCenterDateTime.FxBusinessCenterDateTimeBuilder>();

        @Override
        @RosettaAttribute(value="touchCondition")
        @RuneAttribute(value="touchCondition")
        public TouchConditionEnum getTouchCondition() {
            return this.touchCondition;
        }

        @Override
        @RosettaAttribute(value="direction")
        @RuneAttribute(value="direction")
        public TriggerConditionEnum getDirection() {
            return this.direction;
        }

        @Override
        @RosettaAttribute(value="quotedCurrencyPair")
        @RuneAttribute(value="quotedCurrencyPair")
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getQuotedCurrencyPair() {
            return this.quotedCurrencyPair;
        }

        @Override
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getOrCreateQuotedCurrencyPair() {
            QuotedCurrencyPair.QuotedCurrencyPairBuilder result = this.quotedCurrencyPair != null ? this.quotedCurrencyPair : (this.quotedCurrencyPair = QuotedCurrencyPair.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="triggerRate")
        @RuneAttribute(value="triggerRate")
        public BigDecimal getTriggerRate() {
            return this.triggerRate;
        }

        @Override
        @RosettaAttribute(value="spotRate")
        @RuneAttribute(value="spotRate")
        public BigDecimal getSpotRate() {
            return this.spotRate;
        }

        @Override
        @RosettaAttribute(value="informationSource")
        @RuneAttribute(value="informationSource")
        public List<? extends InformationSource.InformationSourceBuilder> getInformationSource() {
            return this.informationSource;
        }

        @Override
        public InformationSource.InformationSourceBuilder getOrCreateInformationSource(int index) {
            if (this.informationSource == null) {
                this.informationSource = new ArrayList<InformationSource.InformationSourceBuilder>();
            }
            return (InformationSource.InformationSourceBuilder)this.getIndex(this.informationSource, index, () -> {
                InformationSource.InformationSourceBuilder newInformationSource = InformationSource.builder();
                return newInformationSource;
            });
        }

        @Override
        @RosettaAttribute(value="fxTouchSequence")
        @RuneAttribute(value="fxTouchSequence")
        public FxTouchSequence.FxTouchSequenceBuilder getFxTouchSequence() {
            return this.fxTouchSequence;
        }

        @Override
        public FxTouchSequence.FxTouchSequenceBuilder getOrCreateFxTouchSequence() {
            FxTouchSequence.FxTouchSequenceBuilder result = this.fxTouchSequence != null ? this.fxTouchSequence : (this.fxTouchSequence = FxTouchSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="observationPoint")
        @RuneAttribute(value="observationPoint")
        public List<? extends FxBusinessCenterDateTime.FxBusinessCenterDateTimeBuilder> getObservationPoint() {
            return this.observationPoint;
        }

        @Override
        public FxBusinessCenterDateTime.FxBusinessCenterDateTimeBuilder getOrCreateObservationPoint(int index) {
            if (this.observationPoint == null) {
                this.observationPoint = new ArrayList<FxBusinessCenterDateTime.FxBusinessCenterDateTimeBuilder>();
            }
            return (FxBusinessCenterDateTime.FxBusinessCenterDateTimeBuilder)this.getIndex(this.observationPoint, index, () -> {
                FxBusinessCenterDateTime.FxBusinessCenterDateTimeBuilder newObservationPoint = FxBusinessCenterDateTime.builder();
                return newObservationPoint;
            });
        }

        @Override
        @RosettaAttribute(value="touchCondition")
        @RuneAttribute(value="touchCondition")
        public FxTouchBuilder setTouchCondition(TouchConditionEnum _touchCondition) {
            this.touchCondition = _touchCondition == null ? null : _touchCondition;
            return this;
        }

        @Override
        @RosettaAttribute(value="direction")
        @RuneAttribute(value="direction")
        public FxTouchBuilder setDirection(TriggerConditionEnum _direction) {
            this.direction = _direction == null ? null : _direction;
            return this;
        }

        @Override
        @RosettaAttribute(value="quotedCurrencyPair")
        @RuneAttribute(value="quotedCurrencyPair")
        public FxTouchBuilder setQuotedCurrencyPair(QuotedCurrencyPair _quotedCurrencyPair) {
            this.quotedCurrencyPair = _quotedCurrencyPair == null ? null : _quotedCurrencyPair.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="triggerRate")
        @RuneAttribute(value="triggerRate")
        public FxTouchBuilder setTriggerRate(BigDecimal _triggerRate) {
            this.triggerRate = _triggerRate == null ? null : _triggerRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="spotRate")
        @RuneAttribute(value="spotRate")
        public FxTouchBuilder setSpotRate(BigDecimal _spotRate) {
            this.spotRate = _spotRate == null ? null : _spotRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="informationSource")
        @RuneAttribute(value="informationSource")
        public FxTouchBuilder addInformationSource(InformationSource _informationSource) {
            if (_informationSource != null) {
                this.informationSource.add(_informationSource.toBuilder());
            }
            return this;
        }

        @Override
        public FxTouchBuilder addInformationSource(InformationSource _informationSource, int idx) {
            this.getIndex(this.informationSource, idx, () -> _informationSource.toBuilder());
            return this;
        }

        @Override
        public FxTouchBuilder addInformationSource(List<? extends InformationSource> informationSources) {
            if (informationSources != null) {
                for (InformationSource informationSource : informationSources) {
                    this.informationSource.add(informationSource.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="informationSource")
        public FxTouchBuilder setInformationSource(List<? extends InformationSource> informationSources) {
            this.informationSource = informationSources == null ? new ArrayList<InformationSource.InformationSourceBuilder>() : (List)informationSources.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="fxTouchSequence")
        @RuneAttribute(value="fxTouchSequence")
        public FxTouchBuilder setFxTouchSequence(FxTouchSequence _fxTouchSequence) {
            this.fxTouchSequence = _fxTouchSequence == null ? null : _fxTouchSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="observationPoint")
        @RuneAttribute(value="observationPoint")
        public FxTouchBuilder addObservationPoint(FxBusinessCenterDateTime _observationPoint) {
            if (_observationPoint != null) {
                this.observationPoint.add(_observationPoint.toBuilder());
            }
            return this;
        }

        @Override
        public FxTouchBuilder addObservationPoint(FxBusinessCenterDateTime _observationPoint, int idx) {
            this.getIndex(this.observationPoint, idx, () -> _observationPoint.toBuilder());
            return this;
        }

        @Override
        public FxTouchBuilder addObservationPoint(List<? extends FxBusinessCenterDateTime> observationPoints) {
            if (observationPoints != null) {
                for (FxBusinessCenterDateTime fxBusinessCenterDateTime : observationPoints) {
                    this.observationPoint.add(fxBusinessCenterDateTime.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="observationPoint")
        public FxTouchBuilder setObservationPoint(List<? extends FxBusinessCenterDateTime> observationPoints) {
            this.observationPoint = observationPoints == null ? new ArrayList<FxBusinessCenterDateTime.FxBusinessCenterDateTimeBuilder>() : (List)observationPoints.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public FxTouch build() {
            return new FxTouchImpl(this);
        }

        @Override
        public FxTouchBuilder toBuilder() {
            return this;
        }

        @Override
        public FxTouchBuilder prune() {
            if (this.quotedCurrencyPair != null && !this.quotedCurrencyPair.prune().hasData()) {
                this.quotedCurrencyPair = null;
            }
            this.informationSource = this.informationSource.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.fxTouchSequence != null && !this.fxTouchSequence.prune().hasData()) {
                this.fxTouchSequence = null;
            }
            this.observationPoint = this.observationPoint.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getTouchCondition() != null) {
                return true;
            }
            if (this.getDirection() != null) {
                return true;
            }
            if (this.getQuotedCurrencyPair() != null && this.getQuotedCurrencyPair().hasData()) {
                return true;
            }
            if (this.getTriggerRate() != null) {
                return true;
            }
            if (this.getSpotRate() != null) {
                return true;
            }
            if (this.getInformationSource() != null && this.getInformationSource().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getFxTouchSequence() != null && this.getFxTouchSequence().hasData()) {
                return true;
            }
            return this.getObservationPoint() != null && this.getObservationPoint().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public FxTouchBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FxTouchBuilder o = (FxTouchBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getQuotedCurrencyPair(), (RosettaModelObjectBuilder)o.getQuotedCurrencyPair(), this::setQuotedCurrencyPair);
            merger.mergeRosetta(this.getInformationSource(), o.getInformationSource(), this::getOrCreateInformationSource);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxTouchSequence(), (RosettaModelObjectBuilder)o.getFxTouchSequence(), this::setFxTouchSequence);
            merger.mergeRosetta(this.getObservationPoint(), o.getObservationPoint(), this::getOrCreateObservationPoint);
            merger.mergeBasic((Object)this.getTouchCondition(), (Object)o.getTouchCondition(), this::setTouchCondition, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDirection(), (Object)o.getDirection(), this::setDirection, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTriggerRate(), (Object)o.getTriggerRate(), this::setTriggerRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSpotRate(), (Object)o.getSpotRate(), this::setSpotRate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxTouch _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.touchCondition, (Object)_that.getTouchCondition())) {
                return false;
            }
            if (!Objects.equals((Object)this.direction, (Object)_that.getDirection())) {
                return false;
            }
            if (!Objects.equals(this.quotedCurrencyPair, _that.getQuotedCurrencyPair())) {
                return false;
            }
            if (!Objects.equals(this.triggerRate, _that.getTriggerRate())) {
                return false;
            }
            if (!Objects.equals(this.spotRate, _that.getSpotRate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.informationSource, _that.getInformationSource())) {
                return false;
            }
            if (!Objects.equals(this.fxTouchSequence, _that.getFxTouchSequence())) {
                return false;
            }
            return ListEquals.listEquals(this.observationPoint, _that.getObservationPoint());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.touchCondition != null ? ((Object)((Object)this.touchCondition)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.direction != null ? ((Object)((Object)this.direction)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.quotedCurrencyPair != null ? this.quotedCurrencyPair.hashCode() : 0);
            _result = 31 * _result + (this.triggerRate != null ? this.triggerRate.hashCode() : 0);
            _result = 31 * _result + (this.spotRate != null ? this.spotRate.hashCode() : 0);
            _result = 31 * _result + (this.informationSource != null ? this.informationSource.hashCode() : 0);
            _result = 31 * _result + (this.fxTouchSequence != null ? this.fxTouchSequence.hashCode() : 0);
            _result = 31 * _result + (this.observationPoint != null ? this.observationPoint.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxTouchBuilder {touchCondition=" + String.valueOf((Object)this.touchCondition) + ", direction=" + String.valueOf((Object)this.direction) + ", quotedCurrencyPair=" + String.valueOf(this.quotedCurrencyPair) + ", triggerRate=" + String.valueOf(this.triggerRate) + ", spotRate=" + String.valueOf(this.spotRate) + ", informationSource=" + String.valueOf(this.informationSource) + ", fxTouchSequence=" + String.valueOf(this.fxTouchSequence) + ", observationPoint=" + String.valueOf(this.observationPoint) + "}";
        }
    }

    public static interface FxTouchBuilder
    extends FxTouch,
    RosettaModelObjectBuilder {
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getOrCreateQuotedCurrencyPair();

        @Override
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getQuotedCurrencyPair();

        public InformationSource.InformationSourceBuilder getOrCreateInformationSource(int var1);

        public List<? extends InformationSource.InformationSourceBuilder> getInformationSource();

        public FxTouchSequence.FxTouchSequenceBuilder getOrCreateFxTouchSequence();

        @Override
        public FxTouchSequence.FxTouchSequenceBuilder getFxTouchSequence();

        public FxBusinessCenterDateTime.FxBusinessCenterDateTimeBuilder getOrCreateObservationPoint(int var1);

        public List<? extends FxBusinessCenterDateTime.FxBusinessCenterDateTimeBuilder> getObservationPoint();

        public FxTouchBuilder setTouchCondition(TouchConditionEnum var1);

        public FxTouchBuilder setDirection(TriggerConditionEnum var1);

        public FxTouchBuilder setQuotedCurrencyPair(QuotedCurrencyPair var1);

        public FxTouchBuilder setTriggerRate(BigDecimal var1);

        public FxTouchBuilder setSpotRate(BigDecimal var1);

        public FxTouchBuilder addInformationSource(InformationSource var1);

        public FxTouchBuilder addInformationSource(InformationSource var1, int var2);

        public FxTouchBuilder addInformationSource(List<? extends InformationSource> var1);

        public FxTouchBuilder setInformationSource(List<? extends InformationSource> var1);

        public FxTouchBuilder setFxTouchSequence(FxTouchSequence var1);

        public FxTouchBuilder addObservationPoint(FxBusinessCenterDateTime var1);

        public FxTouchBuilder addObservationPoint(FxBusinessCenterDateTime var1, int var2);

        public FxTouchBuilder addObservationPoint(List<? extends FxBusinessCenterDateTime> var1);

        public FxTouchBuilder setObservationPoint(List<? extends FxBusinessCenterDateTime> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("touchCondition"), TouchConditionEnum.class, (Object)this.getTouchCondition(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("direction"), TriggerConditionEnum.class, (Object)this.getDirection(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("quotedCurrencyPair"), processor, QuotedCurrencyPair.QuotedCurrencyPairBuilder.class, this.getQuotedCurrencyPair(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("triggerRate"), BigDecimal.class, (Object)this.getTriggerRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spotRate"), BigDecimal.class, (Object)this.getSpotRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("informationSource"), processor, InformationSource.InformationSourceBuilder.class, this.getInformationSource(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxTouchSequence"), processor, FxTouchSequence.FxTouchSequenceBuilder.class, this.getFxTouchSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("observationPoint"), processor, FxBusinessCenterDateTime.FxBusinessCenterDateTimeBuilder.class, this.getObservationPoint(), new AttributeMeta[0]);
        }

        public FxTouchBuilder prune();
    }

    public static class FxTouchImpl
    implements FxTouch {
        private final TouchConditionEnum touchCondition;
        private final TriggerConditionEnum direction;
        private final QuotedCurrencyPair quotedCurrencyPair;
        private final BigDecimal triggerRate;
        private final BigDecimal spotRate;
        private final List<? extends InformationSource> informationSource;
        private final FxTouchSequence fxTouchSequence;
        private final List<? extends FxBusinessCenterDateTime> observationPoint;

        protected FxTouchImpl(FxTouchBuilder builder) {
            this.touchCondition = builder.getTouchCondition();
            this.direction = builder.getDirection();
            this.quotedCurrencyPair = Optional.ofNullable(builder.getQuotedCurrencyPair()).map(f -> f.build()).orElse(null);
            this.triggerRate = builder.getTriggerRate();
            this.spotRate = builder.getSpotRate();
            this.informationSource = Optional.ofNullable(builder.getInformationSource()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.fxTouchSequence = Optional.ofNullable(builder.getFxTouchSequence()).map(f -> f.build()).orElse(null);
            this.observationPoint = Optional.ofNullable(builder.getObservationPoint()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="touchCondition")
        @RuneAttribute(value="touchCondition")
        public TouchConditionEnum getTouchCondition() {
            return this.touchCondition;
        }

        @Override
        @RosettaAttribute(value="direction")
        @RuneAttribute(value="direction")
        public TriggerConditionEnum getDirection() {
            return this.direction;
        }

        @Override
        @RosettaAttribute(value="quotedCurrencyPair")
        @RuneAttribute(value="quotedCurrencyPair")
        public QuotedCurrencyPair getQuotedCurrencyPair() {
            return this.quotedCurrencyPair;
        }

        @Override
        @RosettaAttribute(value="triggerRate")
        @RuneAttribute(value="triggerRate")
        public BigDecimal getTriggerRate() {
            return this.triggerRate;
        }

        @Override
        @RosettaAttribute(value="spotRate")
        @RuneAttribute(value="spotRate")
        public BigDecimal getSpotRate() {
            return this.spotRate;
        }

        @Override
        @RosettaAttribute(value="informationSource")
        @RuneAttribute(value="informationSource")
        public List<? extends InformationSource> getInformationSource() {
            return this.informationSource;
        }

        @Override
        @RosettaAttribute(value="fxTouchSequence")
        @RuneAttribute(value="fxTouchSequence")
        public FxTouchSequence getFxTouchSequence() {
            return this.fxTouchSequence;
        }

        @Override
        @RosettaAttribute(value="observationPoint")
        @RuneAttribute(value="observationPoint")
        public List<? extends FxBusinessCenterDateTime> getObservationPoint() {
            return this.observationPoint;
        }

        @Override
        public FxTouch build() {
            return this;
        }

        @Override
        public FxTouchBuilder toBuilder() {
            FxTouchBuilder builder = FxTouch.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxTouchBuilder builder) {
            Optional.ofNullable(this.getTouchCondition()).ifPresent(builder::setTouchCondition);
            Optional.ofNullable(this.getDirection()).ifPresent(builder::setDirection);
            Optional.ofNullable(this.getQuotedCurrencyPair()).ifPresent(builder::setQuotedCurrencyPair);
            Optional.ofNullable(this.getTriggerRate()).ifPresent(builder::setTriggerRate);
            Optional.ofNullable(this.getSpotRate()).ifPresent(builder::setSpotRate);
            Optional.ofNullable(this.getInformationSource()).ifPresent(builder::setInformationSource);
            Optional.ofNullable(this.getFxTouchSequence()).ifPresent(builder::setFxTouchSequence);
            Optional.ofNullable(this.getObservationPoint()).ifPresent(builder::setObservationPoint);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxTouch _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.touchCondition, (Object)_that.getTouchCondition())) {
                return false;
            }
            if (!Objects.equals((Object)this.direction, (Object)_that.getDirection())) {
                return false;
            }
            if (!Objects.equals(this.quotedCurrencyPair, _that.getQuotedCurrencyPair())) {
                return false;
            }
            if (!Objects.equals(this.triggerRate, _that.getTriggerRate())) {
                return false;
            }
            if (!Objects.equals(this.spotRate, _that.getSpotRate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.informationSource, _that.getInformationSource())) {
                return false;
            }
            if (!Objects.equals(this.fxTouchSequence, _that.getFxTouchSequence())) {
                return false;
            }
            return ListEquals.listEquals(this.observationPoint, _that.getObservationPoint());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.touchCondition != null ? ((Object)((Object)this.touchCondition)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.direction != null ? ((Object)((Object)this.direction)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.quotedCurrencyPair != null ? this.quotedCurrencyPair.hashCode() : 0);
            _result = 31 * _result + (this.triggerRate != null ? this.triggerRate.hashCode() : 0);
            _result = 31 * _result + (this.spotRate != null ? this.spotRate.hashCode() : 0);
            _result = 31 * _result + (this.informationSource != null ? this.informationSource.hashCode() : 0);
            _result = 31 * _result + (this.fxTouchSequence != null ? this.fxTouchSequence.hashCode() : 0);
            _result = 31 * _result + (this.observationPoint != null ? this.observationPoint.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxTouch {touchCondition=" + String.valueOf((Object)this.touchCondition) + ", direction=" + String.valueOf((Object)this.direction) + ", quotedCurrencyPair=" + String.valueOf(this.quotedCurrencyPair) + ", triggerRate=" + String.valueOf(this.triggerRate) + ", spotRate=" + String.valueOf(this.spotRate) + ", informationSource=" + String.valueOf(this.informationSource) + ", fxTouchSequence=" + String.valueOf(this.fxTouchSequence) + ", observationPoint=" + String.valueOf(this.observationPoint) + "}";
        }
    }
}

