/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.fx;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.fx.meta.FxStraddlePremiumMeta;
import fpml.consolidated.shared.AdjustableOrRelativeDate;
import fpml.consolidated.shared.IdentifiedCurrency;
import fpml.consolidated.shared.PayerReceiverModel;
import fpml.consolidated.shared.PaymentBaseExtended;
import fpml.consolidated.shared.SettlementInformation;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="FxStraddlePremium", builder=FxStraddlePremiumBuilderImpl.class, version="1.2.2")
@RuneDataType(value="FxStraddlePremium", model="fpml", builder=FxStraddlePremiumBuilderImpl.class, version="1.2.2")
public interface FxStraddlePremium
extends PaymentBaseExtended {
    public static final FxStraddlePremiumMeta metaData = new FxStraddlePremiumMeta();

    public IdentifiedCurrency getPaymentCurrency();

    public SettlementInformation getSettlementInformation();

    @Override
    public FxStraddlePremium build();

    @Override
    public FxStraddlePremiumBuilder toBuilder();

    public static FxStraddlePremiumBuilder builder() {
        return new FxStraddlePremiumBuilderImpl();
    }

    default public RosettaMetaData<? extends FxStraddlePremium> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxStraddlePremium> getType() {
        return FxStraddlePremium.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableOrRelativeDate.class, this.getPaymentDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentCurrency"), processor, IdentifiedCurrency.class, this.getPaymentCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementInformation"), processor, SettlementInformation.class, this.getSettlementInformation(), new AttributeMeta[0]);
    }

    public static class FxStraddlePremiumBuilderImpl
    extends PaymentBaseExtended.PaymentBaseExtendedBuilderImpl
    implements FxStraddlePremiumBuilder {
        protected IdentifiedCurrency.IdentifiedCurrencyBuilder paymentCurrency;
        protected SettlementInformation.SettlementInformationBuilder settlementInformation;

        @Override
        @RosettaAttribute(value="paymentCurrency", isRequired=true)
        @RuneAttribute(value="paymentCurrency", isRequired=true)
        public IdentifiedCurrency.IdentifiedCurrencyBuilder getPaymentCurrency() {
            return this.paymentCurrency;
        }

        @Override
        public IdentifiedCurrency.IdentifiedCurrencyBuilder getOrCreatePaymentCurrency() {
            IdentifiedCurrency.IdentifiedCurrencyBuilder result = this.paymentCurrency != null ? this.paymentCurrency : (this.paymentCurrency = IdentifiedCurrency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementInformation")
        @RuneAttribute(value="settlementInformation")
        public SettlementInformation.SettlementInformationBuilder getSettlementInformation() {
            return this.settlementInformation;
        }

        @Override
        public SettlementInformation.SettlementInformationBuilder getOrCreateSettlementInformation() {
            SettlementInformation.SettlementInformationBuilder result = this.settlementInformation != null ? this.settlementInformation : (this.settlementInformation = SettlementInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public FxStraddlePremiumBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public FxStraddlePremiumBuilder setPayerReceiverModel(PayerReceiverModel _payerReceiverModel) {
            this.payerReceiverModel = _payerReceiverModel == null ? null : _payerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentDate")
        @RuneAttribute(value="paymentDate")
        public FxStraddlePremiumBuilder setPaymentDate(AdjustableOrRelativeDate _paymentDate) {
            this.paymentDate = _paymentDate == null ? null : _paymentDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentCurrency", isRequired=true)
        @RuneAttribute(value="paymentCurrency", isRequired=true)
        public FxStraddlePremiumBuilder setPaymentCurrency(IdentifiedCurrency _paymentCurrency) {
            this.paymentCurrency = _paymentCurrency == null ? null : _paymentCurrency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementInformation")
        @RuneAttribute(value="settlementInformation")
        public FxStraddlePremiumBuilder setSettlementInformation(SettlementInformation _settlementInformation) {
            this.settlementInformation = _settlementInformation == null ? null : _settlementInformation.toBuilder();
            return this;
        }

        @Override
        public FxStraddlePremium build() {
            return new FxStraddlePremiumImpl(this);
        }

        @Override
        public FxStraddlePremiumBuilder toBuilder() {
            return this;
        }

        @Override
        public FxStraddlePremiumBuilder prune() {
            super.prune();
            if (this.paymentCurrency != null && !this.paymentCurrency.prune().hasData()) {
                this.paymentCurrency = null;
            }
            if (this.settlementInformation != null && !this.settlementInformation.prune().hasData()) {
                this.settlementInformation = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPaymentCurrency() != null && this.getPaymentCurrency().hasData()) {
                return true;
            }
            return this.getSettlementInformation() != null && this.getSettlementInformation().hasData();
        }

        @Override
        public FxStraddlePremiumBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FxStraddlePremiumBuilder o = (FxStraddlePremiumBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentCurrency(), (RosettaModelObjectBuilder)o.getPaymentCurrency(), this::setPaymentCurrency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementInformation(), (RosettaModelObjectBuilder)o.getSettlementInformation(), this::setSettlementInformation);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxStraddlePremium _that = (FxStraddlePremium)this.getType().cast(o);
            if (!Objects.equals(this.paymentCurrency, _that.getPaymentCurrency())) {
                return false;
            }
            return Objects.equals(this.settlementInformation, _that.getSettlementInformation());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.paymentCurrency != null ? this.paymentCurrency.hashCode() : 0);
            _result = 31 * _result + (this.settlementInformation != null ? this.settlementInformation.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxStraddlePremiumBuilder {paymentCurrency=" + String.valueOf(this.paymentCurrency) + ", settlementInformation=" + String.valueOf(this.settlementInformation) + "} " + super.toString();
        }
    }

    public static interface FxStraddlePremiumBuilder
    extends FxStraddlePremium,
    PaymentBaseExtended.PaymentBaseExtendedBuilder {
        public IdentifiedCurrency.IdentifiedCurrencyBuilder getOrCreatePaymentCurrency();

        @Override
        public IdentifiedCurrency.IdentifiedCurrencyBuilder getPaymentCurrency();

        public SettlementInformation.SettlementInformationBuilder getOrCreateSettlementInformation();

        @Override
        public SettlementInformation.SettlementInformationBuilder getSettlementInformation();

        @Override
        public FxStraddlePremiumBuilder setId(String var1);

        @Override
        public FxStraddlePremiumBuilder setPayerReceiverModel(PayerReceiverModel var1);

        @Override
        public FxStraddlePremiumBuilder setPaymentDate(AdjustableOrRelativeDate var1);

        public FxStraddlePremiumBuilder setPaymentCurrency(IdentifiedCurrency var1);

        public FxStraddlePremiumBuilder setSettlementInformation(SettlementInformation var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.PayerReceiverModelBuilder.class, (RosettaModelObjectBuilder)this.getPayerReceiverModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getPaymentDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentCurrency"), processor, IdentifiedCurrency.IdentifiedCurrencyBuilder.class, this.getPaymentCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementInformation"), processor, SettlementInformation.SettlementInformationBuilder.class, this.getSettlementInformation(), new AttributeMeta[0]);
        }

        @Override
        public FxStraddlePremiumBuilder prune();
    }

    public static class FxStraddlePremiumImpl
    extends PaymentBaseExtended.PaymentBaseExtendedImpl
    implements FxStraddlePremium {
        private final IdentifiedCurrency paymentCurrency;
        private final SettlementInformation settlementInformation;

        protected FxStraddlePremiumImpl(FxStraddlePremiumBuilder builder) {
            super(builder);
            this.paymentCurrency = Optional.ofNullable(builder.getPaymentCurrency()).map(f -> f.build()).orElse(null);
            this.settlementInformation = Optional.ofNullable(builder.getSettlementInformation()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="paymentCurrency", isRequired=true)
        @RuneAttribute(value="paymentCurrency", isRequired=true)
        public IdentifiedCurrency getPaymentCurrency() {
            return this.paymentCurrency;
        }

        @Override
        @RosettaAttribute(value="settlementInformation")
        @RuneAttribute(value="settlementInformation")
        public SettlementInformation getSettlementInformation() {
            return this.settlementInformation;
        }

        @Override
        public FxStraddlePremium build() {
            return this;
        }

        @Override
        public FxStraddlePremiumBuilder toBuilder() {
            FxStraddlePremiumBuilder builder = FxStraddlePremium.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxStraddlePremiumBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPaymentCurrency()).ifPresent(builder::setPaymentCurrency);
            Optional.ofNullable(this.getSettlementInformation()).ifPresent(builder::setSettlementInformation);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxStraddlePremium _that = (FxStraddlePremium)this.getType().cast(o);
            if (!Objects.equals(this.paymentCurrency, _that.getPaymentCurrency())) {
                return false;
            }
            return Objects.equals(this.settlementInformation, _that.getSettlementInformation());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.paymentCurrency != null ? this.paymentCurrency.hashCode() : 0);
            _result = 31 * _result + (this.settlementInformation != null ? this.settlementInformation.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxStraddlePremium {paymentCurrency=" + String.valueOf(this.paymentCurrency) + ", settlementInformation=" + String.valueOf(this.settlementInformation) + "} " + super.toString();
        }
    }
}

