/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.fx;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.fx.PremiumQuote;
import fpml.consolidated.fx.meta.FxOptionPremiumMeta;
import fpml.consolidated.shared.AdjustableOrRelativeDate;
import fpml.consolidated.shared.NonNegativeMoney;
import fpml.consolidated.shared.NonNegativePayment;
import fpml.consolidated.shared.PayerReceiverModel;
import fpml.consolidated.shared.SettlementInformation;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="FxOptionPremium", builder=FxOptionPremiumBuilderImpl.class, version="1.2.2")
@RuneDataType(value="FxOptionPremium", model="fpml", builder=FxOptionPremiumBuilderImpl.class, version="1.2.2")
public interface FxOptionPremium
extends NonNegativePayment {
    public static final FxOptionPremiumMeta metaData = new FxOptionPremiumMeta();

    public SettlementInformation getSettlementInformation();

    public PremiumQuote getQuote();

    @Override
    public FxOptionPremium build();

    @Override
    public FxOptionPremiumBuilder toBuilder();

    public static FxOptionPremiumBuilder builder() {
        return new FxOptionPremiumBuilderImpl();
    }

    default public RosettaMetaData<? extends FxOptionPremium> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxOptionPremium> getType() {
        return FxOptionPremium.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableOrRelativeDate.class, this.getPaymentDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentAmount"), processor, NonNegativeMoney.class, this.getPaymentAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementInformation"), processor, SettlementInformation.class, this.getSettlementInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("quote"), processor, PremiumQuote.class, this.getQuote(), new AttributeMeta[0]);
    }

    public static class FxOptionPremiumBuilderImpl
    extends NonNegativePayment.NonNegativePaymentBuilderImpl
    implements FxOptionPremiumBuilder {
        protected SettlementInformation.SettlementInformationBuilder settlementInformation;
        protected PremiumQuote.PremiumQuoteBuilder quote;

        @Override
        @RosettaAttribute(value="settlementInformation")
        @RuneAttribute(value="settlementInformation")
        public SettlementInformation.SettlementInformationBuilder getSettlementInformation() {
            return this.settlementInformation;
        }

        @Override
        public SettlementInformation.SettlementInformationBuilder getOrCreateSettlementInformation() {
            SettlementInformation.SettlementInformationBuilder result = this.settlementInformation != null ? this.settlementInformation : (this.settlementInformation = SettlementInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="quote")
        @RuneAttribute(value="quote")
        public PremiumQuote.PremiumQuoteBuilder getQuote() {
            return this.quote;
        }

        @Override
        public PremiumQuote.PremiumQuoteBuilder getOrCreateQuote() {
            PremiumQuote.PremiumQuoteBuilder result = this.quote != null ? this.quote : (this.quote = PremiumQuote.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public FxOptionPremiumBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public FxOptionPremiumBuilder setPayerReceiverModel(PayerReceiverModel _payerReceiverModel) {
            this.payerReceiverModel = _payerReceiverModel == null ? null : _payerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentDate")
        @RuneAttribute(value="paymentDate")
        public FxOptionPremiumBuilder setPaymentDate(AdjustableOrRelativeDate _paymentDate) {
            this.paymentDate = _paymentDate == null ? null : _paymentDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentAmount", isRequired=true)
        @RuneAttribute(value="paymentAmount", isRequired=true)
        public FxOptionPremiumBuilder setPaymentAmount(NonNegativeMoney _paymentAmount) {
            this.paymentAmount = _paymentAmount == null ? null : _paymentAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementInformation")
        @RuneAttribute(value="settlementInformation")
        public FxOptionPremiumBuilder setSettlementInformation(SettlementInformation _settlementInformation) {
            this.settlementInformation = _settlementInformation == null ? null : _settlementInformation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="quote")
        @RuneAttribute(value="quote")
        public FxOptionPremiumBuilder setQuote(PremiumQuote _quote) {
            this.quote = _quote == null ? null : _quote.toBuilder();
            return this;
        }

        @Override
        public FxOptionPremium build() {
            return new FxOptionPremiumImpl(this);
        }

        @Override
        public FxOptionPremiumBuilder toBuilder() {
            return this;
        }

        @Override
        public FxOptionPremiumBuilder prune() {
            super.prune();
            if (this.settlementInformation != null && !this.settlementInformation.prune().hasData()) {
                this.settlementInformation = null;
            }
            if (this.quote != null && !this.quote.prune().hasData()) {
                this.quote = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getSettlementInformation() != null && this.getSettlementInformation().hasData()) {
                return true;
            }
            return this.getQuote() != null && this.getQuote().hasData();
        }

        @Override
        public FxOptionPremiumBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FxOptionPremiumBuilder o = (FxOptionPremiumBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementInformation(), (RosettaModelObjectBuilder)o.getSettlementInformation(), this::setSettlementInformation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getQuote(), (RosettaModelObjectBuilder)o.getQuote(), this::setQuote);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxOptionPremium _that = (FxOptionPremium)this.getType().cast(o);
            if (!Objects.equals(this.settlementInformation, _that.getSettlementInformation())) {
                return false;
            }
            return Objects.equals(this.quote, _that.getQuote());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.settlementInformation != null ? this.settlementInformation.hashCode() : 0);
            _result = 31 * _result + (this.quote != null ? this.quote.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxOptionPremiumBuilder {settlementInformation=" + String.valueOf(this.settlementInformation) + ", quote=" + String.valueOf(this.quote) + "} " + super.toString();
        }
    }

    public static interface FxOptionPremiumBuilder
    extends FxOptionPremium,
    NonNegativePayment.NonNegativePaymentBuilder {
        public SettlementInformation.SettlementInformationBuilder getOrCreateSettlementInformation();

        @Override
        public SettlementInformation.SettlementInformationBuilder getSettlementInformation();

        public PremiumQuote.PremiumQuoteBuilder getOrCreateQuote();

        @Override
        public PremiumQuote.PremiumQuoteBuilder getQuote();

        @Override
        public FxOptionPremiumBuilder setId(String var1);

        @Override
        public FxOptionPremiumBuilder setPayerReceiverModel(PayerReceiverModel var1);

        @Override
        public FxOptionPremiumBuilder setPaymentDate(AdjustableOrRelativeDate var1);

        @Override
        public FxOptionPremiumBuilder setPaymentAmount(NonNegativeMoney var1);

        public FxOptionPremiumBuilder setSettlementInformation(SettlementInformation var1);

        public FxOptionPremiumBuilder setQuote(PremiumQuote var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.PayerReceiverModelBuilder.class, (RosettaModelObjectBuilder)this.getPayerReceiverModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getPaymentDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentAmount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, (RosettaModelObjectBuilder)this.getPaymentAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementInformation"), processor, SettlementInformation.SettlementInformationBuilder.class, this.getSettlementInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("quote"), processor, PremiumQuote.PremiumQuoteBuilder.class, this.getQuote(), new AttributeMeta[0]);
        }

        @Override
        public FxOptionPremiumBuilder prune();
    }

    public static class FxOptionPremiumImpl
    extends NonNegativePayment.NonNegativePaymentImpl
    implements FxOptionPremium {
        private final SettlementInformation settlementInformation;
        private final PremiumQuote quote;

        protected FxOptionPremiumImpl(FxOptionPremiumBuilder builder) {
            super(builder);
            this.settlementInformation = Optional.ofNullable(builder.getSettlementInformation()).map(f -> f.build()).orElse(null);
            this.quote = Optional.ofNullable(builder.getQuote()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="settlementInformation")
        @RuneAttribute(value="settlementInformation")
        public SettlementInformation getSettlementInformation() {
            return this.settlementInformation;
        }

        @Override
        @RosettaAttribute(value="quote")
        @RuneAttribute(value="quote")
        public PremiumQuote getQuote() {
            return this.quote;
        }

        @Override
        public FxOptionPremium build() {
            return this;
        }

        @Override
        public FxOptionPremiumBuilder toBuilder() {
            FxOptionPremiumBuilder builder = FxOptionPremium.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxOptionPremiumBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getSettlementInformation()).ifPresent(builder::setSettlementInformation);
            Optional.ofNullable(this.getQuote()).ifPresent(builder::setQuote);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxOptionPremium _that = (FxOptionPremium)this.getType().cast(o);
            if (!Objects.equals(this.settlementInformation, _that.getSettlementInformation())) {
                return false;
            }
            return Objects.equals(this.quote, _that.getQuote());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.settlementInformation != null ? this.settlementInformation.hashCode() : 0);
            _result = 31 * _result + (this.quote != null ? this.quote.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxOptionPremium {settlementInformation=" + String.valueOf(this.settlementInformation) + ", quote=" + String.valueOf(this.quote) + "} " + super.toString();
        }
    }
}

