/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.fx;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.fpmlenum.DealtCurrencyEnum;
import fpml.consolidated.fx.ExchangeRate;
import fpml.consolidated.fx.FxCoreDetailsModelSequence;
import fpml.consolidated.fx.FxDisruption;
import fpml.consolidated.fx.FxTenorModel;
import fpml.consolidated.fx.meta.FxCoreDetailsModelMeta;
import fpml.consolidated.shared.FxCashSettlement;
import fpml.consolidated.shared.Payment;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FxCoreDetailsModel", builder=FxCoreDetailsModelBuilderImpl.class, version="1.2.2")
@RuneDataType(value="FxCoreDetailsModel", model="fpml", builder=FxCoreDetailsModelBuilderImpl.class, version="1.2.2")
public interface FxCoreDetailsModel
extends RosettaModelObject {
    public static final FxCoreDetailsModelMeta metaData = new FxCoreDetailsModelMeta();

    public Payment getExchangedCurrency1();

    public Payment getExchangedCurrency2();

    public DealtCurrencyEnum getDealtCurrency();

    public FxTenorModel getFxTenorModel();

    public ZonedDateTime getValueDate();

    public FxCoreDetailsModelSequence getFxCoreDetailsModelSequence();

    public ExchangeRate getExchangeRate();

    public FxCashSettlement getNonDeliverableSettlement();

    public List<? extends FxDisruption> getDisruption();

    public FxCoreDetailsModel build();

    public FxCoreDetailsModelBuilder toBuilder();

    public static FxCoreDetailsModelBuilder builder() {
        return new FxCoreDetailsModelBuilderImpl();
    }

    default public RosettaMetaData<? extends FxCoreDetailsModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxCoreDetailsModel> getType() {
        return FxCoreDetailsModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("exchangedCurrency1"), processor, Payment.class, this.getExchangedCurrency1(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangedCurrency2"), processor, Payment.class, this.getExchangedCurrency2(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("dealtCurrency"), DealtCurrencyEnum.class, (Object)this.getDealtCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxTenorModel"), processor, FxTenorModel.class, this.getFxTenorModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valueDate"), ZonedDateTime.class, (Object)this.getValueDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxCoreDetailsModelSequence"), processor, FxCoreDetailsModelSequence.class, this.getFxCoreDetailsModelSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeRate"), processor, ExchangeRate.class, this.getExchangeRate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("nonDeliverableSettlement"), processor, FxCashSettlement.class, this.getNonDeliverableSettlement(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("disruption"), processor, FxDisruption.class, this.getDisruption(), new AttributeMeta[0]);
    }

    public static class FxCoreDetailsModelBuilderImpl
    implements FxCoreDetailsModelBuilder {
        protected Payment.PaymentBuilder exchangedCurrency1;
        protected Payment.PaymentBuilder exchangedCurrency2;
        protected DealtCurrencyEnum dealtCurrency;
        protected FxTenorModel.FxTenorModelBuilder fxTenorModel;
        protected ZonedDateTime valueDate;
        protected FxCoreDetailsModelSequence.FxCoreDetailsModelSequenceBuilder fxCoreDetailsModelSequence;
        protected ExchangeRate.ExchangeRateBuilder exchangeRate;
        protected FxCashSettlement.FxCashSettlementBuilder nonDeliverableSettlement;
        protected List<FxDisruption.FxDisruptionBuilder> disruption = new ArrayList<FxDisruption.FxDisruptionBuilder>();

        @Override
        @RosettaAttribute(value="exchangedCurrency1", isRequired=true)
        @RuneAttribute(value="exchangedCurrency1", isRequired=true)
        public Payment.PaymentBuilder getExchangedCurrency1() {
            return this.exchangedCurrency1;
        }

        @Override
        public Payment.PaymentBuilder getOrCreateExchangedCurrency1() {
            Payment.PaymentBuilder result = this.exchangedCurrency1 != null ? this.exchangedCurrency1 : (this.exchangedCurrency1 = Payment.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exchangedCurrency2", isRequired=true)
        @RuneAttribute(value="exchangedCurrency2", isRequired=true)
        public Payment.PaymentBuilder getExchangedCurrency2() {
            return this.exchangedCurrency2;
        }

        @Override
        public Payment.PaymentBuilder getOrCreateExchangedCurrency2() {
            Payment.PaymentBuilder result = this.exchangedCurrency2 != null ? this.exchangedCurrency2 : (this.exchangedCurrency2 = Payment.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dealtCurrency")
        @RuneAttribute(value="dealtCurrency")
        public DealtCurrencyEnum getDealtCurrency() {
            return this.dealtCurrency;
        }

        @Override
        @RosettaAttribute(value="fxTenorModel")
        @RuneAttribute(value="fxTenorModel")
        public FxTenorModel.FxTenorModelBuilder getFxTenorModel() {
            return this.fxTenorModel;
        }

        @Override
        public FxTenorModel.FxTenorModelBuilder getOrCreateFxTenorModel() {
            FxTenorModel.FxTenorModelBuilder result = this.fxTenorModel != null ? this.fxTenorModel : (this.fxTenorModel = FxTenorModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="valueDate")
        @RuneAttribute(value="valueDate")
        public ZonedDateTime getValueDate() {
            return this.valueDate;
        }

        @Override
        @RosettaAttribute(value="fxCoreDetailsModelSequence")
        @RuneAttribute(value="fxCoreDetailsModelSequence")
        public FxCoreDetailsModelSequence.FxCoreDetailsModelSequenceBuilder getFxCoreDetailsModelSequence() {
            return this.fxCoreDetailsModelSequence;
        }

        @Override
        public FxCoreDetailsModelSequence.FxCoreDetailsModelSequenceBuilder getOrCreateFxCoreDetailsModelSequence() {
            FxCoreDetailsModelSequence.FxCoreDetailsModelSequenceBuilder result = this.fxCoreDetailsModelSequence != null ? this.fxCoreDetailsModelSequence : (this.fxCoreDetailsModelSequence = FxCoreDetailsModelSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exchangeRate")
        @RuneAttribute(value="exchangeRate")
        public ExchangeRate.ExchangeRateBuilder getExchangeRate() {
            return this.exchangeRate;
        }

        @Override
        public ExchangeRate.ExchangeRateBuilder getOrCreateExchangeRate() {
            ExchangeRate.ExchangeRateBuilder result = this.exchangeRate != null ? this.exchangeRate : (this.exchangeRate = ExchangeRate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="nonDeliverableSettlement")
        @RuneAttribute(value="nonDeliverableSettlement")
        public FxCashSettlement.FxCashSettlementBuilder getNonDeliverableSettlement() {
            return this.nonDeliverableSettlement;
        }

        @Override
        public FxCashSettlement.FxCashSettlementBuilder getOrCreateNonDeliverableSettlement() {
            FxCashSettlement.FxCashSettlementBuilder result = this.nonDeliverableSettlement != null ? this.nonDeliverableSettlement : (this.nonDeliverableSettlement = FxCashSettlement.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="disruption")
        @RuneAttribute(value="disruption")
        public List<? extends FxDisruption.FxDisruptionBuilder> getDisruption() {
            return this.disruption;
        }

        @Override
        public FxDisruption.FxDisruptionBuilder getOrCreateDisruption(int index) {
            if (this.disruption == null) {
                this.disruption = new ArrayList<FxDisruption.FxDisruptionBuilder>();
            }
            return (FxDisruption.FxDisruptionBuilder)this.getIndex(this.disruption, index, () -> {
                FxDisruption.FxDisruptionBuilder newDisruption = FxDisruption.builder();
                return newDisruption;
            });
        }

        @Override
        @RosettaAttribute(value="exchangedCurrency1", isRequired=true)
        @RuneAttribute(value="exchangedCurrency1", isRequired=true)
        public FxCoreDetailsModelBuilder setExchangedCurrency1(Payment _exchangedCurrency1) {
            this.exchangedCurrency1 = _exchangedCurrency1 == null ? null : _exchangedCurrency1.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangedCurrency2", isRequired=true)
        @RuneAttribute(value="exchangedCurrency2", isRequired=true)
        public FxCoreDetailsModelBuilder setExchangedCurrency2(Payment _exchangedCurrency2) {
            this.exchangedCurrency2 = _exchangedCurrency2 == null ? null : _exchangedCurrency2.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dealtCurrency")
        @RuneAttribute(value="dealtCurrency")
        public FxCoreDetailsModelBuilder setDealtCurrency(DealtCurrencyEnum _dealtCurrency) {
            this.dealtCurrency = _dealtCurrency == null ? null : _dealtCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="fxTenorModel")
        @RuneAttribute(value="fxTenorModel")
        public FxCoreDetailsModelBuilder setFxTenorModel(FxTenorModel _fxTenorModel) {
            this.fxTenorModel = _fxTenorModel == null ? null : _fxTenorModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="valueDate")
        @RuneAttribute(value="valueDate")
        public FxCoreDetailsModelBuilder setValueDate(ZonedDateTime _valueDate) {
            this.valueDate = _valueDate == null ? null : _valueDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="fxCoreDetailsModelSequence")
        @RuneAttribute(value="fxCoreDetailsModelSequence")
        public FxCoreDetailsModelBuilder setFxCoreDetailsModelSequence(FxCoreDetailsModelSequence _fxCoreDetailsModelSequence) {
            this.fxCoreDetailsModelSequence = _fxCoreDetailsModelSequence == null ? null : _fxCoreDetailsModelSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeRate")
        @RuneAttribute(value="exchangeRate")
        public FxCoreDetailsModelBuilder setExchangeRate(ExchangeRate _exchangeRate) {
            this.exchangeRate = _exchangeRate == null ? null : _exchangeRate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="nonDeliverableSettlement")
        @RuneAttribute(value="nonDeliverableSettlement")
        public FxCoreDetailsModelBuilder setNonDeliverableSettlement(FxCashSettlement _nonDeliverableSettlement) {
            this.nonDeliverableSettlement = _nonDeliverableSettlement == null ? null : _nonDeliverableSettlement.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="disruption")
        @RuneAttribute(value="disruption")
        public FxCoreDetailsModelBuilder addDisruption(FxDisruption _disruption) {
            if (_disruption != null) {
                this.disruption.add(_disruption.toBuilder());
            }
            return this;
        }

        @Override
        public FxCoreDetailsModelBuilder addDisruption(FxDisruption _disruption, int idx) {
            this.getIndex(this.disruption, idx, () -> _disruption.toBuilder());
            return this;
        }

        @Override
        public FxCoreDetailsModelBuilder addDisruption(List<? extends FxDisruption> disruptions) {
            if (disruptions != null) {
                for (FxDisruption fxDisruption : disruptions) {
                    this.disruption.add(fxDisruption.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="disruption")
        public FxCoreDetailsModelBuilder setDisruption(List<? extends FxDisruption> disruptions) {
            this.disruption = disruptions == null ? new ArrayList<FxDisruption.FxDisruptionBuilder>() : (List)disruptions.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public FxCoreDetailsModel build() {
            return new FxCoreDetailsModelImpl(this);
        }

        @Override
        public FxCoreDetailsModelBuilder toBuilder() {
            return this;
        }

        @Override
        public FxCoreDetailsModelBuilder prune() {
            if (this.exchangedCurrency1 != null && !this.exchangedCurrency1.prune().hasData()) {
                this.exchangedCurrency1 = null;
            }
            if (this.exchangedCurrency2 != null && !this.exchangedCurrency2.prune().hasData()) {
                this.exchangedCurrency2 = null;
            }
            if (this.fxTenorModel != null && !this.fxTenorModel.prune().hasData()) {
                this.fxTenorModel = null;
            }
            if (this.fxCoreDetailsModelSequence != null && !this.fxCoreDetailsModelSequence.prune().hasData()) {
                this.fxCoreDetailsModelSequence = null;
            }
            if (this.exchangeRate != null && !this.exchangeRate.prune().hasData()) {
                this.exchangeRate = null;
            }
            if (this.nonDeliverableSettlement != null && !this.nonDeliverableSettlement.prune().hasData()) {
                this.nonDeliverableSettlement = null;
            }
            this.disruption = this.disruption.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getExchangedCurrency1() != null && this.getExchangedCurrency1().hasData()) {
                return true;
            }
            if (this.getExchangedCurrency2() != null && this.getExchangedCurrency2().hasData()) {
                return true;
            }
            if (this.getDealtCurrency() != null) {
                return true;
            }
            if (this.getFxTenorModel() != null && this.getFxTenorModel().hasData()) {
                return true;
            }
            if (this.getValueDate() != null) {
                return true;
            }
            if (this.getFxCoreDetailsModelSequence() != null && this.getFxCoreDetailsModelSequence().hasData()) {
                return true;
            }
            if (this.getExchangeRate() != null && this.getExchangeRate().hasData()) {
                return true;
            }
            if (this.getNonDeliverableSettlement() != null && this.getNonDeliverableSettlement().hasData()) {
                return true;
            }
            return this.getDisruption() != null && this.getDisruption().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public FxCoreDetailsModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FxCoreDetailsModelBuilder o = (FxCoreDetailsModelBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExchangedCurrency1(), (RosettaModelObjectBuilder)o.getExchangedCurrency1(), this::setExchangedCurrency1);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExchangedCurrency2(), (RosettaModelObjectBuilder)o.getExchangedCurrency2(), this::setExchangedCurrency2);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxTenorModel(), (RosettaModelObjectBuilder)o.getFxTenorModel(), this::setFxTenorModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxCoreDetailsModelSequence(), (RosettaModelObjectBuilder)o.getFxCoreDetailsModelSequence(), this::setFxCoreDetailsModelSequence);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExchangeRate(), (RosettaModelObjectBuilder)o.getExchangeRate(), this::setExchangeRate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNonDeliverableSettlement(), (RosettaModelObjectBuilder)o.getNonDeliverableSettlement(), this::setNonDeliverableSettlement);
            merger.mergeRosetta(this.getDisruption(), o.getDisruption(), this::getOrCreateDisruption);
            merger.mergeBasic((Object)this.getDealtCurrency(), (Object)o.getDealtCurrency(), this::setDealtCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValueDate(), (Object)o.getValueDate(), this::setValueDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxCoreDetailsModel _that = this.getType().cast(o);
            if (!Objects.equals(this.exchangedCurrency1, _that.getExchangedCurrency1())) {
                return false;
            }
            if (!Objects.equals(this.exchangedCurrency2, _that.getExchangedCurrency2())) {
                return false;
            }
            if (!Objects.equals((Object)this.dealtCurrency, (Object)_that.getDealtCurrency())) {
                return false;
            }
            if (!Objects.equals(this.fxTenorModel, _that.getFxTenorModel())) {
                return false;
            }
            if (!Objects.equals(this.valueDate, _that.getValueDate())) {
                return false;
            }
            if (!Objects.equals(this.fxCoreDetailsModelSequence, _that.getFxCoreDetailsModelSequence())) {
                return false;
            }
            if (!Objects.equals(this.exchangeRate, _that.getExchangeRate())) {
                return false;
            }
            if (!Objects.equals(this.nonDeliverableSettlement, _that.getNonDeliverableSettlement())) {
                return false;
            }
            return ListEquals.listEquals(this.disruption, _that.getDisruption());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.exchangedCurrency1 != null ? this.exchangedCurrency1.hashCode() : 0);
            _result = 31 * _result + (this.exchangedCurrency2 != null ? this.exchangedCurrency2.hashCode() : 0);
            _result = 31 * _result + (this.dealtCurrency != null ? ((Object)((Object)this.dealtCurrency)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.fxTenorModel != null ? this.fxTenorModel.hashCode() : 0);
            _result = 31 * _result + (this.valueDate != null ? this.valueDate.hashCode() : 0);
            _result = 31 * _result + (this.fxCoreDetailsModelSequence != null ? this.fxCoreDetailsModelSequence.hashCode() : 0);
            _result = 31 * _result + (this.exchangeRate != null ? this.exchangeRate.hashCode() : 0);
            _result = 31 * _result + (this.nonDeliverableSettlement != null ? this.nonDeliverableSettlement.hashCode() : 0);
            _result = 31 * _result + (this.disruption != null ? this.disruption.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxCoreDetailsModelBuilder {exchangedCurrency1=" + String.valueOf(this.exchangedCurrency1) + ", exchangedCurrency2=" + String.valueOf(this.exchangedCurrency2) + ", dealtCurrency=" + String.valueOf((Object)this.dealtCurrency) + ", fxTenorModel=" + String.valueOf(this.fxTenorModel) + ", valueDate=" + String.valueOf(this.valueDate) + ", fxCoreDetailsModelSequence=" + String.valueOf(this.fxCoreDetailsModelSequence) + ", exchangeRate=" + String.valueOf(this.exchangeRate) + ", nonDeliverableSettlement=" + String.valueOf(this.nonDeliverableSettlement) + ", disruption=" + String.valueOf(this.disruption) + "}";
        }
    }

    public static interface FxCoreDetailsModelBuilder
    extends FxCoreDetailsModel,
    RosettaModelObjectBuilder {
        public Payment.PaymentBuilder getOrCreateExchangedCurrency1();

        @Override
        public Payment.PaymentBuilder getExchangedCurrency1();

        public Payment.PaymentBuilder getOrCreateExchangedCurrency2();

        @Override
        public Payment.PaymentBuilder getExchangedCurrency2();

        public FxTenorModel.FxTenorModelBuilder getOrCreateFxTenorModel();

        @Override
        public FxTenorModel.FxTenorModelBuilder getFxTenorModel();

        public FxCoreDetailsModelSequence.FxCoreDetailsModelSequenceBuilder getOrCreateFxCoreDetailsModelSequence();

        @Override
        public FxCoreDetailsModelSequence.FxCoreDetailsModelSequenceBuilder getFxCoreDetailsModelSequence();

        public ExchangeRate.ExchangeRateBuilder getOrCreateExchangeRate();

        @Override
        public ExchangeRate.ExchangeRateBuilder getExchangeRate();

        public FxCashSettlement.FxCashSettlementBuilder getOrCreateNonDeliverableSettlement();

        @Override
        public FxCashSettlement.FxCashSettlementBuilder getNonDeliverableSettlement();

        public FxDisruption.FxDisruptionBuilder getOrCreateDisruption(int var1);

        public List<? extends FxDisruption.FxDisruptionBuilder> getDisruption();

        public FxCoreDetailsModelBuilder setExchangedCurrency1(Payment var1);

        public FxCoreDetailsModelBuilder setExchangedCurrency2(Payment var1);

        public FxCoreDetailsModelBuilder setDealtCurrency(DealtCurrencyEnum var1);

        public FxCoreDetailsModelBuilder setFxTenorModel(FxTenorModel var1);

        public FxCoreDetailsModelBuilder setValueDate(ZonedDateTime var1);

        public FxCoreDetailsModelBuilder setFxCoreDetailsModelSequence(FxCoreDetailsModelSequence var1);

        public FxCoreDetailsModelBuilder setExchangeRate(ExchangeRate var1);

        public FxCoreDetailsModelBuilder setNonDeliverableSettlement(FxCashSettlement var1);

        public FxCoreDetailsModelBuilder addDisruption(FxDisruption var1);

        public FxCoreDetailsModelBuilder addDisruption(FxDisruption var1, int var2);

        public FxCoreDetailsModelBuilder addDisruption(List<? extends FxDisruption> var1);

        public FxCoreDetailsModelBuilder setDisruption(List<? extends FxDisruption> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("exchangedCurrency1"), processor, Payment.PaymentBuilder.class, this.getExchangedCurrency1(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangedCurrency2"), processor, Payment.PaymentBuilder.class, this.getExchangedCurrency2(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("dealtCurrency"), DealtCurrencyEnum.class, (Object)this.getDealtCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxTenorModel"), processor, FxTenorModel.FxTenorModelBuilder.class, this.getFxTenorModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valueDate"), ZonedDateTime.class, (Object)this.getValueDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxCoreDetailsModelSequence"), processor, FxCoreDetailsModelSequence.FxCoreDetailsModelSequenceBuilder.class, this.getFxCoreDetailsModelSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeRate"), processor, ExchangeRate.ExchangeRateBuilder.class, this.getExchangeRate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("nonDeliverableSettlement"), processor, FxCashSettlement.FxCashSettlementBuilder.class, this.getNonDeliverableSettlement(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("disruption"), processor, FxDisruption.FxDisruptionBuilder.class, this.getDisruption(), new AttributeMeta[0]);
        }

        public FxCoreDetailsModelBuilder prune();
    }

    public static class FxCoreDetailsModelImpl
    implements FxCoreDetailsModel {
        private final Payment exchangedCurrency1;
        private final Payment exchangedCurrency2;
        private final DealtCurrencyEnum dealtCurrency;
        private final FxTenorModel fxTenorModel;
        private final ZonedDateTime valueDate;
        private final FxCoreDetailsModelSequence fxCoreDetailsModelSequence;
        private final ExchangeRate exchangeRate;
        private final FxCashSettlement nonDeliverableSettlement;
        private final List<? extends FxDisruption> disruption;

        protected FxCoreDetailsModelImpl(FxCoreDetailsModelBuilder builder) {
            this.exchangedCurrency1 = Optional.ofNullable(builder.getExchangedCurrency1()).map(f -> f.build()).orElse(null);
            this.exchangedCurrency2 = Optional.ofNullable(builder.getExchangedCurrency2()).map(f -> f.build()).orElse(null);
            this.dealtCurrency = builder.getDealtCurrency();
            this.fxTenorModel = Optional.ofNullable(builder.getFxTenorModel()).map(f -> f.build()).orElse(null);
            this.valueDate = builder.getValueDate();
            this.fxCoreDetailsModelSequence = Optional.ofNullable(builder.getFxCoreDetailsModelSequence()).map(f -> f.build()).orElse(null);
            this.exchangeRate = Optional.ofNullable(builder.getExchangeRate()).map(f -> f.build()).orElse(null);
            this.nonDeliverableSettlement = Optional.ofNullable(builder.getNonDeliverableSettlement()).map(f -> f.build()).orElse(null);
            this.disruption = Optional.ofNullable(builder.getDisruption()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="exchangedCurrency1", isRequired=true)
        @RuneAttribute(value="exchangedCurrency1", isRequired=true)
        public Payment getExchangedCurrency1() {
            return this.exchangedCurrency1;
        }

        @Override
        @RosettaAttribute(value="exchangedCurrency2", isRequired=true)
        @RuneAttribute(value="exchangedCurrency2", isRequired=true)
        public Payment getExchangedCurrency2() {
            return this.exchangedCurrency2;
        }

        @Override
        @RosettaAttribute(value="dealtCurrency")
        @RuneAttribute(value="dealtCurrency")
        public DealtCurrencyEnum getDealtCurrency() {
            return this.dealtCurrency;
        }

        @Override
        @RosettaAttribute(value="fxTenorModel")
        @RuneAttribute(value="fxTenorModel")
        public FxTenorModel getFxTenorModel() {
            return this.fxTenorModel;
        }

        @Override
        @RosettaAttribute(value="valueDate")
        @RuneAttribute(value="valueDate")
        public ZonedDateTime getValueDate() {
            return this.valueDate;
        }

        @Override
        @RosettaAttribute(value="fxCoreDetailsModelSequence")
        @RuneAttribute(value="fxCoreDetailsModelSequence")
        public FxCoreDetailsModelSequence getFxCoreDetailsModelSequence() {
            return this.fxCoreDetailsModelSequence;
        }

        @Override
        @RosettaAttribute(value="exchangeRate")
        @RuneAttribute(value="exchangeRate")
        public ExchangeRate getExchangeRate() {
            return this.exchangeRate;
        }

        @Override
        @RosettaAttribute(value="nonDeliverableSettlement")
        @RuneAttribute(value="nonDeliverableSettlement")
        public FxCashSettlement getNonDeliverableSettlement() {
            return this.nonDeliverableSettlement;
        }

        @Override
        @RosettaAttribute(value="disruption")
        @RuneAttribute(value="disruption")
        public List<? extends FxDisruption> getDisruption() {
            return this.disruption;
        }

        @Override
        public FxCoreDetailsModel build() {
            return this;
        }

        @Override
        public FxCoreDetailsModelBuilder toBuilder() {
            FxCoreDetailsModelBuilder builder = FxCoreDetailsModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxCoreDetailsModelBuilder builder) {
            Optional.ofNullable(this.getExchangedCurrency1()).ifPresent(builder::setExchangedCurrency1);
            Optional.ofNullable(this.getExchangedCurrency2()).ifPresent(builder::setExchangedCurrency2);
            Optional.ofNullable(this.getDealtCurrency()).ifPresent(builder::setDealtCurrency);
            Optional.ofNullable(this.getFxTenorModel()).ifPresent(builder::setFxTenorModel);
            Optional.ofNullable(this.getValueDate()).ifPresent(builder::setValueDate);
            Optional.ofNullable(this.getFxCoreDetailsModelSequence()).ifPresent(builder::setFxCoreDetailsModelSequence);
            Optional.ofNullable(this.getExchangeRate()).ifPresent(builder::setExchangeRate);
            Optional.ofNullable(this.getNonDeliverableSettlement()).ifPresent(builder::setNonDeliverableSettlement);
            Optional.ofNullable(this.getDisruption()).ifPresent(builder::setDisruption);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxCoreDetailsModel _that = this.getType().cast(o);
            if (!Objects.equals(this.exchangedCurrency1, _that.getExchangedCurrency1())) {
                return false;
            }
            if (!Objects.equals(this.exchangedCurrency2, _that.getExchangedCurrency2())) {
                return false;
            }
            if (!Objects.equals((Object)this.dealtCurrency, (Object)_that.getDealtCurrency())) {
                return false;
            }
            if (!Objects.equals(this.fxTenorModel, _that.getFxTenorModel())) {
                return false;
            }
            if (!Objects.equals(this.valueDate, _that.getValueDate())) {
                return false;
            }
            if (!Objects.equals(this.fxCoreDetailsModelSequence, _that.getFxCoreDetailsModelSequence())) {
                return false;
            }
            if (!Objects.equals(this.exchangeRate, _that.getExchangeRate())) {
                return false;
            }
            if (!Objects.equals(this.nonDeliverableSettlement, _that.getNonDeliverableSettlement())) {
                return false;
            }
            return ListEquals.listEquals(this.disruption, _that.getDisruption());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.exchangedCurrency1 != null ? this.exchangedCurrency1.hashCode() : 0);
            _result = 31 * _result + (this.exchangedCurrency2 != null ? this.exchangedCurrency2.hashCode() : 0);
            _result = 31 * _result + (this.dealtCurrency != null ? ((Object)((Object)this.dealtCurrency)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.fxTenorModel != null ? this.fxTenorModel.hashCode() : 0);
            _result = 31 * _result + (this.valueDate != null ? this.valueDate.hashCode() : 0);
            _result = 31 * _result + (this.fxCoreDetailsModelSequence != null ? this.fxCoreDetailsModelSequence.hashCode() : 0);
            _result = 31 * _result + (this.exchangeRate != null ? this.exchangeRate.hashCode() : 0);
            _result = 31 * _result + (this.nonDeliverableSettlement != null ? this.nonDeliverableSettlement.hashCode() : 0);
            _result = 31 * _result + (this.disruption != null ? this.disruption.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxCoreDetailsModel {exchangedCurrency1=" + String.valueOf(this.exchangedCurrency1) + ", exchangedCurrency2=" + String.valueOf(this.exchangedCurrency2) + ", dealtCurrency=" + String.valueOf((Object)this.dealtCurrency) + ", fxTenorModel=" + String.valueOf(this.fxTenorModel) + ", valueDate=" + String.valueOf(this.valueDate) + ", fxCoreDetailsModelSequence=" + String.valueOf(this.fxCoreDetailsModelSequence) + ", exchangeRate=" + String.valueOf(this.exchangeRate) + ", nonDeliverableSettlement=" + String.valueOf(this.nonDeliverableSettlement) + ", disruption=" + String.valueOf(this.disruption) + "}";
        }
    }
}

