/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.eqd;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.Underlyer;
import fpml.consolidated.eq.shared.FeatureModel;
import fpml.consolidated.eqd.EquityExerciseValuationSettlement;
import fpml.consolidated.eqd.meta.EquityDerivativeBaseMeta;
import fpml.consolidated.fpmlenum.EquityOptionTypeEnum;
import fpml.consolidated.option.shared.StrategyFeature;
import fpml.consolidated.shared.BuyerSellerModel;
import fpml.consolidated.shared.NonNegativeMoney;
import fpml.consolidated.shared.Product;
import fpml.consolidated.shared.ProductModel;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="EquityDerivativeBase", builder=EquityDerivativeBaseBuilderImpl.class, version="1.2.2")
@RuneDataType(value="EquityDerivativeBase", model="fpml", builder=EquityDerivativeBaseBuilderImpl.class, version="1.2.2")
public interface EquityDerivativeBase
extends Product {
    public static final EquityDerivativeBaseMeta metaData = new EquityDerivativeBaseMeta();

    public BuyerSellerModel getBuyerSellerModel();

    public EquityOptionTypeEnum getOptionType();

    public ZonedDateTime getEquityEffectiveDate();

    public Underlyer getUnderlyer();

    public NonNegativeMoney getNotional();

    public EquityExerciseValuationSettlement getEquityExercise();

    public FeatureModel getFeatureModel();

    public StrategyFeature getStrategyFeature();

    @Override
    public EquityDerivativeBase build();

    @Override
    public EquityDerivativeBaseBuilder toBuilder();

    public static EquityDerivativeBaseBuilder builder() {
        return new EquityDerivativeBaseBuilderImpl();
    }

    default public RosettaMetaData<? extends EquityDerivativeBase> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends EquityDerivativeBase> getType() {
        return EquityDerivativeBase.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionType"), EquityOptionTypeEnum.class, (Object)this.getOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("equityEffectiveDate"), ZonedDateTime.class, (Object)this.getEquityEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyer"), processor, Underlyer.class, this.getUnderlyer(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notional"), processor, NonNegativeMoney.class, this.getNotional(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("equityExercise"), processor, EquityExerciseValuationSettlement.class, this.getEquityExercise(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("featureModel"), processor, FeatureModel.class, this.getFeatureModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strategyFeature"), processor, StrategyFeature.class, this.getStrategyFeature(), new AttributeMeta[0]);
    }

    public static class EquityDerivativeBaseBuilderImpl
    extends Product.ProductBuilderImpl
    implements EquityDerivativeBaseBuilder {
        protected BuyerSellerModel.BuyerSellerModelBuilder buyerSellerModel;
        protected EquityOptionTypeEnum optionType;
        protected ZonedDateTime equityEffectiveDate;
        protected Underlyer.UnderlyerBuilder underlyer;
        protected NonNegativeMoney.NonNegativeMoneyBuilder notional;
        protected EquityExerciseValuationSettlement.EquityExerciseValuationSettlementBuilder equityExercise;
        protected FeatureModel.FeatureModelBuilder featureModel;
        protected StrategyFeature.StrategyFeatureBuilder strategyFeature;

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public BuyerSellerModel.BuyerSellerModelBuilder getBuyerSellerModel() {
            return this.buyerSellerModel;
        }

        @Override
        public BuyerSellerModel.BuyerSellerModelBuilder getOrCreateBuyerSellerModel() {
            BuyerSellerModel.BuyerSellerModelBuilder result = this.buyerSellerModel != null ? this.buyerSellerModel : (this.buyerSellerModel = BuyerSellerModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public EquityOptionTypeEnum getOptionType() {
            return this.optionType;
        }

        @Override
        @RosettaAttribute(value="equityEffectiveDate")
        @RuneAttribute(value="equityEffectiveDate")
        public ZonedDateTime getEquityEffectiveDate() {
            return this.equityEffectiveDate;
        }

        @Override
        @RosettaAttribute(value="underlyer", isRequired=true)
        @RuneAttribute(value="underlyer", isRequired=true)
        public Underlyer.UnderlyerBuilder getUnderlyer() {
            return this.underlyer;
        }

        @Override
        public Underlyer.UnderlyerBuilder getOrCreateUnderlyer() {
            Underlyer.UnderlyerBuilder result = this.underlyer != null ? this.underlyer : (this.underlyer = Underlyer.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="notional")
        @RuneAttribute(value="notional")
        public NonNegativeMoney.NonNegativeMoneyBuilder getNotional() {
            return this.notional;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateNotional() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.notional != null ? this.notional : (this.notional = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="equityExercise", isRequired=true)
        @RuneAttribute(value="equityExercise", isRequired=true)
        public EquityExerciseValuationSettlement.EquityExerciseValuationSettlementBuilder getEquityExercise() {
            return this.equityExercise;
        }

        @Override
        public EquityExerciseValuationSettlement.EquityExerciseValuationSettlementBuilder getOrCreateEquityExercise() {
            EquityExerciseValuationSettlement.EquityExerciseValuationSettlementBuilder result = this.equityExercise != null ? this.equityExercise : (this.equityExercise = EquityExerciseValuationSettlement.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="featureModel")
        @RuneAttribute(value="featureModel")
        public FeatureModel.FeatureModelBuilder getFeatureModel() {
            return this.featureModel;
        }

        @Override
        public FeatureModel.FeatureModelBuilder getOrCreateFeatureModel() {
            FeatureModel.FeatureModelBuilder result = this.featureModel != null ? this.featureModel : (this.featureModel = FeatureModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="strategyFeature")
        @RuneAttribute(value="strategyFeature")
        public StrategyFeature.StrategyFeatureBuilder getStrategyFeature() {
            return this.strategyFeature;
        }

        @Override
        public StrategyFeature.StrategyFeatureBuilder getOrCreateStrategyFeature() {
            StrategyFeature.StrategyFeatureBuilder result = this.strategyFeature != null ? this.strategyFeature : (this.strategyFeature = StrategyFeature.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public EquityDerivativeBaseBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public EquityDerivativeBaseBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public EquityDerivativeBaseBuilder setBuyerSellerModel(BuyerSellerModel _buyerSellerModel) {
            this.buyerSellerModel = _buyerSellerModel == null ? null : _buyerSellerModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public EquityDerivativeBaseBuilder setOptionType(EquityOptionTypeEnum _optionType) {
            this.optionType = _optionType == null ? null : _optionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="equityEffectiveDate")
        @RuneAttribute(value="equityEffectiveDate")
        public EquityDerivativeBaseBuilder setEquityEffectiveDate(ZonedDateTime _equityEffectiveDate) {
            this.equityEffectiveDate = _equityEffectiveDate == null ? null : _equityEffectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyer", isRequired=true)
        @RuneAttribute(value="underlyer", isRequired=true)
        public EquityDerivativeBaseBuilder setUnderlyer(Underlyer _underlyer) {
            this.underlyer = _underlyer == null ? null : _underlyer.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="notional")
        @RuneAttribute(value="notional")
        public EquityDerivativeBaseBuilder setNotional(NonNegativeMoney _notional) {
            this.notional = _notional == null ? null : _notional.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="equityExercise", isRequired=true)
        @RuneAttribute(value="equityExercise", isRequired=true)
        public EquityDerivativeBaseBuilder setEquityExercise(EquityExerciseValuationSettlement _equityExercise) {
            this.equityExercise = _equityExercise == null ? null : _equityExercise.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="featureModel")
        @RuneAttribute(value="featureModel")
        public EquityDerivativeBaseBuilder setFeatureModel(FeatureModel _featureModel) {
            this.featureModel = _featureModel == null ? null : _featureModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="strategyFeature")
        @RuneAttribute(value="strategyFeature")
        public EquityDerivativeBaseBuilder setStrategyFeature(StrategyFeature _strategyFeature) {
            this.strategyFeature = _strategyFeature == null ? null : _strategyFeature.toBuilder();
            return this;
        }

        @Override
        public EquityDerivativeBase build() {
            return new EquityDerivativeBaseImpl(this);
        }

        @Override
        public EquityDerivativeBaseBuilder toBuilder() {
            return this;
        }

        @Override
        public EquityDerivativeBaseBuilder prune() {
            super.prune();
            if (this.buyerSellerModel != null && !this.buyerSellerModel.prune().hasData()) {
                this.buyerSellerModel = null;
            }
            if (this.underlyer != null && !this.underlyer.prune().hasData()) {
                this.underlyer = null;
            }
            if (this.notional != null && !this.notional.prune().hasData()) {
                this.notional = null;
            }
            if (this.equityExercise != null && !this.equityExercise.prune().hasData()) {
                this.equityExercise = null;
            }
            if (this.featureModel != null && !this.featureModel.prune().hasData()) {
                this.featureModel = null;
            }
            if (this.strategyFeature != null && !this.strategyFeature.prune().hasData()) {
                this.strategyFeature = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getBuyerSellerModel() != null && this.getBuyerSellerModel().hasData()) {
                return true;
            }
            if (this.getOptionType() != null) {
                return true;
            }
            if (this.getEquityEffectiveDate() != null) {
                return true;
            }
            if (this.getUnderlyer() != null && this.getUnderlyer().hasData()) {
                return true;
            }
            if (this.getNotional() != null && this.getNotional().hasData()) {
                return true;
            }
            if (this.getEquityExercise() != null && this.getEquityExercise().hasData()) {
                return true;
            }
            if (this.getFeatureModel() != null && this.getFeatureModel().hasData()) {
                return true;
            }
            return this.getStrategyFeature() != null && this.getStrategyFeature().hasData();
        }

        @Override
        public EquityDerivativeBaseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            EquityDerivativeBaseBuilder o = (EquityDerivativeBaseBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBuyerSellerModel(), (RosettaModelObjectBuilder)o.getBuyerSellerModel(), this::setBuyerSellerModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnderlyer(), (RosettaModelObjectBuilder)o.getUnderlyer(), this::setUnderlyer);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNotional(), (RosettaModelObjectBuilder)o.getNotional(), this::setNotional);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEquityExercise(), (RosettaModelObjectBuilder)o.getEquityExercise(), this::setEquityExercise);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFeatureModel(), (RosettaModelObjectBuilder)o.getFeatureModel(), this::setFeatureModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStrategyFeature(), (RosettaModelObjectBuilder)o.getStrategyFeature(), this::setStrategyFeature);
            merger.mergeBasic((Object)this.getOptionType(), (Object)o.getOptionType(), this::setOptionType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEquityEffectiveDate(), (Object)o.getEquityEffectiveDate(), this::setEquityEffectiveDate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EquityDerivativeBase _that = (EquityDerivativeBase)this.getType().cast(o);
            if (!Objects.equals(this.buyerSellerModel, _that.getBuyerSellerModel())) {
                return false;
            }
            if (!Objects.equals((Object)this.optionType, (Object)_that.getOptionType())) {
                return false;
            }
            if (!Objects.equals(this.equityEffectiveDate, _that.getEquityEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.underlyer, _that.getUnderlyer())) {
                return false;
            }
            if (!Objects.equals(this.notional, _that.getNotional())) {
                return false;
            }
            if (!Objects.equals(this.equityExercise, _that.getEquityExercise())) {
                return false;
            }
            if (!Objects.equals(this.featureModel, _that.getFeatureModel())) {
                return false;
            }
            return Objects.equals(this.strategyFeature, _that.getStrategyFeature());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.buyerSellerModel != null ? this.buyerSellerModel.hashCode() : 0);
            _result = 31 * _result + (this.optionType != null ? ((Object)((Object)this.optionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.equityEffectiveDate != null ? this.equityEffectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.underlyer != null ? this.underlyer.hashCode() : 0);
            _result = 31 * _result + (this.notional != null ? this.notional.hashCode() : 0);
            _result = 31 * _result + (this.equityExercise != null ? this.equityExercise.hashCode() : 0);
            _result = 31 * _result + (this.featureModel != null ? this.featureModel.hashCode() : 0);
            _result = 31 * _result + (this.strategyFeature != null ? this.strategyFeature.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "EquityDerivativeBaseBuilder {buyerSellerModel=" + String.valueOf(this.buyerSellerModel) + ", optionType=" + String.valueOf((Object)this.optionType) + ", equityEffectiveDate=" + String.valueOf(this.equityEffectiveDate) + ", underlyer=" + String.valueOf(this.underlyer) + ", notional=" + String.valueOf(this.notional) + ", equityExercise=" + String.valueOf(this.equityExercise) + ", featureModel=" + String.valueOf(this.featureModel) + ", strategyFeature=" + String.valueOf(this.strategyFeature) + "} " + super.toString();
        }
    }

    public static interface EquityDerivativeBaseBuilder
    extends EquityDerivativeBase,
    Product.ProductBuilder {
        public BuyerSellerModel.BuyerSellerModelBuilder getOrCreateBuyerSellerModel();

        @Override
        public BuyerSellerModel.BuyerSellerModelBuilder getBuyerSellerModel();

        public Underlyer.UnderlyerBuilder getOrCreateUnderlyer();

        @Override
        public Underlyer.UnderlyerBuilder getUnderlyer();

        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateNotional();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getNotional();

        public EquityExerciseValuationSettlement.EquityExerciseValuationSettlementBuilder getOrCreateEquityExercise();

        @Override
        public EquityExerciseValuationSettlement.EquityExerciseValuationSettlementBuilder getEquityExercise();

        public FeatureModel.FeatureModelBuilder getOrCreateFeatureModel();

        @Override
        public FeatureModel.FeatureModelBuilder getFeatureModel();

        public StrategyFeature.StrategyFeatureBuilder getOrCreateStrategyFeature();

        @Override
        public StrategyFeature.StrategyFeatureBuilder getStrategyFeature();

        @Override
        public EquityDerivativeBaseBuilder setProductModel(ProductModel var1);

        @Override
        public EquityDerivativeBaseBuilder setId(String var1);

        public EquityDerivativeBaseBuilder setBuyerSellerModel(BuyerSellerModel var1);

        public EquityDerivativeBaseBuilder setOptionType(EquityOptionTypeEnum var1);

        public EquityDerivativeBaseBuilder setEquityEffectiveDate(ZonedDateTime var1);

        public EquityDerivativeBaseBuilder setUnderlyer(Underlyer var1);

        public EquityDerivativeBaseBuilder setNotional(NonNegativeMoney var1);

        public EquityDerivativeBaseBuilder setEquityExercise(EquityExerciseValuationSettlement var1);

        public EquityDerivativeBaseBuilder setFeatureModel(FeatureModel var1);

        public EquityDerivativeBaseBuilder setStrategyFeature(StrategyFeature var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.BuyerSellerModelBuilder.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionType"), EquityOptionTypeEnum.class, (Object)this.getOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("equityEffectiveDate"), ZonedDateTime.class, (Object)this.getEquityEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyer"), processor, Underlyer.UnderlyerBuilder.class, this.getUnderlyer(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notional"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getNotional(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("equityExercise"), processor, EquityExerciseValuationSettlement.EquityExerciseValuationSettlementBuilder.class, this.getEquityExercise(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("featureModel"), processor, FeatureModel.FeatureModelBuilder.class, this.getFeatureModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strategyFeature"), processor, StrategyFeature.StrategyFeatureBuilder.class, this.getStrategyFeature(), new AttributeMeta[0]);
        }

        @Override
        public EquityDerivativeBaseBuilder prune();
    }

    public static class EquityDerivativeBaseImpl
    extends Product.ProductImpl
    implements EquityDerivativeBase {
        private final BuyerSellerModel buyerSellerModel;
        private final EquityOptionTypeEnum optionType;
        private final ZonedDateTime equityEffectiveDate;
        private final Underlyer underlyer;
        private final NonNegativeMoney notional;
        private final EquityExerciseValuationSettlement equityExercise;
        private final FeatureModel featureModel;
        private final StrategyFeature strategyFeature;

        protected EquityDerivativeBaseImpl(EquityDerivativeBaseBuilder builder) {
            super(builder);
            this.buyerSellerModel = Optional.ofNullable(builder.getBuyerSellerModel()).map(f -> f.build()).orElse(null);
            this.optionType = builder.getOptionType();
            this.equityEffectiveDate = builder.getEquityEffectiveDate();
            this.underlyer = Optional.ofNullable(builder.getUnderlyer()).map(f -> f.build()).orElse(null);
            this.notional = Optional.ofNullable(builder.getNotional()).map(f -> f.build()).orElse(null);
            this.equityExercise = Optional.ofNullable(builder.getEquityExercise()).map(f -> f.build()).orElse(null);
            this.featureModel = Optional.ofNullable(builder.getFeatureModel()).map(f -> f.build()).orElse(null);
            this.strategyFeature = Optional.ofNullable(builder.getStrategyFeature()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public BuyerSellerModel getBuyerSellerModel() {
            return this.buyerSellerModel;
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public EquityOptionTypeEnum getOptionType() {
            return this.optionType;
        }

        @Override
        @RosettaAttribute(value="equityEffectiveDate")
        @RuneAttribute(value="equityEffectiveDate")
        public ZonedDateTime getEquityEffectiveDate() {
            return this.equityEffectiveDate;
        }

        @Override
        @RosettaAttribute(value="underlyer", isRequired=true)
        @RuneAttribute(value="underlyer", isRequired=true)
        public Underlyer getUnderlyer() {
            return this.underlyer;
        }

        @Override
        @RosettaAttribute(value="notional")
        @RuneAttribute(value="notional")
        public NonNegativeMoney getNotional() {
            return this.notional;
        }

        @Override
        @RosettaAttribute(value="equityExercise", isRequired=true)
        @RuneAttribute(value="equityExercise", isRequired=true)
        public EquityExerciseValuationSettlement getEquityExercise() {
            return this.equityExercise;
        }

        @Override
        @RosettaAttribute(value="featureModel")
        @RuneAttribute(value="featureModel")
        public FeatureModel getFeatureModel() {
            return this.featureModel;
        }

        @Override
        @RosettaAttribute(value="strategyFeature")
        @RuneAttribute(value="strategyFeature")
        public StrategyFeature getStrategyFeature() {
            return this.strategyFeature;
        }

        @Override
        public EquityDerivativeBase build() {
            return this;
        }

        @Override
        public EquityDerivativeBaseBuilder toBuilder() {
            EquityDerivativeBaseBuilder builder = EquityDerivativeBase.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(EquityDerivativeBaseBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getBuyerSellerModel()).ifPresent(builder::setBuyerSellerModel);
            Optional.ofNullable(this.getOptionType()).ifPresent(builder::setOptionType);
            Optional.ofNullable(this.getEquityEffectiveDate()).ifPresent(builder::setEquityEffectiveDate);
            Optional.ofNullable(this.getUnderlyer()).ifPresent(builder::setUnderlyer);
            Optional.ofNullable(this.getNotional()).ifPresent(builder::setNotional);
            Optional.ofNullable(this.getEquityExercise()).ifPresent(builder::setEquityExercise);
            Optional.ofNullable(this.getFeatureModel()).ifPresent(builder::setFeatureModel);
            Optional.ofNullable(this.getStrategyFeature()).ifPresent(builder::setStrategyFeature);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EquityDerivativeBase _that = (EquityDerivativeBase)this.getType().cast(o);
            if (!Objects.equals(this.buyerSellerModel, _that.getBuyerSellerModel())) {
                return false;
            }
            if (!Objects.equals((Object)this.optionType, (Object)_that.getOptionType())) {
                return false;
            }
            if (!Objects.equals(this.equityEffectiveDate, _that.getEquityEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.underlyer, _that.getUnderlyer())) {
                return false;
            }
            if (!Objects.equals(this.notional, _that.getNotional())) {
                return false;
            }
            if (!Objects.equals(this.equityExercise, _that.getEquityExercise())) {
                return false;
            }
            if (!Objects.equals(this.featureModel, _that.getFeatureModel())) {
                return false;
            }
            return Objects.equals(this.strategyFeature, _that.getStrategyFeature());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.buyerSellerModel != null ? this.buyerSellerModel.hashCode() : 0);
            _result = 31 * _result + (this.optionType != null ? ((Object)((Object)this.optionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.equityEffectiveDate != null ? this.equityEffectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.underlyer != null ? this.underlyer.hashCode() : 0);
            _result = 31 * _result + (this.notional != null ? this.notional.hashCode() : 0);
            _result = 31 * _result + (this.equityExercise != null ? this.equityExercise.hashCode() : 0);
            _result = 31 * _result + (this.featureModel != null ? this.featureModel.hashCode() : 0);
            _result = 31 * _result + (this.strategyFeature != null ? this.strategyFeature.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "EquityDerivativeBase {buyerSellerModel=" + String.valueOf(this.buyerSellerModel) + ", optionType=" + String.valueOf((Object)this.optionType) + ", equityEffectiveDate=" + String.valueOf(this.equityEffectiveDate) + ", underlyer=" + String.valueOf(this.underlyer) + ", notional=" + String.valueOf(this.notional) + ", equityExercise=" + String.valueOf(this.equityExercise) + ", featureModel=" + String.valueOf(this.featureModel) + ", strategyFeature=" + String.valueOf(this.strategyFeature) + "} " + super.toString();
        }
    }
}

