/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.eqd;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.eqd.EquityExpirationModel;
import fpml.consolidated.eqd.EquityMultipleExercise;
import fpml.consolidated.eqd.meta.EquityBermudaExerciseMeta;
import fpml.consolidated.fpmlenum.TimeTypeEnum;
import fpml.consolidated.shared.AdjustableOrRelativeDate;
import fpml.consolidated.shared.BusinessCenterTime;
import fpml.consolidated.shared.DateList;
import fpml.consolidated.shared.DeterminationMethod;
import fpml.consolidated.shared.SharedAmericanExercise;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="EquityBermudaExercise", builder=EquityBermudaExerciseBuilderImpl.class, version="1.2.2")
@RuneDataType(value="EquityBermudaExercise", model="fpml", builder=EquityBermudaExerciseBuilderImpl.class, version="1.2.2")
public interface EquityBermudaExercise
extends SharedAmericanExercise {
    public static final EquityBermudaExerciseMeta metaData = new EquityBermudaExerciseMeta();

    public DateList getBermudaExerciseDates();

    public TimeTypeEnum getLatestExerciseTimeType();

    public EquityExpirationModel getEquityExpirationModel();

    public EquityMultipleExercise getEquityMultipleExercise();

    @Override
    public EquityBermudaExercise build();

    @Override
    public EquityBermudaExerciseBuilder toBuilder();

    public static EquityBermudaExerciseBuilder builder() {
        return new EquityBermudaExerciseBuilderImpl();
    }

    default public RosettaMetaData<? extends EquityBermudaExercise> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends EquityBermudaExercise> getType() {
        return EquityBermudaExercise.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commencementDate"), processor, AdjustableOrRelativeDate.class, this.getCommencementDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("expirationDate"), processor, AdjustableOrRelativeDate.class, this.getExpirationDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("latestExerciseTime"), processor, BusinessCenterTime.class, this.getLatestExerciseTime(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("latestExerciseTimeDetermination"), processor, DeterminationMethod.class, this.getLatestExerciseTimeDetermination(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("bermudaExerciseDates"), processor, DateList.class, this.getBermudaExerciseDates(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("latestExerciseTimeType"), TimeTypeEnum.class, (Object)this.getLatestExerciseTimeType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("equityExpirationModel"), processor, EquityExpirationModel.class, this.getEquityExpirationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("equityMultipleExercise"), processor, EquityMultipleExercise.class, this.getEquityMultipleExercise(), new AttributeMeta[0]);
    }

    public static class EquityBermudaExerciseBuilderImpl
    extends SharedAmericanExercise.SharedAmericanExerciseBuilderImpl
    implements EquityBermudaExerciseBuilder {
        protected DateList.DateListBuilder bermudaExerciseDates;
        protected TimeTypeEnum latestExerciseTimeType;
        protected EquityExpirationModel.EquityExpirationModelBuilder equityExpirationModel;
        protected EquityMultipleExercise.EquityMultipleExerciseBuilder equityMultipleExercise;

        @Override
        @RosettaAttribute(value="bermudaExerciseDates")
        @RuneAttribute(value="bermudaExerciseDates")
        public DateList.DateListBuilder getBermudaExerciseDates() {
            return this.bermudaExerciseDates;
        }

        @Override
        public DateList.DateListBuilder getOrCreateBermudaExerciseDates() {
            DateList.DateListBuilder result = this.bermudaExerciseDates != null ? this.bermudaExerciseDates : (this.bermudaExerciseDates = DateList.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="latestExerciseTimeType")
        @RuneAttribute(value="latestExerciseTimeType")
        public TimeTypeEnum getLatestExerciseTimeType() {
            return this.latestExerciseTimeType;
        }

        @Override
        @RosettaAttribute(value="equityExpirationModel", isRequired=true)
        @RuneAttribute(value="equityExpirationModel", isRequired=true)
        public EquityExpirationModel.EquityExpirationModelBuilder getEquityExpirationModel() {
            return this.equityExpirationModel;
        }

        @Override
        public EquityExpirationModel.EquityExpirationModelBuilder getOrCreateEquityExpirationModel() {
            EquityExpirationModel.EquityExpirationModelBuilder result = this.equityExpirationModel != null ? this.equityExpirationModel : (this.equityExpirationModel = EquityExpirationModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="equityMultipleExercise")
        @RuneAttribute(value="equityMultipleExercise")
        public EquityMultipleExercise.EquityMultipleExerciseBuilder getEquityMultipleExercise() {
            return this.equityMultipleExercise;
        }

        @Override
        public EquityMultipleExercise.EquityMultipleExerciseBuilder getOrCreateEquityMultipleExercise() {
            EquityMultipleExercise.EquityMultipleExerciseBuilder result = this.equityMultipleExercise != null ? this.equityMultipleExercise : (this.equityMultipleExercise = EquityMultipleExercise.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public EquityBermudaExerciseBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="commencementDate")
        @RuneAttribute(value="commencementDate")
        public EquityBermudaExerciseBuilder setCommencementDate(AdjustableOrRelativeDate _commencementDate) {
            this.commencementDate = _commencementDate == null ? null : _commencementDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="expirationDate", isRequired=true)
        @RuneAttribute(value="expirationDate", isRequired=true)
        public EquityBermudaExerciseBuilder setExpirationDate(AdjustableOrRelativeDate _expirationDate) {
            this.expirationDate = _expirationDate == null ? null : _expirationDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="latestExerciseTime")
        @RuneAttribute(value="latestExerciseTime")
        public EquityBermudaExerciseBuilder setLatestExerciseTime(BusinessCenterTime _latestExerciseTime) {
            this.latestExerciseTime = _latestExerciseTime == null ? null : _latestExerciseTime.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="latestExerciseTimeDetermination")
        @RuneAttribute(value="latestExerciseTimeDetermination")
        public EquityBermudaExerciseBuilder setLatestExerciseTimeDetermination(DeterminationMethod _latestExerciseTimeDetermination) {
            this.latestExerciseTimeDetermination = _latestExerciseTimeDetermination == null ? null : _latestExerciseTimeDetermination.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="bermudaExerciseDates")
        @RuneAttribute(value="bermudaExerciseDates")
        public EquityBermudaExerciseBuilder setBermudaExerciseDates(DateList _bermudaExerciseDates) {
            this.bermudaExerciseDates = _bermudaExerciseDates == null ? null : _bermudaExerciseDates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="latestExerciseTimeType")
        @RuneAttribute(value="latestExerciseTimeType")
        public EquityBermudaExerciseBuilder setLatestExerciseTimeType(TimeTypeEnum _latestExerciseTimeType) {
            this.latestExerciseTimeType = _latestExerciseTimeType == null ? null : _latestExerciseTimeType;
            return this;
        }

        @Override
        @RosettaAttribute(value="equityExpirationModel", isRequired=true)
        @RuneAttribute(value="equityExpirationModel", isRequired=true)
        public EquityBermudaExerciseBuilder setEquityExpirationModel(EquityExpirationModel _equityExpirationModel) {
            this.equityExpirationModel = _equityExpirationModel == null ? null : _equityExpirationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="equityMultipleExercise")
        @RuneAttribute(value="equityMultipleExercise")
        public EquityBermudaExerciseBuilder setEquityMultipleExercise(EquityMultipleExercise _equityMultipleExercise) {
            this.equityMultipleExercise = _equityMultipleExercise == null ? null : _equityMultipleExercise.toBuilder();
            return this;
        }

        @Override
        public EquityBermudaExercise build() {
            return new EquityBermudaExerciseImpl(this);
        }

        @Override
        public EquityBermudaExerciseBuilder toBuilder() {
            return this;
        }

        @Override
        public EquityBermudaExerciseBuilder prune() {
            super.prune();
            if (this.bermudaExerciseDates != null && !this.bermudaExerciseDates.prune().hasData()) {
                this.bermudaExerciseDates = null;
            }
            if (this.equityExpirationModel != null && !this.equityExpirationModel.prune().hasData()) {
                this.equityExpirationModel = null;
            }
            if (this.equityMultipleExercise != null && !this.equityMultipleExercise.prune().hasData()) {
                this.equityMultipleExercise = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getBermudaExerciseDates() != null && this.getBermudaExerciseDates().hasData()) {
                return true;
            }
            if (this.getLatestExerciseTimeType() != null) {
                return true;
            }
            if (this.getEquityExpirationModel() != null && this.getEquityExpirationModel().hasData()) {
                return true;
            }
            return this.getEquityMultipleExercise() != null && this.getEquityMultipleExercise().hasData();
        }

        @Override
        public EquityBermudaExerciseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            EquityBermudaExerciseBuilder o = (EquityBermudaExerciseBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBermudaExerciseDates(), (RosettaModelObjectBuilder)o.getBermudaExerciseDates(), this::setBermudaExerciseDates);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEquityExpirationModel(), (RosettaModelObjectBuilder)o.getEquityExpirationModel(), this::setEquityExpirationModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEquityMultipleExercise(), (RosettaModelObjectBuilder)o.getEquityMultipleExercise(), this::setEquityMultipleExercise);
            merger.mergeBasic((Object)this.getLatestExerciseTimeType(), (Object)o.getLatestExerciseTimeType(), this::setLatestExerciseTimeType, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EquityBermudaExercise _that = (EquityBermudaExercise)this.getType().cast(o);
            if (!Objects.equals(this.bermudaExerciseDates, _that.getBermudaExerciseDates())) {
                return false;
            }
            if (!Objects.equals((Object)this.latestExerciseTimeType, (Object)_that.getLatestExerciseTimeType())) {
                return false;
            }
            if (!Objects.equals(this.equityExpirationModel, _that.getEquityExpirationModel())) {
                return false;
            }
            return Objects.equals(this.equityMultipleExercise, _that.getEquityMultipleExercise());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.bermudaExerciseDates != null ? this.bermudaExerciseDates.hashCode() : 0);
            _result = 31 * _result + (this.latestExerciseTimeType != null ? ((Object)((Object)this.latestExerciseTimeType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.equityExpirationModel != null ? this.equityExpirationModel.hashCode() : 0);
            _result = 31 * _result + (this.equityMultipleExercise != null ? this.equityMultipleExercise.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "EquityBermudaExerciseBuilder {bermudaExerciseDates=" + String.valueOf(this.bermudaExerciseDates) + ", latestExerciseTimeType=" + String.valueOf((Object)this.latestExerciseTimeType) + ", equityExpirationModel=" + String.valueOf(this.equityExpirationModel) + ", equityMultipleExercise=" + String.valueOf(this.equityMultipleExercise) + "} " + super.toString();
        }
    }

    public static interface EquityBermudaExerciseBuilder
    extends EquityBermudaExercise,
    SharedAmericanExercise.SharedAmericanExerciseBuilder {
        public DateList.DateListBuilder getOrCreateBermudaExerciseDates();

        @Override
        public DateList.DateListBuilder getBermudaExerciseDates();

        public EquityExpirationModel.EquityExpirationModelBuilder getOrCreateEquityExpirationModel();

        @Override
        public EquityExpirationModel.EquityExpirationModelBuilder getEquityExpirationModel();

        public EquityMultipleExercise.EquityMultipleExerciseBuilder getOrCreateEquityMultipleExercise();

        @Override
        public EquityMultipleExercise.EquityMultipleExerciseBuilder getEquityMultipleExercise();

        @Override
        public EquityBermudaExerciseBuilder setId(String var1);

        @Override
        public EquityBermudaExerciseBuilder setCommencementDate(AdjustableOrRelativeDate var1);

        @Override
        public EquityBermudaExerciseBuilder setExpirationDate(AdjustableOrRelativeDate var1);

        @Override
        public EquityBermudaExerciseBuilder setLatestExerciseTime(BusinessCenterTime var1);

        @Override
        public EquityBermudaExerciseBuilder setLatestExerciseTimeDetermination(DeterminationMethod var1);

        public EquityBermudaExerciseBuilder setBermudaExerciseDates(DateList var1);

        public EquityBermudaExerciseBuilder setLatestExerciseTimeType(TimeTypeEnum var1);

        public EquityBermudaExerciseBuilder setEquityExpirationModel(EquityExpirationModel var1);

        public EquityBermudaExerciseBuilder setEquityMultipleExercise(EquityMultipleExercise var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commencementDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getCommencementDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("expirationDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getExpirationDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("latestExerciseTime"), processor, BusinessCenterTime.BusinessCenterTimeBuilder.class, (RosettaModelObjectBuilder)this.getLatestExerciseTime(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("latestExerciseTimeDetermination"), processor, DeterminationMethod.DeterminationMethodBuilder.class, (RosettaModelObjectBuilder)this.getLatestExerciseTimeDetermination(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("bermudaExerciseDates"), processor, DateList.DateListBuilder.class, this.getBermudaExerciseDates(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("latestExerciseTimeType"), TimeTypeEnum.class, (Object)this.getLatestExerciseTimeType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("equityExpirationModel"), processor, EquityExpirationModel.EquityExpirationModelBuilder.class, this.getEquityExpirationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("equityMultipleExercise"), processor, EquityMultipleExercise.EquityMultipleExerciseBuilder.class, this.getEquityMultipleExercise(), new AttributeMeta[0]);
        }

        @Override
        public EquityBermudaExerciseBuilder prune();
    }

    public static class EquityBermudaExerciseImpl
    extends SharedAmericanExercise.SharedAmericanExerciseImpl
    implements EquityBermudaExercise {
        private final DateList bermudaExerciseDates;
        private final TimeTypeEnum latestExerciseTimeType;
        private final EquityExpirationModel equityExpirationModel;
        private final EquityMultipleExercise equityMultipleExercise;

        protected EquityBermudaExerciseImpl(EquityBermudaExerciseBuilder builder) {
            super(builder);
            this.bermudaExerciseDates = Optional.ofNullable(builder.getBermudaExerciseDates()).map(f -> f.build()).orElse(null);
            this.latestExerciseTimeType = builder.getLatestExerciseTimeType();
            this.equityExpirationModel = Optional.ofNullable(builder.getEquityExpirationModel()).map(f -> f.build()).orElse(null);
            this.equityMultipleExercise = Optional.ofNullable(builder.getEquityMultipleExercise()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="bermudaExerciseDates")
        @RuneAttribute(value="bermudaExerciseDates")
        public DateList getBermudaExerciseDates() {
            return this.bermudaExerciseDates;
        }

        @Override
        @RosettaAttribute(value="latestExerciseTimeType")
        @RuneAttribute(value="latestExerciseTimeType")
        public TimeTypeEnum getLatestExerciseTimeType() {
            return this.latestExerciseTimeType;
        }

        @Override
        @RosettaAttribute(value="equityExpirationModel", isRequired=true)
        @RuneAttribute(value="equityExpirationModel", isRequired=true)
        public EquityExpirationModel getEquityExpirationModel() {
            return this.equityExpirationModel;
        }

        @Override
        @RosettaAttribute(value="equityMultipleExercise")
        @RuneAttribute(value="equityMultipleExercise")
        public EquityMultipleExercise getEquityMultipleExercise() {
            return this.equityMultipleExercise;
        }

        @Override
        public EquityBermudaExercise build() {
            return this;
        }

        @Override
        public EquityBermudaExerciseBuilder toBuilder() {
            EquityBermudaExerciseBuilder builder = EquityBermudaExercise.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(EquityBermudaExerciseBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getBermudaExerciseDates()).ifPresent(builder::setBermudaExerciseDates);
            Optional.ofNullable(this.getLatestExerciseTimeType()).ifPresent(builder::setLatestExerciseTimeType);
            Optional.ofNullable(this.getEquityExpirationModel()).ifPresent(builder::setEquityExpirationModel);
            Optional.ofNullable(this.getEquityMultipleExercise()).ifPresent(builder::setEquityMultipleExercise);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EquityBermudaExercise _that = (EquityBermudaExercise)this.getType().cast(o);
            if (!Objects.equals(this.bermudaExerciseDates, _that.getBermudaExerciseDates())) {
                return false;
            }
            if (!Objects.equals((Object)this.latestExerciseTimeType, (Object)_that.getLatestExerciseTimeType())) {
                return false;
            }
            if (!Objects.equals(this.equityExpirationModel, _that.getEquityExpirationModel())) {
                return false;
            }
            return Objects.equals(this.equityMultipleExercise, _that.getEquityMultipleExercise());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.bermudaExerciseDates != null ? this.bermudaExerciseDates.hashCode() : 0);
            _result = 31 * _result + (this.latestExerciseTimeType != null ? ((Object)((Object)this.latestExerciseTimeType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.equityExpirationModel != null ? this.equityExpirationModel.hashCode() : 0);
            _result = 31 * _result + (this.equityMultipleExercise != null ? this.equityMultipleExercise.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "EquityBermudaExercise {bermudaExerciseDates=" + String.valueOf(this.bermudaExerciseDates) + ", latestExerciseTimeType=" + String.valueOf((Object)this.latestExerciseTimeType) + ", equityExpirationModel=" + String.valueOf(this.equityExpirationModel) + ", equityMultipleExercise=" + String.valueOf(this.equityMultipleExercise) + "} " + super.toString();
        }
    }
}

