/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.doc.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.doc.TradeIdentifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="TradeIdentifierChoice")
@ImplementedBy(value=Default.class)
public interface TradeIdentifierChoice
extends Validator<TradeIdentifier> {
    public static final String NAME = "TradeIdentifierChoice";
    public static final String DEFINITION = "optional choice issuerTradeIdModel, tradeIdentifierSequence";

    public static class NoOp
    implements TradeIdentifierChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, TradeIdentifier tradeIdentifier) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements TradeIdentifierChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, TradeIdentifier tradeIdentifier) {
            ComparisonResult result = this.executeDataRule(tradeIdentifier);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)TradeIdentifierChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TradeIdentifier", (RosettaPath)path, (String)TradeIdentifierChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)TradeIdentifierChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TradeIdentifier", (RosettaPath)path, (String)TradeIdentifierChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(TradeIdentifier tradeIdentifier) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)tradeIdentifier), Arrays.asList("issuerTradeIdModel", "tradeIdentifierSequence"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

