/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.doc;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.Allocations;
import fpml.consolidated.doc.Approvals;
import fpml.consolidated.doc.CalculationAgentModel;
import fpml.consolidated.doc.TradeHeader;
import fpml.consolidated.doc.meta.TradeMeta;
import fpml.consolidated.shared.Collateral;
import fpml.consolidated.shared.Documentation;
import fpml.consolidated.shared.GoverningLaw;
import fpml.consolidated.shared.PartyReference;
import fpml.consolidated.shared.Payment;
import fpml.consolidated.shared.Product;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Trade", builder=TradeBuilderImpl.class, version="1.2.2")
@RuneDataType(value="Trade", model="fpml", builder=TradeBuilderImpl.class, version="1.2.2")
public interface Trade
extends RosettaModelObject {
    public static final TradeMeta metaData = new TradeMeta();

    public TradeHeader getTradeHeader();

    public Product getProduct();

    public List<? extends Payment> getOtherPartyPayment();

    public List<? extends PartyReference> getBrokerPartyReference();

    public CalculationAgentModel getCalculationAgentModel();

    public List<? extends PartyReference> getDeterminingParty();

    public PartyReference getBarrierDeterminationAgent();

    public List<? extends PartyReference> getHedgingParty();

    public Collateral getCollateral();

    public Documentation getDocumentation();

    public GoverningLaw getGoverningLaw();

    public List<? extends Allocations> getAllocations();

    public String getId();

    public Approvals getApprovals();

    public Trade build();

    public TradeBuilder toBuilder();

    public static TradeBuilder builder() {
        return new TradeBuilderImpl();
    }

    default public RosettaMetaData<? extends Trade> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Trade> getType() {
        return Trade.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("tradeHeader"), processor, TradeHeader.class, this.getTradeHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("product"), processor, Product.class, this.getProduct(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("otherPartyPayment"), processor, Payment.class, this.getOtherPartyPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("brokerPartyReference"), processor, PartyReference.class, this.getBrokerPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("calculationAgentModel"), processor, CalculationAgentModel.class, this.getCalculationAgentModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("determiningParty"), processor, PartyReference.class, this.getDeterminingParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("barrierDeterminationAgent"), processor, PartyReference.class, this.getBarrierDeterminationAgent(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("hedgingParty"), processor, PartyReference.class, this.getHedgingParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateral"), processor, Collateral.class, this.getCollateral(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("documentation"), processor, Documentation.class, this.getDocumentation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("governingLaw"), processor, GoverningLaw.class, this.getGoverningLaw(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("allocations"), processor, Allocations.class, this.getAllocations(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("approvals"), processor, Approvals.class, this.getApprovals(), new AttributeMeta[0]);
    }

    public static class TradeBuilderImpl
    implements TradeBuilder {
        protected TradeHeader.TradeHeaderBuilder tradeHeader;
        protected Product.ProductBuilder product;
        protected List<Payment.PaymentBuilder> otherPartyPayment = new ArrayList<Payment.PaymentBuilder>();
        protected List<PartyReference.PartyReferenceBuilder> brokerPartyReference = new ArrayList<PartyReference.PartyReferenceBuilder>();
        protected CalculationAgentModel.CalculationAgentModelBuilder calculationAgentModel;
        protected List<PartyReference.PartyReferenceBuilder> determiningParty = new ArrayList<PartyReference.PartyReferenceBuilder>();
        protected PartyReference.PartyReferenceBuilder barrierDeterminationAgent;
        protected List<PartyReference.PartyReferenceBuilder> hedgingParty = new ArrayList<PartyReference.PartyReferenceBuilder>();
        protected Collateral.CollateralBuilder collateral;
        protected Documentation.DocumentationBuilder documentation;
        protected GoverningLaw.GoverningLawBuilder governingLaw;
        protected List<Allocations.AllocationsBuilder> allocations = new ArrayList<Allocations.AllocationsBuilder>();
        protected String id;
        protected Approvals.ApprovalsBuilder approvals;

        @Override
        @RosettaAttribute(value="tradeHeader")
        @RuneAttribute(value="tradeHeader")
        public TradeHeader.TradeHeaderBuilder getTradeHeader() {
            return this.tradeHeader;
        }

        @Override
        public TradeHeader.TradeHeaderBuilder getOrCreateTradeHeader() {
            TradeHeader.TradeHeaderBuilder result = this.tradeHeader != null ? this.tradeHeader : (this.tradeHeader = TradeHeader.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="product")
        @RuneAttribute(value="product")
        public Product.ProductBuilder getProduct() {
            return this.product;
        }

        @Override
        public Product.ProductBuilder getOrCreateProduct() {
            Product.ProductBuilder result = this.product != null ? this.product : (this.product = Product.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="otherPartyPayment")
        @RuneAttribute(value="otherPartyPayment")
        public List<? extends Payment.PaymentBuilder> getOtherPartyPayment() {
            return this.otherPartyPayment;
        }

        @Override
        public Payment.PaymentBuilder getOrCreateOtherPartyPayment(int index) {
            if (this.otherPartyPayment == null) {
                this.otherPartyPayment = new ArrayList<Payment.PaymentBuilder>();
            }
            return (Payment.PaymentBuilder)this.getIndex(this.otherPartyPayment, index, () -> {
                Payment.PaymentBuilder newOtherPartyPayment = Payment.builder();
                return newOtherPartyPayment;
            });
        }

        @Override
        @RosettaAttribute(value="brokerPartyReference")
        @RuneAttribute(value="brokerPartyReference")
        public List<? extends PartyReference.PartyReferenceBuilder> getBrokerPartyReference() {
            return this.brokerPartyReference;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateBrokerPartyReference(int index) {
            if (this.brokerPartyReference == null) {
                this.brokerPartyReference = new ArrayList<PartyReference.PartyReferenceBuilder>();
            }
            return (PartyReference.PartyReferenceBuilder)this.getIndex(this.brokerPartyReference, index, () -> {
                PartyReference.PartyReferenceBuilder newBrokerPartyReference = PartyReference.builder();
                return newBrokerPartyReference;
            });
        }

        @Override
        @RosettaAttribute(value="calculationAgentModel", isRequired=true)
        @RuneAttribute(value="calculationAgentModel", isRequired=true)
        public CalculationAgentModel.CalculationAgentModelBuilder getCalculationAgentModel() {
            return this.calculationAgentModel;
        }

        @Override
        public CalculationAgentModel.CalculationAgentModelBuilder getOrCreateCalculationAgentModel() {
            CalculationAgentModel.CalculationAgentModelBuilder result = this.calculationAgentModel != null ? this.calculationAgentModel : (this.calculationAgentModel = CalculationAgentModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="determiningParty")
        @RuneAttribute(value="determiningParty")
        public List<? extends PartyReference.PartyReferenceBuilder> getDeterminingParty() {
            return this.determiningParty;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateDeterminingParty(int index) {
            if (this.determiningParty == null) {
                this.determiningParty = new ArrayList<PartyReference.PartyReferenceBuilder>();
            }
            return (PartyReference.PartyReferenceBuilder)this.getIndex(this.determiningParty, index, () -> {
                PartyReference.PartyReferenceBuilder newDeterminingParty = PartyReference.builder();
                return newDeterminingParty;
            });
        }

        @Override
        @RosettaAttribute(value="barrierDeterminationAgent")
        @RuneAttribute(value="barrierDeterminationAgent")
        public PartyReference.PartyReferenceBuilder getBarrierDeterminationAgent() {
            return this.barrierDeterminationAgent;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateBarrierDeterminationAgent() {
            PartyReference.PartyReferenceBuilder result = this.barrierDeterminationAgent != null ? this.barrierDeterminationAgent : (this.barrierDeterminationAgent = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="hedgingParty")
        @RuneAttribute(value="hedgingParty")
        public List<? extends PartyReference.PartyReferenceBuilder> getHedgingParty() {
            return this.hedgingParty;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateHedgingParty(int index) {
            if (this.hedgingParty == null) {
                this.hedgingParty = new ArrayList<PartyReference.PartyReferenceBuilder>();
            }
            return (PartyReference.PartyReferenceBuilder)this.getIndex(this.hedgingParty, index, () -> {
                PartyReference.PartyReferenceBuilder newHedgingParty = PartyReference.builder();
                return newHedgingParty;
            });
        }

        @Override
        @RosettaAttribute(value="collateral")
        @RuneAttribute(value="collateral")
        public Collateral.CollateralBuilder getCollateral() {
            return this.collateral;
        }

        @Override
        public Collateral.CollateralBuilder getOrCreateCollateral() {
            Collateral.CollateralBuilder result = this.collateral != null ? this.collateral : (this.collateral = Collateral.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="documentation")
        @RuneAttribute(value="documentation")
        public Documentation.DocumentationBuilder getDocumentation() {
            return this.documentation;
        }

        @Override
        public Documentation.DocumentationBuilder getOrCreateDocumentation() {
            Documentation.DocumentationBuilder result = this.documentation != null ? this.documentation : (this.documentation = Documentation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="governingLaw")
        @RuneAttribute(value="governingLaw")
        public GoverningLaw.GoverningLawBuilder getGoverningLaw() {
            return this.governingLaw;
        }

        @Override
        public GoverningLaw.GoverningLawBuilder getOrCreateGoverningLaw() {
            GoverningLaw.GoverningLawBuilder result = this.governingLaw != null ? this.governingLaw : (this.governingLaw = GoverningLaw.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="allocations")
        @RuneAttribute(value="allocations")
        public List<? extends Allocations.AllocationsBuilder> getAllocations() {
            return this.allocations;
        }

        @Override
        public Allocations.AllocationsBuilder getOrCreateAllocations(int index) {
            if (this.allocations == null) {
                this.allocations = new ArrayList<Allocations.AllocationsBuilder>();
            }
            return (Allocations.AllocationsBuilder)this.getIndex(this.allocations, index, () -> {
                Allocations.AllocationsBuilder newAllocations = Allocations.builder();
                return newAllocations;
            });
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="approvals")
        @RuneAttribute(value="approvals")
        public Approvals.ApprovalsBuilder getApprovals() {
            return this.approvals;
        }

        @Override
        public Approvals.ApprovalsBuilder getOrCreateApprovals() {
            Approvals.ApprovalsBuilder result = this.approvals != null ? this.approvals : (this.approvals = Approvals.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradeHeader")
        @RuneAttribute(value="tradeHeader")
        public TradeBuilder setTradeHeader(TradeHeader _tradeHeader) {
            this.tradeHeader = _tradeHeader == null ? null : _tradeHeader.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="product")
        @RuneAttribute(value="product")
        public TradeBuilder setProduct(Product _product) {
            this.product = _product == null ? null : _product.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="otherPartyPayment")
        @RuneAttribute(value="otherPartyPayment")
        public TradeBuilder addOtherPartyPayment(Payment _otherPartyPayment) {
            if (_otherPartyPayment != null) {
                this.otherPartyPayment.add(_otherPartyPayment.toBuilder());
            }
            return this;
        }

        @Override
        public TradeBuilder addOtherPartyPayment(Payment _otherPartyPayment, int idx) {
            this.getIndex(this.otherPartyPayment, idx, () -> _otherPartyPayment.toBuilder());
            return this;
        }

        @Override
        public TradeBuilder addOtherPartyPayment(List<? extends Payment> otherPartyPayments) {
            if (otherPartyPayments != null) {
                for (Payment payment : otherPartyPayments) {
                    this.otherPartyPayment.add(payment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="otherPartyPayment")
        public TradeBuilder setOtherPartyPayment(List<? extends Payment> otherPartyPayments) {
            this.otherPartyPayment = otherPartyPayments == null ? new ArrayList<Payment.PaymentBuilder>() : (List)otherPartyPayments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="brokerPartyReference")
        @RuneAttribute(value="brokerPartyReference")
        public TradeBuilder addBrokerPartyReference(PartyReference _brokerPartyReference) {
            if (_brokerPartyReference != null) {
                this.brokerPartyReference.add(_brokerPartyReference.toBuilder());
            }
            return this;
        }

        @Override
        public TradeBuilder addBrokerPartyReference(PartyReference _brokerPartyReference, int idx) {
            this.getIndex(this.brokerPartyReference, idx, () -> _brokerPartyReference.toBuilder());
            return this;
        }

        @Override
        public TradeBuilder addBrokerPartyReference(List<? extends PartyReference> brokerPartyReferences) {
            if (brokerPartyReferences != null) {
                for (PartyReference partyReference : brokerPartyReferences) {
                    this.brokerPartyReference.add(partyReference.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="brokerPartyReference")
        public TradeBuilder setBrokerPartyReference(List<? extends PartyReference> brokerPartyReferences) {
            this.brokerPartyReference = brokerPartyReferences == null ? new ArrayList<PartyReference.PartyReferenceBuilder>() : (List)brokerPartyReferences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="calculationAgentModel", isRequired=true)
        @RuneAttribute(value="calculationAgentModel", isRequired=true)
        public TradeBuilder setCalculationAgentModel(CalculationAgentModel _calculationAgentModel) {
            this.calculationAgentModel = _calculationAgentModel == null ? null : _calculationAgentModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="determiningParty")
        @RuneAttribute(value="determiningParty")
        public TradeBuilder addDeterminingParty(PartyReference _determiningParty) {
            if (_determiningParty != null) {
                this.determiningParty.add(_determiningParty.toBuilder());
            }
            return this;
        }

        @Override
        public TradeBuilder addDeterminingParty(PartyReference _determiningParty, int idx) {
            this.getIndex(this.determiningParty, idx, () -> _determiningParty.toBuilder());
            return this;
        }

        @Override
        public TradeBuilder addDeterminingParty(List<? extends PartyReference> determiningPartys) {
            if (determiningPartys != null) {
                for (PartyReference partyReference : determiningPartys) {
                    this.determiningParty.add(partyReference.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="determiningParty")
        public TradeBuilder setDeterminingParty(List<? extends PartyReference> determiningPartys) {
            this.determiningParty = determiningPartys == null ? new ArrayList<PartyReference.PartyReferenceBuilder>() : (List)determiningPartys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="barrierDeterminationAgent")
        @RuneAttribute(value="barrierDeterminationAgent")
        public TradeBuilder setBarrierDeterminationAgent(PartyReference _barrierDeterminationAgent) {
            this.barrierDeterminationAgent = _barrierDeterminationAgent == null ? null : _barrierDeterminationAgent.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="hedgingParty")
        @RuneAttribute(value="hedgingParty")
        public TradeBuilder addHedgingParty(PartyReference _hedgingParty) {
            if (_hedgingParty != null) {
                this.hedgingParty.add(_hedgingParty.toBuilder());
            }
            return this;
        }

        @Override
        public TradeBuilder addHedgingParty(PartyReference _hedgingParty, int idx) {
            this.getIndex(this.hedgingParty, idx, () -> _hedgingParty.toBuilder());
            return this;
        }

        @Override
        public TradeBuilder addHedgingParty(List<? extends PartyReference> hedgingPartys) {
            if (hedgingPartys != null) {
                for (PartyReference partyReference : hedgingPartys) {
                    this.hedgingParty.add(partyReference.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="hedgingParty")
        public TradeBuilder setHedgingParty(List<? extends PartyReference> hedgingPartys) {
            this.hedgingParty = hedgingPartys == null ? new ArrayList<PartyReference.PartyReferenceBuilder>() : (List)hedgingPartys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="collateral")
        @RuneAttribute(value="collateral")
        public TradeBuilder setCollateral(Collateral _collateral) {
            this.collateral = _collateral == null ? null : _collateral.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="documentation")
        @RuneAttribute(value="documentation")
        public TradeBuilder setDocumentation(Documentation _documentation) {
            this.documentation = _documentation == null ? null : _documentation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="governingLaw")
        @RuneAttribute(value="governingLaw")
        public TradeBuilder setGoverningLaw(GoverningLaw _governingLaw) {
            this.governingLaw = _governingLaw == null ? null : _governingLaw.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="allocations")
        @RuneAttribute(value="allocations")
        public TradeBuilder addAllocations(Allocations _allocations) {
            if (_allocations != null) {
                this.allocations.add(_allocations.toBuilder());
            }
            return this;
        }

        @Override
        public TradeBuilder addAllocations(Allocations _allocations, int idx) {
            this.getIndex(this.allocations, idx, () -> _allocations.toBuilder());
            return this;
        }

        @Override
        public TradeBuilder addAllocations(List<? extends Allocations> allocationss) {
            if (allocationss != null) {
                for (Allocations allocations : allocationss) {
                    this.allocations.add(allocations.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="allocations")
        public TradeBuilder setAllocations(List<? extends Allocations> allocationss) {
            this.allocations = allocationss == null ? new ArrayList<Allocations.AllocationsBuilder>() : (List)allocationss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public TradeBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="approvals")
        @RuneAttribute(value="approvals")
        public TradeBuilder setApprovals(Approvals _approvals) {
            this.approvals = _approvals == null ? null : _approvals.toBuilder();
            return this;
        }

        @Override
        public Trade build() {
            return new TradeImpl(this);
        }

        @Override
        public TradeBuilder toBuilder() {
            return this;
        }

        @Override
        public TradeBuilder prune() {
            if (this.tradeHeader != null && !this.tradeHeader.prune().hasData()) {
                this.tradeHeader = null;
            }
            if (this.product != null && !this.product.prune().hasData()) {
                this.product = null;
            }
            this.otherPartyPayment = this.otherPartyPayment.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.brokerPartyReference = this.brokerPartyReference.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.calculationAgentModel != null && !this.calculationAgentModel.prune().hasData()) {
                this.calculationAgentModel = null;
            }
            this.determiningParty = this.determiningParty.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.barrierDeterminationAgent != null && !this.barrierDeterminationAgent.prune().hasData()) {
                this.barrierDeterminationAgent = null;
            }
            this.hedgingParty = this.hedgingParty.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.collateral != null && !this.collateral.prune().hasData()) {
                this.collateral = null;
            }
            if (this.documentation != null && !this.documentation.prune().hasData()) {
                this.documentation = null;
            }
            if (this.governingLaw != null && !this.governingLaw.prune().hasData()) {
                this.governingLaw = null;
            }
            this.allocations = this.allocations.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.approvals != null && !this.approvals.prune().hasData()) {
                this.approvals = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getTradeHeader() != null && this.getTradeHeader().hasData()) {
                return true;
            }
            if (this.getProduct() != null && this.getProduct().hasData()) {
                return true;
            }
            if (this.getOtherPartyPayment() != null && this.getOtherPartyPayment().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getBrokerPartyReference() != null && this.getBrokerPartyReference().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCalculationAgentModel() != null && this.getCalculationAgentModel().hasData()) {
                return true;
            }
            if (this.getDeterminingParty() != null && this.getDeterminingParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getBarrierDeterminationAgent() != null && this.getBarrierDeterminationAgent().hasData()) {
                return true;
            }
            if (this.getHedgingParty() != null && this.getHedgingParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCollateral() != null && this.getCollateral().hasData()) {
                return true;
            }
            if (this.getDocumentation() != null && this.getDocumentation().hasData()) {
                return true;
            }
            if (this.getGoverningLaw() != null && this.getGoverningLaw().hasData()) {
                return true;
            }
            if (this.getAllocations() != null && this.getAllocations().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getId() != null) {
                return true;
            }
            return this.getApprovals() != null && this.getApprovals().hasData();
        }

        public TradeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TradeBuilder o = (TradeBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradeHeader(), (RosettaModelObjectBuilder)o.getTradeHeader(), this::setTradeHeader);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getProduct(), (RosettaModelObjectBuilder)o.getProduct(), this::setProduct);
            merger.mergeRosetta(this.getOtherPartyPayment(), o.getOtherPartyPayment(), this::getOrCreateOtherPartyPayment);
            merger.mergeRosetta(this.getBrokerPartyReference(), o.getBrokerPartyReference(), this::getOrCreateBrokerPartyReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCalculationAgentModel(), (RosettaModelObjectBuilder)o.getCalculationAgentModel(), this::setCalculationAgentModel);
            merger.mergeRosetta(this.getDeterminingParty(), o.getDeterminingParty(), this::getOrCreateDeterminingParty);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBarrierDeterminationAgent(), (RosettaModelObjectBuilder)o.getBarrierDeterminationAgent(), this::setBarrierDeterminationAgent);
            merger.mergeRosetta(this.getHedgingParty(), o.getHedgingParty(), this::getOrCreateHedgingParty);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCollateral(), (RosettaModelObjectBuilder)o.getCollateral(), this::setCollateral);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDocumentation(), (RosettaModelObjectBuilder)o.getDocumentation(), this::setDocumentation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getGoverningLaw(), (RosettaModelObjectBuilder)o.getGoverningLaw(), this::setGoverningLaw);
            merger.mergeRosetta(this.getAllocations(), o.getAllocations(), this::getOrCreateAllocations);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getApprovals(), (RosettaModelObjectBuilder)o.getApprovals(), this::setApprovals);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Trade _that = this.getType().cast(o);
            if (!Objects.equals(this.tradeHeader, _that.getTradeHeader())) {
                return false;
            }
            if (!Objects.equals(this.product, _that.getProduct())) {
                return false;
            }
            if (!ListEquals.listEquals(this.otherPartyPayment, _that.getOtherPartyPayment())) {
                return false;
            }
            if (!ListEquals.listEquals(this.brokerPartyReference, _that.getBrokerPartyReference())) {
                return false;
            }
            if (!Objects.equals(this.calculationAgentModel, _that.getCalculationAgentModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.determiningParty, _that.getDeterminingParty())) {
                return false;
            }
            if (!Objects.equals(this.barrierDeterminationAgent, _that.getBarrierDeterminationAgent())) {
                return false;
            }
            if (!ListEquals.listEquals(this.hedgingParty, _that.getHedgingParty())) {
                return false;
            }
            if (!Objects.equals(this.collateral, _that.getCollateral())) {
                return false;
            }
            if (!Objects.equals(this.documentation, _that.getDocumentation())) {
                return false;
            }
            if (!Objects.equals(this.governingLaw, _that.getGoverningLaw())) {
                return false;
            }
            if (!ListEquals.listEquals(this.allocations, _that.getAllocations())) {
                return false;
            }
            if (!Objects.equals(this.id, _that.getId())) {
                return false;
            }
            return Objects.equals(this.approvals, _that.getApprovals());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.tradeHeader != null ? this.tradeHeader.hashCode() : 0);
            _result = 31 * _result + (this.product != null ? this.product.hashCode() : 0);
            _result = 31 * _result + (this.otherPartyPayment != null ? this.otherPartyPayment.hashCode() : 0);
            _result = 31 * _result + (this.brokerPartyReference != null ? this.brokerPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.calculationAgentModel != null ? this.calculationAgentModel.hashCode() : 0);
            _result = 31 * _result + (this.determiningParty != null ? this.determiningParty.hashCode() : 0);
            _result = 31 * _result + (this.barrierDeterminationAgent != null ? this.barrierDeterminationAgent.hashCode() : 0);
            _result = 31 * _result + (this.hedgingParty != null ? this.hedgingParty.hashCode() : 0);
            _result = 31 * _result + (this.collateral != null ? this.collateral.hashCode() : 0);
            _result = 31 * _result + (this.documentation != null ? this.documentation.hashCode() : 0);
            _result = 31 * _result + (this.governingLaw != null ? this.governingLaw.hashCode() : 0);
            _result = 31 * _result + (this.allocations != null ? this.allocations.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            _result = 31 * _result + (this.approvals != null ? this.approvals.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TradeBuilder {tradeHeader=" + String.valueOf(this.tradeHeader) + ", product=" + String.valueOf(this.product) + ", otherPartyPayment=" + String.valueOf(this.otherPartyPayment) + ", brokerPartyReference=" + String.valueOf(this.brokerPartyReference) + ", calculationAgentModel=" + String.valueOf(this.calculationAgentModel) + ", determiningParty=" + String.valueOf(this.determiningParty) + ", barrierDeterminationAgent=" + String.valueOf(this.barrierDeterminationAgent) + ", hedgingParty=" + String.valueOf(this.hedgingParty) + ", collateral=" + String.valueOf(this.collateral) + ", documentation=" + String.valueOf(this.documentation) + ", governingLaw=" + String.valueOf(this.governingLaw) + ", allocations=" + String.valueOf(this.allocations) + ", id=" + this.id + ", approvals=" + String.valueOf(this.approvals) + "}";
        }
    }

    public static interface TradeBuilder
    extends Trade,
    RosettaModelObjectBuilder {
        public TradeHeader.TradeHeaderBuilder getOrCreateTradeHeader();

        @Override
        public TradeHeader.TradeHeaderBuilder getTradeHeader();

        public Product.ProductBuilder getOrCreateProduct();

        @Override
        public Product.ProductBuilder getProduct();

        public Payment.PaymentBuilder getOrCreateOtherPartyPayment(int var1);

        public List<? extends Payment.PaymentBuilder> getOtherPartyPayment();

        public PartyReference.PartyReferenceBuilder getOrCreateBrokerPartyReference(int var1);

        public List<? extends PartyReference.PartyReferenceBuilder> getBrokerPartyReference();

        public CalculationAgentModel.CalculationAgentModelBuilder getOrCreateCalculationAgentModel();

        @Override
        public CalculationAgentModel.CalculationAgentModelBuilder getCalculationAgentModel();

        public PartyReference.PartyReferenceBuilder getOrCreateDeterminingParty(int var1);

        public List<? extends PartyReference.PartyReferenceBuilder> getDeterminingParty();

        public PartyReference.PartyReferenceBuilder getOrCreateBarrierDeterminationAgent();

        @Override
        public PartyReference.PartyReferenceBuilder getBarrierDeterminationAgent();

        public PartyReference.PartyReferenceBuilder getOrCreateHedgingParty(int var1);

        public List<? extends PartyReference.PartyReferenceBuilder> getHedgingParty();

        public Collateral.CollateralBuilder getOrCreateCollateral();

        @Override
        public Collateral.CollateralBuilder getCollateral();

        public Documentation.DocumentationBuilder getOrCreateDocumentation();

        @Override
        public Documentation.DocumentationBuilder getDocumentation();

        public GoverningLaw.GoverningLawBuilder getOrCreateGoverningLaw();

        @Override
        public GoverningLaw.GoverningLawBuilder getGoverningLaw();

        public Allocations.AllocationsBuilder getOrCreateAllocations(int var1);

        public List<? extends Allocations.AllocationsBuilder> getAllocations();

        public Approvals.ApprovalsBuilder getOrCreateApprovals();

        @Override
        public Approvals.ApprovalsBuilder getApprovals();

        public TradeBuilder setTradeHeader(TradeHeader var1);

        public TradeBuilder setProduct(Product var1);

        public TradeBuilder addOtherPartyPayment(Payment var1);

        public TradeBuilder addOtherPartyPayment(Payment var1, int var2);

        public TradeBuilder addOtherPartyPayment(List<? extends Payment> var1);

        public TradeBuilder setOtherPartyPayment(List<? extends Payment> var1);

        public TradeBuilder addBrokerPartyReference(PartyReference var1);

        public TradeBuilder addBrokerPartyReference(PartyReference var1, int var2);

        public TradeBuilder addBrokerPartyReference(List<? extends PartyReference> var1);

        public TradeBuilder setBrokerPartyReference(List<? extends PartyReference> var1);

        public TradeBuilder setCalculationAgentModel(CalculationAgentModel var1);

        public TradeBuilder addDeterminingParty(PartyReference var1);

        public TradeBuilder addDeterminingParty(PartyReference var1, int var2);

        public TradeBuilder addDeterminingParty(List<? extends PartyReference> var1);

        public TradeBuilder setDeterminingParty(List<? extends PartyReference> var1);

        public TradeBuilder setBarrierDeterminationAgent(PartyReference var1);

        public TradeBuilder addHedgingParty(PartyReference var1);

        public TradeBuilder addHedgingParty(PartyReference var1, int var2);

        public TradeBuilder addHedgingParty(List<? extends PartyReference> var1);

        public TradeBuilder setHedgingParty(List<? extends PartyReference> var1);

        public TradeBuilder setCollateral(Collateral var1);

        public TradeBuilder setDocumentation(Documentation var1);

        public TradeBuilder setGoverningLaw(GoverningLaw var1);

        public TradeBuilder addAllocations(Allocations var1);

        public TradeBuilder addAllocations(Allocations var1, int var2);

        public TradeBuilder addAllocations(List<? extends Allocations> var1);

        public TradeBuilder setAllocations(List<? extends Allocations> var1);

        public TradeBuilder setId(String var1);

        public TradeBuilder setApprovals(Approvals var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("tradeHeader"), processor, TradeHeader.TradeHeaderBuilder.class, this.getTradeHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("product"), processor, Product.ProductBuilder.class, this.getProduct(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("otherPartyPayment"), processor, Payment.PaymentBuilder.class, this.getOtherPartyPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("brokerPartyReference"), processor, PartyReference.PartyReferenceBuilder.class, this.getBrokerPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("calculationAgentModel"), processor, CalculationAgentModel.CalculationAgentModelBuilder.class, this.getCalculationAgentModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("determiningParty"), processor, PartyReference.PartyReferenceBuilder.class, this.getDeterminingParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("barrierDeterminationAgent"), processor, PartyReference.PartyReferenceBuilder.class, this.getBarrierDeterminationAgent(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("hedgingParty"), processor, PartyReference.PartyReferenceBuilder.class, this.getHedgingParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateral"), processor, Collateral.CollateralBuilder.class, this.getCollateral(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("documentation"), processor, Documentation.DocumentationBuilder.class, this.getDocumentation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("governingLaw"), processor, GoverningLaw.GoverningLawBuilder.class, this.getGoverningLaw(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("allocations"), processor, Allocations.AllocationsBuilder.class, this.getAllocations(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("approvals"), processor, Approvals.ApprovalsBuilder.class, this.getApprovals(), new AttributeMeta[0]);
        }

        public TradeBuilder prune();
    }

    public static class TradeImpl
    implements Trade {
        private final TradeHeader tradeHeader;
        private final Product product;
        private final List<? extends Payment> otherPartyPayment;
        private final List<? extends PartyReference> brokerPartyReference;
        private final CalculationAgentModel calculationAgentModel;
        private final List<? extends PartyReference> determiningParty;
        private final PartyReference barrierDeterminationAgent;
        private final List<? extends PartyReference> hedgingParty;
        private final Collateral collateral;
        private final Documentation documentation;
        private final GoverningLaw governingLaw;
        private final List<? extends Allocations> allocations;
        private final String id;
        private final Approvals approvals;

        protected TradeImpl(TradeBuilder builder) {
            this.tradeHeader = Optional.ofNullable(builder.getTradeHeader()).map(f -> f.build()).orElse(null);
            this.product = Optional.ofNullable(builder.getProduct()).map(f -> f.build()).orElse(null);
            this.otherPartyPayment = Optional.ofNullable(builder.getOtherPartyPayment()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.brokerPartyReference = Optional.ofNullable(builder.getBrokerPartyReference()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.calculationAgentModel = Optional.ofNullable(builder.getCalculationAgentModel()).map(f -> f.build()).orElse(null);
            this.determiningParty = Optional.ofNullable(builder.getDeterminingParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.barrierDeterminationAgent = Optional.ofNullable(builder.getBarrierDeterminationAgent()).map(f -> f.build()).orElse(null);
            this.hedgingParty = Optional.ofNullable(builder.getHedgingParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.collateral = Optional.ofNullable(builder.getCollateral()).map(f -> f.build()).orElse(null);
            this.documentation = Optional.ofNullable(builder.getDocumentation()).map(f -> f.build()).orElse(null);
            this.governingLaw = Optional.ofNullable(builder.getGoverningLaw()).map(f -> f.build()).orElse(null);
            this.allocations = Optional.ofNullable(builder.getAllocations()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.id = builder.getId();
            this.approvals = Optional.ofNullable(builder.getApprovals()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="tradeHeader")
        @RuneAttribute(value="tradeHeader")
        public TradeHeader getTradeHeader() {
            return this.tradeHeader;
        }

        @Override
        @RosettaAttribute(value="product")
        @RuneAttribute(value="product")
        public Product getProduct() {
            return this.product;
        }

        @Override
        @RosettaAttribute(value="otherPartyPayment")
        @RuneAttribute(value="otherPartyPayment")
        public List<? extends Payment> getOtherPartyPayment() {
            return this.otherPartyPayment;
        }

        @Override
        @RosettaAttribute(value="brokerPartyReference")
        @RuneAttribute(value="brokerPartyReference")
        public List<? extends PartyReference> getBrokerPartyReference() {
            return this.brokerPartyReference;
        }

        @Override
        @RosettaAttribute(value="calculationAgentModel", isRequired=true)
        @RuneAttribute(value="calculationAgentModel", isRequired=true)
        public CalculationAgentModel getCalculationAgentModel() {
            return this.calculationAgentModel;
        }

        @Override
        @RosettaAttribute(value="determiningParty")
        @RuneAttribute(value="determiningParty")
        public List<? extends PartyReference> getDeterminingParty() {
            return this.determiningParty;
        }

        @Override
        @RosettaAttribute(value="barrierDeterminationAgent")
        @RuneAttribute(value="barrierDeterminationAgent")
        public PartyReference getBarrierDeterminationAgent() {
            return this.barrierDeterminationAgent;
        }

        @Override
        @RosettaAttribute(value="hedgingParty")
        @RuneAttribute(value="hedgingParty")
        public List<? extends PartyReference> getHedgingParty() {
            return this.hedgingParty;
        }

        @Override
        @RosettaAttribute(value="collateral")
        @RuneAttribute(value="collateral")
        public Collateral getCollateral() {
            return this.collateral;
        }

        @Override
        @RosettaAttribute(value="documentation")
        @RuneAttribute(value="documentation")
        public Documentation getDocumentation() {
            return this.documentation;
        }

        @Override
        @RosettaAttribute(value="governingLaw")
        @RuneAttribute(value="governingLaw")
        public GoverningLaw getGoverningLaw() {
            return this.governingLaw;
        }

        @Override
        @RosettaAttribute(value="allocations")
        @RuneAttribute(value="allocations")
        public List<? extends Allocations> getAllocations() {
            return this.allocations;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="approvals")
        @RuneAttribute(value="approvals")
        public Approvals getApprovals() {
            return this.approvals;
        }

        @Override
        public Trade build() {
            return this;
        }

        @Override
        public TradeBuilder toBuilder() {
            TradeBuilder builder = Trade.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TradeBuilder builder) {
            Optional.ofNullable(this.getTradeHeader()).ifPresent(builder::setTradeHeader);
            Optional.ofNullable(this.getProduct()).ifPresent(builder::setProduct);
            Optional.ofNullable(this.getOtherPartyPayment()).ifPresent(builder::setOtherPartyPayment);
            Optional.ofNullable(this.getBrokerPartyReference()).ifPresent(builder::setBrokerPartyReference);
            Optional.ofNullable(this.getCalculationAgentModel()).ifPresent(builder::setCalculationAgentModel);
            Optional.ofNullable(this.getDeterminingParty()).ifPresent(builder::setDeterminingParty);
            Optional.ofNullable(this.getBarrierDeterminationAgent()).ifPresent(builder::setBarrierDeterminationAgent);
            Optional.ofNullable(this.getHedgingParty()).ifPresent(builder::setHedgingParty);
            Optional.ofNullable(this.getCollateral()).ifPresent(builder::setCollateral);
            Optional.ofNullable(this.getDocumentation()).ifPresent(builder::setDocumentation);
            Optional.ofNullable(this.getGoverningLaw()).ifPresent(builder::setGoverningLaw);
            Optional.ofNullable(this.getAllocations()).ifPresent(builder::setAllocations);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
            Optional.ofNullable(this.getApprovals()).ifPresent(builder::setApprovals);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Trade _that = this.getType().cast(o);
            if (!Objects.equals(this.tradeHeader, _that.getTradeHeader())) {
                return false;
            }
            if (!Objects.equals(this.product, _that.getProduct())) {
                return false;
            }
            if (!ListEquals.listEquals(this.otherPartyPayment, _that.getOtherPartyPayment())) {
                return false;
            }
            if (!ListEquals.listEquals(this.brokerPartyReference, _that.getBrokerPartyReference())) {
                return false;
            }
            if (!Objects.equals(this.calculationAgentModel, _that.getCalculationAgentModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.determiningParty, _that.getDeterminingParty())) {
                return false;
            }
            if (!Objects.equals(this.barrierDeterminationAgent, _that.getBarrierDeterminationAgent())) {
                return false;
            }
            if (!ListEquals.listEquals(this.hedgingParty, _that.getHedgingParty())) {
                return false;
            }
            if (!Objects.equals(this.collateral, _that.getCollateral())) {
                return false;
            }
            if (!Objects.equals(this.documentation, _that.getDocumentation())) {
                return false;
            }
            if (!Objects.equals(this.governingLaw, _that.getGoverningLaw())) {
                return false;
            }
            if (!ListEquals.listEquals(this.allocations, _that.getAllocations())) {
                return false;
            }
            if (!Objects.equals(this.id, _that.getId())) {
                return false;
            }
            return Objects.equals(this.approvals, _that.getApprovals());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.tradeHeader != null ? this.tradeHeader.hashCode() : 0);
            _result = 31 * _result + (this.product != null ? this.product.hashCode() : 0);
            _result = 31 * _result + (this.otherPartyPayment != null ? this.otherPartyPayment.hashCode() : 0);
            _result = 31 * _result + (this.brokerPartyReference != null ? this.brokerPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.calculationAgentModel != null ? this.calculationAgentModel.hashCode() : 0);
            _result = 31 * _result + (this.determiningParty != null ? this.determiningParty.hashCode() : 0);
            _result = 31 * _result + (this.barrierDeterminationAgent != null ? this.barrierDeterminationAgent.hashCode() : 0);
            _result = 31 * _result + (this.hedgingParty != null ? this.hedgingParty.hashCode() : 0);
            _result = 31 * _result + (this.collateral != null ? this.collateral.hashCode() : 0);
            _result = 31 * _result + (this.documentation != null ? this.documentation.hashCode() : 0);
            _result = 31 * _result + (this.governingLaw != null ? this.governingLaw.hashCode() : 0);
            _result = 31 * _result + (this.allocations != null ? this.allocations.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            _result = 31 * _result + (this.approvals != null ? this.approvals.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Trade {tradeHeader=" + String.valueOf(this.tradeHeader) + ", product=" + String.valueOf(this.product) + ", otherPartyPayment=" + String.valueOf(this.otherPartyPayment) + ", brokerPartyReference=" + String.valueOf(this.brokerPartyReference) + ", calculationAgentModel=" + String.valueOf(this.calculationAgentModel) + ", determiningParty=" + String.valueOf(this.determiningParty) + ", barrierDeterminationAgent=" + String.valueOf(this.barrierDeterminationAgent) + ", hedgingParty=" + String.valueOf(this.hedgingParty) + ", collateral=" + String.valueOf(this.collateral) + ", documentation=" + String.valueOf(this.documentation) + ", governingLaw=" + String.valueOf(this.governingLaw) + ", allocations=" + String.valueOf(this.allocations) + ", id=" + this.id + ", approvals=" + String.valueOf(this.approvals) + "}";
        }
    }
}

