/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.credit.event.notification;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.credit.event.notification.AffectedTransactions;
import fpml.consolidated.credit.event.notification.CreditEvent;
import fpml.consolidated.credit.event.notification.meta.CreditEventNoticeDocumentMeta;
import fpml.consolidated.shared.LegalEntity;
import fpml.consolidated.shared.PartyReference;
import fpml.consolidated.shared.Resource;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CreditEventNoticeDocument", builder=CreditEventNoticeDocumentBuilderImpl.class, version="1.2.2")
@RuneDataType(value="CreditEventNoticeDocument", model="fpml", builder=CreditEventNoticeDocumentBuilderImpl.class, version="1.2.2")
public interface CreditEventNoticeDocument
extends RosettaModelObject {
    public static final CreditEventNoticeDocumentMeta metaData = new CreditEventNoticeDocumentMeta();

    public AffectedTransactions getAffectedTransactions();

    public LegalEntity getReferenceEntity();

    public CreditEvent getCreditEvent();

    public List<? extends Resource> getPubliclyAvailableInformation();

    public PartyReference getNotifyingPartyReference();

    public PartyReference getNotifiedPartyReference();

    public ZonedDateTime getCreditEventNoticeDate();

    public ZonedDateTime getCreditEventDate();

    public CreditEventNoticeDocument build();

    public CreditEventNoticeDocumentBuilder toBuilder();

    public static CreditEventNoticeDocumentBuilder builder() {
        return new CreditEventNoticeDocumentBuilderImpl();
    }

    default public RosettaMetaData<? extends CreditEventNoticeDocument> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CreditEventNoticeDocument> getType() {
        return CreditEventNoticeDocument.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("affectedTransactions"), processor, AffectedTransactions.class, this.getAffectedTransactions(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("referenceEntity"), processor, LegalEntity.class, this.getReferenceEntity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("creditEvent"), processor, CreditEvent.class, this.getCreditEvent(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("publiclyAvailableInformation"), processor, Resource.class, this.getPubliclyAvailableInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notifyingPartyReference"), processor, PartyReference.class, this.getNotifyingPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notifiedPartyReference"), processor, PartyReference.class, this.getNotifiedPartyReference(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("creditEventNoticeDate"), ZonedDateTime.class, (Object)this.getCreditEventNoticeDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("creditEventDate"), ZonedDateTime.class, (Object)this.getCreditEventDate(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CreditEventNoticeDocumentBuilderImpl
    implements CreditEventNoticeDocumentBuilder {
        protected AffectedTransactions.AffectedTransactionsBuilder affectedTransactions;
        protected LegalEntity.LegalEntityBuilder referenceEntity;
        protected CreditEvent.CreditEventBuilder creditEvent;
        protected List<Resource.ResourceBuilder> publiclyAvailableInformation = new ArrayList<Resource.ResourceBuilder>();
        protected PartyReference.PartyReferenceBuilder notifyingPartyReference;
        protected PartyReference.PartyReferenceBuilder notifiedPartyReference;
        protected ZonedDateTime creditEventNoticeDate;
        protected ZonedDateTime creditEventDate;

        @Override
        @RosettaAttribute(value="affectedTransactions")
        @RuneAttribute(value="affectedTransactions")
        public AffectedTransactions.AffectedTransactionsBuilder getAffectedTransactions() {
            return this.affectedTransactions;
        }

        @Override
        public AffectedTransactions.AffectedTransactionsBuilder getOrCreateAffectedTransactions() {
            AffectedTransactions.AffectedTransactionsBuilder result = this.affectedTransactions != null ? this.affectedTransactions : (this.affectedTransactions = AffectedTransactions.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="referenceEntity")
        @RuneAttribute(value="referenceEntity")
        public LegalEntity.LegalEntityBuilder getReferenceEntity() {
            return this.referenceEntity;
        }

        @Override
        public LegalEntity.LegalEntityBuilder getOrCreateReferenceEntity() {
            LegalEntity.LegalEntityBuilder result = this.referenceEntity != null ? this.referenceEntity : (this.referenceEntity = LegalEntity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="creditEvent")
        @RuneAttribute(value="creditEvent")
        public CreditEvent.CreditEventBuilder getCreditEvent() {
            return this.creditEvent;
        }

        @Override
        public CreditEvent.CreditEventBuilder getOrCreateCreditEvent() {
            CreditEvent.CreditEventBuilder result = this.creditEvent != null ? this.creditEvent : (this.creditEvent = CreditEvent.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="publiclyAvailableInformation")
        @RuneAttribute(value="publiclyAvailableInformation")
        public List<? extends Resource.ResourceBuilder> getPubliclyAvailableInformation() {
            return this.publiclyAvailableInformation;
        }

        @Override
        public Resource.ResourceBuilder getOrCreatePubliclyAvailableInformation(int index) {
            if (this.publiclyAvailableInformation == null) {
                this.publiclyAvailableInformation = new ArrayList<Resource.ResourceBuilder>();
            }
            return (Resource.ResourceBuilder)this.getIndex(this.publiclyAvailableInformation, index, () -> {
                Resource.ResourceBuilder newPubliclyAvailableInformation = Resource.builder();
                return newPubliclyAvailableInformation;
            });
        }

        @Override
        @RosettaAttribute(value="notifyingPartyReference")
        @RuneAttribute(value="notifyingPartyReference")
        public PartyReference.PartyReferenceBuilder getNotifyingPartyReference() {
            return this.notifyingPartyReference;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateNotifyingPartyReference() {
            PartyReference.PartyReferenceBuilder result = this.notifyingPartyReference != null ? this.notifyingPartyReference : (this.notifyingPartyReference = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="notifiedPartyReference")
        @RuneAttribute(value="notifiedPartyReference")
        public PartyReference.PartyReferenceBuilder getNotifiedPartyReference() {
            return this.notifiedPartyReference;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateNotifiedPartyReference() {
            PartyReference.PartyReferenceBuilder result = this.notifiedPartyReference != null ? this.notifiedPartyReference : (this.notifiedPartyReference = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="creditEventNoticeDate")
        @RuneAttribute(value="creditEventNoticeDate")
        public ZonedDateTime getCreditEventNoticeDate() {
            return this.creditEventNoticeDate;
        }

        @Override
        @RosettaAttribute(value="creditEventDate")
        @RuneAttribute(value="creditEventDate")
        public ZonedDateTime getCreditEventDate() {
            return this.creditEventDate;
        }

        @Override
        @RosettaAttribute(value="affectedTransactions")
        @RuneAttribute(value="affectedTransactions")
        public CreditEventNoticeDocumentBuilder setAffectedTransactions(AffectedTransactions _affectedTransactions) {
            this.affectedTransactions = _affectedTransactions == null ? null : _affectedTransactions.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="referenceEntity")
        @RuneAttribute(value="referenceEntity")
        public CreditEventNoticeDocumentBuilder setReferenceEntity(LegalEntity _referenceEntity) {
            this.referenceEntity = _referenceEntity == null ? null : _referenceEntity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="creditEvent")
        @RuneAttribute(value="creditEvent")
        public CreditEventNoticeDocumentBuilder setCreditEvent(CreditEvent _creditEvent) {
            this.creditEvent = _creditEvent == null ? null : _creditEvent.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="publiclyAvailableInformation")
        @RuneAttribute(value="publiclyAvailableInformation")
        public CreditEventNoticeDocumentBuilder addPubliclyAvailableInformation(Resource _publiclyAvailableInformation) {
            if (_publiclyAvailableInformation != null) {
                this.publiclyAvailableInformation.add(_publiclyAvailableInformation.toBuilder());
            }
            return this;
        }

        @Override
        public CreditEventNoticeDocumentBuilder addPubliclyAvailableInformation(Resource _publiclyAvailableInformation, int idx) {
            this.getIndex(this.publiclyAvailableInformation, idx, () -> _publiclyAvailableInformation.toBuilder());
            return this;
        }

        @Override
        public CreditEventNoticeDocumentBuilder addPubliclyAvailableInformation(List<? extends Resource> publiclyAvailableInformations) {
            if (publiclyAvailableInformations != null) {
                for (Resource resource : publiclyAvailableInformations) {
                    this.publiclyAvailableInformation.add(resource.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="publiclyAvailableInformation")
        public CreditEventNoticeDocumentBuilder setPubliclyAvailableInformation(List<? extends Resource> publiclyAvailableInformations) {
            this.publiclyAvailableInformation = publiclyAvailableInformations == null ? new ArrayList<Resource.ResourceBuilder>() : (List)publiclyAvailableInformations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="notifyingPartyReference")
        @RuneAttribute(value="notifyingPartyReference")
        public CreditEventNoticeDocumentBuilder setNotifyingPartyReference(PartyReference _notifyingPartyReference) {
            this.notifyingPartyReference = _notifyingPartyReference == null ? null : _notifyingPartyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="notifiedPartyReference")
        @RuneAttribute(value="notifiedPartyReference")
        public CreditEventNoticeDocumentBuilder setNotifiedPartyReference(PartyReference _notifiedPartyReference) {
            this.notifiedPartyReference = _notifiedPartyReference == null ? null : _notifiedPartyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="creditEventNoticeDate")
        @RuneAttribute(value="creditEventNoticeDate")
        public CreditEventNoticeDocumentBuilder setCreditEventNoticeDate(ZonedDateTime _creditEventNoticeDate) {
            this.creditEventNoticeDate = _creditEventNoticeDate == null ? null : _creditEventNoticeDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="creditEventDate")
        @RuneAttribute(value="creditEventDate")
        public CreditEventNoticeDocumentBuilder setCreditEventDate(ZonedDateTime _creditEventDate) {
            this.creditEventDate = _creditEventDate == null ? null : _creditEventDate;
            return this;
        }

        @Override
        public CreditEventNoticeDocument build() {
            return new CreditEventNoticeDocumentImpl(this);
        }

        @Override
        public CreditEventNoticeDocumentBuilder toBuilder() {
            return this;
        }

        @Override
        public CreditEventNoticeDocumentBuilder prune() {
            if (this.affectedTransactions != null && !this.affectedTransactions.prune().hasData()) {
                this.affectedTransactions = null;
            }
            if (this.referenceEntity != null && !this.referenceEntity.prune().hasData()) {
                this.referenceEntity = null;
            }
            if (this.creditEvent != null && !this.creditEvent.prune().hasData()) {
                this.creditEvent = null;
            }
            this.publiclyAvailableInformation = this.publiclyAvailableInformation.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.notifyingPartyReference != null && !this.notifyingPartyReference.prune().hasData()) {
                this.notifyingPartyReference = null;
            }
            if (this.notifiedPartyReference != null && !this.notifiedPartyReference.prune().hasData()) {
                this.notifiedPartyReference = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAffectedTransactions() != null && this.getAffectedTransactions().hasData()) {
                return true;
            }
            if (this.getReferenceEntity() != null && this.getReferenceEntity().hasData()) {
                return true;
            }
            if (this.getCreditEvent() != null && this.getCreditEvent().hasData()) {
                return true;
            }
            if (this.getPubliclyAvailableInformation() != null && this.getPubliclyAvailableInformation().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getNotifyingPartyReference() != null && this.getNotifyingPartyReference().hasData()) {
                return true;
            }
            if (this.getNotifiedPartyReference() != null && this.getNotifiedPartyReference().hasData()) {
                return true;
            }
            if (this.getCreditEventNoticeDate() != null) {
                return true;
            }
            return this.getCreditEventDate() != null;
        }

        public CreditEventNoticeDocumentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CreditEventNoticeDocumentBuilder o = (CreditEventNoticeDocumentBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAffectedTransactions(), (RosettaModelObjectBuilder)o.getAffectedTransactions(), this::setAffectedTransactions);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReferenceEntity(), (RosettaModelObjectBuilder)o.getReferenceEntity(), this::setReferenceEntity);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCreditEvent(), (RosettaModelObjectBuilder)o.getCreditEvent(), this::setCreditEvent);
            merger.mergeRosetta(this.getPubliclyAvailableInformation(), o.getPubliclyAvailableInformation(), this::getOrCreatePubliclyAvailableInformation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNotifyingPartyReference(), (RosettaModelObjectBuilder)o.getNotifyingPartyReference(), this::setNotifyingPartyReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNotifiedPartyReference(), (RosettaModelObjectBuilder)o.getNotifiedPartyReference(), this::setNotifiedPartyReference);
            merger.mergeBasic((Object)this.getCreditEventNoticeDate(), (Object)o.getCreditEventNoticeDate(), this::setCreditEventNoticeDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCreditEventDate(), (Object)o.getCreditEventDate(), this::setCreditEventDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CreditEventNoticeDocument _that = this.getType().cast(o);
            if (!Objects.equals(this.affectedTransactions, _that.getAffectedTransactions())) {
                return false;
            }
            if (!Objects.equals(this.referenceEntity, _that.getReferenceEntity())) {
                return false;
            }
            if (!Objects.equals(this.creditEvent, _that.getCreditEvent())) {
                return false;
            }
            if (!ListEquals.listEquals(this.publiclyAvailableInformation, _that.getPubliclyAvailableInformation())) {
                return false;
            }
            if (!Objects.equals(this.notifyingPartyReference, _that.getNotifyingPartyReference())) {
                return false;
            }
            if (!Objects.equals(this.notifiedPartyReference, _that.getNotifiedPartyReference())) {
                return false;
            }
            if (!Objects.equals(this.creditEventNoticeDate, _that.getCreditEventNoticeDate())) {
                return false;
            }
            return Objects.equals(this.creditEventDate, _that.getCreditEventDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.affectedTransactions != null ? this.affectedTransactions.hashCode() : 0);
            _result = 31 * _result + (this.referenceEntity != null ? this.referenceEntity.hashCode() : 0);
            _result = 31 * _result + (this.creditEvent != null ? this.creditEvent.hashCode() : 0);
            _result = 31 * _result + (this.publiclyAvailableInformation != null ? this.publiclyAvailableInformation.hashCode() : 0);
            _result = 31 * _result + (this.notifyingPartyReference != null ? this.notifyingPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.notifiedPartyReference != null ? this.notifiedPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.creditEventNoticeDate != null ? this.creditEventNoticeDate.hashCode() : 0);
            _result = 31 * _result + (this.creditEventDate != null ? this.creditEventDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CreditEventNoticeDocumentBuilder {affectedTransactions=" + String.valueOf(this.affectedTransactions) + ", referenceEntity=" + String.valueOf(this.referenceEntity) + ", creditEvent=" + String.valueOf(this.creditEvent) + ", publiclyAvailableInformation=" + String.valueOf(this.publiclyAvailableInformation) + ", notifyingPartyReference=" + String.valueOf(this.notifyingPartyReference) + ", notifiedPartyReference=" + String.valueOf(this.notifiedPartyReference) + ", creditEventNoticeDate=" + String.valueOf(this.creditEventNoticeDate) + ", creditEventDate=" + String.valueOf(this.creditEventDate) + "}";
        }
    }

    public static interface CreditEventNoticeDocumentBuilder
    extends CreditEventNoticeDocument,
    RosettaModelObjectBuilder {
        public AffectedTransactions.AffectedTransactionsBuilder getOrCreateAffectedTransactions();

        @Override
        public AffectedTransactions.AffectedTransactionsBuilder getAffectedTransactions();

        public LegalEntity.LegalEntityBuilder getOrCreateReferenceEntity();

        @Override
        public LegalEntity.LegalEntityBuilder getReferenceEntity();

        public CreditEvent.CreditEventBuilder getOrCreateCreditEvent();

        @Override
        public CreditEvent.CreditEventBuilder getCreditEvent();

        public Resource.ResourceBuilder getOrCreatePubliclyAvailableInformation(int var1);

        public List<? extends Resource.ResourceBuilder> getPubliclyAvailableInformation();

        public PartyReference.PartyReferenceBuilder getOrCreateNotifyingPartyReference();

        @Override
        public PartyReference.PartyReferenceBuilder getNotifyingPartyReference();

        public PartyReference.PartyReferenceBuilder getOrCreateNotifiedPartyReference();

        @Override
        public PartyReference.PartyReferenceBuilder getNotifiedPartyReference();

        public CreditEventNoticeDocumentBuilder setAffectedTransactions(AffectedTransactions var1);

        public CreditEventNoticeDocumentBuilder setReferenceEntity(LegalEntity var1);

        public CreditEventNoticeDocumentBuilder setCreditEvent(CreditEvent var1);

        public CreditEventNoticeDocumentBuilder addPubliclyAvailableInformation(Resource var1);

        public CreditEventNoticeDocumentBuilder addPubliclyAvailableInformation(Resource var1, int var2);

        public CreditEventNoticeDocumentBuilder addPubliclyAvailableInformation(List<? extends Resource> var1);

        public CreditEventNoticeDocumentBuilder setPubliclyAvailableInformation(List<? extends Resource> var1);

        public CreditEventNoticeDocumentBuilder setNotifyingPartyReference(PartyReference var1);

        public CreditEventNoticeDocumentBuilder setNotifiedPartyReference(PartyReference var1);

        public CreditEventNoticeDocumentBuilder setCreditEventNoticeDate(ZonedDateTime var1);

        public CreditEventNoticeDocumentBuilder setCreditEventDate(ZonedDateTime var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("affectedTransactions"), processor, AffectedTransactions.AffectedTransactionsBuilder.class, this.getAffectedTransactions(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("referenceEntity"), processor, LegalEntity.LegalEntityBuilder.class, this.getReferenceEntity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("creditEvent"), processor, CreditEvent.CreditEventBuilder.class, this.getCreditEvent(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("publiclyAvailableInformation"), processor, Resource.ResourceBuilder.class, this.getPubliclyAvailableInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notifyingPartyReference"), processor, PartyReference.PartyReferenceBuilder.class, this.getNotifyingPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notifiedPartyReference"), processor, PartyReference.PartyReferenceBuilder.class, this.getNotifiedPartyReference(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("creditEventNoticeDate"), ZonedDateTime.class, (Object)this.getCreditEventNoticeDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("creditEventDate"), ZonedDateTime.class, (Object)this.getCreditEventDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CreditEventNoticeDocumentBuilder prune();
    }

    public static class CreditEventNoticeDocumentImpl
    implements CreditEventNoticeDocument {
        private final AffectedTransactions affectedTransactions;
        private final LegalEntity referenceEntity;
        private final CreditEvent creditEvent;
        private final List<? extends Resource> publiclyAvailableInformation;
        private final PartyReference notifyingPartyReference;
        private final PartyReference notifiedPartyReference;
        private final ZonedDateTime creditEventNoticeDate;
        private final ZonedDateTime creditEventDate;

        protected CreditEventNoticeDocumentImpl(CreditEventNoticeDocumentBuilder builder) {
            this.affectedTransactions = Optional.ofNullable(builder.getAffectedTransactions()).map(f -> f.build()).orElse(null);
            this.referenceEntity = Optional.ofNullable(builder.getReferenceEntity()).map(f -> f.build()).orElse(null);
            this.creditEvent = Optional.ofNullable(builder.getCreditEvent()).map(f -> f.build()).orElse(null);
            this.publiclyAvailableInformation = Optional.ofNullable(builder.getPubliclyAvailableInformation()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.notifyingPartyReference = Optional.ofNullable(builder.getNotifyingPartyReference()).map(f -> f.build()).orElse(null);
            this.notifiedPartyReference = Optional.ofNullable(builder.getNotifiedPartyReference()).map(f -> f.build()).orElse(null);
            this.creditEventNoticeDate = builder.getCreditEventNoticeDate();
            this.creditEventDate = builder.getCreditEventDate();
        }

        @Override
        @RosettaAttribute(value="affectedTransactions")
        @RuneAttribute(value="affectedTransactions")
        public AffectedTransactions getAffectedTransactions() {
            return this.affectedTransactions;
        }

        @Override
        @RosettaAttribute(value="referenceEntity")
        @RuneAttribute(value="referenceEntity")
        public LegalEntity getReferenceEntity() {
            return this.referenceEntity;
        }

        @Override
        @RosettaAttribute(value="creditEvent")
        @RuneAttribute(value="creditEvent")
        public CreditEvent getCreditEvent() {
            return this.creditEvent;
        }

        @Override
        @RosettaAttribute(value="publiclyAvailableInformation")
        @RuneAttribute(value="publiclyAvailableInformation")
        public List<? extends Resource> getPubliclyAvailableInformation() {
            return this.publiclyAvailableInformation;
        }

        @Override
        @RosettaAttribute(value="notifyingPartyReference")
        @RuneAttribute(value="notifyingPartyReference")
        public PartyReference getNotifyingPartyReference() {
            return this.notifyingPartyReference;
        }

        @Override
        @RosettaAttribute(value="notifiedPartyReference")
        @RuneAttribute(value="notifiedPartyReference")
        public PartyReference getNotifiedPartyReference() {
            return this.notifiedPartyReference;
        }

        @Override
        @RosettaAttribute(value="creditEventNoticeDate")
        @RuneAttribute(value="creditEventNoticeDate")
        public ZonedDateTime getCreditEventNoticeDate() {
            return this.creditEventNoticeDate;
        }

        @Override
        @RosettaAttribute(value="creditEventDate")
        @RuneAttribute(value="creditEventDate")
        public ZonedDateTime getCreditEventDate() {
            return this.creditEventDate;
        }

        @Override
        public CreditEventNoticeDocument build() {
            return this;
        }

        @Override
        public CreditEventNoticeDocumentBuilder toBuilder() {
            CreditEventNoticeDocumentBuilder builder = CreditEventNoticeDocument.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CreditEventNoticeDocumentBuilder builder) {
            Optional.ofNullable(this.getAffectedTransactions()).ifPresent(builder::setAffectedTransactions);
            Optional.ofNullable(this.getReferenceEntity()).ifPresent(builder::setReferenceEntity);
            Optional.ofNullable(this.getCreditEvent()).ifPresent(builder::setCreditEvent);
            Optional.ofNullable(this.getPubliclyAvailableInformation()).ifPresent(builder::setPubliclyAvailableInformation);
            Optional.ofNullable(this.getNotifyingPartyReference()).ifPresent(builder::setNotifyingPartyReference);
            Optional.ofNullable(this.getNotifiedPartyReference()).ifPresent(builder::setNotifiedPartyReference);
            Optional.ofNullable(this.getCreditEventNoticeDate()).ifPresent(builder::setCreditEventNoticeDate);
            Optional.ofNullable(this.getCreditEventDate()).ifPresent(builder::setCreditEventDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CreditEventNoticeDocument _that = this.getType().cast(o);
            if (!Objects.equals(this.affectedTransactions, _that.getAffectedTransactions())) {
                return false;
            }
            if (!Objects.equals(this.referenceEntity, _that.getReferenceEntity())) {
                return false;
            }
            if (!Objects.equals(this.creditEvent, _that.getCreditEvent())) {
                return false;
            }
            if (!ListEquals.listEquals(this.publiclyAvailableInformation, _that.getPubliclyAvailableInformation())) {
                return false;
            }
            if (!Objects.equals(this.notifyingPartyReference, _that.getNotifyingPartyReference())) {
                return false;
            }
            if (!Objects.equals(this.notifiedPartyReference, _that.getNotifiedPartyReference())) {
                return false;
            }
            if (!Objects.equals(this.creditEventNoticeDate, _that.getCreditEventNoticeDate())) {
                return false;
            }
            return Objects.equals(this.creditEventDate, _that.getCreditEventDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.affectedTransactions != null ? this.affectedTransactions.hashCode() : 0);
            _result = 31 * _result + (this.referenceEntity != null ? this.referenceEntity.hashCode() : 0);
            _result = 31 * _result + (this.creditEvent != null ? this.creditEvent.hashCode() : 0);
            _result = 31 * _result + (this.publiclyAvailableInformation != null ? this.publiclyAvailableInformation.hashCode() : 0);
            _result = 31 * _result + (this.notifyingPartyReference != null ? this.notifyingPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.notifiedPartyReference != null ? this.notifiedPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.creditEventNoticeDate != null ? this.creditEventNoticeDate.hashCode() : 0);
            _result = 31 * _result + (this.creditEventDate != null ? this.creditEventDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CreditEventNoticeDocument {affectedTransactions=" + String.valueOf(this.affectedTransactions) + ", referenceEntity=" + String.valueOf(this.referenceEntity) + ", creditEvent=" + String.valueOf(this.creditEvent) + ", publiclyAvailableInformation=" + String.valueOf(this.publiclyAvailableInformation) + ", notifyingPartyReference=" + String.valueOf(this.notifyingPartyReference) + ", notifiedPartyReference=" + String.valueOf(this.notifiedPartyReference) + ", creditEventNoticeDate=" + String.valueOf(this.creditEventNoticeDate) + ", creditEventDate=" + String.valueOf(this.creditEventDate) + "}";
        }
    }
}

