/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.com.CoalProduct;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CoalProductChoice")
@ImplementedBy(value=Default.class)
public interface CoalProductChoice
extends Validator<CoalProduct> {
    public static final String NAME = "CoalProductChoice";
    public static final String DEFINITION = "optional choice ^type, coalProductSpecifications";

    public static class NoOp
    implements CoalProductChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CoalProduct coalProduct) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CoalProductChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CoalProduct coalProduct) {
            ComparisonResult result = this.executeDataRule(coalProduct);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CoalProductChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CoalProduct", (RosettaPath)path, (String)CoalProductChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CoalProductChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CoalProduct", (RosettaPath)path, (String)CoalProductChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CoalProduct coalProduct) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)coalProduct), Arrays.asList("type", "coalProductSpecifications"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

