/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.com.EEPRiskPeriod;
import fpml.consolidated.com.meta.EEPParametersMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="EEPParameters", builder=EEPParametersBuilderImpl.class, version="1.2.2")
@RuneDataType(value="EEPParameters", model="fpml", builder=EEPParametersBuilderImpl.class, version="1.2.2")
public interface EEPParameters
extends RosettaModelObject {
    public static final EEPParametersMeta metaData = new EEPParametersMeta();

    public Boolean getEEPApplicable();

    public EEPRiskPeriod getRiskPeriod();

    public Boolean getEquivalentApplicable();

    public Boolean getPenaltyApplicable();

    public EEPParameters build();

    public EEPParametersBuilder toBuilder();

    public static EEPParametersBuilder builder() {
        return new EEPParametersBuilderImpl();
    }

    default public RosettaMetaData<? extends EEPParameters> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends EEPParameters> getType() {
        return EEPParameters.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("eEPApplicable"), Boolean.class, (Object)this.getEEPApplicable(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("riskPeriod"), processor, EEPRiskPeriod.class, this.getRiskPeriod(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("equivalentApplicable"), Boolean.class, (Object)this.getEquivalentApplicable(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("penaltyApplicable"), Boolean.class, (Object)this.getPenaltyApplicable(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class EEPParametersBuilderImpl
    implements EEPParametersBuilder {
        protected Boolean eEPApplicable;
        protected EEPRiskPeriod.EEPRiskPeriodBuilder riskPeriod;
        protected Boolean equivalentApplicable;
        protected Boolean penaltyApplicable;

        @Override
        @RosettaAttribute(value="eEPApplicable")
        @RuneAttribute(value="eEPApplicable")
        public Boolean getEEPApplicable() {
            return this.eEPApplicable;
        }

        @Override
        @RosettaAttribute(value="riskPeriod")
        @RuneAttribute(value="riskPeriod")
        public EEPRiskPeriod.EEPRiskPeriodBuilder getRiskPeriod() {
            return this.riskPeriod;
        }

        @Override
        public EEPRiskPeriod.EEPRiskPeriodBuilder getOrCreateRiskPeriod() {
            EEPRiskPeriod.EEPRiskPeriodBuilder result = this.riskPeriod != null ? this.riskPeriod : (this.riskPeriod = EEPRiskPeriod.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="equivalentApplicable")
        @RuneAttribute(value="equivalentApplicable")
        public Boolean getEquivalentApplicable() {
            return this.equivalentApplicable;
        }

        @Override
        @RosettaAttribute(value="penaltyApplicable")
        @RuneAttribute(value="penaltyApplicable")
        public Boolean getPenaltyApplicable() {
            return this.penaltyApplicable;
        }

        @Override
        @RosettaAttribute(value="eEPApplicable")
        @RuneAttribute(value="eEPApplicable")
        public EEPParametersBuilder setEEPApplicable(Boolean _eEPApplicable) {
            this.eEPApplicable = _eEPApplicable == null ? null : _eEPApplicable;
            return this;
        }

        @Override
        @RosettaAttribute(value="riskPeriod")
        @RuneAttribute(value="riskPeriod")
        public EEPParametersBuilder setRiskPeriod(EEPRiskPeriod _riskPeriod) {
            this.riskPeriod = _riskPeriod == null ? null : _riskPeriod.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="equivalentApplicable")
        @RuneAttribute(value="equivalentApplicable")
        public EEPParametersBuilder setEquivalentApplicable(Boolean _equivalentApplicable) {
            this.equivalentApplicable = _equivalentApplicable == null ? null : _equivalentApplicable;
            return this;
        }

        @Override
        @RosettaAttribute(value="penaltyApplicable")
        @RuneAttribute(value="penaltyApplicable")
        public EEPParametersBuilder setPenaltyApplicable(Boolean _penaltyApplicable) {
            this.penaltyApplicable = _penaltyApplicable == null ? null : _penaltyApplicable;
            return this;
        }

        @Override
        public EEPParameters build() {
            return new EEPParametersImpl(this);
        }

        @Override
        public EEPParametersBuilder toBuilder() {
            return this;
        }

        @Override
        public EEPParametersBuilder prune() {
            if (this.riskPeriod != null && !this.riskPeriod.prune().hasData()) {
                this.riskPeriod = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getEEPApplicable() != null) {
                return true;
            }
            if (this.getRiskPeriod() != null && this.getRiskPeriod().hasData()) {
                return true;
            }
            if (this.getEquivalentApplicable() != null) {
                return true;
            }
            return this.getPenaltyApplicable() != null;
        }

        public EEPParametersBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            EEPParametersBuilder o = (EEPParametersBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRiskPeriod(), (RosettaModelObjectBuilder)o.getRiskPeriod(), this::setRiskPeriod);
            merger.mergeBasic((Object)this.getEEPApplicable(), (Object)o.getEEPApplicable(), this::setEEPApplicable, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEquivalentApplicable(), (Object)o.getEquivalentApplicable(), this::setEquivalentApplicable, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPenaltyApplicable(), (Object)o.getPenaltyApplicable(), this::setPenaltyApplicable, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            EEPParameters _that = this.getType().cast(o);
            if (!Objects.equals(this.eEPApplicable, _that.getEEPApplicable())) {
                return false;
            }
            if (!Objects.equals(this.riskPeriod, _that.getRiskPeriod())) {
                return false;
            }
            if (!Objects.equals(this.equivalentApplicable, _that.getEquivalentApplicable())) {
                return false;
            }
            return Objects.equals(this.penaltyApplicable, _that.getPenaltyApplicable());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.eEPApplicable != null ? this.eEPApplicable.hashCode() : 0);
            _result = 31 * _result + (this.riskPeriod != null ? this.riskPeriod.hashCode() : 0);
            _result = 31 * _result + (this.equivalentApplicable != null ? this.equivalentApplicable.hashCode() : 0);
            _result = 31 * _result + (this.penaltyApplicable != null ? this.penaltyApplicable.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "EEPParametersBuilder {eEPApplicable=" + this.eEPApplicable + ", riskPeriod=" + String.valueOf(this.riskPeriod) + ", equivalentApplicable=" + this.equivalentApplicable + ", penaltyApplicable=" + this.penaltyApplicable + "}";
        }
    }

    public static interface EEPParametersBuilder
    extends EEPParameters,
    RosettaModelObjectBuilder {
        public EEPRiskPeriod.EEPRiskPeriodBuilder getOrCreateRiskPeriod();

        @Override
        public EEPRiskPeriod.EEPRiskPeriodBuilder getRiskPeriod();

        public EEPParametersBuilder setEEPApplicable(Boolean var1);

        public EEPParametersBuilder setRiskPeriod(EEPRiskPeriod var1);

        public EEPParametersBuilder setEquivalentApplicable(Boolean var1);

        public EEPParametersBuilder setPenaltyApplicable(Boolean var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("eEPApplicable"), Boolean.class, (Object)this.getEEPApplicable(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("riskPeriod"), processor, EEPRiskPeriod.EEPRiskPeriodBuilder.class, this.getRiskPeriod(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("equivalentApplicable"), Boolean.class, (Object)this.getEquivalentApplicable(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("penaltyApplicable"), Boolean.class, (Object)this.getPenaltyApplicable(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public EEPParametersBuilder prune();
    }

    public static class EEPParametersImpl
    implements EEPParameters {
        private final Boolean eEPApplicable;
        private final EEPRiskPeriod riskPeriod;
        private final Boolean equivalentApplicable;
        private final Boolean penaltyApplicable;

        protected EEPParametersImpl(EEPParametersBuilder builder) {
            this.eEPApplicable = builder.getEEPApplicable();
            this.riskPeriod = Optional.ofNullable(builder.getRiskPeriod()).map(f -> f.build()).orElse(null);
            this.equivalentApplicable = builder.getEquivalentApplicable();
            this.penaltyApplicable = builder.getPenaltyApplicable();
        }

        @Override
        @RosettaAttribute(value="eEPApplicable")
        @RuneAttribute(value="eEPApplicable")
        public Boolean getEEPApplicable() {
            return this.eEPApplicable;
        }

        @Override
        @RosettaAttribute(value="riskPeriod")
        @RuneAttribute(value="riskPeriod")
        public EEPRiskPeriod getRiskPeriod() {
            return this.riskPeriod;
        }

        @Override
        @RosettaAttribute(value="equivalentApplicable")
        @RuneAttribute(value="equivalentApplicable")
        public Boolean getEquivalentApplicable() {
            return this.equivalentApplicable;
        }

        @Override
        @RosettaAttribute(value="penaltyApplicable")
        @RuneAttribute(value="penaltyApplicable")
        public Boolean getPenaltyApplicable() {
            return this.penaltyApplicable;
        }

        @Override
        public EEPParameters build() {
            return this;
        }

        @Override
        public EEPParametersBuilder toBuilder() {
            EEPParametersBuilder builder = EEPParameters.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(EEPParametersBuilder builder) {
            Optional.ofNullable(this.getEEPApplicable()).ifPresent(builder::setEEPApplicable);
            Optional.ofNullable(this.getRiskPeriod()).ifPresent(builder::setRiskPeriod);
            Optional.ofNullable(this.getEquivalentApplicable()).ifPresent(builder::setEquivalentApplicable);
            Optional.ofNullable(this.getPenaltyApplicable()).ifPresent(builder::setPenaltyApplicable);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            EEPParameters _that = this.getType().cast(o);
            if (!Objects.equals(this.eEPApplicable, _that.getEEPApplicable())) {
                return false;
            }
            if (!Objects.equals(this.riskPeriod, _that.getRiskPeriod())) {
                return false;
            }
            if (!Objects.equals(this.equivalentApplicable, _that.getEquivalentApplicable())) {
                return false;
            }
            return Objects.equals(this.penaltyApplicable, _that.getPenaltyApplicable());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.eEPApplicable != null ? this.eEPApplicable.hashCode() : 0);
            _result = 31 * _result + (this.riskPeriod != null ? this.riskPeriod.hashCode() : 0);
            _result = 31 * _result + (this.equivalentApplicable != null ? this.equivalentApplicable.hashCode() : 0);
            _result = 31 * _result + (this.penaltyApplicable != null ? this.penaltyApplicable.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "EEPParameters {eEPApplicable=" + this.eEPApplicable + ", riskPeriod=" + String.valueOf(this.riskPeriod) + ", equivalentApplicable=" + this.equivalentApplicable + ", penaltyApplicable=" + this.penaltyApplicable + "}";
        }
    }
}

