/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.com.CommodityContentModel;
import fpml.consolidated.com.CommodityPerformanceSwapLeg;
import fpml.consolidated.com.meta.CommodityPerformanceSwapBaseMeta;
import fpml.consolidated.shared.AdjustableOrRelativeDate;
import fpml.consolidated.shared.IdentifiedCurrency;
import fpml.consolidated.shared.Product;
import fpml.consolidated.shared.ProductModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CommodityPerformanceSwapBase", builder=CommodityPerformanceSwapBaseBuilderImpl.class, version="1.2.2")
@RuneDataType(value="CommodityPerformanceSwapBase", model="fpml", builder=CommodityPerformanceSwapBaseBuilderImpl.class, version="1.2.2")
public interface CommodityPerformanceSwapBase
extends Product {
    public static final CommodityPerformanceSwapBaseMeta metaData = new CommodityPerformanceSwapBaseMeta();

    public AdjustableOrRelativeDate getEffectiveDate();

    public AdjustableOrRelativeDate getTerminationDate();

    public IdentifiedCurrency getSettlementCurrency();

    public List<? extends CommodityPerformanceSwapLeg> getCommodityPerformanceSwapLeg();

    public CommodityContentModel getCommodityContentModel();

    @Override
    public CommodityPerformanceSwapBase build();

    @Override
    public CommodityPerformanceSwapBaseBuilder toBuilder();

    public static CommodityPerformanceSwapBaseBuilder builder() {
        return new CommodityPerformanceSwapBaseBuilderImpl();
    }

    default public RosettaMetaData<? extends CommodityPerformanceSwapBase> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CommodityPerformanceSwapBase> getType() {
        return CommodityPerformanceSwapBase.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableOrRelativeDate.class, this.getEffectiveDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("terminationDate"), processor, AdjustableOrRelativeDate.class, this.getTerminationDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementCurrency"), processor, IdentifiedCurrency.class, this.getSettlementCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityPerformanceSwapLeg"), processor, CommodityPerformanceSwapLeg.class, this.getCommodityPerformanceSwapLeg(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityContentModel"), processor, CommodityContentModel.class, this.getCommodityContentModel(), new AttributeMeta[0]);
    }

    public static class CommodityPerformanceSwapBaseBuilderImpl
    extends Product.ProductBuilderImpl
    implements CommodityPerformanceSwapBaseBuilder {
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder effectiveDate;
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder terminationDate;
        protected IdentifiedCurrency.IdentifiedCurrencyBuilder settlementCurrency;
        protected List<CommodityPerformanceSwapLeg.CommodityPerformanceSwapLegBuilder> commodityPerformanceSwapLeg = new ArrayList<CommodityPerformanceSwapLeg.CommodityPerformanceSwapLegBuilder>();
        protected CommodityContentModel.CommodityContentModelBuilder commodityContentModel;

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateEffectiveDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.effectiveDate != null ? this.effectiveDate : (this.effectiveDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="terminationDate")
        @RuneAttribute(value="terminationDate")
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getTerminationDate() {
            return this.terminationDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateTerminationDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.terminationDate != null ? this.terminationDate : (this.terminationDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementCurrency")
        @RuneAttribute(value="settlementCurrency")
        public IdentifiedCurrency.IdentifiedCurrencyBuilder getSettlementCurrency() {
            return this.settlementCurrency;
        }

        @Override
        public IdentifiedCurrency.IdentifiedCurrencyBuilder getOrCreateSettlementCurrency() {
            IdentifiedCurrency.IdentifiedCurrencyBuilder result = this.settlementCurrency != null ? this.settlementCurrency : (this.settlementCurrency = IdentifiedCurrency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="commodityPerformanceSwapLeg")
        @RuneAttribute(value="commodityPerformanceSwapLeg")
        public List<? extends CommodityPerformanceSwapLeg.CommodityPerformanceSwapLegBuilder> getCommodityPerformanceSwapLeg() {
            return this.commodityPerformanceSwapLeg;
        }

        @Override
        public CommodityPerformanceSwapLeg.CommodityPerformanceSwapLegBuilder getOrCreateCommodityPerformanceSwapLeg(int index) {
            if (this.commodityPerformanceSwapLeg == null) {
                this.commodityPerformanceSwapLeg = new ArrayList<CommodityPerformanceSwapLeg.CommodityPerformanceSwapLegBuilder>();
            }
            return (CommodityPerformanceSwapLeg.CommodityPerformanceSwapLegBuilder)this.getIndex(this.commodityPerformanceSwapLeg, index, () -> {
                CommodityPerformanceSwapLeg.CommodityPerformanceSwapLegBuilder newCommodityPerformanceSwapLeg = CommodityPerformanceSwapLeg.builder();
                return newCommodityPerformanceSwapLeg;
            });
        }

        @Override
        @RosettaAttribute(value="commodityContentModel")
        @RuneAttribute(value="commodityContentModel")
        public CommodityContentModel.CommodityContentModelBuilder getCommodityContentModel() {
            return this.commodityContentModel;
        }

        @Override
        public CommodityContentModel.CommodityContentModelBuilder getOrCreateCommodityContentModel() {
            CommodityContentModel.CommodityContentModelBuilder result = this.commodityContentModel != null ? this.commodityContentModel : (this.commodityContentModel = CommodityContentModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public CommodityPerformanceSwapBaseBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public CommodityPerformanceSwapBaseBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public CommodityPerformanceSwapBaseBuilder setEffectiveDate(AdjustableOrRelativeDate _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="terminationDate")
        @RuneAttribute(value="terminationDate")
        public CommodityPerformanceSwapBaseBuilder setTerminationDate(AdjustableOrRelativeDate _terminationDate) {
            this.terminationDate = _terminationDate == null ? null : _terminationDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementCurrency")
        @RuneAttribute(value="settlementCurrency")
        public CommodityPerformanceSwapBaseBuilder setSettlementCurrency(IdentifiedCurrency _settlementCurrency) {
            this.settlementCurrency = _settlementCurrency == null ? null : _settlementCurrency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityPerformanceSwapLeg")
        @RuneAttribute(value="commodityPerformanceSwapLeg")
        public CommodityPerformanceSwapBaseBuilder addCommodityPerformanceSwapLeg(CommodityPerformanceSwapLeg _commodityPerformanceSwapLeg) {
            if (_commodityPerformanceSwapLeg != null) {
                this.commodityPerformanceSwapLeg.add(_commodityPerformanceSwapLeg.toBuilder());
            }
            return this;
        }

        @Override
        public CommodityPerformanceSwapBaseBuilder addCommodityPerformanceSwapLeg(CommodityPerformanceSwapLeg _commodityPerformanceSwapLeg, int idx) {
            this.getIndex(this.commodityPerformanceSwapLeg, idx, () -> _commodityPerformanceSwapLeg.toBuilder());
            return this;
        }

        @Override
        public CommodityPerformanceSwapBaseBuilder addCommodityPerformanceSwapLeg(List<? extends CommodityPerformanceSwapLeg> commodityPerformanceSwapLegs) {
            if (commodityPerformanceSwapLegs != null) {
                for (CommodityPerformanceSwapLeg commodityPerformanceSwapLeg : commodityPerformanceSwapLegs) {
                    this.commodityPerformanceSwapLeg.add(commodityPerformanceSwapLeg.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="commodityPerformanceSwapLeg")
        public CommodityPerformanceSwapBaseBuilder setCommodityPerformanceSwapLeg(List<? extends CommodityPerformanceSwapLeg> commodityPerformanceSwapLegs) {
            this.commodityPerformanceSwapLeg = commodityPerformanceSwapLegs == null ? new ArrayList<CommodityPerformanceSwapLeg.CommodityPerformanceSwapLegBuilder>() : (List)commodityPerformanceSwapLegs.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityContentModel")
        @RuneAttribute(value="commodityContentModel")
        public CommodityPerformanceSwapBaseBuilder setCommodityContentModel(CommodityContentModel _commodityContentModel) {
            this.commodityContentModel = _commodityContentModel == null ? null : _commodityContentModel.toBuilder();
            return this;
        }

        @Override
        public CommodityPerformanceSwapBase build() {
            return new CommodityPerformanceSwapBaseImpl(this);
        }

        @Override
        public CommodityPerformanceSwapBaseBuilder toBuilder() {
            return this;
        }

        @Override
        public CommodityPerformanceSwapBaseBuilder prune() {
            super.prune();
            if (this.effectiveDate != null && !this.effectiveDate.prune().hasData()) {
                this.effectiveDate = null;
            }
            if (this.terminationDate != null && !this.terminationDate.prune().hasData()) {
                this.terminationDate = null;
            }
            if (this.settlementCurrency != null && !this.settlementCurrency.prune().hasData()) {
                this.settlementCurrency = null;
            }
            this.commodityPerformanceSwapLeg = this.commodityPerformanceSwapLeg.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.commodityContentModel != null && !this.commodityContentModel.prune().hasData()) {
                this.commodityContentModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getEffectiveDate() != null && this.getEffectiveDate().hasData()) {
                return true;
            }
            if (this.getTerminationDate() != null && this.getTerminationDate().hasData()) {
                return true;
            }
            if (this.getSettlementCurrency() != null && this.getSettlementCurrency().hasData()) {
                return true;
            }
            if (this.getCommodityPerformanceSwapLeg() != null && this.getCommodityPerformanceSwapLeg().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getCommodityContentModel() != null && this.getCommodityContentModel().hasData();
        }

        @Override
        public CommodityPerformanceSwapBaseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CommodityPerformanceSwapBaseBuilder o = (CommodityPerformanceSwapBaseBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEffectiveDate(), (RosettaModelObjectBuilder)o.getEffectiveDate(), this::setEffectiveDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTerminationDate(), (RosettaModelObjectBuilder)o.getTerminationDate(), this::setTerminationDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementCurrency(), (RosettaModelObjectBuilder)o.getSettlementCurrency(), this::setSettlementCurrency);
            merger.mergeRosetta(this.getCommodityPerformanceSwapLeg(), o.getCommodityPerformanceSwapLeg(), this::getOrCreateCommodityPerformanceSwapLeg);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommodityContentModel(), (RosettaModelObjectBuilder)o.getCommodityContentModel(), this::setCommodityContentModel);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CommodityPerformanceSwapBase _that = (CommodityPerformanceSwapBase)this.getType().cast(o);
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.terminationDate, _that.getTerminationDate())) {
                return false;
            }
            if (!Objects.equals(this.settlementCurrency, _that.getSettlementCurrency())) {
                return false;
            }
            if (!ListEquals.listEquals(this.commodityPerformanceSwapLeg, _that.getCommodityPerformanceSwapLeg())) {
                return false;
            }
            return Objects.equals(this.commodityContentModel, _that.getCommodityContentModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.terminationDate != null ? this.terminationDate.hashCode() : 0);
            _result = 31 * _result + (this.settlementCurrency != null ? this.settlementCurrency.hashCode() : 0);
            _result = 31 * _result + (this.commodityPerformanceSwapLeg != null ? this.commodityPerformanceSwapLeg.hashCode() : 0);
            _result = 31 * _result + (this.commodityContentModel != null ? this.commodityContentModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CommodityPerformanceSwapBaseBuilder {effectiveDate=" + String.valueOf(this.effectiveDate) + ", terminationDate=" + String.valueOf(this.terminationDate) + ", settlementCurrency=" + String.valueOf(this.settlementCurrency) + ", commodityPerformanceSwapLeg=" + String.valueOf(this.commodityPerformanceSwapLeg) + ", commodityContentModel=" + String.valueOf(this.commodityContentModel) + "} " + super.toString();
        }
    }

    public static interface CommodityPerformanceSwapBaseBuilder
    extends CommodityPerformanceSwapBase,
    Product.ProductBuilder {
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateEffectiveDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getEffectiveDate();

        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateTerminationDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getTerminationDate();

        public IdentifiedCurrency.IdentifiedCurrencyBuilder getOrCreateSettlementCurrency();

        @Override
        public IdentifiedCurrency.IdentifiedCurrencyBuilder getSettlementCurrency();

        public CommodityPerformanceSwapLeg.CommodityPerformanceSwapLegBuilder getOrCreateCommodityPerformanceSwapLeg(int var1);

        public List<? extends CommodityPerformanceSwapLeg.CommodityPerformanceSwapLegBuilder> getCommodityPerformanceSwapLeg();

        public CommodityContentModel.CommodityContentModelBuilder getOrCreateCommodityContentModel();

        @Override
        public CommodityContentModel.CommodityContentModelBuilder getCommodityContentModel();

        @Override
        public CommodityPerformanceSwapBaseBuilder setProductModel(ProductModel var1);

        @Override
        public CommodityPerformanceSwapBaseBuilder setId(String var1);

        public CommodityPerformanceSwapBaseBuilder setEffectiveDate(AdjustableOrRelativeDate var1);

        public CommodityPerformanceSwapBaseBuilder setTerminationDate(AdjustableOrRelativeDate var1);

        public CommodityPerformanceSwapBaseBuilder setSettlementCurrency(IdentifiedCurrency var1);

        public CommodityPerformanceSwapBaseBuilder addCommodityPerformanceSwapLeg(CommodityPerformanceSwapLeg var1);

        public CommodityPerformanceSwapBaseBuilder addCommodityPerformanceSwapLeg(CommodityPerformanceSwapLeg var1, int var2);

        public CommodityPerformanceSwapBaseBuilder addCommodityPerformanceSwapLeg(List<? extends CommodityPerformanceSwapLeg> var1);

        public CommodityPerformanceSwapBaseBuilder setCommodityPerformanceSwapLeg(List<? extends CommodityPerformanceSwapLeg> var1);

        public CommodityPerformanceSwapBaseBuilder setCommodityContentModel(CommodityContentModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getEffectiveDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("terminationDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getTerminationDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementCurrency"), processor, IdentifiedCurrency.IdentifiedCurrencyBuilder.class, this.getSettlementCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityPerformanceSwapLeg"), processor, CommodityPerformanceSwapLeg.CommodityPerformanceSwapLegBuilder.class, this.getCommodityPerformanceSwapLeg(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityContentModel"), processor, CommodityContentModel.CommodityContentModelBuilder.class, this.getCommodityContentModel(), new AttributeMeta[0]);
        }

        @Override
        public CommodityPerformanceSwapBaseBuilder prune();
    }

    public static class CommodityPerformanceSwapBaseImpl
    extends Product.ProductImpl
    implements CommodityPerformanceSwapBase {
        private final AdjustableOrRelativeDate effectiveDate;
        private final AdjustableOrRelativeDate terminationDate;
        private final IdentifiedCurrency settlementCurrency;
        private final List<? extends CommodityPerformanceSwapLeg> commodityPerformanceSwapLeg;
        private final CommodityContentModel commodityContentModel;

        protected CommodityPerformanceSwapBaseImpl(CommodityPerformanceSwapBaseBuilder builder) {
            super(builder);
            this.effectiveDate = Optional.ofNullable(builder.getEffectiveDate()).map(f -> f.build()).orElse(null);
            this.terminationDate = Optional.ofNullable(builder.getTerminationDate()).map(f -> f.build()).orElse(null);
            this.settlementCurrency = Optional.ofNullable(builder.getSettlementCurrency()).map(f -> f.build()).orElse(null);
            this.commodityPerformanceSwapLeg = Optional.ofNullable(builder.getCommodityPerformanceSwapLeg()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.commodityContentModel = Optional.ofNullable(builder.getCommodityContentModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public AdjustableOrRelativeDate getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="terminationDate")
        @RuneAttribute(value="terminationDate")
        public AdjustableOrRelativeDate getTerminationDate() {
            return this.terminationDate;
        }

        @Override
        @RosettaAttribute(value="settlementCurrency")
        @RuneAttribute(value="settlementCurrency")
        public IdentifiedCurrency getSettlementCurrency() {
            return this.settlementCurrency;
        }

        @Override
        @RosettaAttribute(value="commodityPerformanceSwapLeg")
        @RuneAttribute(value="commodityPerformanceSwapLeg")
        public List<? extends CommodityPerformanceSwapLeg> getCommodityPerformanceSwapLeg() {
            return this.commodityPerformanceSwapLeg;
        }

        @Override
        @RosettaAttribute(value="commodityContentModel")
        @RuneAttribute(value="commodityContentModel")
        public CommodityContentModel getCommodityContentModel() {
            return this.commodityContentModel;
        }

        @Override
        public CommodityPerformanceSwapBase build() {
            return this;
        }

        @Override
        public CommodityPerformanceSwapBaseBuilder toBuilder() {
            CommodityPerformanceSwapBaseBuilder builder = CommodityPerformanceSwapBase.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommodityPerformanceSwapBaseBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDate);
            Optional.ofNullable(this.getTerminationDate()).ifPresent(builder::setTerminationDate);
            Optional.ofNullable(this.getSettlementCurrency()).ifPresent(builder::setSettlementCurrency);
            Optional.ofNullable(this.getCommodityPerformanceSwapLeg()).ifPresent(builder::setCommodityPerformanceSwapLeg);
            Optional.ofNullable(this.getCommodityContentModel()).ifPresent(builder::setCommodityContentModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CommodityPerformanceSwapBase _that = (CommodityPerformanceSwapBase)this.getType().cast(o);
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.terminationDate, _that.getTerminationDate())) {
                return false;
            }
            if (!Objects.equals(this.settlementCurrency, _that.getSettlementCurrency())) {
                return false;
            }
            if (!ListEquals.listEquals(this.commodityPerformanceSwapLeg, _that.getCommodityPerformanceSwapLeg())) {
                return false;
            }
            return Objects.equals(this.commodityContentModel, _that.getCommodityContentModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.terminationDate != null ? this.terminationDate.hashCode() : 0);
            _result = 31 * _result + (this.settlementCurrency != null ? this.settlementCurrency.hashCode() : 0);
            _result = 31 * _result + (this.commodityPerformanceSwapLeg != null ? this.commodityPerformanceSwapLeg.hashCode() : 0);
            _result = 31 * _result + (this.commodityContentModel != null ? this.commodityContentModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CommodityPerformanceSwapBase {effectiveDate=" + String.valueOf(this.effectiveDate) + ", terminationDate=" + String.valueOf(this.terminationDate) + ", settlementCurrency=" + String.valueOf(this.settlementCurrency) + ", commodityPerformanceSwapLeg=" + String.valueOf(this.commodityPerformanceSwapLeg) + ", commodityContentModel=" + String.valueOf(this.commodityContentModel) + "} " + super.toString();
        }
    }
}

