/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.cd;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.cd.InitialPayment;
import fpml.consolidated.cd.PeriodicPayment;
import fpml.consolidated.cd.SinglePayment;
import fpml.consolidated.cd.meta.FeeLegSequenceMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FeeLegSequence", builder=FeeLegSequenceBuilderImpl.class, version="1.2.2")
@RuneDataType(value="FeeLegSequence", model="fpml", builder=FeeLegSequenceBuilderImpl.class, version="1.2.2")
public interface FeeLegSequence
extends RosettaModelObject {
    public static final FeeLegSequenceMeta metaData = new FeeLegSequenceMeta();

    public InitialPayment getInitialPayment();

    public List<? extends SinglePayment> getSinglePayment();

    public PeriodicPayment getPeriodicPayment();

    public FeeLegSequence build();

    public FeeLegSequenceBuilder toBuilder();

    public static FeeLegSequenceBuilder builder() {
        return new FeeLegSequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends FeeLegSequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FeeLegSequence> getType() {
        return FeeLegSequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("initialPayment"), processor, InitialPayment.class, this.getInitialPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("singlePayment"), processor, SinglePayment.class, this.getSinglePayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("periodicPayment"), processor, PeriodicPayment.class, this.getPeriodicPayment(), new AttributeMeta[0]);
    }

    public static class FeeLegSequenceBuilderImpl
    implements FeeLegSequenceBuilder {
        protected InitialPayment.InitialPaymentBuilder initialPayment;
        protected List<SinglePayment.SinglePaymentBuilder> singlePayment = new ArrayList<SinglePayment.SinglePaymentBuilder>();
        protected PeriodicPayment.PeriodicPaymentBuilder periodicPayment;

        @Override
        @RosettaAttribute(value="initialPayment")
        @RuneAttribute(value="initialPayment")
        public InitialPayment.InitialPaymentBuilder getInitialPayment() {
            return this.initialPayment;
        }

        @Override
        public InitialPayment.InitialPaymentBuilder getOrCreateInitialPayment() {
            InitialPayment.InitialPaymentBuilder result = this.initialPayment != null ? this.initialPayment : (this.initialPayment = InitialPayment.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="singlePayment")
        @RuneAttribute(value="singlePayment")
        public List<? extends SinglePayment.SinglePaymentBuilder> getSinglePayment() {
            return this.singlePayment;
        }

        @Override
        public SinglePayment.SinglePaymentBuilder getOrCreateSinglePayment(int index) {
            if (this.singlePayment == null) {
                this.singlePayment = new ArrayList<SinglePayment.SinglePaymentBuilder>();
            }
            return (SinglePayment.SinglePaymentBuilder)this.getIndex(this.singlePayment, index, () -> {
                SinglePayment.SinglePaymentBuilder newSinglePayment = SinglePayment.builder();
                return newSinglePayment;
            });
        }

        @Override
        @RosettaAttribute(value="periodicPayment")
        @RuneAttribute(value="periodicPayment")
        public PeriodicPayment.PeriodicPaymentBuilder getPeriodicPayment() {
            return this.periodicPayment;
        }

        @Override
        public PeriodicPayment.PeriodicPaymentBuilder getOrCreatePeriodicPayment() {
            PeriodicPayment.PeriodicPaymentBuilder result = this.periodicPayment != null ? this.periodicPayment : (this.periodicPayment = PeriodicPayment.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="initialPayment")
        @RuneAttribute(value="initialPayment")
        public FeeLegSequenceBuilder setInitialPayment(InitialPayment _initialPayment) {
            this.initialPayment = _initialPayment == null ? null : _initialPayment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="singlePayment")
        @RuneAttribute(value="singlePayment")
        public FeeLegSequenceBuilder addSinglePayment(SinglePayment _singlePayment) {
            if (_singlePayment != null) {
                this.singlePayment.add(_singlePayment.toBuilder());
            }
            return this;
        }

        @Override
        public FeeLegSequenceBuilder addSinglePayment(SinglePayment _singlePayment, int idx) {
            this.getIndex(this.singlePayment, idx, () -> _singlePayment.toBuilder());
            return this;
        }

        @Override
        public FeeLegSequenceBuilder addSinglePayment(List<? extends SinglePayment> singlePayments) {
            if (singlePayments != null) {
                for (SinglePayment singlePayment : singlePayments) {
                    this.singlePayment.add(singlePayment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="singlePayment")
        public FeeLegSequenceBuilder setSinglePayment(List<? extends SinglePayment> singlePayments) {
            this.singlePayment = singlePayments == null ? new ArrayList<SinglePayment.SinglePaymentBuilder>() : (List)singlePayments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="periodicPayment")
        @RuneAttribute(value="periodicPayment")
        public FeeLegSequenceBuilder setPeriodicPayment(PeriodicPayment _periodicPayment) {
            this.periodicPayment = _periodicPayment == null ? null : _periodicPayment.toBuilder();
            return this;
        }

        @Override
        public FeeLegSequence build() {
            return new FeeLegSequenceImpl(this);
        }

        @Override
        public FeeLegSequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public FeeLegSequenceBuilder prune() {
            if (this.initialPayment != null && !this.initialPayment.prune().hasData()) {
                this.initialPayment = null;
            }
            this.singlePayment = this.singlePayment.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.periodicPayment != null && !this.periodicPayment.prune().hasData()) {
                this.periodicPayment = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getInitialPayment() != null && this.getInitialPayment().hasData()) {
                return true;
            }
            if (this.getSinglePayment() != null && this.getSinglePayment().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getPeriodicPayment() != null && this.getPeriodicPayment().hasData();
        }

        public FeeLegSequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FeeLegSequenceBuilder o = (FeeLegSequenceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInitialPayment(), (RosettaModelObjectBuilder)o.getInitialPayment(), this::setInitialPayment);
            merger.mergeRosetta(this.getSinglePayment(), o.getSinglePayment(), this::getOrCreateSinglePayment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPeriodicPayment(), (RosettaModelObjectBuilder)o.getPeriodicPayment(), this::setPeriodicPayment);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FeeLegSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.initialPayment, _that.getInitialPayment())) {
                return false;
            }
            if (!ListEquals.listEquals(this.singlePayment, _that.getSinglePayment())) {
                return false;
            }
            return Objects.equals(this.periodicPayment, _that.getPeriodicPayment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.initialPayment != null ? this.initialPayment.hashCode() : 0);
            _result = 31 * _result + (this.singlePayment != null ? this.singlePayment.hashCode() : 0);
            _result = 31 * _result + (this.periodicPayment != null ? this.periodicPayment.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FeeLegSequenceBuilder {initialPayment=" + String.valueOf(this.initialPayment) + ", singlePayment=" + String.valueOf(this.singlePayment) + ", periodicPayment=" + String.valueOf(this.periodicPayment) + "}";
        }
    }

    public static interface FeeLegSequenceBuilder
    extends FeeLegSequence,
    RosettaModelObjectBuilder {
        public InitialPayment.InitialPaymentBuilder getOrCreateInitialPayment();

        @Override
        public InitialPayment.InitialPaymentBuilder getInitialPayment();

        public SinglePayment.SinglePaymentBuilder getOrCreateSinglePayment(int var1);

        public List<? extends SinglePayment.SinglePaymentBuilder> getSinglePayment();

        public PeriodicPayment.PeriodicPaymentBuilder getOrCreatePeriodicPayment();

        @Override
        public PeriodicPayment.PeriodicPaymentBuilder getPeriodicPayment();

        public FeeLegSequenceBuilder setInitialPayment(InitialPayment var1);

        public FeeLegSequenceBuilder addSinglePayment(SinglePayment var1);

        public FeeLegSequenceBuilder addSinglePayment(SinglePayment var1, int var2);

        public FeeLegSequenceBuilder addSinglePayment(List<? extends SinglePayment> var1);

        public FeeLegSequenceBuilder setSinglePayment(List<? extends SinglePayment> var1);

        public FeeLegSequenceBuilder setPeriodicPayment(PeriodicPayment var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("initialPayment"), processor, InitialPayment.InitialPaymentBuilder.class, this.getInitialPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("singlePayment"), processor, SinglePayment.SinglePaymentBuilder.class, this.getSinglePayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("periodicPayment"), processor, PeriodicPayment.PeriodicPaymentBuilder.class, this.getPeriodicPayment(), new AttributeMeta[0]);
        }

        public FeeLegSequenceBuilder prune();
    }

    public static class FeeLegSequenceImpl
    implements FeeLegSequence {
        private final InitialPayment initialPayment;
        private final List<? extends SinglePayment> singlePayment;
        private final PeriodicPayment periodicPayment;

        protected FeeLegSequenceImpl(FeeLegSequenceBuilder builder) {
            this.initialPayment = Optional.ofNullable(builder.getInitialPayment()).map(f -> f.build()).orElse(null);
            this.singlePayment = Optional.ofNullable(builder.getSinglePayment()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.periodicPayment = Optional.ofNullable(builder.getPeriodicPayment()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="initialPayment")
        @RuneAttribute(value="initialPayment")
        public InitialPayment getInitialPayment() {
            return this.initialPayment;
        }

        @Override
        @RosettaAttribute(value="singlePayment")
        @RuneAttribute(value="singlePayment")
        public List<? extends SinglePayment> getSinglePayment() {
            return this.singlePayment;
        }

        @Override
        @RosettaAttribute(value="periodicPayment")
        @RuneAttribute(value="periodicPayment")
        public PeriodicPayment getPeriodicPayment() {
            return this.periodicPayment;
        }

        @Override
        public FeeLegSequence build() {
            return this;
        }

        @Override
        public FeeLegSequenceBuilder toBuilder() {
            FeeLegSequenceBuilder builder = FeeLegSequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FeeLegSequenceBuilder builder) {
            Optional.ofNullable(this.getInitialPayment()).ifPresent(builder::setInitialPayment);
            Optional.ofNullable(this.getSinglePayment()).ifPresent(builder::setSinglePayment);
            Optional.ofNullable(this.getPeriodicPayment()).ifPresent(builder::setPeriodicPayment);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FeeLegSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.initialPayment, _that.getInitialPayment())) {
                return false;
            }
            if (!ListEquals.listEquals(this.singlePayment, _that.getSinglePayment())) {
                return false;
            }
            return Objects.equals(this.periodicPayment, _that.getPeriodicPayment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.initialPayment != null ? this.initialPayment.hashCode() : 0);
            _result = 31 * _result + (this.singlePayment != null ? this.singlePayment.hashCode() : 0);
            _result = 31 * _result + (this.periodicPayment != null ? this.periodicPayment.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FeeLegSequence {initialPayment=" + String.valueOf(this.initialPayment) + ", singlePayment=" + String.valueOf(this.singlePayment) + ", periodicPayment=" + String.valueOf(this.periodicPayment) + "}";
        }
    }
}

