/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.business.events.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.business.events.OptionEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="OptionEventChoice1")
@ImplementedBy(value=Default.class)
public interface OptionEventChoice1
extends Validator<OptionEvent> {
    public static final String NAME = "OptionEventChoice1";
    public static final String DEFINITION = "optional choice knockIn, knockOut , touch , noTouch";

    public static class NoOp
    implements OptionEventChoice1 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, OptionEvent optionEvent) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements OptionEventChoice1 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, OptionEvent optionEvent) {
            ComparisonResult result = this.executeDataRule(optionEvent);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)OptionEventChoice1.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"OptionEvent", (RosettaPath)path, (String)OptionEventChoice1.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)OptionEventChoice1.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"OptionEvent", (RosettaPath)path, (String)OptionEventChoice1.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(OptionEvent optionEvent) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)optionEvent), Arrays.asList("knockIn", "knockOut", "touch", "noTouch"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

