/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.business.events;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.business.events.PackageHeader;
import fpml.consolidated.business.events.TradeReferenceInformationModel;
import fpml.consolidated.business.events.meta.TradePackageMeta;
import fpml.consolidated.doc.Approvals;
import fpml.consolidated.doc.Trade;
import fpml.consolidated.doc.TradeIdentifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="TradePackage", builder=TradePackageBuilderImpl.class, version="1.2.2")
@RuneDataType(value="TradePackage", model="fpml", builder=TradePackageBuilderImpl.class, version="1.2.2")
public interface TradePackage
extends RosettaModelObject {
    public static final TradePackageMeta metaData = new TradePackageMeta();

    public PackageHeader getPackageHeader();

    public List<? extends Trade> getTrade();

    public List<? extends TradeReferenceInformationModel> getTradeReferenceInformationModel();

    public List<? extends TradeIdentifier> getTradeIdentifier();

    public Approvals getApprovals();

    public TradePackage build();

    public TradePackageBuilder toBuilder();

    public static TradePackageBuilder builder() {
        return new TradePackageBuilderImpl();
    }

    default public RosettaMetaData<? extends TradePackage> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends TradePackage> getType() {
        return TradePackage.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("packageHeader"), processor, PackageHeader.class, this.getPackageHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("trade"), processor, Trade.class, this.getTrade(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeReferenceInformationModel"), processor, TradeReferenceInformationModel.class, this.getTradeReferenceInformationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeIdentifier"), processor, TradeIdentifier.class, this.getTradeIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("approvals"), processor, Approvals.class, this.getApprovals(), new AttributeMeta[0]);
    }

    public static class TradePackageBuilderImpl
    implements TradePackageBuilder {
        protected PackageHeader.PackageHeaderBuilder packageHeader;
        protected List<Trade.TradeBuilder> trade = new ArrayList<Trade.TradeBuilder>();
        protected List<TradeReferenceInformationModel.TradeReferenceInformationModelBuilder> tradeReferenceInformationModel = new ArrayList<TradeReferenceInformationModel.TradeReferenceInformationModelBuilder>();
        protected List<TradeIdentifier.TradeIdentifierBuilder> tradeIdentifier = new ArrayList<TradeIdentifier.TradeIdentifierBuilder>();
        protected Approvals.ApprovalsBuilder approvals;

        @Override
        @RosettaAttribute(value="packageHeader")
        @RuneAttribute(value="packageHeader")
        public PackageHeader.PackageHeaderBuilder getPackageHeader() {
            return this.packageHeader;
        }

        @Override
        public PackageHeader.PackageHeaderBuilder getOrCreatePackageHeader() {
            PackageHeader.PackageHeaderBuilder result = this.packageHeader != null ? this.packageHeader : (this.packageHeader = PackageHeader.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="trade")
        @RuneAttribute(value="trade")
        public List<? extends Trade.TradeBuilder> getTrade() {
            return this.trade;
        }

        @Override
        public Trade.TradeBuilder getOrCreateTrade(int index) {
            if (this.trade == null) {
                this.trade = new ArrayList<Trade.TradeBuilder>();
            }
            return (Trade.TradeBuilder)this.getIndex(this.trade, index, () -> {
                Trade.TradeBuilder newTrade = Trade.builder();
                return newTrade;
            });
        }

        @Override
        @RosettaAttribute(value="tradeReferenceInformationModel")
        @RuneAttribute(value="tradeReferenceInformationModel")
        public List<? extends TradeReferenceInformationModel.TradeReferenceInformationModelBuilder> getTradeReferenceInformationModel() {
            return this.tradeReferenceInformationModel;
        }

        @Override
        public TradeReferenceInformationModel.TradeReferenceInformationModelBuilder getOrCreateTradeReferenceInformationModel(int index) {
            if (this.tradeReferenceInformationModel == null) {
                this.tradeReferenceInformationModel = new ArrayList<TradeReferenceInformationModel.TradeReferenceInformationModelBuilder>();
            }
            return (TradeReferenceInformationModel.TradeReferenceInformationModelBuilder)this.getIndex(this.tradeReferenceInformationModel, index, () -> {
                TradeReferenceInformationModel.TradeReferenceInformationModelBuilder newTradeReferenceInformationModel = TradeReferenceInformationModel.builder();
                return newTradeReferenceInformationModel;
            });
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public List<? extends TradeIdentifier.TradeIdentifierBuilder> getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        public TradeIdentifier.TradeIdentifierBuilder getOrCreateTradeIdentifier(int index) {
            if (this.tradeIdentifier == null) {
                this.tradeIdentifier = new ArrayList<TradeIdentifier.TradeIdentifierBuilder>();
            }
            return (TradeIdentifier.TradeIdentifierBuilder)this.getIndex(this.tradeIdentifier, index, () -> {
                TradeIdentifier.TradeIdentifierBuilder newTradeIdentifier = TradeIdentifier.builder();
                return newTradeIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="approvals")
        @RuneAttribute(value="approvals")
        public Approvals.ApprovalsBuilder getApprovals() {
            return this.approvals;
        }

        @Override
        public Approvals.ApprovalsBuilder getOrCreateApprovals() {
            Approvals.ApprovalsBuilder result = this.approvals != null ? this.approvals : (this.approvals = Approvals.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="packageHeader")
        @RuneAttribute(value="packageHeader")
        public TradePackageBuilder setPackageHeader(PackageHeader _packageHeader) {
            this.packageHeader = _packageHeader == null ? null : _packageHeader.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="trade")
        @RuneAttribute(value="trade")
        public TradePackageBuilder addTrade(Trade _trade) {
            if (_trade != null) {
                this.trade.add(_trade.toBuilder());
            }
            return this;
        }

        @Override
        public TradePackageBuilder addTrade(Trade _trade, int idx) {
            this.getIndex(this.trade, idx, () -> _trade.toBuilder());
            return this;
        }

        @Override
        public TradePackageBuilder addTrade(List<? extends Trade> trades) {
            if (trades != null) {
                for (Trade trade : trades) {
                    this.trade.add(trade.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="trade")
        public TradePackageBuilder setTrade(List<? extends Trade> trades) {
            this.trade = trades == null ? new ArrayList<Trade.TradeBuilder>() : (List)trades.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeReferenceInformationModel")
        @RuneAttribute(value="tradeReferenceInformationModel")
        public TradePackageBuilder addTradeReferenceInformationModel(TradeReferenceInformationModel _tradeReferenceInformationModel) {
            if (_tradeReferenceInformationModel != null) {
                this.tradeReferenceInformationModel.add(_tradeReferenceInformationModel.toBuilder());
            }
            return this;
        }

        @Override
        public TradePackageBuilder addTradeReferenceInformationModel(TradeReferenceInformationModel _tradeReferenceInformationModel, int idx) {
            this.getIndex(this.tradeReferenceInformationModel, idx, () -> _tradeReferenceInformationModel.toBuilder());
            return this;
        }

        @Override
        public TradePackageBuilder addTradeReferenceInformationModel(List<? extends TradeReferenceInformationModel> tradeReferenceInformationModels) {
            if (tradeReferenceInformationModels != null) {
                for (TradeReferenceInformationModel tradeReferenceInformationModel : tradeReferenceInformationModels) {
                    this.tradeReferenceInformationModel.add(tradeReferenceInformationModel.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradeReferenceInformationModel")
        public TradePackageBuilder setTradeReferenceInformationModel(List<? extends TradeReferenceInformationModel> tradeReferenceInformationModels) {
            this.tradeReferenceInformationModel = tradeReferenceInformationModels == null ? new ArrayList<TradeReferenceInformationModel.TradeReferenceInformationModelBuilder>() : (List)tradeReferenceInformationModels.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public TradePackageBuilder addTradeIdentifier(TradeIdentifier _tradeIdentifier) {
            if (_tradeIdentifier != null) {
                this.tradeIdentifier.add(_tradeIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public TradePackageBuilder addTradeIdentifier(TradeIdentifier _tradeIdentifier, int idx) {
            this.getIndex(this.tradeIdentifier, idx, () -> _tradeIdentifier.toBuilder());
            return this;
        }

        @Override
        public TradePackageBuilder addTradeIdentifier(List<? extends TradeIdentifier> tradeIdentifiers) {
            if (tradeIdentifiers != null) {
                for (TradeIdentifier tradeIdentifier : tradeIdentifiers) {
                    this.tradeIdentifier.add(tradeIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradeIdentifier")
        public TradePackageBuilder setTradeIdentifier(List<? extends TradeIdentifier> tradeIdentifiers) {
            this.tradeIdentifier = tradeIdentifiers == null ? new ArrayList<TradeIdentifier.TradeIdentifierBuilder>() : (List)tradeIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="approvals")
        @RuneAttribute(value="approvals")
        public TradePackageBuilder setApprovals(Approvals _approvals) {
            this.approvals = _approvals == null ? null : _approvals.toBuilder();
            return this;
        }

        @Override
        public TradePackage build() {
            return new TradePackageImpl(this);
        }

        @Override
        public TradePackageBuilder toBuilder() {
            return this;
        }

        @Override
        public TradePackageBuilder prune() {
            if (this.packageHeader != null && !this.packageHeader.prune().hasData()) {
                this.packageHeader = null;
            }
            this.trade = this.trade.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.tradeReferenceInformationModel = this.tradeReferenceInformationModel.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.tradeIdentifier = this.tradeIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.approvals != null && !this.approvals.prune().hasData()) {
                this.approvals = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPackageHeader() != null && this.getPackageHeader().hasData()) {
                return true;
            }
            if (this.getTrade() != null && this.getTrade().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getTradeReferenceInformationModel() != null && this.getTradeReferenceInformationModel().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getTradeIdentifier() != null && this.getTradeIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getApprovals() != null && this.getApprovals().hasData();
        }

        public TradePackageBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TradePackageBuilder o = (TradePackageBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPackageHeader(), (RosettaModelObjectBuilder)o.getPackageHeader(), this::setPackageHeader);
            merger.mergeRosetta(this.getTrade(), o.getTrade(), this::getOrCreateTrade);
            merger.mergeRosetta(this.getTradeReferenceInformationModel(), o.getTradeReferenceInformationModel(), this::getOrCreateTradeReferenceInformationModel);
            merger.mergeRosetta(this.getTradeIdentifier(), o.getTradeIdentifier(), this::getOrCreateTradeIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getApprovals(), (RosettaModelObjectBuilder)o.getApprovals(), this::setApprovals);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TradePackage _that = this.getType().cast(o);
            if (!Objects.equals(this.packageHeader, _that.getPackageHeader())) {
                return false;
            }
            if (!ListEquals.listEquals(this.trade, _that.getTrade())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradeReferenceInformationModel, _that.getTradeReferenceInformationModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradeIdentifier, _that.getTradeIdentifier())) {
                return false;
            }
            return Objects.equals(this.approvals, _that.getApprovals());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.packageHeader != null ? this.packageHeader.hashCode() : 0);
            _result = 31 * _result + (this.trade != null ? this.trade.hashCode() : 0);
            _result = 31 * _result + (this.tradeReferenceInformationModel != null ? this.tradeReferenceInformationModel.hashCode() : 0);
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.approvals != null ? this.approvals.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TradePackageBuilder {packageHeader=" + String.valueOf(this.packageHeader) + ", trade=" + String.valueOf(this.trade) + ", tradeReferenceInformationModel=" + String.valueOf(this.tradeReferenceInformationModel) + ", tradeIdentifier=" + String.valueOf(this.tradeIdentifier) + ", approvals=" + String.valueOf(this.approvals) + "}";
        }
    }

    public static interface TradePackageBuilder
    extends TradePackage,
    RosettaModelObjectBuilder {
        public PackageHeader.PackageHeaderBuilder getOrCreatePackageHeader();

        @Override
        public PackageHeader.PackageHeaderBuilder getPackageHeader();

        public Trade.TradeBuilder getOrCreateTrade(int var1);

        public List<? extends Trade.TradeBuilder> getTrade();

        public TradeReferenceInformationModel.TradeReferenceInformationModelBuilder getOrCreateTradeReferenceInformationModel(int var1);

        public List<? extends TradeReferenceInformationModel.TradeReferenceInformationModelBuilder> getTradeReferenceInformationModel();

        public TradeIdentifier.TradeIdentifierBuilder getOrCreateTradeIdentifier(int var1);

        public List<? extends TradeIdentifier.TradeIdentifierBuilder> getTradeIdentifier();

        public Approvals.ApprovalsBuilder getOrCreateApprovals();

        @Override
        public Approvals.ApprovalsBuilder getApprovals();

        public TradePackageBuilder setPackageHeader(PackageHeader var1);

        public TradePackageBuilder addTrade(Trade var1);

        public TradePackageBuilder addTrade(Trade var1, int var2);

        public TradePackageBuilder addTrade(List<? extends Trade> var1);

        public TradePackageBuilder setTrade(List<? extends Trade> var1);

        public TradePackageBuilder addTradeReferenceInformationModel(TradeReferenceInformationModel var1);

        public TradePackageBuilder addTradeReferenceInformationModel(TradeReferenceInformationModel var1, int var2);

        public TradePackageBuilder addTradeReferenceInformationModel(List<? extends TradeReferenceInformationModel> var1);

        public TradePackageBuilder setTradeReferenceInformationModel(List<? extends TradeReferenceInformationModel> var1);

        public TradePackageBuilder addTradeIdentifier(TradeIdentifier var1);

        public TradePackageBuilder addTradeIdentifier(TradeIdentifier var1, int var2);

        public TradePackageBuilder addTradeIdentifier(List<? extends TradeIdentifier> var1);

        public TradePackageBuilder setTradeIdentifier(List<? extends TradeIdentifier> var1);

        public TradePackageBuilder setApprovals(Approvals var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("packageHeader"), processor, PackageHeader.PackageHeaderBuilder.class, this.getPackageHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("trade"), processor, Trade.TradeBuilder.class, this.getTrade(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeReferenceInformationModel"), processor, TradeReferenceInformationModel.TradeReferenceInformationModelBuilder.class, this.getTradeReferenceInformationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeIdentifier"), processor, TradeIdentifier.TradeIdentifierBuilder.class, this.getTradeIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("approvals"), processor, Approvals.ApprovalsBuilder.class, this.getApprovals(), new AttributeMeta[0]);
        }

        public TradePackageBuilder prune();
    }

    public static class TradePackageImpl
    implements TradePackage {
        private final PackageHeader packageHeader;
        private final List<? extends Trade> trade;
        private final List<? extends TradeReferenceInformationModel> tradeReferenceInformationModel;
        private final List<? extends TradeIdentifier> tradeIdentifier;
        private final Approvals approvals;

        protected TradePackageImpl(TradePackageBuilder builder) {
            this.packageHeader = Optional.ofNullable(builder.getPackageHeader()).map(f -> f.build()).orElse(null);
            this.trade = Optional.ofNullable(builder.getTrade()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.tradeReferenceInformationModel = Optional.ofNullable(builder.getTradeReferenceInformationModel()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.tradeIdentifier = Optional.ofNullable(builder.getTradeIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.approvals = Optional.ofNullable(builder.getApprovals()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="packageHeader")
        @RuneAttribute(value="packageHeader")
        public PackageHeader getPackageHeader() {
            return this.packageHeader;
        }

        @Override
        @RosettaAttribute(value="trade")
        @RuneAttribute(value="trade")
        public List<? extends Trade> getTrade() {
            return this.trade;
        }

        @Override
        @RosettaAttribute(value="tradeReferenceInformationModel")
        @RuneAttribute(value="tradeReferenceInformationModel")
        public List<? extends TradeReferenceInformationModel> getTradeReferenceInformationModel() {
            return this.tradeReferenceInformationModel;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public List<? extends TradeIdentifier> getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        @RosettaAttribute(value="approvals")
        @RuneAttribute(value="approvals")
        public Approvals getApprovals() {
            return this.approvals;
        }

        @Override
        public TradePackage build() {
            return this;
        }

        @Override
        public TradePackageBuilder toBuilder() {
            TradePackageBuilder builder = TradePackage.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TradePackageBuilder builder) {
            Optional.ofNullable(this.getPackageHeader()).ifPresent(builder::setPackageHeader);
            Optional.ofNullable(this.getTrade()).ifPresent(builder::setTrade);
            Optional.ofNullable(this.getTradeReferenceInformationModel()).ifPresent(builder::setTradeReferenceInformationModel);
            Optional.ofNullable(this.getTradeIdentifier()).ifPresent(builder::setTradeIdentifier);
            Optional.ofNullable(this.getApprovals()).ifPresent(builder::setApprovals);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TradePackage _that = this.getType().cast(o);
            if (!Objects.equals(this.packageHeader, _that.getPackageHeader())) {
                return false;
            }
            if (!ListEquals.listEquals(this.trade, _that.getTrade())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradeReferenceInformationModel, _that.getTradeReferenceInformationModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradeIdentifier, _that.getTradeIdentifier())) {
                return false;
            }
            return Objects.equals(this.approvals, _that.getApprovals());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.packageHeader != null ? this.packageHeader.hashCode() : 0);
            _result = 31 * _result + (this.trade != null ? this.trade.hashCode() : 0);
            _result = 31 * _result + (this.tradeReferenceInformationModel != null ? this.tradeReferenceInformationModel.hashCode() : 0);
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.approvals != null ? this.approvals.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TradePackage {packageHeader=" + String.valueOf(this.packageHeader) + ", trade=" + String.valueOf(this.trade) + ", tradeReferenceInformationModel=" + String.valueOf(this.tradeReferenceInformationModel) + ", tradeIdentifier=" + String.valueOf(this.tradeIdentifier) + ", approvals=" + String.valueOf(this.approvals) + "}";
        }
    }
}

