/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.business.events;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.business.events.ChangeEvent;
import fpml.consolidated.business.events.meta.TradeChangeContentMeta;
import fpml.consolidated.doc.PartyTradeIdentifier;
import fpml.consolidated.doc.Trade;
import fpml.consolidated.shared.Payment;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="TradeChangeContent", builder=TradeChangeContentBuilderImpl.class, version="1.2.2")
@RuneDataType(value="TradeChangeContent", model="fpml", builder=TradeChangeContentBuilderImpl.class, version="1.2.2")
public interface TradeChangeContent
extends RosettaModelObject {
    public static final TradeChangeContentMeta metaData = new TradeChangeContentMeta();

    public PartyTradeIdentifier getOldTradeIdentifier();

    public Trade getOldTrade();

    public Trade getTrade();

    public ZonedDateTime getEffectiveDate();

    public ChangeEvent getChangeEvent();

    public List<? extends Payment> getPayment();

    public TradeChangeContent build();

    public TradeChangeContentBuilder toBuilder();

    public static TradeChangeContentBuilder builder() {
        return new TradeChangeContentBuilderImpl();
    }

    default public RosettaMetaData<? extends TradeChangeContent> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends TradeChangeContent> getType() {
        return TradeChangeContent.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("oldTradeIdentifier"), processor, PartyTradeIdentifier.class, this.getOldTradeIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("oldTrade"), processor, Trade.class, this.getOldTrade(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("trade"), processor, Trade.class, this.getTrade(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("changeEvent"), processor, ChangeEvent.class, this.getChangeEvent(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payment"), processor, Payment.class, this.getPayment(), new AttributeMeta[0]);
    }

    public static class TradeChangeContentBuilderImpl
    implements TradeChangeContentBuilder {
        protected PartyTradeIdentifier.PartyTradeIdentifierBuilder oldTradeIdentifier;
        protected Trade.TradeBuilder oldTrade;
        protected Trade.TradeBuilder trade;
        protected ZonedDateTime effectiveDate;
        protected ChangeEvent.ChangeEventBuilder changeEvent;
        protected List<Payment.PaymentBuilder> payment = new ArrayList<Payment.PaymentBuilder>();

        @Override
        @RosettaAttribute(value="oldTradeIdentifier")
        @RuneAttribute(value="oldTradeIdentifier")
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOldTradeIdentifier() {
            return this.oldTradeIdentifier;
        }

        @Override
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreateOldTradeIdentifier() {
            PartyTradeIdentifier.PartyTradeIdentifierBuilder result = this.oldTradeIdentifier != null ? this.oldTradeIdentifier : (this.oldTradeIdentifier = PartyTradeIdentifier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="oldTrade")
        @RuneAttribute(value="oldTrade")
        public Trade.TradeBuilder getOldTrade() {
            return this.oldTrade;
        }

        @Override
        public Trade.TradeBuilder getOrCreateOldTrade() {
            Trade.TradeBuilder result = this.oldTrade != null ? this.oldTrade : (this.oldTrade = Trade.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="trade")
        @RuneAttribute(value="trade")
        public Trade.TradeBuilder getTrade() {
            return this.trade;
        }

        @Override
        public Trade.TradeBuilder getOrCreateTrade() {
            Trade.TradeBuilder result = this.trade != null ? this.trade : (this.trade = Trade.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public ZonedDateTime getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="changeEvent")
        @RuneAttribute(value="changeEvent")
        public ChangeEvent.ChangeEventBuilder getChangeEvent() {
            return this.changeEvent;
        }

        @Override
        public ChangeEvent.ChangeEventBuilder getOrCreateChangeEvent() {
            ChangeEvent.ChangeEventBuilder result = this.changeEvent != null ? this.changeEvent : (this.changeEvent = ChangeEvent.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="payment")
        @RuneAttribute(value="payment")
        public List<? extends Payment.PaymentBuilder> getPayment() {
            return this.payment;
        }

        @Override
        public Payment.PaymentBuilder getOrCreatePayment(int index) {
            if (this.payment == null) {
                this.payment = new ArrayList<Payment.PaymentBuilder>();
            }
            return (Payment.PaymentBuilder)this.getIndex(this.payment, index, () -> {
                Payment.PaymentBuilder newPayment = Payment.builder();
                return newPayment;
            });
        }

        @Override
        @RosettaAttribute(value="oldTradeIdentifier")
        @RuneAttribute(value="oldTradeIdentifier")
        public TradeChangeContentBuilder setOldTradeIdentifier(PartyTradeIdentifier _oldTradeIdentifier) {
            this.oldTradeIdentifier = _oldTradeIdentifier == null ? null : _oldTradeIdentifier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="oldTrade")
        @RuneAttribute(value="oldTrade")
        public TradeChangeContentBuilder setOldTrade(Trade _oldTrade) {
            this.oldTrade = _oldTrade == null ? null : _oldTrade.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="trade")
        @RuneAttribute(value="trade")
        public TradeChangeContentBuilder setTrade(Trade _trade) {
            this.trade = _trade == null ? null : _trade.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public TradeChangeContentBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="changeEvent")
        @RuneAttribute(value="changeEvent")
        public TradeChangeContentBuilder setChangeEvent(ChangeEvent _changeEvent) {
            this.changeEvent = _changeEvent == null ? null : _changeEvent.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="payment")
        @RuneAttribute(value="payment")
        public TradeChangeContentBuilder addPayment(Payment _payment) {
            if (_payment != null) {
                this.payment.add(_payment.toBuilder());
            }
            return this;
        }

        @Override
        public TradeChangeContentBuilder addPayment(Payment _payment, int idx) {
            this.getIndex(this.payment, idx, () -> _payment.toBuilder());
            return this;
        }

        @Override
        public TradeChangeContentBuilder addPayment(List<? extends Payment> payments) {
            if (payments != null) {
                for (Payment payment : payments) {
                    this.payment.add(payment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="payment")
        public TradeChangeContentBuilder setPayment(List<? extends Payment> payments) {
            this.payment = payments == null ? new ArrayList<Payment.PaymentBuilder>() : (List)payments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public TradeChangeContent build() {
            return new TradeChangeContentImpl(this);
        }

        @Override
        public TradeChangeContentBuilder toBuilder() {
            return this;
        }

        @Override
        public TradeChangeContentBuilder prune() {
            if (this.oldTradeIdentifier != null && !this.oldTradeIdentifier.prune().hasData()) {
                this.oldTradeIdentifier = null;
            }
            if (this.oldTrade != null && !this.oldTrade.prune().hasData()) {
                this.oldTrade = null;
            }
            if (this.trade != null && !this.trade.prune().hasData()) {
                this.trade = null;
            }
            if (this.changeEvent != null && !this.changeEvent.prune().hasData()) {
                this.changeEvent = null;
            }
            this.payment = this.payment.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getOldTradeIdentifier() != null && this.getOldTradeIdentifier().hasData()) {
                return true;
            }
            if (this.getOldTrade() != null && this.getOldTrade().hasData()) {
                return true;
            }
            if (this.getTrade() != null && this.getTrade().hasData()) {
                return true;
            }
            if (this.getEffectiveDate() != null) {
                return true;
            }
            if (this.getChangeEvent() != null && this.getChangeEvent().hasData()) {
                return true;
            }
            return this.getPayment() != null && this.getPayment().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public TradeChangeContentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TradeChangeContentBuilder o = (TradeChangeContentBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOldTradeIdentifier(), (RosettaModelObjectBuilder)o.getOldTradeIdentifier(), this::setOldTradeIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOldTrade(), (RosettaModelObjectBuilder)o.getOldTrade(), this::setOldTrade);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTrade(), (RosettaModelObjectBuilder)o.getTrade(), this::setTrade);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getChangeEvent(), (RosettaModelObjectBuilder)o.getChangeEvent(), this::setChangeEvent);
            merger.mergeRosetta(this.getPayment(), o.getPayment(), this::getOrCreatePayment);
            merger.mergeBasic((Object)this.getEffectiveDate(), (Object)o.getEffectiveDate(), this::setEffectiveDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TradeChangeContent _that = this.getType().cast(o);
            if (!Objects.equals(this.oldTradeIdentifier, _that.getOldTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.oldTrade, _that.getOldTrade())) {
                return false;
            }
            if (!Objects.equals(this.trade, _that.getTrade())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.changeEvent, _that.getChangeEvent())) {
                return false;
            }
            return ListEquals.listEquals(this.payment, _that.getPayment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.oldTradeIdentifier != null ? this.oldTradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.oldTrade != null ? this.oldTrade.hashCode() : 0);
            _result = 31 * _result + (this.trade != null ? this.trade.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.changeEvent != null ? this.changeEvent.hashCode() : 0);
            _result = 31 * _result + (this.payment != null ? this.payment.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TradeChangeContentBuilder {oldTradeIdentifier=" + String.valueOf(this.oldTradeIdentifier) + ", oldTrade=" + String.valueOf(this.oldTrade) + ", trade=" + String.valueOf(this.trade) + ", effectiveDate=" + String.valueOf(this.effectiveDate) + ", changeEvent=" + String.valueOf(this.changeEvent) + ", payment=" + String.valueOf(this.payment) + "}";
        }
    }

    public static interface TradeChangeContentBuilder
    extends TradeChangeContent,
    RosettaModelObjectBuilder {
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreateOldTradeIdentifier();

        @Override
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOldTradeIdentifier();

        public Trade.TradeBuilder getOrCreateOldTrade();

        @Override
        public Trade.TradeBuilder getOldTrade();

        public Trade.TradeBuilder getOrCreateTrade();

        @Override
        public Trade.TradeBuilder getTrade();

        public ChangeEvent.ChangeEventBuilder getOrCreateChangeEvent();

        @Override
        public ChangeEvent.ChangeEventBuilder getChangeEvent();

        public Payment.PaymentBuilder getOrCreatePayment(int var1);

        public List<? extends Payment.PaymentBuilder> getPayment();

        public TradeChangeContentBuilder setOldTradeIdentifier(PartyTradeIdentifier var1);

        public TradeChangeContentBuilder setOldTrade(Trade var1);

        public TradeChangeContentBuilder setTrade(Trade var1);

        public TradeChangeContentBuilder setEffectiveDate(ZonedDateTime var1);

        public TradeChangeContentBuilder setChangeEvent(ChangeEvent var1);

        public TradeChangeContentBuilder addPayment(Payment var1);

        public TradeChangeContentBuilder addPayment(Payment var1, int var2);

        public TradeChangeContentBuilder addPayment(List<? extends Payment> var1);

        public TradeChangeContentBuilder setPayment(List<? extends Payment> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("oldTradeIdentifier"), processor, PartyTradeIdentifier.PartyTradeIdentifierBuilder.class, this.getOldTradeIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("oldTrade"), processor, Trade.TradeBuilder.class, this.getOldTrade(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("trade"), processor, Trade.TradeBuilder.class, this.getTrade(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("changeEvent"), processor, ChangeEvent.ChangeEventBuilder.class, this.getChangeEvent(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payment"), processor, Payment.PaymentBuilder.class, this.getPayment(), new AttributeMeta[0]);
        }

        public TradeChangeContentBuilder prune();
    }

    public static class TradeChangeContentImpl
    implements TradeChangeContent {
        private final PartyTradeIdentifier oldTradeIdentifier;
        private final Trade oldTrade;
        private final Trade trade;
        private final ZonedDateTime effectiveDate;
        private final ChangeEvent changeEvent;
        private final List<? extends Payment> payment;

        protected TradeChangeContentImpl(TradeChangeContentBuilder builder) {
            this.oldTradeIdentifier = Optional.ofNullable(builder.getOldTradeIdentifier()).map(f -> f.build()).orElse(null);
            this.oldTrade = Optional.ofNullable(builder.getOldTrade()).map(f -> f.build()).orElse(null);
            this.trade = Optional.ofNullable(builder.getTrade()).map(f -> f.build()).orElse(null);
            this.effectiveDate = builder.getEffectiveDate();
            this.changeEvent = Optional.ofNullable(builder.getChangeEvent()).map(f -> f.build()).orElse(null);
            this.payment = Optional.ofNullable(builder.getPayment()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="oldTradeIdentifier")
        @RuneAttribute(value="oldTradeIdentifier")
        public PartyTradeIdentifier getOldTradeIdentifier() {
            return this.oldTradeIdentifier;
        }

        @Override
        @RosettaAttribute(value="oldTrade")
        @RuneAttribute(value="oldTrade")
        public Trade getOldTrade() {
            return this.oldTrade;
        }

        @Override
        @RosettaAttribute(value="trade")
        @RuneAttribute(value="trade")
        public Trade getTrade() {
            return this.trade;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public ZonedDateTime getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="changeEvent")
        @RuneAttribute(value="changeEvent")
        public ChangeEvent getChangeEvent() {
            return this.changeEvent;
        }

        @Override
        @RosettaAttribute(value="payment")
        @RuneAttribute(value="payment")
        public List<? extends Payment> getPayment() {
            return this.payment;
        }

        @Override
        public TradeChangeContent build() {
            return this;
        }

        @Override
        public TradeChangeContentBuilder toBuilder() {
            TradeChangeContentBuilder builder = TradeChangeContent.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TradeChangeContentBuilder builder) {
            Optional.ofNullable(this.getOldTradeIdentifier()).ifPresent(builder::setOldTradeIdentifier);
            Optional.ofNullable(this.getOldTrade()).ifPresent(builder::setOldTrade);
            Optional.ofNullable(this.getTrade()).ifPresent(builder::setTrade);
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDate);
            Optional.ofNullable(this.getChangeEvent()).ifPresent(builder::setChangeEvent);
            Optional.ofNullable(this.getPayment()).ifPresent(builder::setPayment);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TradeChangeContent _that = this.getType().cast(o);
            if (!Objects.equals(this.oldTradeIdentifier, _that.getOldTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.oldTrade, _that.getOldTrade())) {
                return false;
            }
            if (!Objects.equals(this.trade, _that.getTrade())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.changeEvent, _that.getChangeEvent())) {
                return false;
            }
            return ListEquals.listEquals(this.payment, _that.getPayment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.oldTradeIdentifier != null ? this.oldTradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.oldTrade != null ? this.oldTrade.hashCode() : 0);
            _result = 31 * _result + (this.trade != null ? this.trade.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.changeEvent != null ? this.changeEvent.hashCode() : 0);
            _result = 31 * _result + (this.payment != null ? this.payment.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TradeChangeContent {oldTradeIdentifier=" + String.valueOf(this.oldTradeIdentifier) + ", oldTrade=" + String.valueOf(this.oldTrade) + ", trade=" + String.valueOf(this.trade) + ", effectiveDate=" + String.valueOf(this.effectiveDate) + ", changeEvent=" + String.valueOf(this.changeEvent) + ", payment=" + String.valueOf(this.payment) + "}";
        }
    }
}

