/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.business.events;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.business.events.AbstractEvent;
import fpml.consolidated.business.events.ActionOnExpiration;
import fpml.consolidated.business.events.BusinessEventIdentifier;
import fpml.consolidated.business.events.meta.OptionExpiryMeta;
import fpml.consolidated.doc.PartyTradeIdentifier;
import fpml.consolidated.doc.Trade;
import fpml.consolidated.shared.ExerciseProcedureOption;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="OptionExpiry", builder=OptionExpiryBuilderImpl.class, version="1.2.2")
@RuneDataType(value="OptionExpiry", model="fpml", builder=OptionExpiryBuilderImpl.class, version="1.2.2")
public interface OptionExpiry
extends AbstractEvent {
    public static final OptionExpiryMeta metaData = new OptionExpiryMeta();

    public Trade getOriginalTrade();

    public List<? extends PartyTradeIdentifier> getTradeIdentifier();

    public ZonedDateTime getDate();

    public LocalTime getTime();

    public ExerciseProcedureOption getExerciseProcedure();

    public ActionOnExpiration getActionOnExpiration();

    @Override
    public OptionExpiry build();

    @Override
    public OptionExpiryBuilder toBuilder();

    public static OptionExpiryBuilder builder() {
        return new OptionExpiryBuilderImpl();
    }

    default public RosettaMetaData<? extends OptionExpiry> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends OptionExpiry> getType() {
        return OptionExpiry.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("originalTrade"), processor, Trade.class, this.getOriginalTrade(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeIdentifier"), processor, PartyTradeIdentifier.class, this.getTradeIdentifier(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("date"), ZonedDateTime.class, (Object)this.getDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("time"), LocalTime.class, (Object)this.getTime(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exerciseProcedure"), processor, ExerciseProcedureOption.class, this.getExerciseProcedure(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("actionOnExpiration"), processor, ActionOnExpiration.class, this.getActionOnExpiration(), new AttributeMeta[0]);
    }

    public static class OptionExpiryBuilderImpl
    extends AbstractEvent.AbstractEventBuilderImpl
    implements OptionExpiryBuilder {
        protected Trade.TradeBuilder originalTrade;
        protected List<PartyTradeIdentifier.PartyTradeIdentifierBuilder> tradeIdentifier = new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>();
        protected ZonedDateTime date;
        protected LocalTime time;
        protected ExerciseProcedureOption.ExerciseProcedureOptionBuilder exerciseProcedure;
        protected ActionOnExpiration.ActionOnExpirationBuilder actionOnExpiration;

        @Override
        @RosettaAttribute(value="originalTrade")
        @RuneAttribute(value="originalTrade")
        public Trade.TradeBuilder getOriginalTrade() {
            return this.originalTrade;
        }

        @Override
        public Trade.TradeBuilder getOrCreateOriginalTrade() {
            Trade.TradeBuilder result = this.originalTrade != null ? this.originalTrade : (this.originalTrade = Trade.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public List<? extends PartyTradeIdentifier.PartyTradeIdentifierBuilder> getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreateTradeIdentifier(int index) {
            if (this.tradeIdentifier == null) {
                this.tradeIdentifier = new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>();
            }
            return (PartyTradeIdentifier.PartyTradeIdentifierBuilder)this.getIndex(this.tradeIdentifier, index, () -> {
                PartyTradeIdentifier.PartyTradeIdentifierBuilder newTradeIdentifier = PartyTradeIdentifier.builder();
                return newTradeIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="date")
        @RuneAttribute(value="date")
        public ZonedDateTime getDate() {
            return this.date;
        }

        @Override
        @RosettaAttribute(value="time")
        @RuneAttribute(value="time")
        public LocalTime getTime() {
            return this.time;
        }

        @Override
        @RosettaAttribute(value="exerciseProcedure")
        @RuneAttribute(value="exerciseProcedure")
        public ExerciseProcedureOption.ExerciseProcedureOptionBuilder getExerciseProcedure() {
            return this.exerciseProcedure;
        }

        @Override
        public ExerciseProcedureOption.ExerciseProcedureOptionBuilder getOrCreateExerciseProcedure() {
            ExerciseProcedureOption.ExerciseProcedureOptionBuilder result = this.exerciseProcedure != null ? this.exerciseProcedure : (this.exerciseProcedure = ExerciseProcedureOption.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="actionOnExpiration")
        @RuneAttribute(value="actionOnExpiration")
        public ActionOnExpiration.ActionOnExpirationBuilder getActionOnExpiration() {
            return this.actionOnExpiration;
        }

        @Override
        public ActionOnExpiration.ActionOnExpirationBuilder getOrCreateActionOnExpiration() {
            ActionOnExpiration.ActionOnExpirationBuilder result = this.actionOnExpiration != null ? this.actionOnExpiration : (this.actionOnExpiration = ActionOnExpiration.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public OptionExpiryBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public OptionExpiryBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public OptionExpiryBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public OptionExpiryBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="originalTrade")
        @RuneAttribute(value="originalTrade")
        public OptionExpiryBuilder setOriginalTrade(Trade _originalTrade) {
            this.originalTrade = _originalTrade == null ? null : _originalTrade.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public OptionExpiryBuilder addTradeIdentifier(PartyTradeIdentifier _tradeIdentifier) {
            if (_tradeIdentifier != null) {
                this.tradeIdentifier.add(_tradeIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public OptionExpiryBuilder addTradeIdentifier(PartyTradeIdentifier _tradeIdentifier, int idx) {
            this.getIndex(this.tradeIdentifier, idx, () -> _tradeIdentifier.toBuilder());
            return this;
        }

        @Override
        public OptionExpiryBuilder addTradeIdentifier(List<? extends PartyTradeIdentifier> tradeIdentifiers) {
            if (tradeIdentifiers != null) {
                for (PartyTradeIdentifier partyTradeIdentifier : tradeIdentifiers) {
                    this.tradeIdentifier.add(partyTradeIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradeIdentifier")
        public OptionExpiryBuilder setTradeIdentifier(List<? extends PartyTradeIdentifier> tradeIdentifiers) {
            this.tradeIdentifier = tradeIdentifiers == null ? new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>() : (List)tradeIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="date")
        @RuneAttribute(value="date")
        public OptionExpiryBuilder setDate(ZonedDateTime _date) {
            this.date = _date == null ? null : _date;
            return this;
        }

        @Override
        @RosettaAttribute(value="time")
        @RuneAttribute(value="time")
        public OptionExpiryBuilder setTime(LocalTime _time) {
            this.time = _time == null ? null : _time;
            return this;
        }

        @Override
        @RosettaAttribute(value="exerciseProcedure")
        @RuneAttribute(value="exerciseProcedure")
        public OptionExpiryBuilder setExerciseProcedure(ExerciseProcedureOption _exerciseProcedure) {
            this.exerciseProcedure = _exerciseProcedure == null ? null : _exerciseProcedure.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="actionOnExpiration")
        @RuneAttribute(value="actionOnExpiration")
        public OptionExpiryBuilder setActionOnExpiration(ActionOnExpiration _actionOnExpiration) {
            this.actionOnExpiration = _actionOnExpiration == null ? null : _actionOnExpiration.toBuilder();
            return this;
        }

        @Override
        public OptionExpiry build() {
            return new OptionExpiryImpl(this);
        }

        @Override
        public OptionExpiryBuilder toBuilder() {
            return this;
        }

        @Override
        public OptionExpiryBuilder prune() {
            super.prune();
            if (this.originalTrade != null && !this.originalTrade.prune().hasData()) {
                this.originalTrade = null;
            }
            this.tradeIdentifier = this.tradeIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.exerciseProcedure != null && !this.exerciseProcedure.prune().hasData()) {
                this.exerciseProcedure = null;
            }
            if (this.actionOnExpiration != null && !this.actionOnExpiration.prune().hasData()) {
                this.actionOnExpiration = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getOriginalTrade() != null && this.getOriginalTrade().hasData()) {
                return true;
            }
            if (this.getTradeIdentifier() != null && this.getTradeIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getDate() != null) {
                return true;
            }
            if (this.getTime() != null) {
                return true;
            }
            if (this.getExerciseProcedure() != null && this.getExerciseProcedure().hasData()) {
                return true;
            }
            return this.getActionOnExpiration() != null && this.getActionOnExpiration().hasData();
        }

        @Override
        public OptionExpiryBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            OptionExpiryBuilder o = (OptionExpiryBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOriginalTrade(), (RosettaModelObjectBuilder)o.getOriginalTrade(), this::setOriginalTrade);
            merger.mergeRosetta(this.getTradeIdentifier(), o.getTradeIdentifier(), this::getOrCreateTradeIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExerciseProcedure(), (RosettaModelObjectBuilder)o.getExerciseProcedure(), this::setExerciseProcedure);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getActionOnExpiration(), (RosettaModelObjectBuilder)o.getActionOnExpiration(), this::setActionOnExpiration);
            merger.mergeBasic((Object)this.getDate(), (Object)o.getDate(), this::setDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTime(), (Object)o.getTime(), this::setTime, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            OptionExpiry _that = (OptionExpiry)this.getType().cast(o);
            if (!Objects.equals(this.originalTrade, _that.getOriginalTrade())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradeIdentifier, _that.getTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.date, _that.getDate())) {
                return false;
            }
            if (!Objects.equals(this.time, _that.getTime())) {
                return false;
            }
            if (!Objects.equals(this.exerciseProcedure, _that.getExerciseProcedure())) {
                return false;
            }
            return Objects.equals(this.actionOnExpiration, _that.getActionOnExpiration());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.originalTrade != null ? this.originalTrade.hashCode() : 0);
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.date != null ? this.date.hashCode() : 0);
            _result = 31 * _result + (this.time != null ? this.time.hashCode() : 0);
            _result = 31 * _result + (this.exerciseProcedure != null ? this.exerciseProcedure.hashCode() : 0);
            _result = 31 * _result + (this.actionOnExpiration != null ? this.actionOnExpiration.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "OptionExpiryBuilder {originalTrade=" + String.valueOf(this.originalTrade) + ", tradeIdentifier=" + String.valueOf(this.tradeIdentifier) + ", date=" + String.valueOf(this.date) + ", time=" + String.valueOf(this.time) + ", exerciseProcedure=" + String.valueOf(this.exerciseProcedure) + ", actionOnExpiration=" + String.valueOf(this.actionOnExpiration) + "} " + super.toString();
        }
    }

    public static interface OptionExpiryBuilder
    extends OptionExpiry,
    AbstractEvent.AbstractEventBuilder {
        public Trade.TradeBuilder getOrCreateOriginalTrade();

        @Override
        public Trade.TradeBuilder getOriginalTrade();

        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreateTradeIdentifier(int var1);

        public List<? extends PartyTradeIdentifier.PartyTradeIdentifierBuilder> getTradeIdentifier();

        public ExerciseProcedureOption.ExerciseProcedureOptionBuilder getOrCreateExerciseProcedure();

        @Override
        public ExerciseProcedureOption.ExerciseProcedureOptionBuilder getExerciseProcedure();

        public ActionOnExpiration.ActionOnExpirationBuilder getOrCreateActionOnExpiration();

        @Override
        public ActionOnExpiration.ActionOnExpirationBuilder getActionOnExpiration();

        @Override
        public OptionExpiryBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public OptionExpiryBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public OptionExpiryBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public OptionExpiryBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        public OptionExpiryBuilder setOriginalTrade(Trade var1);

        public OptionExpiryBuilder addTradeIdentifier(PartyTradeIdentifier var1);

        public OptionExpiryBuilder addTradeIdentifier(PartyTradeIdentifier var1, int var2);

        public OptionExpiryBuilder addTradeIdentifier(List<? extends PartyTradeIdentifier> var1);

        public OptionExpiryBuilder setTradeIdentifier(List<? extends PartyTradeIdentifier> var1);

        public OptionExpiryBuilder setDate(ZonedDateTime var1);

        public OptionExpiryBuilder setTime(LocalTime var1);

        public OptionExpiryBuilder setExerciseProcedure(ExerciseProcedureOption var1);

        public OptionExpiryBuilder setActionOnExpiration(ActionOnExpiration var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("originalTrade"), processor, Trade.TradeBuilder.class, this.getOriginalTrade(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeIdentifier"), processor, PartyTradeIdentifier.PartyTradeIdentifierBuilder.class, this.getTradeIdentifier(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("date"), ZonedDateTime.class, (Object)this.getDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("time"), LocalTime.class, (Object)this.getTime(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exerciseProcedure"), processor, ExerciseProcedureOption.ExerciseProcedureOptionBuilder.class, this.getExerciseProcedure(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("actionOnExpiration"), processor, ActionOnExpiration.ActionOnExpirationBuilder.class, this.getActionOnExpiration(), new AttributeMeta[0]);
        }

        @Override
        public OptionExpiryBuilder prune();
    }

    public static class OptionExpiryImpl
    extends AbstractEvent.AbstractEventImpl
    implements OptionExpiry {
        private final Trade originalTrade;
        private final List<? extends PartyTradeIdentifier> tradeIdentifier;
        private final ZonedDateTime date;
        private final LocalTime time;
        private final ExerciseProcedureOption exerciseProcedure;
        private final ActionOnExpiration actionOnExpiration;

        protected OptionExpiryImpl(OptionExpiryBuilder builder) {
            super(builder);
            this.originalTrade = Optional.ofNullable(builder.getOriginalTrade()).map(f -> f.build()).orElse(null);
            this.tradeIdentifier = Optional.ofNullable(builder.getTradeIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.date = builder.getDate();
            this.time = builder.getTime();
            this.exerciseProcedure = Optional.ofNullable(builder.getExerciseProcedure()).map(f -> f.build()).orElse(null);
            this.actionOnExpiration = Optional.ofNullable(builder.getActionOnExpiration()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="originalTrade")
        @RuneAttribute(value="originalTrade")
        public Trade getOriginalTrade() {
            return this.originalTrade;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public List<? extends PartyTradeIdentifier> getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        @RosettaAttribute(value="date")
        @RuneAttribute(value="date")
        public ZonedDateTime getDate() {
            return this.date;
        }

        @Override
        @RosettaAttribute(value="time")
        @RuneAttribute(value="time")
        public LocalTime getTime() {
            return this.time;
        }

        @Override
        @RosettaAttribute(value="exerciseProcedure")
        @RuneAttribute(value="exerciseProcedure")
        public ExerciseProcedureOption getExerciseProcedure() {
            return this.exerciseProcedure;
        }

        @Override
        @RosettaAttribute(value="actionOnExpiration")
        @RuneAttribute(value="actionOnExpiration")
        public ActionOnExpiration getActionOnExpiration() {
            return this.actionOnExpiration;
        }

        @Override
        public OptionExpiry build() {
            return this;
        }

        @Override
        public OptionExpiryBuilder toBuilder() {
            OptionExpiryBuilder builder = OptionExpiry.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(OptionExpiryBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getOriginalTrade()).ifPresent(builder::setOriginalTrade);
            Optional.ofNullable(this.getTradeIdentifier()).ifPresent(builder::setTradeIdentifier);
            Optional.ofNullable(this.getDate()).ifPresent(builder::setDate);
            Optional.ofNullable(this.getTime()).ifPresent(builder::setTime);
            Optional.ofNullable(this.getExerciseProcedure()).ifPresent(builder::setExerciseProcedure);
            Optional.ofNullable(this.getActionOnExpiration()).ifPresent(builder::setActionOnExpiration);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            OptionExpiry _that = (OptionExpiry)this.getType().cast(o);
            if (!Objects.equals(this.originalTrade, _that.getOriginalTrade())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradeIdentifier, _that.getTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.date, _that.getDate())) {
                return false;
            }
            if (!Objects.equals(this.time, _that.getTime())) {
                return false;
            }
            if (!Objects.equals(this.exerciseProcedure, _that.getExerciseProcedure())) {
                return false;
            }
            return Objects.equals(this.actionOnExpiration, _that.getActionOnExpiration());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.originalTrade != null ? this.originalTrade.hashCode() : 0);
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.date != null ? this.date.hashCode() : 0);
            _result = 31 * _result + (this.time != null ? this.time.hashCode() : 0);
            _result = 31 * _result + (this.exerciseProcedure != null ? this.exerciseProcedure.hashCode() : 0);
            _result = 31 * _result + (this.actionOnExpiration != null ? this.actionOnExpiration.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "OptionExpiry {originalTrade=" + String.valueOf(this.originalTrade) + ", tradeIdentifier=" + String.valueOf(this.tradeIdentifier) + ", date=" + String.valueOf(this.date) + ", time=" + String.valueOf(this.time) + ", exerciseProcedure=" + String.valueOf(this.exerciseProcedure) + ", actionOnExpiration=" + String.valueOf(this.actionOnExpiration) + "} " + super.toString();
        }
    }
}

