/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.asset;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.CreditQuality;
import fpml.consolidated.asset.GenericSecurity;
import fpml.consolidated.asset.InstrumentType;
import fpml.consolidated.asset.meta.SecurityMeta;
import fpml.consolidated.shared.IdentifiedCurrency;
import fpml.consolidated.shared.InstrumentId;
import fpml.consolidated.shared.PartyReference;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@RosettaDataType(value="Security", builder=SecurityBuilderImpl.class, version="1.2.2")
@RuneDataType(value="Security", model="fpml", builder=SecurityBuilderImpl.class, version="1.2.2")
public interface Security
extends GenericSecurity {
    public static final SecurityMeta metaData = new SecurityMeta();

    @Override
    public Security build();

    @Override
    public SecurityBuilder toBuilder();

    public static SecurityBuilder builder() {
        return new SecurityBuilderImpl();
    }

    default public RosettaMetaData<? extends Security> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Security> getType() {
        return Security.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.class, this.getInstrumentId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.class, this.getInstrumentType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.class, this.getCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("issuerPartyReference"), processor, PartyReference.class, this.getIssuerPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("creditQuality"), processor, CreditQuality.class, this.getCreditQuality(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("maturity"), ZonedDateTime.class, (Object)this.getMaturity(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class SecurityBuilderImpl
    extends GenericSecurity.GenericSecurityBuilderImpl
    implements SecurityBuilder {
        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public SecurityBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentId", isRequired=true)
        @RuneAttribute(value="instrumentId", isRequired=true)
        public SecurityBuilder addInstrumentId(InstrumentId _instrumentId) {
            if (_instrumentId != null) {
                this.instrumentId.add(_instrumentId.toBuilder());
            }
            return this;
        }

        @Override
        public SecurityBuilder addInstrumentId(InstrumentId _instrumentId, int idx) {
            this.getIndex(this.instrumentId, idx, () -> _instrumentId.toBuilder());
            return this;
        }

        @Override
        public SecurityBuilder addInstrumentId(List<? extends InstrumentId> instrumentIds) {
            if (instrumentIds != null) {
                for (InstrumentId instrumentId : instrumentIds) {
                    this.instrumentId.add(instrumentId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentId")
        public SecurityBuilder setInstrumentId(List<? extends InstrumentId> instrumentIds) {
            this.instrumentId = instrumentIds == null ? new ArrayList() : (List)instrumentIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentType")
        @RuneAttribute(value="instrumentType")
        public SecurityBuilder addInstrumentType(InstrumentType _instrumentType) {
            if (_instrumentType != null) {
                this.instrumentType.add(_instrumentType.toBuilder());
            }
            return this;
        }

        @Override
        public SecurityBuilder addInstrumentType(InstrumentType _instrumentType, int idx) {
            this.getIndex(this.instrumentType, idx, () -> _instrumentType.toBuilder());
            return this;
        }

        @Override
        public SecurityBuilder addInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            if (instrumentTypes != null) {
                for (InstrumentType instrumentType : instrumentTypes) {
                    this.instrumentType.add(instrumentType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentType")
        public SecurityBuilder setInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            this.instrumentType = instrumentTypes == null ? new ArrayList() : (List)instrumentTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public SecurityBuilder setDescription(String _description) {
            this.description = _description == null ? null : _description;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public SecurityBuilder setCurrency(IdentifiedCurrency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="issuerPartyReference")
        @RuneAttribute(value="issuerPartyReference")
        public SecurityBuilder setIssuerPartyReference(PartyReference _issuerPartyReference) {
            this.issuerPartyReference = _issuerPartyReference == null ? null : _issuerPartyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="creditQuality")
        @RuneAttribute(value="creditQuality")
        public SecurityBuilder addCreditQuality(CreditQuality _creditQuality) {
            if (_creditQuality != null) {
                this.creditQuality.add(_creditQuality.toBuilder());
            }
            return this;
        }

        @Override
        public SecurityBuilder addCreditQuality(CreditQuality _creditQuality, int idx) {
            this.getIndex(this.creditQuality, idx, () -> _creditQuality.toBuilder());
            return this;
        }

        @Override
        public SecurityBuilder addCreditQuality(List<? extends CreditQuality> creditQualitys) {
            if (creditQualitys != null) {
                for (CreditQuality creditQuality : creditQualitys) {
                    this.creditQuality.add(creditQuality.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="creditQuality")
        public SecurityBuilder setCreditQuality(List<? extends CreditQuality> creditQualitys) {
            this.creditQuality = creditQualitys == null ? new ArrayList() : (List)creditQualitys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="maturity")
        @RuneAttribute(value="maturity")
        public SecurityBuilder setMaturity(ZonedDateTime _maturity) {
            this.maturity = _maturity == null ? null : _maturity;
            return this;
        }

        @Override
        public Security build() {
            return new SecurityImpl(this);
        }

        @Override
        public SecurityBuilder toBuilder() {
            return this;
        }

        @Override
        public SecurityBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            return super.hasData();
        }

        @Override
        public SecurityBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            SecurityBuilder o = (SecurityBuilder)other;
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            return _result;
        }

        @Override
        public String toString() {
            return "SecurityBuilder {} " + super.toString();
        }
    }

    public static interface SecurityBuilder
    extends Security,
    GenericSecurity.GenericSecurityBuilder {
        @Override
        public SecurityBuilder setId(String var1);

        @Override
        public SecurityBuilder addInstrumentId(InstrumentId var1);

        @Override
        public SecurityBuilder addInstrumentId(InstrumentId var1, int var2);

        @Override
        public SecurityBuilder addInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public SecurityBuilder setInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public SecurityBuilder addInstrumentType(InstrumentType var1);

        @Override
        public SecurityBuilder addInstrumentType(InstrumentType var1, int var2);

        @Override
        public SecurityBuilder addInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public SecurityBuilder setInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public SecurityBuilder setDescription(String var1);

        @Override
        public SecurityBuilder setCurrency(IdentifiedCurrency var1);

        @Override
        public SecurityBuilder setIssuerPartyReference(PartyReference var1);

        @Override
        public SecurityBuilder addCreditQuality(CreditQuality var1);

        @Override
        public SecurityBuilder addCreditQuality(CreditQuality var1, int var2);

        @Override
        public SecurityBuilder addCreditQuality(List<? extends CreditQuality> var1);

        @Override
        public SecurityBuilder setCreditQuality(List<? extends CreditQuality> var1);

        @Override
        public SecurityBuilder setMaturity(ZonedDateTime var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.InstrumentIdBuilder.class, this.getInstrumentId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.InstrumentTypeBuilder.class, this.getInstrumentType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.IdentifiedCurrencyBuilder.class, (RosettaModelObjectBuilder)this.getCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("issuerPartyReference"), processor, PartyReference.PartyReferenceBuilder.class, (RosettaModelObjectBuilder)this.getIssuerPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("creditQuality"), processor, CreditQuality.CreditQualityBuilder.class, this.getCreditQuality(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("maturity"), ZonedDateTime.class, (Object)this.getMaturity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public SecurityBuilder prune();
    }

    public static class SecurityImpl
    extends GenericSecurity.GenericSecurityImpl
    implements Security {
        protected SecurityImpl(SecurityBuilder builder) {
            super(builder);
        }

        @Override
        public Security build() {
            return this;
        }

        @Override
        public SecurityBuilder toBuilder() {
            SecurityBuilder builder = Security.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SecurityBuilder builder) {
            super.setBuilderFields(builder);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            return _result;
        }

        @Override
        public String toString() {
            return "Security {} " + super.toString();
        }
    }
}

