/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.asset;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.BondCalculationModel;
import fpml.consolidated.asset.FixedIncomeSecurityContentModel;
import fpml.consolidated.asset.InstrumentType;
import fpml.consolidated.asset.UnderlyingAsset;
import fpml.consolidated.asset.meta.BondMeta;
import fpml.consolidated.shared.ClearanceSystem;
import fpml.consolidated.shared.ExchangeId;
import fpml.consolidated.shared.IdentifiedCurrency;
import fpml.consolidated.shared.InstrumentId;
import fpml.consolidated.shared.ProductReference;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Bond", builder=BondBuilderImpl.class, version="1.2.2")
@RuneDataType(value="Bond", model="fpml", builder=BondBuilderImpl.class, version="1.2.2")
public interface Bond
extends UnderlyingAsset {
    public static final BondMeta metaData = new BondMeta();

    public FixedIncomeSecurityContentModel getFixedIncomeSecurityContentModel();

    public BigDecimal getParValue();

    public BigDecimal getFaceAmount();

    public BondCalculationModel getBondCalculationModel();

    @Override
    public Bond build();

    @Override
    public BondBuilder toBuilder();

    public static BondBuilder builder() {
        return new BondBuilderImpl();
    }

    default public RosettaMetaData<? extends Bond> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Bond> getType() {
        return Bond.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.class, this.getInstrumentId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.class, this.getInstrumentType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.class, this.getCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.class, this.getExchangeId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.class, this.getClearanceSystem(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("definition"), processor, ProductReference.class, this.getDefinition(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fixedIncomeSecurityContentModel"), processor, FixedIncomeSecurityContentModel.class, this.getFixedIncomeSecurityContentModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("parValue"), BigDecimal.class, (Object)this.getParValue(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("faceAmount"), BigDecimal.class, (Object)this.getFaceAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("bondCalculationModel"), processor, BondCalculationModel.class, this.getBondCalculationModel(), new AttributeMeta[0]);
    }

    public static class BondBuilderImpl
    extends UnderlyingAsset.UnderlyingAssetBuilderImpl
    implements BondBuilder {
        protected FixedIncomeSecurityContentModel.FixedIncomeSecurityContentModelBuilder fixedIncomeSecurityContentModel;
        protected BigDecimal parValue;
        protected BigDecimal faceAmount;
        protected BondCalculationModel.BondCalculationModelBuilder bondCalculationModel;

        @Override
        @RosettaAttribute(value="fixedIncomeSecurityContentModel", isRequired=true)
        @RuneAttribute(value="fixedIncomeSecurityContentModel", isRequired=true)
        public FixedIncomeSecurityContentModel.FixedIncomeSecurityContentModelBuilder getFixedIncomeSecurityContentModel() {
            return this.fixedIncomeSecurityContentModel;
        }

        @Override
        public FixedIncomeSecurityContentModel.FixedIncomeSecurityContentModelBuilder getOrCreateFixedIncomeSecurityContentModel() {
            FixedIncomeSecurityContentModel.FixedIncomeSecurityContentModelBuilder result = this.fixedIncomeSecurityContentModel != null ? this.fixedIncomeSecurityContentModel : (this.fixedIncomeSecurityContentModel = FixedIncomeSecurityContentModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="parValue")
        @RuneAttribute(value="parValue")
        public BigDecimal getParValue() {
            return this.parValue;
        }

        @Override
        @RosettaAttribute(value="faceAmount")
        @RuneAttribute(value="faceAmount")
        public BigDecimal getFaceAmount() {
            return this.faceAmount;
        }

        @Override
        @RosettaAttribute(value="bondCalculationModel", isRequired=true)
        @RuneAttribute(value="bondCalculationModel", isRequired=true)
        public BondCalculationModel.BondCalculationModelBuilder getBondCalculationModel() {
            return this.bondCalculationModel;
        }

        @Override
        public BondCalculationModel.BondCalculationModelBuilder getOrCreateBondCalculationModel() {
            BondCalculationModel.BondCalculationModelBuilder result = this.bondCalculationModel != null ? this.bondCalculationModel : (this.bondCalculationModel = BondCalculationModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public BondBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentId", isRequired=true)
        @RuneAttribute(value="instrumentId", isRequired=true)
        public BondBuilder addInstrumentId(InstrumentId _instrumentId) {
            if (_instrumentId != null) {
                this.instrumentId.add(_instrumentId.toBuilder());
            }
            return this;
        }

        @Override
        public BondBuilder addInstrumentId(InstrumentId _instrumentId, int idx) {
            this.getIndex(this.instrumentId, idx, () -> _instrumentId.toBuilder());
            return this;
        }

        @Override
        public BondBuilder addInstrumentId(List<? extends InstrumentId> instrumentIds) {
            if (instrumentIds != null) {
                for (InstrumentId instrumentId : instrumentIds) {
                    this.instrumentId.add(instrumentId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentId")
        public BondBuilder setInstrumentId(List<? extends InstrumentId> instrumentIds) {
            this.instrumentId = instrumentIds == null ? new ArrayList() : (List)instrumentIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentType")
        @RuneAttribute(value="instrumentType")
        public BondBuilder addInstrumentType(InstrumentType _instrumentType) {
            if (_instrumentType != null) {
                this.instrumentType.add(_instrumentType.toBuilder());
            }
            return this;
        }

        @Override
        public BondBuilder addInstrumentType(InstrumentType _instrumentType, int idx) {
            this.getIndex(this.instrumentType, idx, () -> _instrumentType.toBuilder());
            return this;
        }

        @Override
        public BondBuilder addInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            if (instrumentTypes != null) {
                for (InstrumentType instrumentType : instrumentTypes) {
                    this.instrumentType.add(instrumentType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentType")
        public BondBuilder setInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            this.instrumentType = instrumentTypes == null ? new ArrayList() : (List)instrumentTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public BondBuilder setDescription(String _description) {
            this.description = _description == null ? null : _description;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public BondBuilder setCurrency(IdentifiedCurrency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeId")
        @RuneAttribute(value="exchangeId")
        public BondBuilder setExchangeId(ExchangeId _exchangeId) {
            this.exchangeId = _exchangeId == null ? null : _exchangeId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="clearanceSystem")
        @RuneAttribute(value="clearanceSystem")
        public BondBuilder setClearanceSystem(ClearanceSystem _clearanceSystem) {
            this.clearanceSystem = _clearanceSystem == null ? null : _clearanceSystem.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="definition")
        @RuneAttribute(value="definition")
        public BondBuilder setDefinition(ProductReference _definition) {
            this.definition = _definition == null ? null : _definition.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedIncomeSecurityContentModel", isRequired=true)
        @RuneAttribute(value="fixedIncomeSecurityContentModel", isRequired=true)
        public BondBuilder setFixedIncomeSecurityContentModel(FixedIncomeSecurityContentModel _fixedIncomeSecurityContentModel) {
            this.fixedIncomeSecurityContentModel = _fixedIncomeSecurityContentModel == null ? null : _fixedIncomeSecurityContentModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="parValue")
        @RuneAttribute(value="parValue")
        public BondBuilder setParValue(BigDecimal _parValue) {
            this.parValue = _parValue == null ? null : _parValue;
            return this;
        }

        @Override
        @RosettaAttribute(value="faceAmount")
        @RuneAttribute(value="faceAmount")
        public BondBuilder setFaceAmount(BigDecimal _faceAmount) {
            this.faceAmount = _faceAmount == null ? null : _faceAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="bondCalculationModel", isRequired=true)
        @RuneAttribute(value="bondCalculationModel", isRequired=true)
        public BondBuilder setBondCalculationModel(BondCalculationModel _bondCalculationModel) {
            this.bondCalculationModel = _bondCalculationModel == null ? null : _bondCalculationModel.toBuilder();
            return this;
        }

        @Override
        public Bond build() {
            return new BondImpl(this);
        }

        @Override
        public BondBuilder toBuilder() {
            return this;
        }

        @Override
        public BondBuilder prune() {
            super.prune();
            if (this.fixedIncomeSecurityContentModel != null && !this.fixedIncomeSecurityContentModel.prune().hasData()) {
                this.fixedIncomeSecurityContentModel = null;
            }
            if (this.bondCalculationModel != null && !this.bondCalculationModel.prune().hasData()) {
                this.bondCalculationModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getFixedIncomeSecurityContentModel() != null && this.getFixedIncomeSecurityContentModel().hasData()) {
                return true;
            }
            if (this.getParValue() != null) {
                return true;
            }
            if (this.getFaceAmount() != null) {
                return true;
            }
            return this.getBondCalculationModel() != null && this.getBondCalculationModel().hasData();
        }

        @Override
        public BondBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            BondBuilder o = (BondBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFixedIncomeSecurityContentModel(), (RosettaModelObjectBuilder)o.getFixedIncomeSecurityContentModel(), this::setFixedIncomeSecurityContentModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBondCalculationModel(), (RosettaModelObjectBuilder)o.getBondCalculationModel(), this::setBondCalculationModel);
            merger.mergeBasic((Object)this.getParValue(), (Object)o.getParValue(), this::setParValue, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFaceAmount(), (Object)o.getFaceAmount(), this::setFaceAmount, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Bond _that = (Bond)this.getType().cast(o);
            if (!Objects.equals(this.fixedIncomeSecurityContentModel, _that.getFixedIncomeSecurityContentModel())) {
                return false;
            }
            if (!Objects.equals(this.parValue, _that.getParValue())) {
                return false;
            }
            if (!Objects.equals(this.faceAmount, _that.getFaceAmount())) {
                return false;
            }
            return Objects.equals(this.bondCalculationModel, _that.getBondCalculationModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.fixedIncomeSecurityContentModel != null ? this.fixedIncomeSecurityContentModel.hashCode() : 0);
            _result = 31 * _result + (this.parValue != null ? this.parValue.hashCode() : 0);
            _result = 31 * _result + (this.faceAmount != null ? this.faceAmount.hashCode() : 0);
            _result = 31 * _result + (this.bondCalculationModel != null ? this.bondCalculationModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "BondBuilder {fixedIncomeSecurityContentModel=" + String.valueOf(this.fixedIncomeSecurityContentModel) + ", parValue=" + String.valueOf(this.parValue) + ", faceAmount=" + String.valueOf(this.faceAmount) + ", bondCalculationModel=" + String.valueOf(this.bondCalculationModel) + "} " + super.toString();
        }
    }

    public static interface BondBuilder
    extends Bond,
    UnderlyingAsset.UnderlyingAssetBuilder {
        public FixedIncomeSecurityContentModel.FixedIncomeSecurityContentModelBuilder getOrCreateFixedIncomeSecurityContentModel();

        @Override
        public FixedIncomeSecurityContentModel.FixedIncomeSecurityContentModelBuilder getFixedIncomeSecurityContentModel();

        public BondCalculationModel.BondCalculationModelBuilder getOrCreateBondCalculationModel();

        @Override
        public BondCalculationModel.BondCalculationModelBuilder getBondCalculationModel();

        @Override
        public BondBuilder setId(String var1);

        @Override
        public BondBuilder addInstrumentId(InstrumentId var1);

        @Override
        public BondBuilder addInstrumentId(InstrumentId var1, int var2);

        @Override
        public BondBuilder addInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public BondBuilder setInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public BondBuilder addInstrumentType(InstrumentType var1);

        @Override
        public BondBuilder addInstrumentType(InstrumentType var1, int var2);

        @Override
        public BondBuilder addInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public BondBuilder setInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public BondBuilder setDescription(String var1);

        @Override
        public BondBuilder setCurrency(IdentifiedCurrency var1);

        @Override
        public BondBuilder setExchangeId(ExchangeId var1);

        @Override
        public BondBuilder setClearanceSystem(ClearanceSystem var1);

        @Override
        public BondBuilder setDefinition(ProductReference var1);

        public BondBuilder setFixedIncomeSecurityContentModel(FixedIncomeSecurityContentModel var1);

        public BondBuilder setParValue(BigDecimal var1);

        public BondBuilder setFaceAmount(BigDecimal var1);

        public BondBuilder setBondCalculationModel(BondCalculationModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.InstrumentIdBuilder.class, this.getInstrumentId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.InstrumentTypeBuilder.class, this.getInstrumentType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.IdentifiedCurrencyBuilder.class, (RosettaModelObjectBuilder)this.getCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.ExchangeIdBuilder.class, (RosettaModelObjectBuilder)this.getExchangeId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.ClearanceSystemBuilder.class, (RosettaModelObjectBuilder)this.getClearanceSystem(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("definition"), processor, ProductReference.ProductReferenceBuilder.class, (RosettaModelObjectBuilder)this.getDefinition(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fixedIncomeSecurityContentModel"), processor, FixedIncomeSecurityContentModel.FixedIncomeSecurityContentModelBuilder.class, this.getFixedIncomeSecurityContentModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("parValue"), BigDecimal.class, (Object)this.getParValue(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("faceAmount"), BigDecimal.class, (Object)this.getFaceAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("bondCalculationModel"), processor, BondCalculationModel.BondCalculationModelBuilder.class, this.getBondCalculationModel(), new AttributeMeta[0]);
        }

        @Override
        public BondBuilder prune();
    }

    public static class BondImpl
    extends UnderlyingAsset.UnderlyingAssetImpl
    implements Bond {
        private final FixedIncomeSecurityContentModel fixedIncomeSecurityContentModel;
        private final BigDecimal parValue;
        private final BigDecimal faceAmount;
        private final BondCalculationModel bondCalculationModel;

        protected BondImpl(BondBuilder builder) {
            super(builder);
            this.fixedIncomeSecurityContentModel = Optional.ofNullable(builder.getFixedIncomeSecurityContentModel()).map(f -> f.build()).orElse(null);
            this.parValue = builder.getParValue();
            this.faceAmount = builder.getFaceAmount();
            this.bondCalculationModel = Optional.ofNullable(builder.getBondCalculationModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="fixedIncomeSecurityContentModel", isRequired=true)
        @RuneAttribute(value="fixedIncomeSecurityContentModel", isRequired=true)
        public FixedIncomeSecurityContentModel getFixedIncomeSecurityContentModel() {
            return this.fixedIncomeSecurityContentModel;
        }

        @Override
        @RosettaAttribute(value="parValue")
        @RuneAttribute(value="parValue")
        public BigDecimal getParValue() {
            return this.parValue;
        }

        @Override
        @RosettaAttribute(value="faceAmount")
        @RuneAttribute(value="faceAmount")
        public BigDecimal getFaceAmount() {
            return this.faceAmount;
        }

        @Override
        @RosettaAttribute(value="bondCalculationModel", isRequired=true)
        @RuneAttribute(value="bondCalculationModel", isRequired=true)
        public BondCalculationModel getBondCalculationModel() {
            return this.bondCalculationModel;
        }

        @Override
        public Bond build() {
            return this;
        }

        @Override
        public BondBuilder toBuilder() {
            BondBuilder builder = Bond.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BondBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getFixedIncomeSecurityContentModel()).ifPresent(builder::setFixedIncomeSecurityContentModel);
            Optional.ofNullable(this.getParValue()).ifPresent(builder::setParValue);
            Optional.ofNullable(this.getFaceAmount()).ifPresent(builder::setFaceAmount);
            Optional.ofNullable(this.getBondCalculationModel()).ifPresent(builder::setBondCalculationModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Bond _that = (Bond)this.getType().cast(o);
            if (!Objects.equals(this.fixedIncomeSecurityContentModel, _that.getFixedIncomeSecurityContentModel())) {
                return false;
            }
            if (!Objects.equals(this.parValue, _that.getParValue())) {
                return false;
            }
            if (!Objects.equals(this.faceAmount, _that.getFaceAmount())) {
                return false;
            }
            return Objects.equals(this.bondCalculationModel, _that.getBondCalculationModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.fixedIncomeSecurityContentModel != null ? this.fixedIncomeSecurityContentModel.hashCode() : 0);
            _result = 31 * _result + (this.parValue != null ? this.parValue.hashCode() : 0);
            _result = 31 * _result + (this.faceAmount != null ? this.faceAmount.hashCode() : 0);
            _result = 31 * _result + (this.bondCalculationModel != null ? this.bondCalculationModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Bond {fixedIncomeSecurityContentModel=" + String.valueOf(this.fixedIncomeSecurityContentModel) + ", parValue=" + String.valueOf(this.parValue) + ", faceAmount=" + String.valueOf(this.faceAmount) + ", bondCalculationModel=" + String.valueOf(this.bondCalculationModel) + "} " + super.toString();
        }
    }
}

