/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.asset;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.Asset;
import fpml.consolidated.asset.ConstituentWeight;
import fpml.consolidated.asset.DividendPayout;
import fpml.consolidated.asset.PendingPayment;
import fpml.consolidated.asset.Price;
import fpml.consolidated.asset.UnderlyerLoanRate;
import fpml.consolidated.asset.meta.BasketConstituentMeta;
import fpml.consolidated.shared.Collateral;
import fpml.consolidated.shared.Money;
import fpml.consolidated.shared.PayerReceiverModel;
import fpml.consolidated.shared.SpreadScheduleReference;
import fpml.consolidated.shared.UnderlyerInterestLeg;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="BasketConstituent", builder=BasketConstituentBuilderImpl.class, version="1.2.2")
@RuneDataType(value="BasketConstituent", model="fpml", builder=BasketConstituentBuilderImpl.class, version="1.2.2")
public interface BasketConstituent
extends RosettaModelObject {
    public static final BasketConstituentMeta metaData = new BasketConstituentMeta();

    public PayerReceiverModel getPayerReceiverModel();

    public Asset getUnderlyingAsset();

    public ConstituentWeight getConstituentWeight();

    public Price getUnderlyerPrice();

    public Money getUnderlyerNotional();

    public SpreadScheduleReference getUnderlyerSpread();

    public UnderlyerInterestLeg getUnderlyerFinancing();

    public UnderlyerLoanRate getUnderlyerLoanRate();

    public Collateral getUnderlyerCollateral();

    public String getId();

    public DividendPayout getDividendPayout();

    public PendingPayment getCouponPayment();

    public BasketConstituent build();

    public BasketConstituentBuilder toBuilder();

    public static BasketConstituentBuilder builder() {
        return new BasketConstituentBuilderImpl();
    }

    default public RosettaMetaData<? extends BasketConstituent> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends BasketConstituent> getType() {
        return BasketConstituent.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyingAsset"), processor, Asset.class, this.getUnderlyingAsset(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("constituentWeight"), processor, ConstituentWeight.class, this.getConstituentWeight(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyerPrice"), processor, Price.class, this.getUnderlyerPrice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyerNotional"), processor, Money.class, this.getUnderlyerNotional(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyerSpread"), processor, SpreadScheduleReference.class, this.getUnderlyerSpread(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyerFinancing"), processor, UnderlyerInterestLeg.class, this.getUnderlyerFinancing(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyerLoanRate"), processor, UnderlyerLoanRate.class, this.getUnderlyerLoanRate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyerCollateral"), processor, Collateral.class, this.getUnderlyerCollateral(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dividendPayout"), processor, DividendPayout.class, this.getDividendPayout(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("couponPayment"), processor, PendingPayment.class, this.getCouponPayment(), new AttributeMeta[0]);
    }

    public static class BasketConstituentBuilderImpl
    implements BasketConstituentBuilder {
        protected PayerReceiverModel.PayerReceiverModelBuilder payerReceiverModel;
        protected Asset.AssetBuilder underlyingAsset;
        protected ConstituentWeight.ConstituentWeightBuilder constituentWeight;
        protected Price.PriceBuilder underlyerPrice;
        protected Money.MoneyBuilder underlyerNotional;
        protected SpreadScheduleReference.SpreadScheduleReferenceBuilder underlyerSpread;
        protected UnderlyerInterestLeg.UnderlyerInterestLegBuilder underlyerFinancing;
        protected UnderlyerLoanRate.UnderlyerLoanRateBuilder underlyerLoanRate;
        protected Collateral.CollateralBuilder underlyerCollateral;
        protected String id;
        protected DividendPayout.DividendPayoutBuilder dividendPayout;
        protected PendingPayment.PendingPaymentBuilder couponPayment;

        @Override
        @RosettaAttribute(value="payerReceiverModel")
        @RuneAttribute(value="payerReceiverModel")
        public PayerReceiverModel.PayerReceiverModelBuilder getPayerReceiverModel() {
            return this.payerReceiverModel;
        }

        @Override
        public PayerReceiverModel.PayerReceiverModelBuilder getOrCreatePayerReceiverModel() {
            PayerReceiverModel.PayerReceiverModelBuilder result = this.payerReceiverModel != null ? this.payerReceiverModel : (this.payerReceiverModel = PayerReceiverModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="underlyingAsset", isRequired=true)
        @RuneAttribute(value="underlyingAsset", isRequired=true)
        public Asset.AssetBuilder getUnderlyingAsset() {
            return this.underlyingAsset;
        }

        @Override
        public Asset.AssetBuilder getOrCreateUnderlyingAsset() {
            Asset.AssetBuilder result = this.underlyingAsset != null ? this.underlyingAsset : (this.underlyingAsset = Asset.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="constituentWeight")
        @RuneAttribute(value="constituentWeight")
        public ConstituentWeight.ConstituentWeightBuilder getConstituentWeight() {
            return this.constituentWeight;
        }

        @Override
        public ConstituentWeight.ConstituentWeightBuilder getOrCreateConstituentWeight() {
            ConstituentWeight.ConstituentWeightBuilder result = this.constituentWeight != null ? this.constituentWeight : (this.constituentWeight = ConstituentWeight.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="underlyerPrice")
        @RuneAttribute(value="underlyerPrice")
        public Price.PriceBuilder getUnderlyerPrice() {
            return this.underlyerPrice;
        }

        @Override
        public Price.PriceBuilder getOrCreateUnderlyerPrice() {
            Price.PriceBuilder result = this.underlyerPrice != null ? this.underlyerPrice : (this.underlyerPrice = Price.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="underlyerNotional")
        @RuneAttribute(value="underlyerNotional")
        public Money.MoneyBuilder getUnderlyerNotional() {
            return this.underlyerNotional;
        }

        @Override
        public Money.MoneyBuilder getOrCreateUnderlyerNotional() {
            Money.MoneyBuilder result = this.underlyerNotional != null ? this.underlyerNotional : (this.underlyerNotional = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="underlyerSpread")
        @RuneAttribute(value="underlyerSpread")
        public SpreadScheduleReference.SpreadScheduleReferenceBuilder getUnderlyerSpread() {
            return this.underlyerSpread;
        }

        @Override
        public SpreadScheduleReference.SpreadScheduleReferenceBuilder getOrCreateUnderlyerSpread() {
            SpreadScheduleReference.SpreadScheduleReferenceBuilder result = this.underlyerSpread != null ? this.underlyerSpread : (this.underlyerSpread = SpreadScheduleReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="underlyerFinancing")
        @RuneAttribute(value="underlyerFinancing")
        public UnderlyerInterestLeg.UnderlyerInterestLegBuilder getUnderlyerFinancing() {
            return this.underlyerFinancing;
        }

        @Override
        public UnderlyerInterestLeg.UnderlyerInterestLegBuilder getOrCreateUnderlyerFinancing() {
            UnderlyerInterestLeg.UnderlyerInterestLegBuilder result = this.underlyerFinancing != null ? this.underlyerFinancing : (this.underlyerFinancing = UnderlyerInterestLeg.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="underlyerLoanRate")
        @RuneAttribute(value="underlyerLoanRate")
        public UnderlyerLoanRate.UnderlyerLoanRateBuilder getUnderlyerLoanRate() {
            return this.underlyerLoanRate;
        }

        @Override
        public UnderlyerLoanRate.UnderlyerLoanRateBuilder getOrCreateUnderlyerLoanRate() {
            UnderlyerLoanRate.UnderlyerLoanRateBuilder result = this.underlyerLoanRate != null ? this.underlyerLoanRate : (this.underlyerLoanRate = UnderlyerLoanRate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="underlyerCollateral")
        @RuneAttribute(value="underlyerCollateral")
        public Collateral.CollateralBuilder getUnderlyerCollateral() {
            return this.underlyerCollateral;
        }

        @Override
        public Collateral.CollateralBuilder getOrCreateUnderlyerCollateral() {
            Collateral.CollateralBuilder result = this.underlyerCollateral != null ? this.underlyerCollateral : (this.underlyerCollateral = Collateral.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="dividendPayout")
        @RuneAttribute(value="dividendPayout")
        public DividendPayout.DividendPayoutBuilder getDividendPayout() {
            return this.dividendPayout;
        }

        @Override
        public DividendPayout.DividendPayoutBuilder getOrCreateDividendPayout() {
            DividendPayout.DividendPayoutBuilder result = this.dividendPayout != null ? this.dividendPayout : (this.dividendPayout = DividendPayout.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="couponPayment")
        @RuneAttribute(value="couponPayment")
        public PendingPayment.PendingPaymentBuilder getCouponPayment() {
            return this.couponPayment;
        }

        @Override
        public PendingPayment.PendingPaymentBuilder getOrCreateCouponPayment() {
            PendingPayment.PendingPaymentBuilder result = this.couponPayment != null ? this.couponPayment : (this.couponPayment = PendingPayment.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel")
        @RuneAttribute(value="payerReceiverModel")
        public BasketConstituentBuilder setPayerReceiverModel(PayerReceiverModel _payerReceiverModel) {
            this.payerReceiverModel = _payerReceiverModel == null ? null : _payerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingAsset", isRequired=true)
        @RuneAttribute(value="underlyingAsset", isRequired=true)
        public BasketConstituentBuilder setUnderlyingAsset(Asset _underlyingAsset) {
            this.underlyingAsset = _underlyingAsset == null ? null : _underlyingAsset.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="constituentWeight")
        @RuneAttribute(value="constituentWeight")
        public BasketConstituentBuilder setConstituentWeight(ConstituentWeight _constituentWeight) {
            this.constituentWeight = _constituentWeight == null ? null : _constituentWeight.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyerPrice")
        @RuneAttribute(value="underlyerPrice")
        public BasketConstituentBuilder setUnderlyerPrice(Price _underlyerPrice) {
            this.underlyerPrice = _underlyerPrice == null ? null : _underlyerPrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyerNotional")
        @RuneAttribute(value="underlyerNotional")
        public BasketConstituentBuilder setUnderlyerNotional(Money _underlyerNotional) {
            this.underlyerNotional = _underlyerNotional == null ? null : _underlyerNotional.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyerSpread")
        @RuneAttribute(value="underlyerSpread")
        public BasketConstituentBuilder setUnderlyerSpread(SpreadScheduleReference _underlyerSpread) {
            this.underlyerSpread = _underlyerSpread == null ? null : _underlyerSpread.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyerFinancing")
        @RuneAttribute(value="underlyerFinancing")
        public BasketConstituentBuilder setUnderlyerFinancing(UnderlyerInterestLeg _underlyerFinancing) {
            this.underlyerFinancing = _underlyerFinancing == null ? null : _underlyerFinancing.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyerLoanRate")
        @RuneAttribute(value="underlyerLoanRate")
        public BasketConstituentBuilder setUnderlyerLoanRate(UnderlyerLoanRate _underlyerLoanRate) {
            this.underlyerLoanRate = _underlyerLoanRate == null ? null : _underlyerLoanRate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyerCollateral")
        @RuneAttribute(value="underlyerCollateral")
        public BasketConstituentBuilder setUnderlyerCollateral(Collateral _underlyerCollateral) {
            this.underlyerCollateral = _underlyerCollateral == null ? null : _underlyerCollateral.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public BasketConstituentBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="dividendPayout")
        @RuneAttribute(value="dividendPayout")
        public BasketConstituentBuilder setDividendPayout(DividendPayout _dividendPayout) {
            this.dividendPayout = _dividendPayout == null ? null : _dividendPayout.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="couponPayment")
        @RuneAttribute(value="couponPayment")
        public BasketConstituentBuilder setCouponPayment(PendingPayment _couponPayment) {
            this.couponPayment = _couponPayment == null ? null : _couponPayment.toBuilder();
            return this;
        }

        @Override
        public BasketConstituent build() {
            return new BasketConstituentImpl(this);
        }

        @Override
        public BasketConstituentBuilder toBuilder() {
            return this;
        }

        @Override
        public BasketConstituentBuilder prune() {
            if (this.payerReceiverModel != null && !this.payerReceiverModel.prune().hasData()) {
                this.payerReceiverModel = null;
            }
            if (this.underlyingAsset != null && !this.underlyingAsset.prune().hasData()) {
                this.underlyingAsset = null;
            }
            if (this.constituentWeight != null && !this.constituentWeight.prune().hasData()) {
                this.constituentWeight = null;
            }
            if (this.underlyerPrice != null && !this.underlyerPrice.prune().hasData()) {
                this.underlyerPrice = null;
            }
            if (this.underlyerNotional != null && !this.underlyerNotional.prune().hasData()) {
                this.underlyerNotional = null;
            }
            if (this.underlyerSpread != null && !this.underlyerSpread.prune().hasData()) {
                this.underlyerSpread = null;
            }
            if (this.underlyerFinancing != null && !this.underlyerFinancing.prune().hasData()) {
                this.underlyerFinancing = null;
            }
            if (this.underlyerLoanRate != null && !this.underlyerLoanRate.prune().hasData()) {
                this.underlyerLoanRate = null;
            }
            if (this.underlyerCollateral != null && !this.underlyerCollateral.prune().hasData()) {
                this.underlyerCollateral = null;
            }
            if (this.dividendPayout != null && !this.dividendPayout.prune().hasData()) {
                this.dividendPayout = null;
            }
            if (this.couponPayment != null && !this.couponPayment.prune().hasData()) {
                this.couponPayment = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPayerReceiverModel() != null && this.getPayerReceiverModel().hasData()) {
                return true;
            }
            if (this.getUnderlyingAsset() != null && this.getUnderlyingAsset().hasData()) {
                return true;
            }
            if (this.getConstituentWeight() != null && this.getConstituentWeight().hasData()) {
                return true;
            }
            if (this.getUnderlyerPrice() != null && this.getUnderlyerPrice().hasData()) {
                return true;
            }
            if (this.getUnderlyerNotional() != null && this.getUnderlyerNotional().hasData()) {
                return true;
            }
            if (this.getUnderlyerSpread() != null && this.getUnderlyerSpread().hasData()) {
                return true;
            }
            if (this.getUnderlyerFinancing() != null && this.getUnderlyerFinancing().hasData()) {
                return true;
            }
            if (this.getUnderlyerLoanRate() != null && this.getUnderlyerLoanRate().hasData()) {
                return true;
            }
            if (this.getUnderlyerCollateral() != null && this.getUnderlyerCollateral().hasData()) {
                return true;
            }
            if (this.getId() != null) {
                return true;
            }
            if (this.getDividendPayout() != null && this.getDividendPayout().hasData()) {
                return true;
            }
            return this.getCouponPayment() != null && this.getCouponPayment().hasData();
        }

        public BasketConstituentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            BasketConstituentBuilder o = (BasketConstituentBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPayerReceiverModel(), (RosettaModelObjectBuilder)o.getPayerReceiverModel(), this::setPayerReceiverModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnderlyingAsset(), (RosettaModelObjectBuilder)o.getUnderlyingAsset(), this::setUnderlyingAsset);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getConstituentWeight(), (RosettaModelObjectBuilder)o.getConstituentWeight(), this::setConstituentWeight);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnderlyerPrice(), (RosettaModelObjectBuilder)o.getUnderlyerPrice(), this::setUnderlyerPrice);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnderlyerNotional(), (RosettaModelObjectBuilder)o.getUnderlyerNotional(), this::setUnderlyerNotional);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnderlyerSpread(), (RosettaModelObjectBuilder)o.getUnderlyerSpread(), this::setUnderlyerSpread);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnderlyerFinancing(), (RosettaModelObjectBuilder)o.getUnderlyerFinancing(), this::setUnderlyerFinancing);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnderlyerLoanRate(), (RosettaModelObjectBuilder)o.getUnderlyerLoanRate(), this::setUnderlyerLoanRate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnderlyerCollateral(), (RosettaModelObjectBuilder)o.getUnderlyerCollateral(), this::setUnderlyerCollateral);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDividendPayout(), (RosettaModelObjectBuilder)o.getDividendPayout(), this::setDividendPayout);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCouponPayment(), (RosettaModelObjectBuilder)o.getCouponPayment(), this::setCouponPayment);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BasketConstituent _that = this.getType().cast(o);
            if (!Objects.equals(this.payerReceiverModel, _that.getPayerReceiverModel())) {
                return false;
            }
            if (!Objects.equals(this.underlyingAsset, _that.getUnderlyingAsset())) {
                return false;
            }
            if (!Objects.equals(this.constituentWeight, _that.getConstituentWeight())) {
                return false;
            }
            if (!Objects.equals(this.underlyerPrice, _that.getUnderlyerPrice())) {
                return false;
            }
            if (!Objects.equals(this.underlyerNotional, _that.getUnderlyerNotional())) {
                return false;
            }
            if (!Objects.equals(this.underlyerSpread, _that.getUnderlyerSpread())) {
                return false;
            }
            if (!Objects.equals(this.underlyerFinancing, _that.getUnderlyerFinancing())) {
                return false;
            }
            if (!Objects.equals(this.underlyerLoanRate, _that.getUnderlyerLoanRate())) {
                return false;
            }
            if (!Objects.equals(this.underlyerCollateral, _that.getUnderlyerCollateral())) {
                return false;
            }
            if (!Objects.equals(this.id, _that.getId())) {
                return false;
            }
            if (!Objects.equals(this.dividendPayout, _that.getDividendPayout())) {
                return false;
            }
            return Objects.equals(this.couponPayment, _that.getCouponPayment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.payerReceiverModel != null ? this.payerReceiverModel.hashCode() : 0);
            _result = 31 * _result + (this.underlyingAsset != null ? this.underlyingAsset.hashCode() : 0);
            _result = 31 * _result + (this.constituentWeight != null ? this.constituentWeight.hashCode() : 0);
            _result = 31 * _result + (this.underlyerPrice != null ? this.underlyerPrice.hashCode() : 0);
            _result = 31 * _result + (this.underlyerNotional != null ? this.underlyerNotional.hashCode() : 0);
            _result = 31 * _result + (this.underlyerSpread != null ? this.underlyerSpread.hashCode() : 0);
            _result = 31 * _result + (this.underlyerFinancing != null ? this.underlyerFinancing.hashCode() : 0);
            _result = 31 * _result + (this.underlyerLoanRate != null ? this.underlyerLoanRate.hashCode() : 0);
            _result = 31 * _result + (this.underlyerCollateral != null ? this.underlyerCollateral.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            _result = 31 * _result + (this.dividendPayout != null ? this.dividendPayout.hashCode() : 0);
            _result = 31 * _result + (this.couponPayment != null ? this.couponPayment.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BasketConstituentBuilder {payerReceiverModel=" + String.valueOf(this.payerReceiverModel) + ", underlyingAsset=" + String.valueOf(this.underlyingAsset) + ", constituentWeight=" + String.valueOf(this.constituentWeight) + ", underlyerPrice=" + String.valueOf(this.underlyerPrice) + ", underlyerNotional=" + String.valueOf(this.underlyerNotional) + ", underlyerSpread=" + String.valueOf(this.underlyerSpread) + ", underlyerFinancing=" + String.valueOf(this.underlyerFinancing) + ", underlyerLoanRate=" + String.valueOf(this.underlyerLoanRate) + ", underlyerCollateral=" + String.valueOf(this.underlyerCollateral) + ", id=" + this.id + ", dividendPayout=" + String.valueOf(this.dividendPayout) + ", couponPayment=" + String.valueOf(this.couponPayment) + "}";
        }
    }

    public static interface BasketConstituentBuilder
    extends BasketConstituent,
    RosettaModelObjectBuilder {
        public PayerReceiverModel.PayerReceiverModelBuilder getOrCreatePayerReceiverModel();

        @Override
        public PayerReceiverModel.PayerReceiverModelBuilder getPayerReceiverModel();

        public Asset.AssetBuilder getOrCreateUnderlyingAsset();

        @Override
        public Asset.AssetBuilder getUnderlyingAsset();

        public ConstituentWeight.ConstituentWeightBuilder getOrCreateConstituentWeight();

        @Override
        public ConstituentWeight.ConstituentWeightBuilder getConstituentWeight();

        public Price.PriceBuilder getOrCreateUnderlyerPrice();

        @Override
        public Price.PriceBuilder getUnderlyerPrice();

        public Money.MoneyBuilder getOrCreateUnderlyerNotional();

        @Override
        public Money.MoneyBuilder getUnderlyerNotional();

        public SpreadScheduleReference.SpreadScheduleReferenceBuilder getOrCreateUnderlyerSpread();

        @Override
        public SpreadScheduleReference.SpreadScheduleReferenceBuilder getUnderlyerSpread();

        public UnderlyerInterestLeg.UnderlyerInterestLegBuilder getOrCreateUnderlyerFinancing();

        @Override
        public UnderlyerInterestLeg.UnderlyerInterestLegBuilder getUnderlyerFinancing();

        public UnderlyerLoanRate.UnderlyerLoanRateBuilder getOrCreateUnderlyerLoanRate();

        @Override
        public UnderlyerLoanRate.UnderlyerLoanRateBuilder getUnderlyerLoanRate();

        public Collateral.CollateralBuilder getOrCreateUnderlyerCollateral();

        @Override
        public Collateral.CollateralBuilder getUnderlyerCollateral();

        public DividendPayout.DividendPayoutBuilder getOrCreateDividendPayout();

        @Override
        public DividendPayout.DividendPayoutBuilder getDividendPayout();

        public PendingPayment.PendingPaymentBuilder getOrCreateCouponPayment();

        @Override
        public PendingPayment.PendingPaymentBuilder getCouponPayment();

        public BasketConstituentBuilder setPayerReceiverModel(PayerReceiverModel var1);

        public BasketConstituentBuilder setUnderlyingAsset(Asset var1);

        public BasketConstituentBuilder setConstituentWeight(ConstituentWeight var1);

        public BasketConstituentBuilder setUnderlyerPrice(Price var1);

        public BasketConstituentBuilder setUnderlyerNotional(Money var1);

        public BasketConstituentBuilder setUnderlyerSpread(SpreadScheduleReference var1);

        public BasketConstituentBuilder setUnderlyerFinancing(UnderlyerInterestLeg var1);

        public BasketConstituentBuilder setUnderlyerLoanRate(UnderlyerLoanRate var1);

        public BasketConstituentBuilder setUnderlyerCollateral(Collateral var1);

        public BasketConstituentBuilder setId(String var1);

        public BasketConstituentBuilder setDividendPayout(DividendPayout var1);

        public BasketConstituentBuilder setCouponPayment(PendingPayment var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.PayerReceiverModelBuilder.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyingAsset"), processor, Asset.AssetBuilder.class, this.getUnderlyingAsset(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("constituentWeight"), processor, ConstituentWeight.ConstituentWeightBuilder.class, this.getConstituentWeight(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyerPrice"), processor, Price.PriceBuilder.class, this.getUnderlyerPrice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyerNotional"), processor, Money.MoneyBuilder.class, this.getUnderlyerNotional(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyerSpread"), processor, SpreadScheduleReference.SpreadScheduleReferenceBuilder.class, this.getUnderlyerSpread(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyerFinancing"), processor, UnderlyerInterestLeg.UnderlyerInterestLegBuilder.class, this.getUnderlyerFinancing(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyerLoanRate"), processor, UnderlyerLoanRate.UnderlyerLoanRateBuilder.class, this.getUnderlyerLoanRate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyerCollateral"), processor, Collateral.CollateralBuilder.class, this.getUnderlyerCollateral(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dividendPayout"), processor, DividendPayout.DividendPayoutBuilder.class, this.getDividendPayout(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("couponPayment"), processor, PendingPayment.PendingPaymentBuilder.class, this.getCouponPayment(), new AttributeMeta[0]);
        }

        public BasketConstituentBuilder prune();
    }

    public static class BasketConstituentImpl
    implements BasketConstituent {
        private final PayerReceiverModel payerReceiverModel;
        private final Asset underlyingAsset;
        private final ConstituentWeight constituentWeight;
        private final Price underlyerPrice;
        private final Money underlyerNotional;
        private final SpreadScheduleReference underlyerSpread;
        private final UnderlyerInterestLeg underlyerFinancing;
        private final UnderlyerLoanRate underlyerLoanRate;
        private final Collateral underlyerCollateral;
        private final String id;
        private final DividendPayout dividendPayout;
        private final PendingPayment couponPayment;

        protected BasketConstituentImpl(BasketConstituentBuilder builder) {
            this.payerReceiverModel = Optional.ofNullable(builder.getPayerReceiverModel()).map(f -> f.build()).orElse(null);
            this.underlyingAsset = Optional.ofNullable(builder.getUnderlyingAsset()).map(f -> f.build()).orElse(null);
            this.constituentWeight = Optional.ofNullable(builder.getConstituentWeight()).map(f -> f.build()).orElse(null);
            this.underlyerPrice = Optional.ofNullable(builder.getUnderlyerPrice()).map(f -> f.build()).orElse(null);
            this.underlyerNotional = Optional.ofNullable(builder.getUnderlyerNotional()).map(f -> f.build()).orElse(null);
            this.underlyerSpread = Optional.ofNullable(builder.getUnderlyerSpread()).map(f -> f.build()).orElse(null);
            this.underlyerFinancing = Optional.ofNullable(builder.getUnderlyerFinancing()).map(f -> f.build()).orElse(null);
            this.underlyerLoanRate = Optional.ofNullable(builder.getUnderlyerLoanRate()).map(f -> f.build()).orElse(null);
            this.underlyerCollateral = Optional.ofNullable(builder.getUnderlyerCollateral()).map(f -> f.build()).orElse(null);
            this.id = builder.getId();
            this.dividendPayout = Optional.ofNullable(builder.getDividendPayout()).map(f -> f.build()).orElse(null);
            this.couponPayment = Optional.ofNullable(builder.getCouponPayment()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel")
        @RuneAttribute(value="payerReceiverModel")
        public PayerReceiverModel getPayerReceiverModel() {
            return this.payerReceiverModel;
        }

        @Override
        @RosettaAttribute(value="underlyingAsset", isRequired=true)
        @RuneAttribute(value="underlyingAsset", isRequired=true)
        public Asset getUnderlyingAsset() {
            return this.underlyingAsset;
        }

        @Override
        @RosettaAttribute(value="constituentWeight")
        @RuneAttribute(value="constituentWeight")
        public ConstituentWeight getConstituentWeight() {
            return this.constituentWeight;
        }

        @Override
        @RosettaAttribute(value="underlyerPrice")
        @RuneAttribute(value="underlyerPrice")
        public Price getUnderlyerPrice() {
            return this.underlyerPrice;
        }

        @Override
        @RosettaAttribute(value="underlyerNotional")
        @RuneAttribute(value="underlyerNotional")
        public Money getUnderlyerNotional() {
            return this.underlyerNotional;
        }

        @Override
        @RosettaAttribute(value="underlyerSpread")
        @RuneAttribute(value="underlyerSpread")
        public SpreadScheduleReference getUnderlyerSpread() {
            return this.underlyerSpread;
        }

        @Override
        @RosettaAttribute(value="underlyerFinancing")
        @RuneAttribute(value="underlyerFinancing")
        public UnderlyerInterestLeg getUnderlyerFinancing() {
            return this.underlyerFinancing;
        }

        @Override
        @RosettaAttribute(value="underlyerLoanRate")
        @RuneAttribute(value="underlyerLoanRate")
        public UnderlyerLoanRate getUnderlyerLoanRate() {
            return this.underlyerLoanRate;
        }

        @Override
        @RosettaAttribute(value="underlyerCollateral")
        @RuneAttribute(value="underlyerCollateral")
        public Collateral getUnderlyerCollateral() {
            return this.underlyerCollateral;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="dividendPayout")
        @RuneAttribute(value="dividendPayout")
        public DividendPayout getDividendPayout() {
            return this.dividendPayout;
        }

        @Override
        @RosettaAttribute(value="couponPayment")
        @RuneAttribute(value="couponPayment")
        public PendingPayment getCouponPayment() {
            return this.couponPayment;
        }

        @Override
        public BasketConstituent build() {
            return this;
        }

        @Override
        public BasketConstituentBuilder toBuilder() {
            BasketConstituentBuilder builder = BasketConstituent.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BasketConstituentBuilder builder) {
            Optional.ofNullable(this.getPayerReceiverModel()).ifPresent(builder::setPayerReceiverModel);
            Optional.ofNullable(this.getUnderlyingAsset()).ifPresent(builder::setUnderlyingAsset);
            Optional.ofNullable(this.getConstituentWeight()).ifPresent(builder::setConstituentWeight);
            Optional.ofNullable(this.getUnderlyerPrice()).ifPresent(builder::setUnderlyerPrice);
            Optional.ofNullable(this.getUnderlyerNotional()).ifPresent(builder::setUnderlyerNotional);
            Optional.ofNullable(this.getUnderlyerSpread()).ifPresent(builder::setUnderlyerSpread);
            Optional.ofNullable(this.getUnderlyerFinancing()).ifPresent(builder::setUnderlyerFinancing);
            Optional.ofNullable(this.getUnderlyerLoanRate()).ifPresent(builder::setUnderlyerLoanRate);
            Optional.ofNullable(this.getUnderlyerCollateral()).ifPresent(builder::setUnderlyerCollateral);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
            Optional.ofNullable(this.getDividendPayout()).ifPresent(builder::setDividendPayout);
            Optional.ofNullable(this.getCouponPayment()).ifPresent(builder::setCouponPayment);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BasketConstituent _that = this.getType().cast(o);
            if (!Objects.equals(this.payerReceiverModel, _that.getPayerReceiverModel())) {
                return false;
            }
            if (!Objects.equals(this.underlyingAsset, _that.getUnderlyingAsset())) {
                return false;
            }
            if (!Objects.equals(this.constituentWeight, _that.getConstituentWeight())) {
                return false;
            }
            if (!Objects.equals(this.underlyerPrice, _that.getUnderlyerPrice())) {
                return false;
            }
            if (!Objects.equals(this.underlyerNotional, _that.getUnderlyerNotional())) {
                return false;
            }
            if (!Objects.equals(this.underlyerSpread, _that.getUnderlyerSpread())) {
                return false;
            }
            if (!Objects.equals(this.underlyerFinancing, _that.getUnderlyerFinancing())) {
                return false;
            }
            if (!Objects.equals(this.underlyerLoanRate, _that.getUnderlyerLoanRate())) {
                return false;
            }
            if (!Objects.equals(this.underlyerCollateral, _that.getUnderlyerCollateral())) {
                return false;
            }
            if (!Objects.equals(this.id, _that.getId())) {
                return false;
            }
            if (!Objects.equals(this.dividendPayout, _that.getDividendPayout())) {
                return false;
            }
            return Objects.equals(this.couponPayment, _that.getCouponPayment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.payerReceiverModel != null ? this.payerReceiverModel.hashCode() : 0);
            _result = 31 * _result + (this.underlyingAsset != null ? this.underlyingAsset.hashCode() : 0);
            _result = 31 * _result + (this.constituentWeight != null ? this.constituentWeight.hashCode() : 0);
            _result = 31 * _result + (this.underlyerPrice != null ? this.underlyerPrice.hashCode() : 0);
            _result = 31 * _result + (this.underlyerNotional != null ? this.underlyerNotional.hashCode() : 0);
            _result = 31 * _result + (this.underlyerSpread != null ? this.underlyerSpread.hashCode() : 0);
            _result = 31 * _result + (this.underlyerFinancing != null ? this.underlyerFinancing.hashCode() : 0);
            _result = 31 * _result + (this.underlyerLoanRate != null ? this.underlyerLoanRate.hashCode() : 0);
            _result = 31 * _result + (this.underlyerCollateral != null ? this.underlyerCollateral.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            _result = 31 * _result + (this.dividendPayout != null ? this.dividendPayout.hashCode() : 0);
            _result = 31 * _result + (this.couponPayment != null ? this.couponPayment.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BasketConstituent {payerReceiverModel=" + String.valueOf(this.payerReceiverModel) + ", underlyingAsset=" + String.valueOf(this.underlyingAsset) + ", constituentWeight=" + String.valueOf(this.constituentWeight) + ", underlyerPrice=" + String.valueOf(this.underlyerPrice) + ", underlyerNotional=" + String.valueOf(this.underlyerNotional) + ", underlyerSpread=" + String.valueOf(this.underlyerSpread) + ", underlyerFinancing=" + String.valueOf(this.underlyerFinancing) + ", underlyerLoanRate=" + String.valueOf(this.underlyerLoanRate) + ", underlyerCollateral=" + String.valueOf(this.underlyerCollateral) + ", id=" + this.id + ", dividendPayout=" + String.valueOf(this.dividendPayout) + ", couponPayment=" + String.valueOf(this.couponPayment) + "}";
        }
    }
}

