/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.testing.schemeimport.fpml;

import com.google.common.collect.Lists;
import com.regnosys.rosetta.common.util.UrlUtils;
import com.regnosys.rosetta.rosetta.RosettaEnumValue;
import com.regnosys.rosetta.rosetta.RosettaFactory;
import com.regnosys.rosetta.rosetta.impl.RosettaFactoryImpl;
import com.regnosys.testing.schemeimport.SchemeEnumReader;
import com.regnosys.testing.schemeimport.fpml.FpMLSchemeHelper;
import jakarta.inject.Inject;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.genericode.xml._2004.ns.codelist._0.CodeListDocument;
import org.genericode.xml._2004.ns.codelist._0.CodeListRef;
import org.genericode.xml._2004.ns.codelist._0.CodeListSetDocument;
import org.genericode.xml._2004.ns.codelist._0.Column;
import org.genericode.xml._2004.ns.codelist._0.Row;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FpMLSchemeEnumReader
implements SchemeEnumReader {
    private static final String CODING_SCHEME_RELATIVE_PATH = "coding-schemes/fpml/";
    private static final Logger LOGGER = LoggerFactory.getLogger(FpMLSchemeEnumReader.class);
    public static final String VERSION = "Version";
    public static final String CODE = "Code";
    public static final String DESCRIPTION = "Description";
    public static final String CODING_SCHEME = "http://www.fpml.org/coding-scheme/";
    private final URL codingSchemeUrl;

    @Inject
    public FpMLSchemeEnumReader(FpMLSchemeHelper fpMLSchemeHelper) {
        this.codingSchemeUrl = fpMLSchemeHelper.getLatestSetOfSchemeUrl();
    }

    @Override
    public List<RosettaEnumValue> generateEnumFromScheme(URL schemaLocationForEnum) {
        try {
            Map<String, CodeListDocument> stringCodeListDocumentMap = this.readSchemaFiles(this.codingSchemeUrl, CODING_SCHEME_RELATIVE_PATH);
            CodeListDocument codeListDocument = stringCodeListDocumentMap.get(schemaLocationForEnum.toString());
            if (codeListDocument != null) {
                Pair<List<RosettaEnumValue>, String> transform = this.transform(codeListDocument);
                return (List)transform.getFirst();
            }
            LOGGER.warn("No document found for schema location {}", (Object)schemaLocationForEnum);
        }
        catch (IOException | JAXBException | XMLStreamException e) {
            throw new RuntimeException(e);
        }
        return new ArrayList<RosettaEnumValue>();
    }

    private Pair<List<RosettaEnumValue>, String> transform(CodeListDocument doc) {
        int nameIndex = 0;
        int descriptionIndex = 0;
        String versionString = null;
        List<JAXBElement<String>> content = doc.getIdentification().getContent();
        for (JAXBElement<String> element : content) {
            QName name = element.getName();
            if (!name.getLocalPart().equals(VERSION)) continue;
            versionString = (String)element.getValue();
        }
        List cols = doc.getColumnSet().getColumnChoice().stream().filter(Column.class::isInstance).map(Column.class::cast).collect(Collectors.toList());
        for (int i = 0; i < cols.size(); ++i) {
            Column c = (Column)cols.get(i);
            if (c.getId().equals(CODE)) {
                nameIndex = i;
            }
            if (!c.getId().equals(DESCRIPTION)) continue;
            descriptionIndex = i;
        }
        ArrayList<RosettaEnumValue> result = new ArrayList<RosettaEnumValue>();
        for (Row row : Lists.reverse(doc.getSimpleCodeList().getRow())) {
            result.add(this.createEnumValue(result, row, nameIndex, descriptionIndex));
        }
        return Tuples.create((Object)Lists.reverse(result), (Object)versionString);
    }

    private RosettaEnumValue createEnumValue(List<RosettaEnumValue> result, Row r, int nameIndex, int descriptionIndex) {
        RosettaFactory factory = RosettaFactoryImpl.eINSTANCE;
        RosettaEnumValue ev = factory.createRosettaEnumValue();
        String displayName = this.encodeDisplayName(r.getValue().get(nameIndex).getSimpleValue().getValue());
        long duplicateCount = result.stream().filter(enumValue -> enumValue.getName().equalsIgnoreCase(this.encodeValue(displayName))).count();
        String value = this.encodeValue(displayName) + (String)(duplicateCount > 0L ? "_" + duplicateCount : "");
        ev.setName(value);
        if (!displayName.equals(value)) {
            ev.setDisplay(displayName);
        }
        ev.setDefinition(this.encodeDescription(r.getValue().get(descriptionIndex).getSimpleValue().getValue()));
        return ev;
    }

    String encodeDisplayName(String name) {
        return FpMLSchemeEnumReader.removeNewLinesAndDuplicatedWhitespace(name);
    }

    String encodeValue(String name) {
        Object replaced = FpMLSchemeEnumReader.removeNewLinesAndDuplicatedWhitespace(name).replaceAll("[-/\"&. ()#':=+]", "_");
        if (((String)replaced).matches("^[0-9].*")) {
            replaced = "_" + (String)replaced;
        }
        return replaced;
    }

    String encodeDescription(String description) {
        return FpMLSchemeEnumReader.removeNewLinesAndDuplicatedWhitespace(description).replace("\t", "").replace("\"", "'").replace("\u201c", "'").replace("\u201d", "'");
    }

    @NotNull
    private static String removeNewLinesAndDuplicatedWhitespace(String name) {
        return name.trim().replaceAll("\n", " ").replaceAll("( )\\1+", "$1");
    }

    private Map<String, CodeListDocument> readSchemaFiles(URL codingSchemeUrl, String codingSchemeRelativePath) throws JAXBException, IOException, XMLStreamException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{CodeListDocument.class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLStreamReader reader = inputFactory.createXMLStreamReader(UrlUtils.openURL((URL)codingSchemeUrl));
        JAXBElement doc = unmarshaller.unmarshal(reader, CodeListSetDocument.class);
        CodeListSetDocument schemeList = (CodeListSetDocument)doc.getValue();
        return schemeList.getCodeListRef().stream().filter(r -> {
            if (r.getLocationUri().get(0).isEmpty()) {
                LOGGER.warn("No location URI for resource: " + r.getCanonicalUri());
                return false;
            }
            return true;
        }).map(r -> this.loadCodeListDocumentEntry(codingSchemeRelativePath, (CodeListRef)r, jaxbContext, inputFactory)).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (first, second) -> {
            LOGGER.warn("Duplicate key found");
            return first;
        }));
    }

    private Map.Entry<String, CodeListDocument> loadCodeListDocumentEntry(String codingSchemeRelativePath, CodeListRef codeListRef, JAXBContext jaxbContext, XMLInputFactory inputFactory) {
        List<String> locationUri = codeListRef.getLocationUri();
        URL localUrl = this.makeUriLocal(codingSchemeRelativePath, codeListRef);
        if (localUrl != null) {
            CodeListDocument codeListDocument = this.readUrl(jaxbContext, inputFactory, localUrl);
            if (codeListDocument != null) {
                LOGGER.debug("Adding entry: key {}, value hashcode {}", (Object)codeListRef.getCanonicalUri(), (Object)codeListDocument.hashCode());
                return Map.entry(codeListRef.getCanonicalUri(), codeListDocument);
            }
        } else {
            LOGGER.warn("The resource: " + String.valueOf(locationUri) + " cannot be loaded");
        }
        return null;
    }

    private URL makeUriLocal(String codingSchemeRelativePath, CodeListRef codeListRef) {
        List<String> locationUris = codeListRef.getLocationUri();
        if (locationUris.size() == 1) {
            String path = locationUris.get(0).replace(CODING_SCHEME, codingSchemeRelativePath);
            Object localPath = path.endsWith(".xml") ? path : path + ".xml";
            return this.getClass().getClassLoader().getResource((String)localPath);
        }
        LOGGER.warn("There were multiple location uris for scheme uri '{}': {}", (Object)codeListRef.getCanonicalUri(), locationUris);
        return null;
    }

    private CodeListDocument readUrl(JAXBContext jaxbContext, XMLInputFactory inputFactory, URL url) {
        try {
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            XMLStreamReader reader = inputFactory.createXMLStreamReader(UrlUtils.openURL((URL)url));
            JAXBElement codeListDocumentJAXBElement = unmarshaller.unmarshal(reader, CodeListDocument.class);
            return (CodeListDocument)codeListDocumentJAXBElement.getValue();
        }
        catch (IOException | JAXBException | XMLStreamException e) {
            LOGGER.warn("Error reading scheme file " + String.valueOf(url), e);
            return null;
        }
    }
}

