/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.testing.pipeline;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Resources;
import com.regnosys.rosetta.common.serialisation.RosettaObjectMapper;
import com.regnosys.rosetta.common.transform.FunctionNameHelper;
import com.regnosys.rosetta.common.transform.PipelineModel;
import com.regnosys.rosetta.common.transform.TestPackModel;
import com.regnosys.rosetta.common.transform.TransformType;
import com.regnosys.rosetta.common.util.UrlUtils;
import com.regnosys.rosetta.common.validation.ValidationReport;
import com.regnosys.testing.pipeline.PipelineFunctionResult;
import com.regnosys.testing.pipeline.PipelineFunctionRunner;
import com.regnosys.testing.pipeline.PipelineFunctionRunnerProvider;
import com.regnosys.testing.pipeline.PipelineModelBuilder;
import com.regnosys.testing.pipeline.PipelineNode;
import com.regnosys.testing.pipeline.PipelineTestPackFilter;
import com.regnosys.testing.pipeline.PipelineTree;
import com.regnosys.testing.pipeline.PipelineTreeBuilder;
import com.regnosys.testing.pipeline.PipelineTreeConfig;
import com.regnosys.testing.reports.ObjectMapperGenerator;
import com.regnosys.testing.validation.ValidationSummariser;
import com.rosetta.model.lib.RosettaModelObject;
import jakarta.inject.Inject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class PipelineTestPackWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipelineTestPackWriter.class);
    private static final ObjectMapper JSON_OBJECT_MAPPER = RosettaObjectMapper.getNewRosettaObjectMapper();
    private final PipelineTreeBuilder pipelineTreeBuilder;
    private final PipelineModelBuilder pipelineModelBuilder;
    private final PipelineFunctionRunnerProvider functionRunnerProvider;
    private final FunctionNameHelper helper;

    @Inject
    public PipelineTestPackWriter(PipelineTreeBuilder pipelineTreeBuilder, PipelineFunctionRunnerProvider functionRunnerProvider, PipelineModelBuilder pipelineModelBuilder, FunctionNameHelper helper) {
        this.pipelineTreeBuilder = pipelineTreeBuilder;
        this.functionRunnerProvider = functionRunnerProvider;
        this.pipelineModelBuilder = pipelineModelBuilder;
        this.helper = helper;
    }

    public void writeTestPacks(PipelineTreeConfig config) throws IOException {
        if (config.getWritePath() == null) {
            LOGGER.error("Write path not configured. Aborting.");
            return;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        ValidationSummariser validationSummariser = config.getValidationSummariser();
        LOGGER.info("Starting test pack Generation");
        ObjectWriter configObjectWriter = ObjectMapperGenerator.createWriterMapper().writerWithDefaultPrettyPrinter();
        ObjectWriter jsonObjectWriter = JSON_OBJECT_MAPPER.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, config.isSortJsonPropertiesAlphabetically()).writerWithDefaultPrettyPrinter();
        Path resourcesPath = config.getWritePath();
        PipelineTree pipelineTree = this.pipelineTreeBuilder.createPipelineTree(config);
        this.createCsvSampleFiles(resourcesPath, config.getCsvTestPackSourceFiles());
        for (PipelineNode pipelineNode : pipelineTree.getNodeList()) {
            Stopwatch pipelineStopwatch = Stopwatch.createStarted();
            TransformType transformType = pipelineNode.getTransformType();
            String functionName = pipelineNode.getFunction().getName();
            LOGGER.info("Generating {} test packs for {} ", (Object)transformType, (Object)functionName);
            PipelineTestPackFilter pipelineTestPackFilter = config.getTestPackFilter();
            if (pipelineTestPackFilter != null && pipelineTestPackFilter.getExcludedFunctionsFromTestPackGeneration().contains(pipelineNode.getFunction())) {
                LOGGER.info("Aborting {} Test Pack Generation for {} as this has been excluded from Test Pack generation", (Object)transformType, (Object)functionName);
                continue;
            }
            Path inputPath = resourcesPath.resolve(pipelineNode.getInputPath(config.isStrictUniqueIds()));
            LOGGER.info("Input path {} ", (Object)inputPath);
            Path outputPath = resourcesPath.resolve(pipelineNode.getOutputPath(config.isStrictUniqueIds()));
            LOGGER.info("Output path {} ", (Object)outputPath);
            List<Path> inputSamples = this.findAllSamples(inputPath);
            Map<String, List<Path>> testPackToSamples = this.filterAndGroupingByTestPackId(resourcesPath, inputPath, inputSamples, config.getTestPackIdFilter(), config.getCsvTestPackSourceFiles());
            Map<String, List<Path>> filteredTestPackToSamples = Optional.ofNullable(pipelineTestPackFilter).map(t -> this.filterTestPacks(pipelineNode, pipelineTestPackFilter, testPackToSamples)).orElse(testPackToSamples);
            for (String testPackId : filteredTestPackToSamples.keySet()) {
                List<Path> inputSamplesForTestPack = filteredTestPackToSamples.get(testPackId);
                TestPackModel testPackModel = this.writeTestPackSamples(resourcesPath, inputPath, outputPath, testPackId, inputSamplesForTestPack, pipelineNode, config, jsonObjectWriter, validationSummariser);
                Path writePath = Files.createDirectories(resourcesPath.resolve(transformType.getResourcePath()).resolve("config"), new FileAttribute[0]);
                Path writeFile = writePath.resolve(testPackModel.getId() + ".json");
                configObjectWriter.writeValue(writeFile.toFile(), (Object)testPackModel);
            }
            LOGGER.info("Generated {} {} test packs for {}, took {}", new Object[]{filteredTestPackToSamples.size(), transformType, functionName, pipelineStopwatch});
        }
        if (validationSummariser != null) {
            validationSummariser.summerize();
        }
        LOGGER.info("Test pack generation complete, took {}", (Object)stopwatch);
    }

    private List<Path> findAllSamples(Path inputDir) throws IOException {
        if (!Files.exists(inputDir, new LinkOption[0])) {
            return List.of();
        }
        try (Stream<Path> paths = Files.walk(inputDir, new FileVisitOption[0]);){
            List<Path> list = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).collect(Collectors.toList());
            return list;
        }
    }

    private TestPackModel writeTestPackSamples(Path resourcesPath, Path inputPath, Path outputDir, String testPackId, List<Path> inputSamplesForTestPack, PipelineNode pipelineNode, PipelineTreeConfig config, ObjectWriter jsonObjectWriter, ValidationSummariser validationSummariser) throws IOException {
        LOGGER.info("Test pack sample generation started for {}", (Object)testPackId);
        TransformType transformType = pipelineNode.getTransformType();
        LOGGER.info("{} {} samples to be generated", (Object)inputSamplesForTestPack.size(), (Object)transformType);
        ArrayList<TestPackModel.SampleModel> sampleModels = new ArrayList<TestPackModel.SampleModel>();
        String pipelineId = pipelineNode.id(config.isStrictUniqueIds());
        String pipelineIdSuffix = pipelineNode.idSuffix(config.isStrictUniqueIds(), "-");
        PipelineModel pipeline = this.pipelineModelBuilder.build(pipelineNode, config);
        PipelineModel.Transform transform = pipeline.getTransform();
        Class<? extends RosettaModelObject> inputType = this.toClass(transform.getInputType());
        Class<? extends RosettaModelObject> functionType = this.toClass(transform.getFunction());
        Class<? extends RosettaModelObject> outputType = this.toClass(transform.getOutputType());
        Validator outputXsdValidator = Optional.ofNullable(config.getXmlSchemaMap()).map(sm -> this.getXsdValidator(outputType, (ImmutableMap<Class<?>, String>)sm)).orElse(null);
        PipelineFunctionRunner functionRunner = this.functionRunnerProvider.create(transform.getType(), inputType, functionType, pipeline.getInputSerialisation(), pipeline.getOutputSerialisation(), JSON_OBJECT_MAPPER, jsonObjectWriter, outputXsdValidator);
        String functionName = functionType.getSimpleName();
        Stopwatch stopwatch = Stopwatch.createStarted();
        for (Path inputSample : inputSamplesForTestPack) {
            LOGGER.info("Generating {} function {} test pack {} sample {}", new Object[]{transformType, functionName, testPackId, inputSample.getFileName()});
            Path relativeOutputPath = resourcesPath.relativize(outputDir.resolve(resourcesPath.relativize(inputPath).relativize(inputSample)));
            Path outputPath = relativeOutputPath.getParent().resolve(Path.of(this.updateFileExtensionBasedOnOutputFormat(pipeline, relativeOutputPath.toFile().getName()), new String[0]));
            PipelineFunctionResult result = functionRunner.run(resourcesPath.resolve(inputSample));
            TestPackModel.SampleModel.Assertions assertions = result.getAssertions();
            String baseFileName = UrlUtils.getBaseFileName((URL)inputSample.toUri().toURL());
            String displayName = baseFileName.replace("-", " ");
            TestPackModel.SampleModel sampleModel = new TestPackModel.SampleModel(baseFileName.toLowerCase(), displayName, inputSample.toString(), outputPath.toString(), assertions);
            sampleModels.add(sampleModel);
            Files.createDirectories(resourcesPath.resolve(outputPath).getParent(), new FileAttribute[0]);
            Files.write(resourcesPath.resolve(outputPath), result.getSerialisedOutput().getBytes(), new OpenOption[0]);
            ValidationReport validationReport = result.getValidationReport();
            if (validationSummariser == null) continue;
            validationSummariser.addValidationReport(pipeline, sampleModel.getName(), sampleModel, validationReport);
        }
        List sortedSamples = sampleModels.stream().sorted(Comparator.comparing(TestPackModel.SampleModel::getId)).collect(Collectors.toList());
        LOGGER.info("Function {} test pack {} generation complete, took {}", new Object[]{functionName, testPackId, stopwatch});
        String testPackName = this.helper.capitalizeFirstLetter(testPackId.replace("-", " "));
        return new TestPackModel(String.format("test-pack-%s-%s-%s", transformType.name().toLowerCase(), pipelineIdSuffix, testPackId), pipelineId, testPackName, sortedSamples);
    }

    @NotNull
    private String updateFileExtensionBasedOnOutputFormat(PipelineModel pipelineModel, String fileName) {
        String outputFormat = Optional.ofNullable(pipelineModel.getOutputSerialisation()).map(PipelineModel.Serialisation::getFormat).map(PipelineModel.Serialisation.Format::getFileExtension).orElse("json");
        return fileName.substring(0, fileName.lastIndexOf(".")) + "." + outputFormat;
    }

    private void createCsvSampleFiles(Path resourcePath, ImmutableSet<Path> csvTestPackSourceFiles) throws IOException {
        for (Path csvSourceFile : csvTestPackSourceFiles) {
            Path resolvedCsvSourcePath = resourcePath.resolve(csvSourceFile);
            BufferedReader reader = Files.newBufferedReader(resolvedCsvSourcePath);
            try {
                String line;
                String header = reader.readLine();
                if (header == null) {
                    throw new IOException("CSV file is empty: " + String.valueOf(resolvedCsvSourcePath));
                }
                int rowNum = 1;
                String baseName = com.google.common.io.Files.getNameWithoutExtension((String)resolvedCsvSourcePath.toString());
                String extension = com.google.common.io.Files.getFileExtension((String)resolvedCsvSourcePath.toString());
                while ((line = reader.readLine()) != null) {
                    String fileName = String.format("%s_%d.%s", baseName, rowNum++, extension);
                    Path outFile = resolvedCsvSourcePath.getParent().resolve(fileName);
                    BufferedWriter writer = Files.newBufferedWriter(outFile, new OpenOption[0]);
                    try {
                        writer.write(header);
                        writer.newLine();
                        writer.write(line);
                    }
                    finally {
                        if (writer == null) continue;
                        writer.close();
                    }
                }
            }
            finally {
                if (reader == null) continue;
                reader.close();
            }
        }
    }

    private Map<String, List<Path>> filterAndGroupingByTestPackId(Path resourcesPath, Path inputPath, List<Path> inputSamples, Predicate<String> testPackIdFilter, ImmutableSet<Path> csvTestPackSourceFiles) {
        return inputSamples.stream().map(resourcesPath::relativize).filter(path -> testPackIdFilter.test(this.testPackId(resourcesPath, inputPath, (Path)path))).filter(path -> !csvTestPackSourceFiles.contains(path)).collect(Collectors.groupingBy(p -> this.testPackId(resourcesPath, inputPath, (Path)p)));
    }

    private String testPackId(Path resourcesPath, Path inputPath, Path samplePath) {
        Path parent = samplePath.getParent();
        Path relativePath = resourcesPath.relativize(inputPath).relativize(parent);
        return relativePath.toString().replace(File.separatorChar, '-');
    }

    @NotNull
    private Map<String, List<Path>> filterTestPacks(PipelineNode pipelineNode, PipelineTestPackFilter pipelineTestPackFilter, Map<String, List<Path>> testPackToSamples) {
        Map<String, List<Path>> filteredTestPackToSamples = testPackToSamples;
        Set testPackSpecificFunctions = pipelineTestPackFilter.getTestPacksSpecificToFunctions().entries().stream().filter(entry -> entry.getValue() == pipelineNode.getFunction()).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (pipelineTestPackFilter.getTestPacksSpecificToFunctions().containsValue(pipelineNode.getFunction())) {
            filteredTestPackToSamples = testPackToSamples.entrySet().stream().filter(entry -> testPackSpecificFunctions.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        } else {
            ImmutableMultiset testPacksToRemove = pipelineTestPackFilter.getTestPacksSpecificToFunctions().keys();
            filteredTestPackToSamples = filteredTestPackToSamples.entrySet().stream().filter(arg_0 -> PipelineTestPackWriter.lambda$filterTestPacks$9((ImmutableCollection)testPacksToRemove, arg_0)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        if (pipelineTestPackFilter.getFunctionsSpecificToTestPacks().containsKey(pipelineNode.getFunction())) {
            filteredTestPackToSamples = filteredTestPackToSamples.entrySet().stream().filter(entry -> pipelineTestPackFilter.getFunctionsSpecificToTestPacks().get(pipelineNode.getFunction()).contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        if (pipelineTestPackFilter.getTestPacksRestrictedForFunctions().values().contains(pipelineNode.getFunction())) {
            filteredTestPackToSamples = filteredTestPackToSamples.entrySet().stream().filter(entry -> this.filterApplicableFunctionsForTestPack((String)entry.getKey(), pipelineNode, pipelineTestPackFilter.getTestPacksRestrictedForFunctions())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        } else {
            ImmutableSet testPacksRestrictedForFunctions = pipelineTestPackFilter.getTestPacksRestrictedForFunctions().keySet();
            filteredTestPackToSamples = filteredTestPackToSamples.entrySet().stream().filter(entry -> !testPacksRestrictedForFunctions.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        return filteredTestPackToSamples;
    }

    protected boolean filterApplicableFunctionsForTestPack(String testPackName, PipelineNode pipelineNode, ImmutableMultimap<String, Class<?>> testPackIncludedReportIds) {
        ImmutableCollection applicableReportsForTestPack = testPackIncludedReportIds.get((Object)testPackName);
        return applicableReportsForTestPack.isEmpty() || applicableReportsForTestPack.contains(pipelineNode.getFunction());
    }

    private Class<? extends RosettaModelObject> toClass(String name) {
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                return contextClassLoader.loadClass(name);
            }
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private Validator getXsdValidator(Class<?> functionType, ImmutableMap<Class<?>, String> outputSchemaMap) {
        URL schemaUrl = Optional.ofNullable((String)outputSchemaMap.get(functionType)).map(Resources::getResource).orElse(null);
        if (schemaUrl == null) {
            return null;
        }
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", false);
            Schema schema = schemaFactory.newSchema(schemaUrl);
            return schema.newValidator();
        }
        catch (SAXException e) {
            throw new RuntimeException(String.format("Failed to create schema validator for %s", schemaUrl), e);
        }
    }

    public boolean isSubPath(Path base, Path other) {
        Path basePath = base.normalize();
        Path otherPath = other.normalize();
        return otherPath.startsWith(basePath);
    }

    private static /* synthetic */ boolean lambda$filterTestPacks$9(ImmutableCollection testPacksToRemove, Map.Entry entry) {
        return !testPacksToRemove.contains(entry.getKey());
    }
}

