/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.testing.pipeline;

import com.fasterxml.jackson.databind.ObjectWriter;
import com.regnosys.rosetta.common.transform.PipelineModel;
import com.regnosys.testing.pipeline.PipelineModelBuilder;
import com.regnosys.testing.pipeline.PipelineTree;
import com.regnosys.testing.pipeline.PipelineTreeBuilder;
import com.regnosys.testing.pipeline.PipelineTreeConfig;
import com.regnosys.testing.reports.ObjectMapperGenerator;
import jakarta.inject.Inject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineModelWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipelineModelWriter.class);
    private final PipelineTreeBuilder pipelineTreeBuilder;
    private final PipelineModelBuilder pipelineModelBuilder;

    @Inject
    public PipelineModelWriter(PipelineTreeBuilder pipelineTreeBuilder, PipelineModelBuilder pipelineModelBuilder) {
        this.pipelineTreeBuilder = pipelineTreeBuilder;
        this.pipelineModelBuilder = pipelineModelBuilder;
    }

    public void writePipelines(PipelineTreeConfig config) throws IOException {
        if (config.getWritePath() == null) {
            LOGGER.error("Write path not configured. Aborting.");
            return;
        }
        Path resourcesPath = config.getWritePath();
        PipelineTree pipelineTree = this.pipelineTreeBuilder.createPipelineTree(config);
        List<PipelineModel> allPipelines = this.pipelineModelBuilder.createPipelineModels(pipelineTree);
        ObjectWriter objectWriter = ObjectMapperGenerator.createWriterMapper().writerWithDefaultPrettyPrinter();
        for (PipelineModel pipeline : allPipelines) {
            LOGGER.info("Generating {} pipeline config files for {}", (Object)pipeline.getTransform().getType(), (Object)pipeline.getName());
            Path writePath = Files.createDirectories(resourcesPath.resolve(pipeline.getTransform().getType().getResourcePath()).resolve("config"), new FileAttribute[0]);
            Path writeFile = writePath.resolve(pipeline.getId() + ".json");
            objectWriter.writeValue(writeFile.toFile(), (Object)pipeline);
        }
    }
}

