/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.testing;

import com.regnosys.rosetta.generator.RosettaGenerator;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.tests.compiler.InMemoryJavacCompiler;
import com.regnosys.testing.CompiledCode;
import com.regnosys.testing.GeneratedCode;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.generator.GeneratorContext;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.testing.util.ParseHelper;
import org.eclipse.xtext.testing.validation.ValidationTestHelper;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.testing.RegisteringFileSystemAccess;

public class ModelHelper {
    private static final String commonTestTypes = "namespace \"com.rosetta.test.model\"\nversion \"test\"\n\nmetaType scheme string\n";
    @Inject
    private RosettaGenerator rosettaGenerator;
    @Inject
    private ParseHelper<RosettaModel> parseHelper;
    @Inject
    private ValidationTestHelper validationTestHelper;

    public GeneratedCode generateCode(CharSequence ... models) throws Exception {
        return this.generateCode(this.parseRosettaWithNoErrors(models).stream().map(EObject::eResource).collect(Collectors.toList()));
    }

    public CompiledCode compileCode(GeneratedCode generatedCode) {
        return this.inMemoryCompileToClasses(generatedCode, this.getClass().getClassLoader());
    }

    public CompiledCode generateAndCompileJava(CharSequence ... models) throws Exception {
        return this.compileCode(this.generateCode(models));
    }

    private CompiledCode inMemoryCompileToClasses(GeneratedCode generatedCode, ClassLoader parentClassLoader) {
        InMemoryJavacCompiler inMemoryCompiler = InMemoryJavacCompiler.newInstance().useParentClassLoader(parentClassLoader).useOptions(new String[]{"--release", "8", "-Xlint:all", "-Xdiags:verbose"});
        generatedCode.getGenerated().forEach((arg_0, arg_1) -> ((InMemoryJavacCompiler)inMemoryCompiler).addSource(arg_0, arg_1));
        return new CompiledCode(inMemoryCompiler.compileAll().values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeneratedCode generateCode(List<Resource> resources) {
        RegisteringFileSystemAccess fsa = new RegisteringFileSystemAccess();
        GeneratorContext ctx = new GeneratorContext(this){

            public CancelIndicator getCancelIndicator() {
                return CancelIndicator.NullImpl;
            }
        };
        ResourceSet resourceSet = resources.get(0).getResourceSet();
        try {
            this.rosettaGenerator.beforeAllGenerate(resourceSet, (IFileSystemAccess2)fsa, (IGeneratorContext)ctx);
            for (Resource eResource : resources) {
                try {
                    this.rosettaGenerator.beforeGenerate(eResource, (IFileSystemAccess2)fsa, (IGeneratorContext)ctx);
                    this.rosettaGenerator.doGenerate(eResource, (IFileSystemAccess2)fsa, (IGeneratorContext)ctx);
                }
                finally {
                    this.rosettaGenerator.afterGenerate(eResource, (IFileSystemAccess2)fsa, (IGeneratorContext)ctx);
                }
            }
        }
        finally {
            this.rosettaGenerator.afterAllGenerate(resourceSet, (IFileSystemAccess2)fsa, (IGeneratorContext)ctx);
        }
        HashMap<String, String> generatedCode = new HashMap<String, String>();
        fsa.getGeneratedFiles().forEach(it -> {
            if (it.getJavaClassName() != null) {
                generatedCode.put(it.getJavaClassName(), it.getContents().toString());
            }
        });
        return new GeneratedCode(generatedCode);
    }

    public List<RosettaModel> parseRosettaWithNoErrors(CharSequence ... models) throws Exception {
        List<RosettaModel> parsed = this.parseRosetta(models);
        for (RosettaModel rosettaModel : parsed) {
            this.validationTestHelper.assertNoErrors((EObject)rosettaModel);
        }
        return parsed;
    }

    private List<RosettaModel> parseRosetta(CharSequence ... models) throws Exception {
        ResourceSet resourceSet = this.testResourceSet();
        ArrayList<RosettaModel> rosettaModels = new ArrayList<RosettaModel>();
        for (CharSequence model : models) {
            rosettaModels.add((RosettaModel)this.parseHelper.parse(model, resourceSet));
        }
        return rosettaModels;
    }

    private ResourceSet testResourceSet() {
        try {
            ResourceSet resourceSet = ((RosettaModel)this.parseHelper.parse((CharSequence)commonTestTypes)).eResource().getResourceSet();
            resourceSet.getResource(URI.createURI((String)"classpath:/model/basictypes.rosetta"), true);
            resourceSet.getResource(URI.createURI((String)"classpath:/model/annotations.rosetta"), true);
            return resourceSet;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

