/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.Service;
import com.refinitiv.eta.valueadd.reactor.Reactor;
import com.refinitiv.eta.valueadd.reactor.ReactorChannel;
import com.refinitiv.eta.valueadd.reactor.ReactorErrorInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorFactory;
import com.refinitiv.eta.valueadd.reactor.ReactorWLSubmitMsgOptions;
import com.refinitiv.eta.valueadd.reactor.ReactorWSBService;
import com.refinitiv.eta.valueadd.reactor.ReactorWarmStandbyEvent;
import com.refinitiv.eta.valueadd.reactor.ReactorWarmStandbyGroupImpl;
import com.refinitiv.eta.valueadd.reactor.ReactorWarmStandbyHandler;
import com.refinitiv.eta.valueadd.reactor.Watchlist;
import com.refinitiv.eta.valueadd.reactor.WlInteger;
import com.refinitiv.eta.valueadd.reactor.WlService;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class WlServiceCache {
    Watchlist _watchlist;
    HashMap<String, WlService> _servicesByNameTable = new HashMap();
    HashMap<WlInteger, WlService> _servicesByIdTable = new HashMap();
    LinkedList<WlService> _serviceList = new LinkedList();
    WlInteger _tempWlInteger = ReactorFactory.createWlInteger();
    boolean initDirectory = false;

    WlServiceCache(Watchlist watchlist) {
        this._watchlist = watchlist;
    }

    int processServiceList(List<Service> serviceList, Msg msg, ReactorErrorInfo errorInfo) {
        int ret = 0;
        WlService wlService = null;
        boolean wsbActive = this._watchlist.reactor().reactorHandlesWarmStandby(this._watchlist.reactorChannel());
        for (Service service : serviceList) {
            switch (service.action()) {
                case 2: {
                    wlService = this.addToCache(service);
                    if (this.initDirectory && wsbActive) {
                        this.wsbUpdateCachedService(wlService, 2, errorInfo);
                    }
                    ret = this._watchlist.itemHandler().serviceAdded(wlService);
                    break;
                }
                case 1: {
                    long serviceState;
                    this._tempWlInteger.value(service.serviceId());
                    wlService = this._servicesByIdTable.get(this._tempWlInteger);
                    if (wlService != null) {
                        serviceState = wlService.rdmService().state().serviceState();
                        service.applyUpdate(wlService.rdmService());
                        if (this.initDirectory && wsbActive) {
                            if (serviceState != wlService.rdmService().state().serviceState()) {
                                this.wsbServiceStateChange(wlService._tableKey, (int)wlService.rdmService().state().serviceState(), 1, errorInfo);
                            }
                            this.wsbUpdateCachedService(wlService, 1, errorInfo);
                        }
                        ret = this._watchlist.itemHandler().serviceUpdated(wlService, service.checkHasState());
                        break;
                    }
                    wlService = this.addToCache(service);
                    if (this.initDirectory && wsbActive) {
                        this.wsbUpdateCachedService(wlService, 2, errorInfo);
                    }
                    ret = this._watchlist.itemHandler().serviceAdded(wlService);
                    break;
                }
                case 3: {
                    this._tempWlInteger.value(service.serviceId());
                    wlService = this._servicesByIdTable.remove(this._tempWlInteger);
                    if (wlService == null) break;
                    String serviceName = null;
                    long serviceState = wlService.rdmService().state().serviceState();
                    if (wlService.rdmService().checkHasInfo()) {
                        serviceName = wlService.rdmService().info().serviceName().toString();
                        this._servicesByNameTable.remove(serviceName);
                    }
                    this._serviceList.remove(wlService);
                    ret = this._watchlist.itemHandler().serviceDeleted(wlService, false);
                    if (this.initDirectory && wsbActive) {
                        if (serviceState != 0L) {
                            this.wsbServiceStateChange(wlService._tableKey, 0, 3, errorInfo);
                        }
                        this.wsbUpdateCachedService(wlService, 3, errorInfo);
                    }
                    wlService.tableKey().returnToPool();
                    wlService.returnToPool();
                    break;
                }
                default: {
                    ret = this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "WlServiceCache.processServiceList", "Invalid map entry action (" + service.action() + ") received on directory service.");
                }
            }
            if (ret >= 0) continue;
            break;
        }
        if (this._watchlist._reactorChannel.reactor().reactorHandlesWarmStandby(this._watchlist._reactorChannel)) {
            ReactorWarmStandbyEvent reactorWarmStandbyEvent;
            ReactorChannel channel = this._watchlist._reactorChannel;
            ReactorWarmStandbyHandler wsbHandler = this._watchlist._reactorChannel.warmStandByHandlerImpl;
            if (!this.initDirectory) {
                if ((wsbHandler.warmStandbyHandlerState() & 2) == 0) {
                    ret = this.wsbUpdateFullServiceCache(errorInfo);
                    wsbHandler.setPrimaryDirectoryResponseState();
                    this._watchlist.reactor().reactorWSBHandleServiceActiveStandby(this._watchlist.reactorChannel(), wsbHandler.currentWarmStandbyGroupImpl(), true, errorInfo);
                    if (!wsbHandler.watchlistSentFirstRequests()) {
                        if (this._watchlist.reactor().submitWSBRequestQueue(this._watchlist.reactorChannel().warmStandByHandlerImpl, this._watchlist.reactorChannel().warmStandByHandlerImpl.currentWarmStandbyGroupImpl(), this._watchlist.reactorChannel(), errorInfo) != 0) {
                            if (this._watchlist.reactorChannel().server() == null && !this._watchlist.reactorChannel().recoveryAttemptLimitReached()) {
                                this._watchlist.reactorChannel().state(ReactorChannel.State.DOWN_RECONNECTING);
                                this._watchlist.reactor().sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 3, this._watchlist.reactorChannel(), errorInfo);
                            } else {
                                this._watchlist.reactorChannel().state(ReactorChannel.State.DOWN);
                                this._watchlist.reactor().sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 2, this._watchlist.reactorChannel(), errorInfo);
                            }
                        }
                        wsbHandler.watchlistSentFirstRequests(true);
                    }
                    reactorWarmStandbyEvent = this._watchlist._reactorChannel.reactor().reactorWarmStandbyEventPool.getEvent(errorInfo);
                    reactorWarmStandbyEvent.eventType = 1;
                    this._watchlist._reactorChannel.reactor().sendWarmStandbyEvent(channel, reactorWarmStandbyEvent, errorInfo);
                } else {
                    wsbHandler.setSecondaryDirectoryResponseState();
                    if (!this.wsbCompareRDMServiceInfo()) {
                        reactorWarmStandbyEvent = this._watchlist._reactorChannel.reactor().reactorWarmStandbyEventPool.getEvent(errorInfo);
                        this._watchlist._reactorChannel.reactor().populateErrorInfo(errorInfo, -1, "processServiceList", "The source directory response from standby server does not match with the primary server.");
                        reactorWarmStandbyEvent.eventType = 7;
                        this._watchlist._reactorChannel.reactor().sendWarmStandbyEvent(channel, reactorWarmStandbyEvent, errorInfo);
                    } else {
                        ret = this.wsbUpdateFullServiceCache(errorInfo);
                        this._watchlist.reactor().reactorWSBHandleServiceActiveStandby(this._watchlist.reactorChannel(), wsbHandler.currentWarmStandbyGroupImpl(), false, errorInfo);
                        if (this._watchlist.reactor().submitWSBRequestQueue(this._watchlist.reactorChannel().warmStandByHandlerImpl, this._watchlist.reactorChannel().warmStandByHandlerImpl.currentWarmStandbyGroupImpl(), this._watchlist.reactorChannel(), errorInfo) != 0) {
                            if (this._watchlist.reactorChannel().server() == null && !this._watchlist.reactorChannel().recoveryAttemptLimitReached()) {
                                this._watchlist.reactorChannel().state(ReactorChannel.State.DOWN_RECONNECTING);
                                this._watchlist.reactor().sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 3, this._watchlist.reactorChannel(), errorInfo);
                            } else {
                                this._watchlist.reactorChannel().state(ReactorChannel.State.DOWN);
                                this._watchlist.reactor().sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 2, this._watchlist.reactorChannel(), errorInfo);
                            }
                        }
                    }
                }
                this.initDirectory = true;
            } else {
                wsbHandler.setSecondaryDirectoryResponseState();
                if (!this.wsbCompareRDMServiceInfo()) {
                    reactorWarmStandbyEvent = this._watchlist._reactorChannel.reactor().reactorWarmStandbyEventPool.getEvent(errorInfo);
                    this._watchlist._reactorChannel.reactor().populateErrorInfo(errorInfo, -1, "processServiceList", "The source directory response from standby server does not match with the primary server.");
                    reactorWarmStandbyEvent.eventType = 7;
                    this._watchlist._reactorChannel.reactor().sendWarmStandbyEvent(channel, reactorWarmStandbyEvent, errorInfo);
                }
            }
        } else if (this._watchlist._reactorChannel.warmStandByHandlerImpl != null) {
            if (this._watchlist._reactorChannel.sendReqFromQueue) {
                return ret;
            }
            ReactorWarmStandbyHandler wsbHandler = this._watchlist._reactorChannel.warmStandByHandlerImpl;
            for (int i = 0; i < this._watchlist._reactorChannel.warmStandByHandlerImpl.submitMsgQueue().size(); ++i) {
                if (wsbHandler.submitMsgQueue().get((int)i).submitTime <= this._watchlist._reactorChannel.lastSubmitOptionsTime || this._watchlist.submitMsg(wsbHandler.submitMsgQueue().get((int)i).msg, wsbHandler.submitMsgQueue().get((int)i).submitOptions, errorInfo) == 0) continue;
                ret = -1;
            }
            ReactorWLSubmitMsgOptions submitOpts = null;
            while (wsbHandler.submitMsgQueue().size() != 0) {
                submitOpts = wsbHandler.submitMsgQueue().remove(0);
                submitOpts.clear();
                wsbHandler.freeSubmitMsgQueue().add(submitOpts);
            }
            this._watchlist._reactorChannel.warmStandByHandlerImpl.queuedRecoveryMessage(false);
            this._watchlist._reactorChannel.lastSubmitOptionsTime = System.nanoTime();
            this._watchlist._reactorChannel.sendReqFromQueue = true;
        }
        return ret;
    }

    WlService addToCache(Service service) {
        WlService wlService = ReactorFactory.createWlService();
        service.copy(wlService.rdmService());
        this._serviceList.add(wlService);
        WlInteger wlInteger = ReactorFactory.createWlInteger();
        wlInteger.value(service.serviceId());
        wlService.tableKey(wlInteger);
        this._servicesByIdTable.put(wlInteger, wlService);
        if (service.checkHasInfo()) {
            this._servicesByNameTable.put(wlService.rdmService().info().serviceName().toString(), wlService);
        }
        return wlService;
    }

    int serviceId(String serviceName) {
        int serviceId = -5;
        WlService wlService = this.service(serviceName);
        if (wlService != null) {
            serviceId = wlService.rdmService().serviceId();
        }
        return serviceId;
    }

    String serviceName(int serviceId) {
        String serviceName = null;
        WlService wlService = this.service(serviceId);
        if (wlService != null && wlService.rdmService().checkHasInfo()) {
            serviceName = wlService.rdmService().info().serviceName().toString();
        }
        return serviceName;
    }

    WlService service(String serviceName) {
        return this._servicesByNameTable.get(serviceName);
    }

    WlService service(int serviceId) {
        this._tempWlInteger.value(serviceId);
        return this._servicesByIdTable.get(this._tempWlInteger);
    }

    void clearCache(boolean channelIsDown) {
        WlService wlService = null;
        while ((wlService = this._serviceList.poll()) != null) {
            this._watchlist.itemHandler().serviceDeleted(wlService, channelIsDown);
            if (this._watchlist.reactor().reactorHandlesWarmStandby(this._watchlist.reactorChannel())) {
                this.wsbUpdateCachedService(wlService, 3, null);
            }
            wlService.rdmService().clear();
            wlService.tableKey().returnToPool();
            wlService.returnToPool();
        }
        this._servicesByNameTable.clear();
        this._servicesByIdTable.clear();
        this.initDirectory = false;
    }

    void clear() {
        this._servicesByNameTable.clear();
        this._servicesByIdTable.clear();
        this._serviceList.clear();
        this.initDirectory = false;
    }

    int wsbUpdateFullServiceCache(ReactorErrorInfo errorInfo) {
        WlService newService2 = null;
        for (WlService newService2 : this._serviceList) {
            this.wsbUpdateCachedService(newService2, newService2.rdmService().action(), errorInfo);
        }
        return 0;
    }

    private boolean wsbCompareRDMServiceInfo() {
        WlService wlService = null;
        ReactorWarmStandbyGroupImpl wsbGroup = this._watchlist._reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl();
        ReactorWSBService wsbService = null;
        Iterator<Map.Entry<WlInteger, ReactorWSBService>> iter = wsbGroup._perServiceById.entrySet().iterator();
        while (iter.hasNext()) {
            wsbService = iter.next().getValue();
            wlService = this._servicesByIdTable.get(wsbService.serviceId);
            if (wlService != null) {
                int i;
                if (!wlService.rdmService().info().serviceName().equals(wsbService.serviceInfo.info().serviceName())) {
                    return false;
                }
                if (wlService.rdmService().info().capabilitiesList().size() != wsbService.serviceInfo.info().capabilitiesList().size()) {
                    return false;
                }
                for (i = 0; i < wlService.rdmService().info().capabilitiesList().size(); ++i) {
                    if (wlService.rdmService().info().capabilitiesList().get(i).longValue() == wsbService.serviceInfo.info().capabilitiesList().get(i).longValue()) continue;
                    return false;
                }
                if (wlService.rdmService().info().dictionariesProvidedList().size() != wsbService.serviceInfo.info().dictionariesProvidedList().size()) {
                    return false;
                }
                for (i = 0; i < wlService.rdmService().info().dictionariesProvidedList().size(); ++i) {
                    if (wlService.rdmService().info().dictionariesProvidedList().get(i).equals(wsbService.serviceInfo.info().dictionariesProvidedList().get(i))) continue;
                    return false;
                }
                if (wlService.rdmService().info().dictionariesUsedList().size() != wsbService.serviceInfo.info().dictionariesUsedList().size()) {
                    return false;
                }
                for (i = 0; i < wlService.rdmService().info().dictionariesUsedList().size(); ++i) {
                    if (wlService.rdmService().info().dictionariesUsedList().get(i).equals(wsbService.serviceInfo.info().dictionariesUsedList().get(i))) continue;
                    return false;
                }
                if (wlService.rdmService().info().qosList().size() != wsbService.serviceInfo.info().qosList().size()) {
                    return false;
                }
                for (i = 0; i < wlService.rdmService().info().qosList().size(); ++i) {
                    if (wlService.rdmService().info().qosList().get(i).equals(wsbService.serviceInfo.info().qosList().get(i))) continue;
                    return false;
                }
                if (wlService.rdmService().info().checkHasSupportsQosRange() != wsbService.serviceInfo.info().checkHasSupportsQosRange()) {
                    return false;
                }
                if (wlService.rdmService().info().supportsQosRange() != wsbService.serviceInfo.info().supportsQosRange()) {
                    return false;
                }
                if (wlService.rdmService().info().checkHasItemList() != wsbService.serviceInfo.info().checkHasItemList()) {
                    return false;
                }
                if (wlService.rdmService().info().itemList().length() != 0 && wsbService.serviceInfo.info().itemList().length() != 0 && !wlService.rdmService().info().itemList().equals(wsbService.serviceInfo.info().itemList())) {
                    return false;
                }
                if (wlService.rdmService().info().supportsOutOfBandSnapshots() != wsbService.serviceInfo.info().supportsOutOfBandSnapshots()) {
                    return false;
                }
                if (wlService.rdmService().info().acceptingConsumerStatus() == wsbService.serviceInfo.info().acceptingConsumerStatus()) continue;
                return false;
            }
            wlService = this._servicesByNameTable.get(wsbService.serviceInfo.info().serviceName().toString());
            if (wlService == null) continue;
            return false;
        }
        return true;
    }

    void wsbUpdateCachedService(WlService newService, int entryAction, ReactorErrorInfo errorInfo) {
        ReactorWarmStandbyGroupImpl wsbGroup = this._watchlist._reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl();
        ReactorWSBService wsbService = wsbGroup._perServiceById.get(newService.tableKey());
        boolean addToUpdateList = false;
        boolean hasService = false;
        boolean sendWsbMsg = false;
        if (wsbService != null) {
            boolean containsChannel = wsbService.channels.contains(this._watchlist._reactorChannel);
            if (newService.rdmService().state().serviceState() != wsbService.serviceState.serviceState()) {
                if (newService.rdmService().state().serviceState() == 1L) {
                    wsbService.serviceState.serviceState(1L);
                    if (!containsChannel) {
                        wsbService.channels.add(this._watchlist._reactorChannel);
                    }
                    wsbService.updateServiceFilter |= 2;
                    wsbService.serviceAction = 1;
                    addToUpdateList = true;
                    sendWsbMsg = true;
                } else if (newService.rdmService().state().serviceState() == 0L) {
                    if (containsChannel) {
                        wsbService.channels.remove(this._watchlist._reactorChannel);
                    }
                    if (wsbService.channels.size() == 0) {
                        wsbService.serviceState.serviceState(0L);
                        wsbService.updateServiceFilter |= 2;
                        wsbService.serviceAction = 1;
                        addToUpdateList = true;
                    }
                }
            } else if (entryAction != 3 && !containsChannel && newService.rdmService().state().serviceState() == 1L) {
                wsbService.channels.add(this._watchlist._reactorChannel);
                sendWsbMsg = true;
            }
            if (entryAction == 3) {
                if (containsChannel && wsbService.channels.size() > 1 || !containsChannel && wsbService.channels.size() > 0) {
                    hasService = true;
                }
                if (containsChannel) {
                    wsbService.channels.remove(this._watchlist._reactorChannel);
                    sendWsbMsg = true;
                }
                if (!hasService) {
                    wsbService.serviceAction = 3;
                    addToUpdateList = true;
                }
            } else if (wsbService.serviceAction == 3 && entryAction == 2) {
                wsbService.serviceAction = 2;
                wsbService.updateServiceFilter = newService.rdmService().flags();
                addToUpdateList = true;
            }
            if (addToUpdateList) {
                wsbGroup._updateServiceList.add(wsbService);
            }
        } else {
            if (entryAction == 3) {
                return;
            }
            wsbService = ReactorFactory.createWsbService();
            newService.rdmService().copy(wsbService.serviceInfo);
            newService.rdmService().state().copy(wsbService.serviceState);
            wsbService.serviceAction = newService.rdmService().action();
            wsbService.updateServiceFilter = newService.rdmService().flags();
            wsbService.serviceId.value(newService.tableKey().value());
            if (wsbService.serviceState.serviceState() == 1L) {
                wsbService.channels.add(this._watchlist.reactorChannel());
            }
            wsbGroup._updateServiceList.add(wsbService);
            wsbGroup._perServiceById.put(wsbService.serviceId, wsbService);
            sendWsbMsg = true;
        }
        if (this.initDirectory && sendWsbMsg && wsbGroup.warmStandbyMode() == 2 && entryAction == 2) {
            Reactor reactor = this._watchlist.reactor();
            ReactorChannel reactorChannel = this._watchlist.reactorChannel();
            boolean activeService = this._watchlist.reactor().wsbServiceInStartupList(wsbGroup, newService, reactorChannel);
            if (wsbService.activeChannel == null && newService._rdmService.state().serviceState() == 1L && activeService) {
                reactorChannel._directoryConsumerStatus.clear();
                reactorChannel._directoryConsumerStatus.streamId(reactorChannel.watchlist().directoryHandler()._directoryStreamId);
                reactorChannel._serviceConsumerStatus.clear();
                reactorChannel._serviceConsumerStatus.flags(2);
                reactorChannel._serviceConsumerStatus.warmStandbyMode(0L);
                reactorChannel._serviceConsumerStatus.serviceId(newService._rdmService.serviceId());
                reactorChannel._directoryConsumerStatus.consumerServiceStatusList().add(reactorChannel._serviceConsumerStatus);
                if (reactor.submitChannel(reactorChannel, reactorChannel._directoryConsumerStatus, reactor.reactorSubmitOptions, errorInfo) < 0) {
                    if (reactorChannel.server() == null && !reactorChannel.recoveryAttemptLimitReached()) {
                        reactorChannel.state(ReactorChannel.State.DOWN_RECONNECTING);
                        reactor.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 3, reactorChannel, errorInfo);
                        return;
                    }
                    reactorChannel.state(ReactorChannel.State.DOWN);
                    reactor.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 2, reactorChannel, errorInfo);
                    return;
                }
                wsbService.activeChannel = reactorChannel;
            } else if (wsbService.activeChannel != reactorChannel) {
                reactorChannel._directoryConsumerStatus.clear();
                reactorChannel._directoryConsumerStatus.streamId(reactorChannel.watchlist().directoryHandler()._directoryStreamId);
                reactorChannel._serviceConsumerStatus.clear();
                reactorChannel._serviceConsumerStatus.flags(2);
                reactorChannel._serviceConsumerStatus.warmStandbyMode(1L);
                reactorChannel._serviceConsumerStatus.serviceId(newService._rdmService.serviceId());
                reactorChannel._directoryConsumerStatus.consumerServiceStatusList().add(reactorChannel._serviceConsumerStatus);
                if (reactor.submitChannel(reactorChannel, reactorChannel._directoryConsumerStatus, reactor.reactorSubmitOptions, errorInfo) < 0) {
                    if (reactorChannel.server() == null && !reactorChannel.recoveryAttemptLimitReached()) {
                        reactorChannel.state(ReactorChannel.State.DOWN_RECONNECTING);
                        reactor.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 3, reactorChannel, errorInfo);
                        return;
                    }
                    reactorChannel.state(ReactorChannel.State.DOWN);
                    reactor.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 2, reactorChannel, errorInfo);
                    return;
                }
            }
        }
    }

    private void wsbServiceStateChange(WlInteger serviceId, int newServiceState, int entryAction, ReactorErrorInfo errorInfo) {
        ReactorWarmStandbyGroupImpl wsbGroup = this._watchlist.reactorChannel().warmStandByHandlerImpl.currentWarmStandbyGroupImpl();
        if (wsbGroup.warmStandbyMode() == 2) {
            ReactorWSBService wsbService = wsbGroup._perServiceById.get(serviceId);
            if (newServiceState == 0 && wsbService.activeChannel == this._watchlist.reactorChannel()) {
                ReactorChannel reactorChannel = this._watchlist.reactorChannel();
                if (entryAction != 3) {
                    reactorChannel._directoryConsumerStatus.clear();
                    reactorChannel._directoryConsumerStatus.streamId(reactorChannel.watchlist().directoryHandler()._directoryStreamId);
                    reactorChannel._serviceConsumerStatus.clear();
                    reactorChannel._serviceConsumerStatus.flags(2);
                    reactorChannel._serviceConsumerStatus.warmStandbyMode(1L);
                    reactorChannel._serviceConsumerStatus.serviceId(serviceId.value());
                    reactorChannel._directoryConsumerStatus.consumerServiceStatusList().add(reactorChannel._serviceConsumerStatus);
                    if (this._watchlist.reactor().submitChannel(reactorChannel, reactorChannel._directoryConsumerStatus, this._watchlist.reactor().reactorSubmitOptions, errorInfo) < 0) {
                        if (reactorChannel.server() == null && !reactorChannel.recoveryAttemptLimitReached()) {
                            reactorChannel.state(ReactorChannel.State.DOWN_RECONNECTING);
                            this._watchlist.reactor().sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 3, reactorChannel, errorInfo);
                            return;
                        }
                        reactorChannel.state(ReactorChannel.State.DOWN);
                        this._watchlist.reactor().sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 2, reactorChannel, errorInfo);
                        return;
                    }
                }
                wsbService.activeChannel = null;
                for (int i = 0; i < wsbService.channels.size(); ++i) {
                    WlService processChannelService;
                    ReactorChannel processReactorChannel = wsbService.channels.get(i);
                    if (processReactorChannel == reactorChannel || (processChannelService = processReactorChannel.watchlist().directoryHandler().service(wsbService.serviceId.value())) == null || processChannelService.rdmService().state().serviceState() == 0L || processChannelService.rdmService().state().serviceState() != 1L) continue;
                    reactorChannel._directoryConsumerStatus.clear();
                    reactorChannel._directoryConsumerStatus.streamId(processReactorChannel.watchlist().directoryHandler()._directoryStreamId);
                    reactorChannel._serviceConsumerStatus.clear();
                    reactorChannel._serviceConsumerStatus.flags(2);
                    reactorChannel._serviceConsumerStatus.warmStandbyMode(0L);
                    reactorChannel._serviceConsumerStatus.serviceId(processChannelService.tableKey().value());
                    reactorChannel._directoryConsumerStatus.consumerServiceStatusList().add(reactorChannel._serviceConsumerStatus);
                    if (this._watchlist.reactor().submitChannel(processReactorChannel, reactorChannel._directoryConsumerStatus, this._watchlist.reactor().reactorSubmitOptions, errorInfo) < 0) {
                        if (processReactorChannel.server() == null && !processReactorChannel.recoveryAttemptLimitReached()) {
                            processReactorChannel.state(ReactorChannel.State.DOWN_RECONNECTING);
                            this._watchlist.reactor().sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 3, processReactorChannel, errorInfo);
                            return;
                        }
                        processReactorChannel.state(ReactorChannel.State.DOWN);
                        this._watchlist.reactor().sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 2, processReactorChannel, errorInfo);
                        return;
                    }
                    wsbService.activeChannel = processReactorChannel;
                    return;
                }
            } else if (newServiceState == 1 && wsbService.activeChannel == null) {
                ReactorChannel reactorChannel = this._watchlist.reactorChannel();
                reactorChannel._directoryConsumerStatus.clear();
                reactorChannel._directoryConsumerStatus.streamId(reactorChannel.watchlist()._directoryHandler._directoryStreamId);
                reactorChannel._serviceConsumerStatus.clear();
                reactorChannel._serviceConsumerStatus.flags(2);
                reactorChannel._serviceConsumerStatus.warmStandbyMode(0L);
                reactorChannel._serviceConsumerStatus.serviceId(serviceId.value());
                reactorChannel._directoryConsumerStatus.consumerServiceStatusList().add(reactorChannel._serviceConsumerStatus);
                if (this._watchlist.reactor().submitChannel(reactorChannel, reactorChannel._directoryConsumerStatus, this._watchlist.reactor().reactorSubmitOptions, errorInfo) < 0) {
                    if (reactorChannel.server() == null && !reactorChannel.recoveryAttemptLimitReached()) {
                        reactorChannel.state(ReactorChannel.State.DOWN_RECONNECTING);
                        this._watchlist.reactor().sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 3, reactorChannel, errorInfo);
                        return;
                    }
                    reactorChannel.state(ReactorChannel.State.DOWN);
                    this._watchlist.reactor().sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 2, reactorChannel, errorInfo);
                    return;
                }
                wsbService.activeChannel = reactorChannel;
            }
        } else if (newServiceState == 1 && this._watchlist.reactorChannel().isActiveServer) {
            ReactorWarmStandbyEvent reactorWarmStandbyEvent = this._watchlist.reactor().reactorWarmStandbyEventPool.getEvent(errorInfo);
            reactorWarmStandbyEvent.eventType = 9;
            reactorWarmStandbyEvent.reactorChannel = this._watchlist.reactorChannel();
            this._watchlist.reactor().sendWarmStandbyEvent(this._watchlist.reactorChannel(), reactorWarmStandbyEvent, errorInfo);
        }
    }
}

