/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.valueadd.reactor.ClassicAsyncResponseConsumer;
import com.refinitiv.eta.valueadd.reactor.ReactorAuthTokenInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorErrorInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorServiceEndpointInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorTokenSession;
import com.refinitiv.eta.valueadd.reactor.RestAuthOptions;
import com.refinitiv.eta.valueadd.reactor.RestClient;
import com.refinitiv.eta.valueadd.reactor.RestConnectOptions;
import com.refinitiv.eta.valueadd.reactor.RestEvent;
import com.refinitiv.eta.valueadd.reactor.RestHandler;
import com.refinitiv.eta.valueadd.reactor.RestHttpHandlerResponse;
import com.refinitiv.eta.valueadd.reactor.RestProxyAuthHandler;
import com.refinitiv.eta.valueadd.reactor.RestReactorOptions;
import com.refinitiv.eta.valueadd.reactor.RestRequest;
import com.refinitiv.eta.valueadd.reactor.RestResponse;
import com.refinitiv.eta.valueadd.reactor.RestResultClosure;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.client5.http.async.methods.SimpleRequestProducer;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http.protocol.HttpProcessorBuilder;
import org.apache.hc.core5.http.protocol.RequestConnControl;
import org.apache.hc.core5.http.protocol.RequestContent;
import org.apache.hc.core5.http.protocol.RequestExpectContinue;
import org.apache.hc.core5.http.protocol.RequestTargetHost;
import org.apache.hc.core5.http.protocol.RequestUserAgent;
import org.apache.hc.core5.http.ssl.TLS;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.net.WWWFormCodec;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.lang.JoseException;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RestReactor {
    static final String AUTH_GRANT_TYPE = "grant_type";
    static final String AUTH_USER_NAME = "username";
    static final String AUTH_PASSWORD = "password";
    static final String AUTH_NEWPASSWORD = "newPassword";
    static final String AUTH_CLIENT_ID = "client_id";
    static final String AUTH_CLIENT_SECRET = "client_secret";
    static final String AUTH_CLIENT_CREDENTIALS_GRANT = "client_credentials";
    static final String AUTH_TAKE_EXCLUSIVE_SIGN_ON_CONTROL = "takeExclusiveSignOnControl";
    static final String AUTH_SCOPE = "scope";
    static final String AUTH_BEARER = "Bearer ";
    static final String AUTH_REFRESH_TOKEN = "refresh_token";
    static final String AUTH_ACCESS_TOKEN = "access_token";
    static final String AUTH_EXPIRES_IN = "expires_in";
    static final String AUTH_TOKEN_TYPE = "token_type";
    static final String AUTH_POST = "POST";
    static final String AUTH_REQUEST_USER_AGENT = "HTTP/1.1";
    static final String AUTH_CLIENT_ASSERTION = "client_assertion";
    static final String AUTH_CLIENT_ASSERTION_TYPE = "client_assertion_type";
    static final String AUTH_CLIENT_ASSERTION_VALUE = "urn:ietf:params:oauth:client-assertion-type:jwt-bearer";
    static final String AUTH_DEFAULT_AUDIENCE = "https://login.ciam.refinitiv.com/as/token.oauth2";
    static final int AUTH_HANDLER = 1;
    static final int DISCOVERY_HANDLER = 2;
    private boolean _reactorActive;
    private RestReactorOptions _restReactorOptions = new RestReactorOptions();
    private final SSLContextBuilder _sslContextBuilder = new SSLContextBuilder();
    private RestProxyAuthHandler _restProxyAuthHandler;
    private PoolingAsyncClientConnectionManager _connectionManager;
    private CloseableHttpAsyncClient _asyncClient;
    private Logger loggerClient = null;
    private List<StringBuilder> bufferPool = null;
    Lock lock = new ReentrantLock();

    public RestReactor(RestReactorOptions options, ReactorErrorInfo errorInfo) {
        if (errorInfo == null) {
            throw new UnsupportedOperationException("ReactorErrorInfo cannot be null");
        }
        if (options != null) {
            options.copy(this._restReactorOptions);
        } else {
            RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.constructor", "options was null and cannot continue.");
        }
        try {
            SSLContext sslContext = this._sslContextBuilder.build();
            this._restProxyAuthHandler = new RestProxyAuthHandler(this);
            this._connectionManager = PoolingAsyncClientConnectionManagerBuilder.create().setMaxConnTotal(options.maxConnectTotal()).setMaxConnPerRoute(options.defaultMaxPerRoute()).setTlsStrategy(ClientTlsStrategyBuilder.create().setSslContext(sslContext).setTlsVersions(new TLS[]{TLS.V_1_2, TLS.V_1_3}).buildAsync()).setPoolConcurrencyPolicy(PoolConcurrencyPolicy.STRICT).setConnPoolPolicy(PoolReusePolicy.LIFO).setDefaultConnectionConfig(ConnectionConfig.custom().setSocketTimeout(Timeout.ofMilliseconds((long)options.soTimeout())).setConnectTimeout(Timeout.ofMilliseconds((long)options.connectTimeout())).setTimeToLive(TimeValue.ofMinutes((long)10L)).build()).setDefaultTlsConfig(TlsConfig.custom().setVersionPolicy(HttpVersionPolicy.NEGOTIATE).setHandshakeTimeout(Timeout.ofMinutes((long)1L)).build()).build();
            this._asyncClient = HttpAsyncClients.custom().setIOReactorConfig(IOReactorConfig.custom().setSoTimeout(options.soTimeout(), TimeUnit.MILLISECONDS).setTcpNoDelay(options.tcpNoDelay()).setSoKeepAlive(options.soKeepAlive()).setIoThreadCount(options.ioThreadCount()).setSelectInterval(TimeValue.of((long)options.selectInterval(), (TimeUnit)TimeUnit.MILLISECONDS)).build()).setConnectionManager((AsyncClientConnectionManager)this._connectionManager).build();
            this._asyncClient.start();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.initialize", "failed to initialize the SSLConnectionSocketFactory, exception=" + RestReactor.getExceptionCause(e));
            return;
        }
        catch (Exception e) {
            RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.initialize", "failed to initialize the DefaultConnectingIOReactor, exception=" + RestReactor.getExceptionCause(e));
            return;
        }
        this._reactorActive = true;
        this.loggerClient = LoggerFactory.getLogger(this.getClass());
        this.bufferPool = new ArrayList<StringBuilder>();
    }

    RestReactorOptions restReactorOptions() {
        return this._restReactorOptions;
    }

    static int populateErrorInfo(ReactorErrorInfo errorInfo, int reactorReturnCode, String location, String text) {
        errorInfo.clear();
        errorInfo.code(reactorReturnCode).location(location);
        errorInfo.error().errorId(reactorReturnCode);
        if (text != null) {
            errorInfo.error().text(text);
        }
        return reactorReturnCode;
    }

    private String getClientJwt(String clientId, String clientJwk, String endpointUrl, String audience, ReactorErrorInfo errorInfo) {
        Date currentDate = new Date(System.currentTimeMillis());
        long expTime = currentDate.getTime() / 1000L + 900L;
        long iatTime = currentDate.getTime() / 1000L;
        PublicJsonWebKey parsedJwkKeyPair = null;
        JsonWebKey webkey = null;
        String tmpAudience = null;
        try {
            webkey = JsonWebKey.Factory.newJwk((String)clientJwk);
            if (webkey == null) {
                RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.getClientAssertion", "Unable to parse the clientJwk string.");
                return null;
            }
            String jwkAsString = webkey.toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE);
            parsedJwkKeyPair = PublicJsonWebKey.Factory.newPublicJwk((String)jwkAsString);
        }
        catch (JoseException e) {
            RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.getClientAssertion", "Jose4j exception: " + e.getMessage());
            return null;
        }
        catch (Exception e) {
            RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.getClientAssertion", "Exception: " + e.getMessage());
            return null;
        }
        tmpAudience = audience == null || audience.isEmpty() ? AUTH_DEFAULT_AUDIENCE : audience;
        JwtClaims claims = new JwtClaims();
        claims.setClaim("iss", (Object)clientId);
        claims.setClaim("sub", (Object)clientId);
        claims.setClaim("aud", (Object)tmpAudience);
        claims.setClaim("exp", (Object)expTime);
        claims.setClaim("iat", (Object)iatTime);
        try {
            JsonWebSignature jws = new JsonWebSignature();
            jws.setPayload(claims.toJson());
            jws.setKey((Key)parsedJwkKeyPair.getPrivateKey());
            jws.setHeader("alg", webkey.getAlgorithm());
            jws.setHeader("typ", "JWT");
            jws.setHeader("kid", webkey.getKeyId());
            jws.sign();
            String sResult = jws.getCompactSerialization();
            return sResult;
        }
        catch (JoseException e) {
            RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.getClientAssertion", "Exception from JWT signing: " + e.getMessage());
            return null;
        }
    }

    public int submitAuthRequest(RestAuthOptions authOptions, RestConnectOptions restConnectOptions, ReactorAuthTokenInfo authTokenInfo, ReactorErrorInfo errorInfo, boolean redirect, String location) {
        restConnectOptions.authRedirect(redirect);
        restConnectOptions.authRedirectLocation(location);
        return this.submitAuthRequest(authOptions, restConnectOptions, authTokenInfo, errorInfo);
    }

    public int submitAuthRequest(final RestAuthOptions authOptions, final RestConnectOptions restConnectOptions, ReactorAuthTokenInfo authTokenInfo, final ReactorErrorInfo errorInfo) {
        if (!this._reactorActive) {
            return RestReactor.populateErrorInfo(errorInfo, -10, "RestReactor.submitAuthRequest", "RestReactor is not active, aborting");
        }
        final ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(7);
        String url = null;
        if (authTokenInfo.tokenVersion() == ReactorAuthTokenInfo.TokenVersion.V1) {
            params.add(new BasicNameValuePair(AUTH_GRANT_TYPE, authOptions.grantType()));
            params.add(new BasicNameValuePair(AUTH_USER_NAME, authOptions.username()));
            params.add(new BasicNameValuePair(AUTH_CLIENT_ID, authOptions.clientId()));
            if (authOptions.grantType().equals(AUTH_REFRESH_TOKEN)) {
                params.add(new BasicNameValuePair(AUTH_REFRESH_TOKEN, authTokenInfo.refreshToken()));
            } else {
                params.add(new BasicNameValuePair(AUTH_TAKE_EXCLUSIVE_SIGN_ON_CONTROL, authOptions.takeExclusiveSignOnControlAsString()));
                params.add(new BasicNameValuePair(AUTH_SCOPE, authOptions.tokenScope()));
                params.add(new BasicNameValuePair(AUTH_PASSWORD, authOptions.password()));
                if (authOptions.hasNewPassword()) {
                    params.add(new BasicNameValuePair(AUTH_NEWPASSWORD, authOptions.newPassword()));
                }
                if (authOptions.hasClientSecret()) {
                    params.add(new BasicNameValuePair(AUTH_CLIENT_SECRET, authOptions.clientSecret()));
                }
                if (authOptions.tokenSession() != null) {
                    authOptions.tokenSession().originalExpiresIn(0);
                }
            }
            if (url == null) {
                url = restConnectOptions.authRedirect() && restConnectOptions.authRedirectLocation() != null ? restConnectOptions.authRedirectLocation() : restConnectOptions.tokenServiceURLV1();
            }
        } else {
            if (url == null) {
                url = restConnectOptions.authRedirect() && restConnectOptions.authRedirectLocation() != null ? restConnectOptions.authRedirectLocation() : restConnectOptions.tokenServiceURLV2();
            }
            params.add(new BasicNameValuePair(AUTH_GRANT_TYPE, AUTH_CLIENT_CREDENTIALS_GRANT));
            params.add(new BasicNameValuePair(AUTH_CLIENT_ID, authOptions.clientId()));
            params.add(new BasicNameValuePair(AUTH_SCOPE, authOptions.tokenScope()));
            if (authOptions.clientJwk().isEmpty()) {
                params.add(new BasicNameValuePair(AUTH_CLIENT_SECRET, authOptions.clientSecret()));
            } else {
                String jwt = this.getClientJwt(authOptions.clientId(), authOptions.clientJwk(), url, authOptions.audience(), errorInfo);
                if (jwt == null) {
                    return -1;
                }
                params.add(new BasicNameValuePair(AUTH_CLIENT_ASSERTION_TYPE, AUTH_CLIENT_ASSERTION_VALUE));
                params.add(new BasicNameValuePair(AUTH_CLIENT_ASSERTION, jwt));
            }
        }
        final RestHandler restHandler = new RestHandler(this, authOptions, restConnectOptions, authTokenInfo, errorInfo);
        if (restConnectOptions.proxyHost() == null || restConnectOptions.proxyHost().isEmpty() || restConnectOptions.proxyPort() == -1) {
            String body = WWWFormCodec.format(params, (Charset)StandardCharsets.UTF_8);
            SimpleHttpRequest httpRequest = SimpleRequestBuilder.post((String)url).setHttpHost(authTokenInfo.tokenVersion() == ReactorAuthTokenInfo.TokenVersion.V1 ? restConnectOptions.tokenServiceHost() : restConnectOptions.tokenServiceHostV2()).setBody(body, ContentType.APPLICATION_FORM_URLENCODED).setHeader("Content-Type", "application/x-www-form-urlencoded").build();
            if (authOptions.hasHeaderAttribute()) {
                Map<String, String> headerAttribs = authOptions.headerAttribute();
                for (Map.Entry<String, String> entry : headerAttribs.entrySet()) {
                    httpRequest.addHeader(entry.getKey(), (Object)entry.getValue());
                }
            }
            this.executeAsync(restHandler, httpRequest);
        } else {
            final RestProxyAuthHandler proxyAuthHandler = new RestProxyAuthHandler(this);
            final String threadUrl = url;
            new Thread(){

                @Override
                public void run() {
                    HttpPost httppost = new HttpPost(threadUrl);
                    if (authOptions.hasHeaderAttribute()) {
                        Map<String, String> headerAttribs = authOptions.headerAttribute();
                        for (Map.Entry<String, String> entry : headerAttribs.entrySet()) {
                            httppost.addHeader(entry.getKey(), (Object)entry.getValue());
                        }
                    }
                    httppost.setEntity((HttpEntity)new UrlEncodedFormEntity((Iterable)params, StandardCharsets.UTF_8));
                    RequestConfig config = RequestConfig.custom().setRedirectsEnabled(false).build();
                    httppost.setConfig(config);
                    try {
                        proxyAuthHandler.executeAsync((HttpUriRequestBase)httppost, restConnectOptions, restHandler, errorInfo);
                    }
                    catch (IOException e) {
                        restHandler.failed(e);
                    }
                }
            }.start();
        }
        return 0;
    }

    void executeAsync(RestHandler restHandler, SimpleHttpRequest httpRequest) {
        HttpProcessor httpProcessor = HttpProcessorBuilder.create().add((HttpRequestInterceptor)new RequestContent()).add((HttpRequestInterceptor)new RequestTargetHost()).add((HttpRequestInterceptor)new RequestConnControl()).add((HttpRequestInterceptor)new RequestUserAgent(AUTH_REQUEST_USER_AGENT)).add((HttpRequestInterceptor)new RequestExpectContinue()).build();
        HttpClientContext localContext = new HttpClientContext();
        localContext.setAttribute(HttpProcessor.class.getName(), (Object)httpProcessor);
        restHandler.setCurrentRequest(httpRequest);
        this._asyncClient.execute((AsyncRequestProducer)SimpleRequestProducer.create((SimpleHttpRequest)httpRequest), (AsyncResponseConsumer)ClassicAsyncResponseConsumer.create(), (HttpContext)localContext, (FutureCallback)restHandler);
    }

    public int submitRequestForServiceDiscovery(RestRequest request, RestConnectOptions restConnectOptions, ReactorAuthTokenInfo authTokenInfo, List<ReactorServiceEndpointInfo> reactorServiceEndpointInfoList, ReactorErrorInfo errorInfo, boolean redirect, String location) {
        restConnectOptions.discoveryRedirect(redirect);
        restConnectOptions.discoveryRedirectLocation(location);
        return this.submitRequestForServiceDiscovery(request, restConnectOptions, authTokenInfo, reactorServiceEndpointInfoList, errorInfo);
    }

    public int submitRequestForServiceDiscovery(RestRequest request, final RestConnectOptions restConnectOptions, ReactorAuthTokenInfo authTokenInfo, List<ReactorServiceEndpointInfo> reactorServiceEndpointInfoList, final ReactorErrorInfo errorInfo) {
        if (!this._reactorActive) {
            return RestReactor.populateErrorInfo(errorInfo, -10, "RestReactor.submitRequestForServiceDiscovery", "RestReactor is not active, aborting");
        }
        URIBuilder uriBuilder = null;
        try {
            uriBuilder = new URIBuilder(restConnectOptions.serviceDiscoveryURL());
        }
        catch (Exception e) {
            return RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.submitRequestForServiceDiscovery", "failed to submit a request, exception = " + RestReactor.getExceptionCause(e));
        }
        Map<String, String> queryParameter = request.queryParameter();
        if (queryParameter != null) {
            for (Map.Entry<String, String> entry : queryParameter.entrySet()) {
                uriBuilder.setParameter(entry.getKey(), entry.getValue());
            }
        }
        String url = null;
        try {
            url = restConnectOptions.discoveryRedirect() && restConnectOptions.discoveryRedirectLocation() != null ? restConnectOptions.discoveryRedirectLocation() : uriBuilder.build().toString();
        }
        catch (URISyntaxException e) {
            return RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.submitRequestForServiceDiscovery", "failed to submit a request, exception = " + RestReactor.getExceptionCause(e));
        }
        SimpleHttpRequest httpRequest = SimpleRequestBuilder.get((String)url).setHttpHost(restConnectOptions.serviceDiscoveryHost()).setHeader("Content-Type", "application/x-www-form-urlencoded").build();
        if (request.hasHeaderAttribute()) {
            Map<String, String> headerAttribs = request.headerAttribute();
            for (Map.Entry<String, String> entry : headerAttribs.entrySet()) {
                httpRequest.addHeader(entry.getKey(), (Object)entry.getValue());
            }
        }
        String token = authTokenInfo.accessToken();
        httpRequest.setHeader("Authorization", (Object)(AUTH_BEARER + token));
        final RestHandler restHandler = new RestHandler(this, request, restConnectOptions, authTokenInfo, reactorServiceEndpointInfoList, errorInfo);
        if (restConnectOptions.proxyHost() == null || restConnectOptions.proxyHost().isEmpty() || restConnectOptions.proxyPort() == -1) {
            this.executeAsync(restHandler, httpRequest);
        } else {
            final RestProxyAuthHandler proxyAuthHandler = new RestProxyAuthHandler(this);
            final HttpGet httpget = new HttpGet(url);
            if (request.hasHeaderAttribute()) {
                Map<String, String> headerAttribs = request.headerAttribute();
                for (Map.Entry<String, String> entry : headerAttribs.entrySet()) {
                    httpget.addHeader(entry.getKey(), (Object)entry.getValue());
                }
            }
            httpget.setHeader("Authorization", (Object)(AUTH_BEARER + token));
            new Thread(){

                @Override
                public void run() {
                    RequestConfig config = RequestConfig.custom().setRedirectsEnabled(false).build();
                    httpget.setConfig(config);
                    try {
                        proxyAuthHandler.executeAsync((HttpUriRequestBase)httpget, restConnectOptions, restHandler, errorInfo);
                    }
                    catch (IOException e) {
                        restHandler.failed(e);
                    }
                }
            }.start();
        }
        return 0;
    }

    public boolean isShutdown() {
        return !this._reactorActive;
    }

    public int shutdown(ReactorErrorInfo errorInfo) {
        if (!this._reactorActive) {
            return 0;
        }
        this._reactorActive = false;
        try {
            this._asyncClient.close(CloseMode.GRACEFUL);
        }
        catch (Exception e) {
            return RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.shutdown", "received Exception, exception = " + RestReactor.getExceptionCause(e));
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int submitAuthRequestBlocking(RestAuthOptions authOptions, RestConnectOptions restConnectOptions, ReactorAuthTokenInfo authTokenInfo, ReactorErrorInfo errorInfo) throws IOException {
        if (!this._reactorActive) {
            return RestReactor.populateErrorInfo(errorInfo, -10, "RestReactor.submitAuthRequestBlocking", "RestReactor is not active, aborting");
        }
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(7);
        String url = null;
        if (authTokenInfo.tokenVersion() == ReactorAuthTokenInfo.TokenVersion.V1) {
            params.add(new BasicNameValuePair(AUTH_GRANT_TYPE, authOptions.grantType()));
            params.add(new BasicNameValuePair(AUTH_USER_NAME, authOptions.username()));
            params.add(new BasicNameValuePair(AUTH_CLIENT_ID, authOptions.clientId()));
            if (authOptions.grantType().equals(AUTH_REFRESH_TOKEN)) {
                params.add(new BasicNameValuePair(AUTH_REFRESH_TOKEN, authTokenInfo.refreshToken()));
            } else {
                params.add(new BasicNameValuePair(AUTH_TAKE_EXCLUSIVE_SIGN_ON_CONTROL, authOptions.takeExclusiveSignOnControlAsString()));
                params.add(new BasicNameValuePair(AUTH_SCOPE, authOptions.tokenScope()));
                params.add(new BasicNameValuePair(AUTH_PASSWORD, authOptions.password()));
                if (authOptions.hasNewPassword()) {
                    params.add(new BasicNameValuePair(AUTH_NEWPASSWORD, authOptions.newPassword()));
                }
                if (authOptions.hasClientSecret()) {
                    params.add(new BasicNameValuePair(AUTH_CLIENT_SECRET, authOptions.clientSecret()));
                }
                if (authOptions.tokenSession() != null) {
                    authOptions.tokenSession().originalExpiresIn(0);
                }
            }
            if (url == null) {
                url = restConnectOptions.authRedirect() && restConnectOptions.authRedirectLocation() != null ? restConnectOptions.authRedirectLocation() : restConnectOptions.tokenServiceURLV1();
            }
        } else {
            params.add(new BasicNameValuePair(AUTH_GRANT_TYPE, AUTH_CLIENT_CREDENTIALS_GRANT));
            params.add(new BasicNameValuePair(AUTH_CLIENT_ID, authOptions.clientId()));
            params.add(new BasicNameValuePair(AUTH_SCOPE, authOptions.tokenScope()));
            if (authOptions.clientJwk().isEmpty()) {
                params.add(new BasicNameValuePair(AUTH_CLIENT_SECRET, authOptions.clientSecret()));
            } else {
                String jwt = this.getClientJwt(authOptions.clientId(), authOptions.clientJwk(), url, authOptions.audience(), errorInfo);
                if (jwt == null) {
                    return -1;
                }
                params.add(new BasicNameValuePair(AUTH_CLIENT_ASSERTION_TYPE, AUTH_CLIENT_ASSERTION_VALUE));
                params.add(new BasicNameValuePair(AUTH_CLIENT_ASSERTION, jwt));
            }
            if (url == null) {
                url = restConnectOptions.authRedirect() && restConnectOptions.authRedirectLocation() != null ? restConnectOptions.authRedirectLocation() : restConnectOptions.tokenServiceURLV2();
            }
        }
        try {
            UrlEncodedFormEntity entity;
            if (authOptions.hasHeaderAttribute()) {
                Map<String, String> headers = authOptions.headerAttribute();
                boolean isChunked = headers.containsKey("Transfer-Encoding") && headers.get("Transfer-Encoding").contentEquals("chunked");
                entity = new StringEntity(WWWFormCodec.format(params, (Charset)StandardCharsets.UTF_8), ContentType.APPLICATION_FORM_URLENCODED.withCharset(StandardCharsets.UTF_8), headers.containsKey("Content-Encoding") ? headers.get("Content-Encoding") : null, isChunked);
            } else {
                entity = new UrlEncodedFormEntity(params, StandardCharsets.UTF_8);
            }
            RestResponse restResponse = new RestResponse();
            HttpPost httppost = new HttpPost(url);
            httppost.setEntity((HttpEntity)entity);
            RequestConfig requestConfig = RequestConfig.custom().setRedirectsEnabled(false).build();
            httppost.setConfig(requestConfig);
            try (CloseableHttpClient httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)this.getHttpClientConnectionManager()).build();){
                int attemptCount;
                if (restConnectOptions.proxyHost() != null && !restConnectOptions.proxyHost().isEmpty() && restConnectOptions.proxyPort() != -1) {
                    RequestConfig config = RequestConfig.custom().setRedirectsEnabled(false).build();
                    httppost.setConfig(config);
                    int ret = this._restProxyAuthHandler.executeSync((HttpUriRequestBase)httppost, restConnectOptions, restResponse, errorInfo);
                    if (ret == 0) {
                        ReactorTokenSession.parseTokenInfomation(restResponse, authTokenInfo);
                    }
                    int n = ret;
                    return n;
                }
                for (attemptCount = 0; attemptCount <= 1; ++attemptCount) {
                    RestHttpHandlerResponse resp = this.executeRequest((HttpUriRequestBase)httppost, restConnectOptions, (HttpClient)httpClient, this.loggerClient, (HttpClientResponseHandler<RestHttpHandlerResponse>)((HttpClientResponseHandler)classicResponse -> {
                        boolean finish = false;
                        HttpEntity entityFromResponse = classicResponse.getEntity();
                        String contentString = null;
                        Exception extractingContentException = null;
                        try {
                            contentString = EntityUtils.toString((HttpEntity)entityFromResponse);
                        }
                        catch (Exception e) {
                            extractingContentException = e;
                        }
                        if (this.loggerClient.isTraceEnabled()) {
                            this.loggerClient.trace(this.prepareResponseString(classicResponse, contentString, extractingContentException));
                        }
                        int statusCode = classicResponse.getCode();
                        switch (statusCode) {
                            case 200: {
                                RestReactor.convertResponse(classicResponse, restResponse, errorInfo, contentString, extractingContentException);
                                ReactorTokenSession.parseTokenInfomation(restResponse, authTokenInfo);
                                finish = true;
                                break;
                            }
                            case 301: 
                            case 302: 
                            case 307: 
                            case 308: {
                                Header header = classicResponse.getFirstHeader("Location");
                                if (header != null) {
                                    String newHost = header.getValue();
                                    if (newHost != null) {
                                        try {
                                            httppost.setUri(new URI(newHost));
                                        }
                                        catch (URISyntaxException e) {
                                            RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.submitAuthRequestBlocking", "Failed to parse new URI: " + classicResponse.getCode() + ". Malformed redirection response.");
                                            break;
                                        }
                                        if (statusCode == 301 || statusCode == 308) {
                                            Buffer newUrl = CodecFactory.createBuffer();
                                            newUrl.data(newHost);
                                            if (authTokenInfo.tokenVersion() == ReactorAuthTokenInfo.TokenVersion.V1) {
                                                restConnectOptions.reactorOptions().tokenServiceURL_V1(newUrl);
                                            } else {
                                                restConnectOptions.reactorOptions().tokenServiceURL_V2(newUrl);
                                            }
                                        }
                                    }
                                    finish = false;
                                    break;
                                }
                                RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.submitAuthRequestBlocking", "Failed to request authentication token information with HTTP error " + classicResponse.getCode() + ". Malformed redirection response.");
                            }
                            default: {
                                RestReactor.convertResponse(classicResponse, restResponse, errorInfo, contentString, extractingContentException);
                                finish = true;
                                RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.submitAuthRequestBlocking", "Failed to request authentication token information with HTTP error " + classicResponse.getCode() + ". Text: " + (Objects.nonNull(contentString) ? contentString : ""));
                            }
                        }
                        return new RestHttpHandlerResponse(errorInfo.code(), finish, RestHttpHandlerResponse.Action.NO_ACTION);
                    }));
                    if (!resp.finished) continue;
                    int n = resp.returnCode;
                    return n;
                }
                if (attemptCount <= true) return 0;
                RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.submitAuthRequestBlocking", "Failed to request authentication token information. Too many redirect attempts.");
                int n = -1;
                return n;
            }
        }
        catch (IOException | JSONException e) {
            return RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.submitAuthRequestBlocking", "failed to submit authorization request, exception = " + RestReactor.getExceptionCause((Exception)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int submitServiceDiscoveryRequestBlocking(RestRequest request, RestConnectOptions restConnectOptions, ReactorAuthTokenInfo authTokenInfo, List<ReactorServiceEndpointInfo> reactorServiceEndpointInfoList, ReactorErrorInfo errorInfo) throws IOException {
        if (!this._reactorActive) {
            return RestReactor.populateErrorInfo(errorInfo, -10, "RestReactor.submitServiceDiscoveryRequestBlocking", "RestReactor is not active, aborting");
        }
        String url = null;
        url = restConnectOptions.discoveryRedirect() ? restConnectOptions.discoveryRedirectLocation() : restConnectOptions.serviceDiscoveryURL();
        try {
            Map<String, String> queryParameter;
            URIBuilder uriBuilder = null;
            String token = authTokenInfo.accessToken();
            RestResponse restResponse = new RestResponse();
            int attemptCount = 0;
            try {
                uriBuilder = new URIBuilder(url);
            }
            catch (Exception e) {
                return RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.submitServiceDiscoveryRequestBlocking", "failed to submit a request, exception = " + RestReactor.getExceptionCause(e));
            }
            if (request.hasQueryParameter() && (queryParameter = request.queryParameter()) != null) {
                for (Map.Entry<String, String> entry : queryParameter.entrySet()) {
                    uriBuilder.setParameter(entry.getKey(), entry.getValue());
                }
            }
            HttpGet httpget = new HttpGet(uriBuilder.build());
            if (request.hasHeaderAttribute()) {
                for (Map.Entry<String, String> entry : request.headerAttribute().entrySet()) {
                    httpget.addHeader(entry.getKey(), (Object)entry.getValue());
                }
            }
            httpget.setHeader("Authorization", (Object)(AUTH_BEARER + token));
            if (restConnectOptions.proxyHost() != null && !restConnectOptions.proxyHost().isEmpty() && restConnectOptions.proxyPort() != -1) {
                RequestConfig config = RequestConfig.custom().setRedirectsEnabled(false).build();
                httpget.setConfig(config);
                int ret = this._restProxyAuthHandler.executeSync((HttpUriRequestBase)httpget, restConnectOptions, restResponse, errorInfo);
                if (ret != 0) return ret;
                RestClient.parseServiceDiscovery(restResponse, reactorServiceEndpointInfoList);
                return ret;
            }
            try (CloseableHttpClient httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)this.getHttpClientConnectionManager()).build();){
                while (attemptCount <= 1) {
                    RestHttpHandlerResponse response = this.executeRequest((HttpUriRequestBase)httpget, restConnectOptions, (HttpClient)httpClient, this.loggerClient, (HttpClientResponseHandler<RestHttpHandlerResponse>)((HttpClientResponseHandler)classicResponse -> {
                        RestHttpHandlerResponse resp = new RestHttpHandlerResponse();
                        HttpEntity entityFromResponse = classicResponse.getEntity();
                        String contentString = null;
                        Exception extractingContentException = null;
                        try {
                            contentString = EntityUtils.toString((HttpEntity)entityFromResponse);
                        }
                        catch (Exception e) {
                            extractingContentException = e;
                        }
                        if (this.loggerClient.isTraceEnabled()) {
                            this.loggerClient.trace(this.prepareResponseString(classicResponse, contentString, extractingContentException));
                        }
                        int statusCode = classicResponse.getCode();
                        switch (statusCode) {
                            case 200: {
                                RestReactor.convertResponse(classicResponse, restResponse, errorInfo, contentString, extractingContentException);
                                RestClient.parseServiceDiscovery(restResponse, reactorServiceEndpointInfoList);
                                resp.finished = true;
                                break;
                            }
                            case 301: 
                            case 302: 
                            case 307: 
                            case 308: {
                                Header header = classicResponse.getFirstHeader("Location");
                                if (header != null) {
                                    String newHost = header.getValue();
                                    if (newHost != null) {
                                        try {
                                            httpget.setUri(new URI(newHost));
                                        }
                                        catch (URISyntaxException e) {
                                            RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.submitServiceDiscoveryRequestBlocking", "Failed to request service discovery information. Malformed redirection response.");
                                            resp.returnCode = -1;
                                            break;
                                        }
                                        if (statusCode == 301 || statusCode == 308) {
                                            Buffer newUrl = CodecFactory.createBuffer();
                                            newUrl.data(newHost);
                                            restConnectOptions.reactorOptions().serviceDiscoveryURL(newUrl);
                                        }
                                    }
                                    resp.finished = false;
                                    break;
                                }
                                RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.submitServiceDiscoveryRequestBlocking", "Failed to request service discovery information. Malformed redirection response.");
                                resp.returnCode = -1;
                            }
                            default: {
                                RestReactor.convertResponse(classicResponse, restResponse, errorInfo, contentString, extractingContentException);
                                resp.finished = true;
                                RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.submitServiceDiscoveryRequestBlocking", "Failed to request service discovery information. Text: " + (Objects.nonNull(contentString) ? contentString : ""));
                                resp.returnCode = -1;
                            }
                        }
                        return resp;
                    }));
                    if (response.finished) {
                        int n = response.returnCode;
                        return n;
                    }
                    ++attemptCount;
                }
                if (attemptCount <= true) return 0;
                RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.submitServiceDiscoveryRequestBlocking", "Failed to request service discovery information. Too many redirect attempts.");
                int n = -1;
                return n;
            }
        }
        catch (URISyntaxException e) {
            return RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.submitServiceDiscoveryRequestBlocking", "failed to submit a request, exception = " + RestReactor.getExceptionCause(e));
        }
        catch (ClientProtocolException e) {
            return RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.submitServiceDiscoveryRequestBlocking", "failed to submit a request, exception = " + RestReactor.getExceptionCause((Exception)((Object)e)));
        }
        catch (IOException e) {
            return RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.submitServiceDiscoveryRequestBlocking", "failed to submit a request, exception = " + RestReactor.getExceptionCause(e));
        }
    }

    static int convertResponse(ClassicHttpResponse response, RestResponse clientResponse, ReactorErrorInfo errorInfo, String entityString, Exception extractingContentException) {
        if (extractingContentException != null) {
            return RestReactor.populateErrorInfo(errorInfo, -1, "RestHandler.handleResponse", "failed to convert entity to json object, exception = " + RestReactor.getExceptionCause(extractingContentException));
        }
        HttpEntity entity = response.getEntity();
        clientResponse.statusCode(response.getCode());
        clientResponse.statusText(response.getReasonPhrase());
        clientResponse.protocolVersion(response.getVersion());
        Iterator headerIt = response.headerIterator();
        while (headerIt.hasNext()) {
            Header header = (Header)headerIt.next();
            clientResponse.headerAttribute().put(header.getName(), header.getValue());
        }
        if (entity != null) {
            String contentType = entity.getContentType();
            if (contentType != null) {
                clientResponse.contentType(entity.getContentType());
            }
            clientResponse.body(entityString, errorInfo);
        }
        return 0;
    }

    static int convertResponse(RestReactor RestReactor2, SimpleHttpResponse response, RestResponse clientResponse, ReactorErrorInfo errorInfo, String entityString, Exception extractingContentException) {
        if (extractingContentException != null) {
            return RestReactor.populateErrorInfo(errorInfo, -1, "RestHandler.handleResponse", "failed to convert entity to json object, exception = " + RestReactor.getExceptionCause(extractingContentException));
        }
        clientResponse.statusCode(response.getCode());
        clientResponse.statusText(response.getReasonPhrase());
        clientResponse.protocolVersion(response.getVersion());
        Iterator headerIt = response.headerIterator();
        while (headerIt.hasNext()) {
            Header header = (Header)headerIt.next();
            clientResponse.headerAttribute().put(header.getName(), header.getValue());
        }
        if (response.getContentType() != null) {
            String contentType = response.getContentType().toString();
            if (contentType != null) {
                clientResponse.contentType(response.getContentType().toString());
            }
            clientResponse.body(entityString, errorInfo);
        }
        return 0;
    }

    static int processResponse(RestReactor restReactor, RestResponse response, RestEvent event) {
        RestResultClosure resultClosure = event.resultClosure();
        resultClosure.restCallback().RestResponseCallback(response, event);
        return 0;
    }

    static String getExceptionCause(Exception e) {
        String cause = e.getLocalizedMessage();
        if (cause == null) {
            cause = " ";
            for (Throwable test = e.getCause(); test != null; test = test.getCause()) {
                cause = cause + test.getLocalizedMessage();
            }
        }
        return cause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String prepareRequestString(HttpUriRequestBase request, RestConnectOptions restConnectOptions) {
        Header[] headers;
        StringBuilder requestLogBuffer = null;
        try {
            this.lock.lock();
            requestLogBuffer = this.extractFromPool();
        }
        finally {
            this.lock.unlock();
        }
        requestLogBuffer.setLength(0);
        requestLogBuffer.append("The next HTTP request was sent\n");
        requestLogBuffer.append(request.toString() + "\n");
        for (Header header : headers = request.getHeaders()) {
            requestLogBuffer.append("    " + header.getName());
            requestLogBuffer.append(": ");
            requestLogBuffer.append(header.getValue());
            requestLogBuffer.append("\n");
        }
        if (restConnectOptions.proxyHost() != null) {
            String proxyPassword;
            requestLogBuffer.append("    Proxy:\n");
            requestLogBuffer.append("        Proxy host: " + restConnectOptions.proxyHost());
            requestLogBuffer.append("\n");
            requestLogBuffer.append("        Proxy port: " + restConnectOptions.proxyPort());
            requestLogBuffer.append("\n");
            String proxyUser = restConnectOptions.proxyUserName();
            if (proxyUser != null) {
                requestLogBuffer.append("        Proxy user: " + proxyUser);
                requestLogBuffer.append("\n");
            }
            if ((proxyPassword = restConnectOptions.proxyPassword()) != null) {
                requestLogBuffer.append("        *** proxy password ***" + proxyUser);
                requestLogBuffer.append("\n");
            }
        } else {
            requestLogBuffer.append("    No proxy is used\n");
        }
        HttpEntity entity = request.getEntity();
        if (entity != null) {
            String contentEncoding = entity.getContentEncoding();
            if (contentEncoding != null) {
                requestLogBuffer.append("    " + contentEncoding);
                requestLogBuffer.append("\n");
            }
            requestLogBuffer.append("    ContentLength: " + entity.getContentLength());
            requestLogBuffer.append("\n");
            String contentType = entity.getContentType();
            if (contentType != null) {
                requestLogBuffer.append("    " + contentType);
                requestLogBuffer.append("\n");
            }
            String contentString = null;
            boolean parsed = false;
            try {
                contentString = EntityUtils.toString((HttpEntity)entity);
                parsed = true;
            }
            catch (ParseException e) {
                requestLogBuffer.append("    Invalid content of request:\n");
                parsed = false;
            }
            catch (IOException e) {
                requestLogBuffer.append("    Invalid content of request:\n");
                parsed = false;
            }
            if (contentString != null && !contentString.isEmpty() && parsed) {
                String[] contentComponents;
                requestLogBuffer.append("    Content of request:\n");
                for (String component : contentComponents = contentString.split("&")) {
                    String[] nameValue = component.split("=");
                    if (nameValue.length == 2) {
                        if (AUTH_PASSWORD.equals(nameValue[0])) {
                            nameValue[1] = "<*** password ***>";
                        }
                        if (AUTH_NEWPASSWORD.equals(nameValue[0])) {
                            nameValue[1] = "<*** newPassword ***>";
                        }
                        if (AUTH_CLIENT_SECRET.equals(nameValue[0])) {
                            nameValue[1] = "<*** client_secret ***>";
                        }
                        requestLogBuffer.append("        " + nameValue[0] + ": " + nameValue[1]);
                    } else if (nameValue.length == 1) {
                        requestLogBuffer.append("        " + nameValue[0] + ": N/A");
                    }
                    requestLogBuffer.append("\n");
                }
            }
        }
        requestLogBuffer.append("\n");
        String returnString = requestLogBuffer.toString();
        try {
            this.lock.lock();
            this.returnToPool(requestLogBuffer);
        }
        finally {
            this.lock.unlock();
        }
        return returnString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String prepareRequestString(SimpleHttpRequest request, RestConnectOptions restConnectOptions) {
        ByteArrayEntity entity;
        Header[] headers;
        StringBuilder requestLogBuffer = null;
        try {
            this.lock.lock();
            requestLogBuffer = this.extractFromPool();
        }
        finally {
            this.lock.unlock();
        }
        requestLogBuffer.setLength(0);
        requestLogBuffer.append("The next HTTP request was sent\n");
        requestLogBuffer.append(request.toString() + "\n");
        for (Header header : headers = request.getHeaders()) {
            requestLogBuffer.append("    " + header.getName());
            requestLogBuffer.append(": ");
            requestLogBuffer.append(header.getValue());
            requestLogBuffer.append("\n");
        }
        if (restConnectOptions.proxyHost() != null) {
            String proxyPassword;
            requestLogBuffer.append("    Proxy:\n");
            requestLogBuffer.append("        Proxy host: " + restConnectOptions.proxyHost());
            requestLogBuffer.append("\n");
            requestLogBuffer.append("        Proxy port: " + restConnectOptions.proxyPort());
            requestLogBuffer.append("\n");
            String proxyUser = restConnectOptions.proxyUserName();
            if (proxyUser != null) {
                requestLogBuffer.append("        Proxy user: " + proxyUser);
                requestLogBuffer.append("\n");
            }
            if ((proxyPassword = restConnectOptions.proxyPassword()) != null) {
                requestLogBuffer.append("        *** proxy password ***" + proxyUser);
                requestLogBuffer.append("\n");
            }
        } else {
            requestLogBuffer.append("    No proxy is used\n");
        }
        try {
            Header contentEncodingHeader = request.getHeader("Content-Encoding");
            if (contentEncodingHeader != null) {
                requestLogBuffer.append("    " + contentEncodingHeader.getValue());
                requestLogBuffer.append("\n");
            }
        }
        catch (ProtocolException e) {
            requestLogBuffer.append("    Invalid content of request.\n");
        }
        ContentType contentType = request.getContentType();
        if (contentType != null) {
            requestLogBuffer.append("    " + contentType.toString());
            requestLogBuffer.append("\n");
        }
        ByteArrayEntity byteArrayEntity = entity = contentType != null ? new ByteArrayEntity(request.getBodyBytes(), contentType) : null;
        if (entity != null) {
            String contentString = null;
            boolean parsed = false;
            try {
                contentString = EntityUtils.toString((HttpEntity)entity);
                parsed = true;
            }
            catch (ParseException e) {
                requestLogBuffer.append("    Invalid content of request:\n");
                parsed = false;
            }
            catch (IOException e) {
                requestLogBuffer.append("    Invalid content of request:\n");
                parsed = false;
            }
            if (contentString != null && !contentString.isEmpty() && parsed) {
                String[] contentComponents;
                requestLogBuffer.append("    Content of request:\n");
                for (String component : contentComponents = contentString.split("&")) {
                    String[] nameValue = component.split("=");
                    if (nameValue.length == 2) {
                        if (AUTH_PASSWORD.equals(nameValue[0])) {
                            nameValue[1] = "<*** password ***>";
                        }
                        if (AUTH_NEWPASSWORD.equals(nameValue[0])) {
                            nameValue[1] = "<*** newPassword ***>";
                        }
                        if (AUTH_CLIENT_SECRET.equals(nameValue[0])) {
                            nameValue[1] = "<*** client_secret ***>";
                        }
                        requestLogBuffer.append("        " + nameValue[0] + ": " + nameValue[1]);
                    } else if (nameValue.length == 1) {
                        requestLogBuffer.append("        " + nameValue[0] + ": N/A");
                    }
                    requestLogBuffer.append("\n");
                }
            }
        }
        requestLogBuffer.append("\n");
        String returnString = requestLogBuffer.toString();
        try {
            this.lock.lock();
            this.returnToPool(requestLogBuffer);
        }
        finally {
            this.lock.unlock();
        }
        return returnString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String prepareResponseString(ClassicHttpResponse response, String contentString, Exception extractingContentException) {
        Header[] headers;
        StringBuilder responseLogBuffer = null;
        try {
            this.lock.lock();
            responseLogBuffer = this.extractFromPool();
        }
        finally {
            this.lock.unlock();
        }
        responseLogBuffer.setLength(0);
        responseLogBuffer.append("The next HTTP response was received\n");
        responseLogBuffer.append(new StatusLine((HttpResponse)response) + "\n");
        for (Header header : headers = response.getHeaders()) {
            responseLogBuffer.append("    " + header.getName());
            responseLogBuffer.append(": ");
            responseLogBuffer.append(header.getValue());
            responseLogBuffer.append("\n");
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            if (contentString != null && !contentString.isEmpty()) {
                responseLogBuffer.append("    Content string:\n");
                responseLogBuffer.append("        " + contentString + "\n");
            } else if (extractingContentException == null) {
                responseLogBuffer.append("    Content string is empty\n");
            } else {
                responseLogBuffer.append("    The next exception is thrown while reading content string:\n");
                responseLogBuffer.append("    " + RestReactor.getExceptionCause(extractingContentException));
                responseLogBuffer.append("\n");
            }
        }
        responseLogBuffer.append("\n");
        String returnString = responseLogBuffer.toString();
        try {
            this.lock.lock();
            this.returnToPool(responseLogBuffer);
        }
        finally {
            this.lock.unlock();
        }
        return returnString;
    }

    private StringBuilder extractFromPool() {
        return this.bufferPool.isEmpty() ? new StringBuilder() : this.bufferPool.remove(this.bufferPool.size() - 1);
    }

    private void returnToPool(StringBuilder buffer) {
        if (!this.bufferPool.contains(buffer)) {
            this.bufferPool.add(buffer);
        }
    }

    RestHttpHandlerResponse executeRequest(HttpUriRequestBase httpRequest, RestConnectOptions connOptions, HttpClient httpClient, Logger loggerClient, HttpClientResponseHandler<RestHttpHandlerResponse> handler) throws IOException {
        if (loggerClient.isTraceEnabled()) {
            loggerClient.trace(this.prepareRequestString(httpRequest, connOptions));
        }
        RestHttpHandlerResponse response = (RestHttpHandlerResponse)httpClient.execute((ClassicHttpRequest)httpRequest, handler);
        return response;
    }

    PoolingHttpClientConnectionManager getHttpClientConnectionManager() {
        return PoolingHttpClientConnectionManagerBuilder.create().setTlsSocketStrategy(ClientTlsStrategyBuilder.create().setSslContext(SSLContexts.createSystemDefault()).setTlsVersions(new TLS[]{TLS.V_1_2, TLS.V_1_3}).buildClassic()).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(Timeout.ofMilliseconds((long)this._restReactorOptions.soTimeout())).build()).setPoolConcurrencyPolicy(PoolConcurrencyPolicy.STRICT).setConnPoolPolicy(PoolReusePolicy.LIFO).setDefaultConnectionConfig(ConnectionConfig.custom().setSocketTimeout(Timeout.ofMilliseconds((long)this._restReactorOptions.soTimeout())).setTimeToLive(TimeValue.ofMinutes((long)10L)).build()).build();
    }
}

