/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.valueadd.reactor.ReactorErrorInfo;
import com.refinitiv.eta.valueadd.reactor.RestConnectOptions;
import com.refinitiv.eta.valueadd.reactor.RestHandler;
import com.refinitiv.eta.valueadd.reactor.RestHttpHandlerResponse;
import com.refinitiv.eta.valueadd.reactor.RestReactor;
import com.refinitiv.eta.valueadd.reactor.RestResponse;
import com.sun.security.auth.module.Krb5LoginModule;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Objects;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.hc.client5.http.AuthenticationStrategy;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.NTCredentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultAuthenticationStrategy;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BasicSchemeFactory;
import org.apache.hc.client5.http.impl.auth.KerberosSchemeFactory;
import org.apache.hc.client5.http.impl.auth.NTLMSchemeFactory;
import org.apache.hc.client5.http.impl.auth.SPNegoSchemeFactory;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RestProxyAuthHandler {
    static final int BASIC = 16;
    static final int NTLM = 32;
    static final int KERBEROS = 64;
    static final int NEGOTIATE = 128;
    private int authSchemeFlag;
    private RestReactor _restReactor;
    private RequestConfig _defaultRequestConfig;
    private Logger loggerClient = null;
    private static String db;
    private static HashMap<String, String> loginConfigOptions;

    RestProxyAuthHandler(RestReactor restReactor) {
        this.clear();
        this._restReactor = restReactor;
        this._defaultRequestConfig = RequestConfig.custom().setAuthenticationEnabled(true).build();
        this.loggerClient = LoggerFactory.getLogger(RestReactor.class);
    }

    void clear() {
        this.authSchemeFlag = 0;
    }

    int executeSync(HttpUriRequestBase httpRequest, RestConnectOptions connOptions, RestResponse restResponse, ReactorErrorInfo errorInfo) throws IOException {
        return this.execute(httpRequest, connOptions, errorInfo, null, restResponse);
    }

    int executeAsync(HttpUriRequestBase httpRequest, RestConnectOptions connOptions, RestHandler restHandler, ReactorErrorInfo errorInfo) throws IOException {
        return this.execute(httpRequest, connOptions, errorInfo, restHandler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int execute(HttpUriRequestBase httpRequest, RestConnectOptions connOptions, ReactorErrorInfo errorInfo, RestHandler restHandler, RestResponse restResponse) throws IOException {
        int attemptCount;
        HttpHost proxy = new HttpHost("http", connOptions.proxyHost(), connOptions.proxyPort());
        RestHttpHandlerResponse handlerResponse = null;
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)this._restReactor.getHttpClientConnectionManager()).setProxy(proxy).build();){
            for (attemptCount = 0; attemptCount <= 1; ++attemptCount) {
                handlerResponse = this._restReactor.executeRequest(httpRequest, connOptions, (HttpClient)httpClient, this.loggerClient, (HttpClientResponseHandler<RestHttpHandlerResponse>)((HttpClientResponseHandler)classicResponse -> {
                    RestHttpHandlerResponse hr = new RestHttpHandlerResponse();
                    HttpEntity entityFromResponse = classicResponse.getEntity();
                    String contentString = null;
                    Exception extractingContentException = null;
                    try {
                        contentString = EntityUtils.toString((HttpEntity)entityFromResponse);
                        if (Objects.nonNull(restHandler)) {
                            restHandler.contentString(contentString);
                        }
                    }
                    catch (Exception e) {
                        extractingContentException = e;
                    }
                    if (this.loggerClient.isTraceEnabled() && restHandler == null) {
                        this.loggerClient.trace(this._restReactor.prepareResponseString(classicResponse, contentString, extractingContentException));
                    }
                    switch (classicResponse.getCode()) {
                        case 200: {
                            if (restHandler == null) {
                                RestReactor.convertResponse(classicResponse, restResponse, errorInfo, contentString, extractingContentException);
                            } else {
                                restHandler.completed(classicResponse);
                            }
                            hr.finished = true;
                            break;
                        }
                        case 301: 
                        case 302: 
                        case 307: 
                        case 308: {
                            if (restHandler == null) {
                                Header header = classicResponse.getFirstHeader("Location");
                                try {
                                    if (header == null || header.getValue() == null) {
                                        RestReactor.populateErrorInfo(errorInfo, -1, "RestProxyAuthHandler.execute", "Failed to send request. Malformed redirection response.");
                                        hr.finished = true;
                                        hr.returnCode = -1;
                                        return hr;
                                    }
                                    httpRequest.setUri(new URI(header.getValue()));
                                    hr.finished = false;
                                    break;
                                }
                                catch (URISyntaxException e) {
                                    RestReactor.populateErrorInfo(errorInfo, -1, "RestProxyAuthHandler.execute", "Failed to request authentication token information with HTTP error " + classicResponse.getCode() + ". Incorrect redirecting.");
                                    hr.finished = true;
                                    hr.returnCode = -1;
                                    return hr;
                                }
                            }
                            restHandler.completed(classicResponse);
                            hr.finished = true;
                            break;
                        }
                        case 407: {
                            this.processProxyAuthResponse((HttpResponse)classicResponse);
                            if ((this.authSchemeFlag & 0x80) != 0) {
                                hr.action = RestHttpHandlerResponse.Action.SEND_KERBOROS_AUTH;
                            } else if ((this.authSchemeFlag & 0x40) != 0) {
                                hr.action = RestHttpHandlerResponse.Action.SEND_KERBOROS_AUTH;
                            } else if ((this.authSchemeFlag & 0x20) != 0) {
                                hr.action = RestHttpHandlerResponse.Action.SEND_NTLM_AUTH;
                            } else if ((this.authSchemeFlag & 0x10) != 0) {
                                hr.action = RestHttpHandlerResponse.Action.SEND_BASIC_AUTH_REQUEST;
                            }
                            hr.finished = true;
                            return hr;
                        }
                        default: {
                            if (restHandler == null) {
                                RestReactor.populateErrorInfo(errorInfo, -1, "RestProxyAuthHandler.execute", "Failed to request authentication token information with HTTP error " + classicResponse.getCode() + ". Text: " + (Objects.nonNull(contentString) ? contentString : ""));
                            } else {
                                restHandler.completed(classicResponse);
                            }
                            hr.finished = true;
                            hr.action = RestHttpHandlerResponse.Action.NO_ACTION;
                            hr.returnCode = -1;
                        }
                    }
                    return hr;
                }));
                if (!handlerResponse.finished) continue;
                if (handlerResponse.action == RestHttpHandlerResponse.Action.NO_ACTION) {
                    int n = handlerResponse.returnCode;
                    return n;
                }
                break;
            }
        }
        if (handlerResponse != null) {
            switch (handlerResponse.action) {
                case NO_ACTION: {
                    break;
                }
                case SEND_BASIC_AUTH_REQUEST: {
                    return this.sendBasicAuthRequest(httpRequest, connOptions, errorInfo, restHandler, restResponse);
                }
                case SEND_KERBOROS_AUTH: {
                    return this.sendKerborosRequest(httpRequest, connOptions, errorInfo, restHandler, restResponse);
                }
                case SEND_NTLM_AUTH: {
                    return this.sendNTLMRequest(httpRequest, connOptions, errorInfo, restHandler, restResponse);
                }
            }
        }
        if (attemptCount > 1 && restHandler == null) {
            RestReactor.populateErrorInfo(errorInfo, -1, "RestProxyAuthHandler.execute", "Failed to send request. Too many redirect attempts.");
            return -1;
        }
        return 0;
    }

    private void processProxyAuthResponse(HttpResponse httpResponse) {
        Header[] headers = httpResponse.getHeaders();
        this.authSchemeFlag = 0;
        for (int index = 0; index < headers.length; ++index) {
            if (headers[index].getName().indexOf("Proxy-Authenticate") == -1) continue;
            if (headers[index].getValue().indexOf("Negotiate") != -1) {
                this.authSchemeFlag |= 0x80;
                continue;
            }
            if (headers[index].getValue().indexOf("Kerberos") != -1) {
                this.authSchemeFlag |= 0x40;
                continue;
            }
            if (headers[index].getValue().indexOf("NTLM") != -1) {
                this.authSchemeFlag |= 0x20;
                continue;
            }
            if (headers[index].getValue().indexOf("Basic") == -1) continue;
            this.authSchemeFlag |= 0x10;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int sendBasicAuthRequest(HttpUriRequestBase httpRequest, RestConnectOptions connOptions, ReactorErrorInfo errorInfo, RestHandler restHandler, RestResponse restResponse) throws IOException {
        Registry authSchemeRegistry = RegistryBuilder.create().register("Basic", (Object)new BasicSchemeFactory()).build();
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(null, null, -1, null, null), (Credentials)new UsernamePasswordCredentials(connOptions.proxyUserName(), connOptions.proxyPassword().toCharArray()));
        PoolingHttpClientConnectionManager connectionManager = this._restReactor.getHttpClientConnectionManager();
        HttpClientBuilder httpBuilder = HttpClientBuilder.create().useSystemProperties().setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistry).setDefaultCredentialsProvider((CredentialsProvider)credsProvider).setConnectionManager((HttpClientConnectionManager)connectionManager);
        httpRequest.setConfig(this._defaultRequestConfig);
        try (CloseableHttpClient httpClient = httpBuilder.setProxy(new HttpHost(connOptions.proxyHost(), connOptions.proxyPort())).setProxyAuthenticationStrategy((AuthenticationStrategy)DefaultAuthenticationStrategy.INSTANCE).build();){
            RestHttpHandlerResponse resp = this._restReactor.executeRequest(httpRequest, connOptions, (HttpClient)httpClient, this.loggerClient, (HttpClientResponseHandler<RestHttpHandlerResponse>)((HttpClientResponseHandler)classicResponse -> {
                HttpEntity entityFromResponse = classicResponse.getEntity();
                String contentString = null;
                Exception extractingContentException = null;
                try {
                    contentString = EntityUtils.toString((HttpEntity)entityFromResponse);
                    if (Objects.nonNull(restHandler)) {
                        restHandler.contentString(contentString);
                    }
                }
                catch (Exception e) {
                    extractingContentException = e;
                }
                if (this.loggerClient.isTraceEnabled()) {
                    this.loggerClient.trace(this._restReactor.prepareResponseString(classicResponse, contentString, extractingContentException));
                }
                if (classicResponse.getCode() != 200) {
                    if (restHandler == null) {
                        RestReactor.populateErrorInfo(errorInfo, -1, "RestProxyAuthHandler.sendBasicAuthRequest", "Failed to request authentication token information with HTTP error " + classicResponse.getCode() + ". Text: " + (Objects.nonNull(contentString) ? contentString : ""));
                    } else {
                        restHandler.completed(classicResponse);
                    }
                    return new RestHttpHandlerResponse(-1, true, RestHttpHandlerResponse.Action.NO_ACTION);
                }
                if (restHandler == null) {
                    RestReactor.convertResponse(classicResponse, restResponse, errorInfo, contentString, extractingContentException);
                } else {
                    restHandler.completed(classicResponse);
                }
                return new RestHttpHandlerResponse(0, true, RestHttpHandlerResponse.Action.NO_ACTION);
            }));
            int n = resp.returnCode;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int sendNTLMRequest(HttpUriRequestBase httpRequest, RestConnectOptions connOptions, ReactorErrorInfo errorInfo, RestHandler restHandler, RestResponse restResponse) throws IOException {
        Registry authSchemeRegistry = RegistryBuilder.create().register("NTLM", (Object)new NTLMSchemeFactory()).register("Basic", (Object)new BasicSchemeFactory()).build();
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(null, null, -1, null, null), (Credentials)new UsernamePasswordCredentials(connOptions.proxyUserName(), connOptions.proxyPassword().toCharArray()));
        credsProvider.setCredentials(new AuthScope(null, null, -1, null, null), (Credentials)new NTCredentials(connOptions.proxyUserName(), connOptions.proxyPassword().toCharArray(), connOptions.proxyLocalHostName(), connOptions.proxyDomain()));
        PoolingHttpClientConnectionManager connectionManager = this._restReactor.getHttpClientConnectionManager();
        HttpClientBuilder httpBuilder = HttpClientBuilder.create().useSystemProperties().setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistry).setDefaultCredentialsProvider((CredentialsProvider)credsProvider).setConnectionManager((HttpClientConnectionManager)connectionManager);
        httpRequest.setConfig(this._defaultRequestConfig);
        try (CloseableHttpClient httpClient = httpBuilder.setProxy(new HttpHost(connOptions.proxyHost(), connOptions.proxyPort())).setProxyAuthenticationStrategy((AuthenticationStrategy)DefaultAuthenticationStrategy.INSTANCE).build();){
            RestHttpHandlerResponse resp = this._restReactor.executeRequest(httpRequest, connOptions, (HttpClient)httpClient, this.loggerClient, (HttpClientResponseHandler<RestHttpHandlerResponse>)((HttpClientResponseHandler)classicResponse -> {
                HttpEntity entityFromResponse = classicResponse.getEntity();
                String contentString = null;
                Exception extractingContentException = null;
                try {
                    contentString = EntityUtils.toString((HttpEntity)entityFromResponse);
                    if (Objects.nonNull(restHandler)) {
                        restHandler.contentString(contentString);
                    }
                }
                catch (Exception e) {
                    extractingContentException = e;
                }
                if (this.loggerClient.isTraceEnabled()) {
                    this.loggerClient.trace(this._restReactor.prepareResponseString(classicResponse, contentString, extractingContentException));
                }
                if (classicResponse.getCode() != 200) {
                    if (restHandler == null) {
                        RestReactor.populateErrorInfo(errorInfo, -1, "RestProxyAuthHandler.sendNTLMRequest", "Failed to request authentication token information with HTTP error " + classicResponse.getCode() + ". Text: " + (Objects.nonNull(contentString) ? contentString : ""));
                        return new RestHttpHandlerResponse(-1, true, RestHttpHandlerResponse.Action.NO_ACTION);
                    }
                    restHandler.completed(classicResponse);
                    return new RestHttpHandlerResponse(-1, true, RestHttpHandlerResponse.Action.NO_ACTION);
                }
                if (restHandler == null) {
                    RestReactor.convertResponse(classicResponse, restResponse, errorInfo, contentString, extractingContentException);
                } else {
                    restHandler.completed(classicResponse);
                }
                return new RestHttpHandlerResponse(0, true, RestHttpHandlerResponse.Action.NO_ACTION);
            }));
            int n = resp.returnCode;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int sendKerborosRequest(final HttpUriRequestBase httpRequest, final RestConnectOptions connOptions, final ReactorErrorInfo errorInfo, final RestHandler restHandler, RestResponse restResponse) throws IOException {
        RestHttpHandlerResponse response;
        LoginContext loginContext;
        System.setProperty("java.security.krb5.conf", connOptions.proxyKRB5ConfigFile());
        RestProxyAuthHandler.loadLoginConfig();
        try {
            loginContext = new LoginContext("etaj-restclient-kerberos", new KerberosCallBackHandler(connOptions.proxyUserName(), connOptions.proxyPassword()));
            loginContext.login();
        }
        catch (LoginException e) {
            if (restHandler == null) {
                return RestReactor.populateErrorInfo(errorInfo, -1, "RestProxyAuthHandler.sendKerborosRequest", "Failed to request authentication token information. Text: " + e.getMessage());
            }
            restHandler.failed(e);
            return 0;
        }
        Subject serviceSubject = loginContext.getSubject();
        Registry authSchemeRegistry = RegistryBuilder.create().register("NTLM", (Object)new NTLMSchemeFactory()).register("Basic", (Object)new BasicSchemeFactory()).register("Negotiate", (Object)SPNegoSchemeFactory.DEFAULT).register("Kerberos", (Object)KerberosSchemeFactory.DEFAULT).build();
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(null, null, -1, null, null), (Credentials)new NTCredentials(connOptions.proxyUserName(), connOptions.proxyPassword().toCharArray(), connOptions.proxyLocalHostName(), connOptions.proxyDomain()));
        HttpClientBuilder httpBuilder = HttpClientBuilder.create().useSystemProperties().setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistry).setDefaultCredentialsProvider((CredentialsProvider)credsProvider).setConnectionManager((HttpClientConnectionManager)this._restReactor.getHttpClientConnectionManager());
        httpRequest.setConfig(this._defaultRequestConfig);
        try (final CloseableHttpClient httpClient = httpBuilder.setProxy(new HttpHost(connOptions.proxyHost(), connOptions.proxyPort())).setProxyAuthenticationStrategy((AuthenticationStrategy)DefaultAuthenticationStrategy.INSTANCE).build();){
            response = Subject.doAs(serviceSubject, new PrivilegedAction<RestHttpHandlerResponse>(){

                @Override
                public RestHttpHandlerResponse run() {
                    RestHttpHandlerResponse response = null;
                    try {
                        response = RestProxyAuthHandler.this._restReactor.executeRequest(httpRequest, connOptions, (HttpClient)httpClient, RestProxyAuthHandler.this.loggerClient, (HttpClientResponseHandler<RestHttpHandlerResponse>)((HttpClientResponseHandler)classicResponse -> {
                            if (classicResponse != null) {
                                HttpEntity entityFromResponse = classicResponse.getEntity();
                                String contentString = null;
                                Exception extractingContentException = null;
                                try {
                                    contentString = EntityUtils.toString((HttpEntity)entityFromResponse);
                                    if (Objects.nonNull(restHandler)) {
                                        restHandler.contentString(contentString);
                                    }
                                }
                                catch (Exception e) {
                                    extractingContentException = e;
                                }
                                if (RestProxyAuthHandler.this.loggerClient.isTraceEnabled()) {
                                    RestProxyAuthHandler.this.loggerClient.trace(RestProxyAuthHandler.this._restReactor.prepareResponseString(classicResponse, contentString, extractingContentException));
                                }
                                if (classicResponse.getCode() != 200) {
                                    if (restHandler == null) {
                                        RestReactor.populateErrorInfo(errorInfo, -1, "RestProxyAuthHandler.sendKerborosRequest", "Failed to request authentication token information with HTTP error " + classicResponse.getCode() + ". Text: " + (Objects.nonNull(contentString) ? contentString : ""));
                                    } else {
                                        restHandler.completed(classicResponse);
                                    }
                                    return new RestHttpHandlerResponse(-1, true, RestHttpHandlerResponse.Action.NO_ACTION);
                                }
                                if (restHandler == null) {
                                    RestResponse resp = new RestResponse();
                                    RestReactor.convertResponse(classicResponse, resp, errorInfo, contentString, extractingContentException);
                                } else {
                                    restHandler.completed(classicResponse);
                                }
                                return new RestHttpHandlerResponse(0, true, RestHttpHandlerResponse.Action.NO_ACTION);
                            }
                            return new RestHttpHandlerResponse(-1, true, RestHttpHandlerResponse.Action.NO_ACTION);
                        }));
                    }
                    catch (IOException e) {
                        if (restHandler == null) {
                            RestReactor.populateErrorInfo(errorInfo, -1, "RestProxyAuthHandler.sendKerborosRequest", "Failed to request authentication token information. Text: " + e.getMessage());
                        } else {
                            restHandler.failed(e);
                        }
                    }
                    finally {
                        try {
                            httpClient.close();
                        }
                        catch (IOException iOException) {}
                    }
                    return response;
                }
            });
        }
        try {
            loginContext.logout();
        }
        catch (LoginException loginException) {
            // empty catch block
        }
        return response.returnCode;
    }

    private static void loadLoginConfig() {
        Configuration.setConfiguration(new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String cname) {
                String name = Krb5LoginModule.class.getName();
                loginConfigOptions.put("com.sun.security.auth.module.Krb5LoginModule", "required");
                String useTC = System.getProperty("krb_login_config_useTicketCache");
                if (useTC != null && useTC.equals("true")) {
                    String TC;
                    loginConfigOptions.put("useTicketCache", "true");
                    String doNotPrompt = System.getProperty("krb_login_config_doNotPrompt");
                    if (doNotPrompt != null && doNotPrompt.equals("true")) {
                        loginConfigOptions.put("doNotPrompt", "true");
                    }
                    if ((TC = System.getProperty("krb_login_config_ticketCache")) != null && !TC.isEmpty()) {
                        loginConfigOptions.put("ticketCache", TC);
                    }
                }
                if ((db = System.getProperty("javax.net.debug")) != null && db.equals("all")) {
                    loginConfigOptions.put("debug", "true");
                }
                AppConfigurationEntry ace = new AppConfigurationEntry(name, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, loginConfigOptions);
                AppConfigurationEntry[] entry = new AppConfigurationEntry[]{ace};
                return entry;
            }
        });
    }

    static {
        loginConfigOptions = new HashMap();
    }

    private static class KerberosCallBackHandler
    implements CallbackHandler {
        private final String user;
        private final String password;

        public KerberosCallBackHandler(String user, String password) {
            this.user = user;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callback;
                    nc.setName(this.user);
                    continue;
                }
                if (!(callback instanceof PasswordCallback)) continue;
                PasswordCallback pc = (PasswordCallback)callback;
                pc.setPassword(this.password.toCharArray());
            }
        }
    }
}

