/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.nio.AsyncEntityConsumer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.util.ByteArrayBuffer;

class RestAsyncEntityConsumer
implements AsyncEntityConsumer<HttpEntity> {
    volatile FutureCallback<HttpEntity> resultCallback;
    EntityDetails entityDetails;
    volatile ByteArrayEntity content;
    ByteArrayBuffer buffer = new ByteArrayBuffer(0);

    RestAsyncEntityConsumer() {
    }

    public void streamStart(EntityDetails entityDetails, FutureCallback<HttpEntity> resultCallback) throws HttpException, IOException {
        this.entityDetails = entityDetails;
        this.resultCallback = resultCallback;
    }

    public void failed(Exception cause) {
        if (this.resultCallback != null) {
            this.resultCallback.failed(cause);
        }
        this.releaseResources();
    }

    public HttpEntity getContent() {
        return this.content;
    }

    public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        capacityChannel.update(Integer.MAX_VALUE);
    }

    public void consume(ByteBuffer src) throws IOException {
        if (src == null) {
            return;
        }
        if (src.hasArray()) {
            this.buffer.append(src.array(), src.arrayOffset() + src.position(), src.remaining());
        } else {
            while (src.hasRemaining()) {
                this.buffer.append((int)src.get());
            }
        }
    }

    public void streamEnd(List<? extends Header> trailers) {
        if (this.entityDetails != null) {
            this.content = new ByteArrayEntity(this.buffer.toByteArray(), ContentType.parse((CharSequence)this.entityDetails.getContentType()), this.entityDetails.getContentEncoding(), this.entityDetails.isChunked());
        }
        this.resultCallback.completed((Object)this.content);
    }

    public void releaseResources() {
        this.buffer.clear();
    }
}

