/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.domainrep.rdm.dictionary;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.codec.MsgKey;
import com.refinitiv.eta.codec.RequestMsg;
import com.refinitiv.eta.valueadd.domainrep.rdm.MsgBaseImpl;
import com.refinitiv.eta.valueadd.domainrep.rdm.dictionary.DictionaryRequest;
import java.nio.ByteBuffer;

class DictionaryRequestImpl
extends MsgBaseImpl {
    private Buffer dictionaryName;
    private int verbosity;
    private int serviceId;
    private int flags;
    private RequestMsg requestMsg = (RequestMsg)CodecFactory.createMsg();
    private static final String eol = "\n";
    private static final String tab = "\t";

    DictionaryRequestImpl() {
        this.dictionaryName = CodecFactory.createBuffer();
        this.clear();
    }

    @Override
    public void clear() {
        super.clear();
        this.flags = 0;
        this.serviceId = 0;
        this.dictionaryName.clear();
        this.verbosity = 7;
    }

    @Override
    public int decode(DecodeIterator dIter, Msg msg) {
        this.clear();
        if (msg.msgClass() != 1) {
            return -1;
        }
        RequestMsg requestMsg = (RequestMsg)msg;
        this.streamId(requestMsg.streamId());
        MsgKey msgKey = msg.msgKey();
        if (requestMsg.checkStreaming()) {
            this.applyStreaming();
        }
        if (msgKey == null) {
            return -1;
        }
        if (!msgKey.checkHasFilter()) {
            return -1;
        }
        if (!msgKey.checkHasServiceId()) {
            return -1;
        }
        if (!msgKey.checkHasName()) {
            return -1;
        }
        this.serviceId(msgKey.serviceId());
        Buffer name = msgKey.name();
        this.dictionaryName().data(name.data(), name.position(), name.length());
        this.verbosity((int)msgKey.filter());
        return 0;
    }

    @Override
    public int encode(EncodeIterator encodeIter) {
        this.requestMsg.clear();
        this.requestMsg.streamId(this.streamId());
        this.requestMsg.msgClass(1);
        this.requestMsg.domainType(5);
        this.requestMsg.containerType(128);
        this.requestMsg.flags(0);
        this.requestMsg.msgKey().applyHasFilter();
        this.requestMsg.msgKey().applyHasName();
        this.requestMsg.msgKey().applyHasServiceId();
        if (this.checkStreaming()) {
            this.requestMsg.applyStreaming();
        }
        this.requestMsg.msgKey().name(this.dictionaryName());
        this.requestMsg.msgKey().serviceId(this.serviceId());
        this.requestMsg.msgKey().filter((long)this.verbosity());
        return this.requestMsg.encode(encodeIter);
    }

    public int verbosity() {
        return this.verbosity;
    }

    public void verbosity(int verbosity) {
        this.verbosity = verbosity;
    }

    public Buffer dictionaryName() {
        return this.dictionaryName;
    }

    public void dictionaryName(Buffer dictionaryName) {
        assert (dictionaryName != null) : "dictionaryName can not be null";
        this.dictionaryName.data(dictionaryName.data(), dictionaryName.position(), dictionaryName.length());
    }

    public int copy(DictionaryRequest destRequestMsg) {
        assert (destRequestMsg != null) : "destRequestMsg can not be null";
        destRequestMsg.streamId(this.streamId());
        destRequestMsg.serviceId(this.serviceId());
        destRequestMsg.verbosity(this.verbosity());
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.dictionaryName.length());
        this.dictionaryName.copy(byteBuffer);
        destRequestMsg.dictionaryName().data(byteBuffer);
        if (this.checkStreaming()) {
            destRequestMsg.applyStreaming();
        }
        return 0;
    }

    public int serviceId() {
        return this.serviceId;
    }

    public void serviceId(int serviceId) {
        this.serviceId = serviceId;
    }

    public int flags() {
        return this.flags;
    }

    public void flags(int flags) {
        this.flags = flags;
    }

    public void applyStreaming() {
        this.flags |= 1;
    }

    public boolean checkStreaming() {
        return (this.flags & 1) != 0;
    }

    @Override
    public String toString() {
        StringBuilder stringBuf = super.buildStringBuffer();
        stringBuf.insert(0, "DictionaryRequest: \n");
        stringBuf.append(tab);
        stringBuf.append("serviceId: ");
        stringBuf.append(this.serviceId());
        stringBuf.append(eol);
        stringBuf.append(tab);
        stringBuf.append("dictionaryName: ");
        stringBuf.append(this.dictionaryName());
        stringBuf.append(eol);
        stringBuf.append(tab);
        stringBuf.append("streaming: ");
        stringBuf.append(this.checkStreaming());
        stringBuf.append(eol);
        stringBuf.append(tab);
        stringBuf.append("verbosity: ");
        boolean addOr = false;
        long verbosity = this.verbosity();
        if ((verbosity & 0L) != 0L) {
            stringBuf.append("INFO");
            addOr = true;
        }
        if ((verbosity & 3L) != 0L) {
            if (addOr) {
                stringBuf.append(" | ");
            }
            stringBuf.append("MINIMAL");
            addOr = true;
        }
        if ((verbosity & 7L) != 0L) {
            if (addOr) {
                stringBuf.append(" | ");
            }
            stringBuf.append("NORMAL");
            addOr = true;
        }
        if ((verbosity & 0xFL) != 0L) {
            if (addOr) {
                stringBuf.append(" | ");
            }
            stringBuf.append("VERBOSE");
            addOr = true;
        }
        stringBuf.append(eol);
        return stringBuf.toString();
    }

    @Override
    public int domainType() {
        return 5;
    }
}

