/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.valueadd.reactor.ReactorAuthTokenInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorErrorInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorServiceEndpointInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorTokenSession;
import com.refinitiv.eta.valueadd.reactor.RestAuthOptions;
import com.refinitiv.eta.valueadd.reactor.RestClient;
import com.refinitiv.eta.valueadd.reactor.RestConnectOptions;
import com.refinitiv.eta.valueadd.reactor.RestEvent;
import com.refinitiv.eta.valueadd.reactor.RestHandler;
import com.refinitiv.eta.valueadd.reactor.RestProxyAuthHandler;
import com.refinitiv.eta.valueadd.reactor.RestReactorOptions;
import com.refinitiv.eta.valueadd.reactor.RestRequest;
import com.refinitiv.eta.valueadd.reactor.RestResponse;
import com.refinitiv.eta.valueadd.reactor.RestResultClosure;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URISyntaxException;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLContext;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.nio.DefaultHttpClientIODispatch;
import org.apache.http.impl.nio.pool.BasicNIOConnFactory;
import org.apache.http.impl.nio.pool.BasicNIOConnPool;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.nio.NHttpClientEventHandler;
import org.apache.http.nio.pool.NIOConnFactory;
import org.apache.http.nio.protocol.BasicAsyncRequestProducer;
import org.apache.http.nio.protocol.BasicAsyncResponseConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestExecutor;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncRequester;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.pool.ConnPool;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.apache.http.protocol.HttpProcessorBuilder;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.lang.JoseException;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RestReactor {
    static final String AUTH_GRANT_TYPE = "grant_type";
    static final String AUTH_USER_NAME = "username";
    static final String AUTH_PASSWORD = "password";
    static final String AUTH_NEWPASSWORD = "newPassword";
    static final String AUTH_CLIENT_ID = "client_id";
    static final String AUTH_CLIENT_SECRET = "client_secret";
    static final String AUTH_CLIENT_CREDENTIALS_GRANT = "client_credentials";
    static final String AUTH_TAKE_EXCLUSIVE_SIGN_ON_CONTROL = "takeExclusiveSignOnControl";
    static final String AUTH_SCOPE = "scope";
    static final String AUTH_BEARER = "Bearer ";
    static final String AUTH_REFRESH_TOKEN = "refresh_token";
    static final String AUTH_ACCESS_TOKEN = "access_token";
    static final String AUTH_EXPIRES_IN = "expires_in";
    static final String AUTH_TOKEN_TYPE = "token_type";
    static final String AUTH_POST = "POST";
    static final String AUTH_REQUEST_USER_AGENT = "HTTP/1.1";
    static final String AUTH_CLIENT_ASSERTION = "client_assertion";
    static final String AUTH_CLIENT_ASSERTION_TYPE = "client_assertion_type";
    static final String AUTH_CLIENT_ASSERTION_VALUE = "urn:ietf:params:oauth:client-assertion-type:jwt-bearer";
    static final String AUTH_DEFAULT_AUDIENCE = "https://login.ciam.refinitiv.com/as/token.oauth2";
    static final int AUTH_HANDLER = 1;
    static final int DISCOVERY_HANDLER = 2;
    private boolean _reactorActive;
    private RestReactorOptions _restReactorOptions = new RestReactorOptions();
    private final SSLContextBuilder _sslContextBuilder = new SSLContextBuilder();
    private SSLConnectionSocketFactory _sslconSocketFactory;
    private final HttpAsyncRequestExecutor _protocolHandler = new HttpAsyncRequestExecutor();
    private IOEventDispatch _ioEventDispatch;
    private ConnectingIOReactor _ioReactor;
    private BasicNIOConnPool _pool;
    private RestProxyAuthHandler _restProxyAuthHandler;
    private Logger loggerClient = null;
    private List<StringBuilder> bufferPool = null;
    Lock lock = new ReentrantLock();

    public RestReactor(RestReactorOptions options, ReactorErrorInfo errorInfo) {
        if (errorInfo == null) {
            throw new UnsupportedOperationException("ReactorErrorInfo cannot be null");
        }
        if (options != null) {
            options.copy(this._restReactorOptions);
        } else {
            RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.constructor", "options was null and cannot continue.");
        }
        try {
            SSLContext sslContext = this._sslContextBuilder.build();
            this._sslconSocketFactory = new SSLConnectionSocketFactory(sslContext);
            this._restProxyAuthHandler = new RestProxyAuthHandler(this, this._sslconSocketFactory);
            ConnectionConfig connectionConfig = ConnectionConfig.custom().setBufferSize(options.bufferSize()).setFragmentSizeHint(options.fragmentSizeHint()).build();
            this._ioEventDispatch = new DefaultHttpClientIODispatch((NHttpClientEventHandler)this._protocolHandler, sslContext, connectionConfig);
            this._ioReactor = new DefaultConnectingIOReactor(IOReactorConfig.custom().setConnectTimeout(options.connectTimeout()).setSoTimeout(options.soTimeout()).setTcpNoDelay(options.tcpNoDelay()).setIoThreadCount(options.ioThreadCount()).setSoKeepAlive(options.soKeepAlive()).setSelectInterval(options.selectInterval()).setShutdownGracePeriod(options.shutdownGracePeriod()).build());
            BasicNIOConnFactory nioConnFactory = new BasicNIOConnFactory(sslContext, null, connectionConfig);
            this._pool = new BasicNIOConnPool(this._ioReactor, (NIOConnFactory)nioConnFactory, options.connectTimeout());
            this._pool.setDefaultMaxPerRoute(options.defaultMaxPerRoute());
            this._pool.setMaxTotal(options.maxConnectTotal());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.initialize", "failed to initialize the SSLConnectionSocketFactory, exception=" + RestReactor.getExceptionCause(e));
            return;
        }
        catch (IOReactorException e) {
            RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.initialize", "failed to initialize the DefaultConnectingIOReactor, exception=" + RestReactor.getExceptionCause((Exception)((Object)e)));
            return;
        }
        this._reactorActive = true;
        this.loggerClient = LoggerFactory.getLogger(this.getClass());
        this.bufferPool = new ArrayList<StringBuilder>();
    }

    RestReactorOptions restReactorOptions() {
        return this._restReactorOptions;
    }

    static int populateErrorInfo(ReactorErrorInfo errorInfo, int reactorReturnCode, String location, String text) {
        errorInfo.clear();
        errorInfo.code(reactorReturnCode).location(location);
        errorInfo.error().errorId(reactorReturnCode);
        if (text != null) {
            errorInfo.error().text(text);
        }
        return reactorReturnCode;
    }

    private String getClientJwt(String clientId, String clientJwk, String endpointUrl, String audience, ReactorErrorInfo errorInfo) {
        Date currentDate = new Date(System.currentTimeMillis());
        long expTime = currentDate.getTime() / 1000L + 900L;
        long iatTime = currentDate.getTime() / 1000L;
        PublicJsonWebKey parsedJwkKeyPair = null;
        JsonWebKey webkey = null;
        String tmpAudience = null;
        try {
            webkey = JsonWebKey.Factory.newJwk((String)clientJwk);
            if (webkey == null) {
                RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.getClientAssertion", "Unable to parse the clientJwk string.");
                return null;
            }
            String jwkAsString = webkey.toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE);
            parsedJwkKeyPair = PublicJsonWebKey.Factory.newPublicJwk((String)jwkAsString);
        }
        catch (JoseException e) {
            RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.getClientAssertion", "Jose4j exception: " + e.getMessage());
            return null;
        }
        catch (Exception e) {
            RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.getClientAssertion", "Exception: " + e.getMessage());
            return null;
        }
        tmpAudience = audience == null || audience.isEmpty() ? AUTH_DEFAULT_AUDIENCE : audience;
        JwtClaims claims = new JwtClaims();
        claims.setClaim("iss", (Object)clientId);
        claims.setClaim("sub", (Object)clientId);
        claims.setClaim("aud", (Object)tmpAudience);
        claims.setClaim("exp", (Object)expTime);
        claims.setClaim("iat", (Object)iatTime);
        try {
            JsonWebSignature jws = new JsonWebSignature();
            jws.setPayload(claims.toJson());
            jws.setKey((Key)parsedJwkKeyPair.getPrivateKey());
            jws.setHeader("alg", webkey.getAlgorithm());
            jws.setHeader("typ", "JWT");
            jws.setHeader("kid", webkey.getKeyId());
            jws.sign();
            String sResult = jws.getCompactSerialization();
            return sResult;
        }
        catch (JoseException e) {
            RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.getClientAssertion", "Exception from JWT signing: " + e.getMessage());
            return null;
        }
    }

    public int submitAuthRequest(RestAuthOptions authOptions, RestConnectOptions restConnectOptions, ReactorAuthTokenInfo authTokenInfo, ReactorErrorInfo errorInfo, boolean redirect, String location) {
        restConnectOptions.authRedirect(redirect);
        restConnectOptions.authRedirectLocation(location);
        return this.submitAuthRequest(authOptions, restConnectOptions, authTokenInfo, errorInfo);
    }

    public int submitAuthRequest(final RestAuthOptions authOptions, final RestConnectOptions restConnectOptions, ReactorAuthTokenInfo authTokenInfo, final ReactorErrorInfo errorInfo) {
        if (!this._reactorActive) {
            return RestReactor.populateErrorInfo(errorInfo, -10, "RestReactor.submitAuthRequest", "RestReactor is not active, aborting");
        }
        final ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(7);
        String url = null;
        if (authTokenInfo.tokenVersion() == ReactorAuthTokenInfo.TokenVersion.V1) {
            params.add(new BasicNameValuePair(AUTH_GRANT_TYPE, authOptions.grantType()));
            params.add(new BasicNameValuePair(AUTH_USER_NAME, authOptions.username()));
            params.add(new BasicNameValuePair(AUTH_CLIENT_ID, authOptions.clientId()));
            if (authOptions.grantType().equals(AUTH_REFRESH_TOKEN)) {
                params.add(new BasicNameValuePair(AUTH_REFRESH_TOKEN, authTokenInfo.refreshToken()));
            } else {
                params.add(new BasicNameValuePair(AUTH_TAKE_EXCLUSIVE_SIGN_ON_CONTROL, authOptions.takeExclusiveSignOnControlAsString()));
                params.add(new BasicNameValuePair(AUTH_SCOPE, authOptions.tokenScope()));
                params.add(new BasicNameValuePair(AUTH_PASSWORD, authOptions.password()));
                if (authOptions.hasNewPassword()) {
                    params.add(new BasicNameValuePair(AUTH_NEWPASSWORD, authOptions.newPassword()));
                }
                if (authOptions.hasClientSecret()) {
                    params.add(new BasicNameValuePair(AUTH_CLIENT_SECRET, authOptions.clientSecret()));
                }
                if (authOptions.tokenSession() != null) {
                    authOptions.tokenSession().originalExpiresIn(0);
                }
            }
            if (url == null) {
                url = restConnectOptions.authRedirect() && restConnectOptions.authRedirectLocation() != null ? restConnectOptions.authRedirectLocation() : restConnectOptions.tokenServiceURLV1();
            }
        } else {
            if (url == null) {
                url = restConnectOptions.authRedirect() && restConnectOptions.authRedirectLocation() != null ? restConnectOptions.authRedirectLocation() : restConnectOptions.tokenServiceURLV2();
            }
            params.add(new BasicNameValuePair(AUTH_GRANT_TYPE, AUTH_CLIENT_CREDENTIALS_GRANT));
            params.add(new BasicNameValuePair(AUTH_CLIENT_ID, authOptions.clientId()));
            params.add(new BasicNameValuePair(AUTH_SCOPE, authOptions.tokenScope()));
            if (authOptions.clientJwk().isEmpty()) {
                params.add(new BasicNameValuePair(AUTH_CLIENT_SECRET, authOptions.clientSecret()));
            } else {
                String jwt = this.getClientJwt(authOptions.clientId(), authOptions.clientJwk(), url, authOptions.audience(), errorInfo);
                if (jwt == null) {
                    return -1;
                }
                params.add(new BasicNameValuePair(AUTH_CLIENT_ASSERTION_TYPE, AUTH_CLIENT_ASSERTION_VALUE));
                params.add(new BasicNameValuePair(AUTH_CLIENT_ASSERTION, jwt));
            }
        }
        final RestHandler restHandler = new RestHandler(this, authOptions, restConnectOptions, authTokenInfo, errorInfo);
        if (restConnectOptions.proxyHost() == null || restConnectOptions.proxyHost().isEmpty() || restConnectOptions.proxyPort() == -1) {
            BasicHttpEntityEnclosingRequest httpRequest = new BasicHttpEntityEnclosingRequest(AUTH_POST, url);
            httpRequest.setEntity((HttpEntity)new UrlEncodedFormEntity(params, Consts.UTF_8));
            if (authOptions.hasHeaderAttribute()) {
                Map<String, String> headerAttribs = authOptions.headerAttribute();
                for (Map.Entry<String, String> entry : headerAttribs.entrySet()) {
                    httpRequest.addHeader(entry.getKey(), entry.getValue());
                }
            }
            HttpAsyncRequester requester = new HttpAsyncRequester(HttpProcessorBuilder.create().add((HttpRequestInterceptor)new RequestContent()).add((HttpRequestInterceptor)new RequestTargetHost()).add((HttpRequestInterceptor)new RequestConnControl()).add((HttpRequestInterceptor)new RequestUserAgent(AUTH_REQUEST_USER_AGENT)).add((HttpRequestInterceptor)new RequestExpectContinue(true)).build());
            restHandler.setCurrentRequest((AbstractHttpMessage)httpRequest);
            if (authTokenInfo.tokenVersion() == ReactorAuthTokenInfo.TokenVersion.V1) {
                requester.execute((HttpAsyncRequestProducer)new BasicAsyncRequestProducer(restConnectOptions.tokenServiceHost(), (HttpRequest)httpRequest), (HttpAsyncResponseConsumer)new BasicAsyncResponseConsumer(), (ConnPool)this._pool, (HttpContext)HttpClientContext.create(), (FutureCallback)restHandler);
            } else {
                requester.execute((HttpAsyncRequestProducer)new BasicAsyncRequestProducer(restConnectOptions.tokenServiceHostV2(), (HttpRequest)httpRequest), (HttpAsyncResponseConsumer)new BasicAsyncResponseConsumer(), (ConnPool)this._pool, (HttpContext)HttpClientContext.create(), (FutureCallback)restHandler);
            }
        } else {
            final RestProxyAuthHandler proxyAuthHandler = new RestProxyAuthHandler(this, this._sslconSocketFactory);
            final String threadUrl = url;
            new Thread(){

                @Override
                public void run() {
                    HttpPost httppost = new HttpPost(threadUrl);
                    if (authOptions.hasHeaderAttribute()) {
                        Map<String, String> headerAttribs = authOptions.headerAttribute();
                        for (Map.Entry<String, String> entry : headerAttribs.entrySet()) {
                            httppost.addHeader(entry.getKey(), entry.getValue());
                        }
                    }
                    httppost.setEntity((HttpEntity)new UrlEncodedFormEntity((Iterable)params, Consts.UTF_8));
                    HttpHost proxy = new HttpHost(restConnectOptions.proxyHost(), restConnectOptions.proxyPort(), "http");
                    RequestConfig config = RequestConfig.custom().setProxy(proxy).setRedirectsEnabled(false).build();
                    httppost.setConfig(config);
                    try {
                        proxyAuthHandler.executeAsync((HttpRequestBase)httppost, restConnectOptions, restHandler, errorInfo);
                    }
                    catch (IOException e) {
                        restHandler.failed(e);
                    }
                }
            }.start();
        }
        return 0;
    }

    public int submitRequestForServiceDiscovery(RestRequest request, RestConnectOptions restConnectOptions, ReactorAuthTokenInfo authTokenInfo, List<ReactorServiceEndpointInfo> reactorServiceEndpointInfoList, ReactorErrorInfo errorInfo, boolean redirect, String location) {
        restConnectOptions.discoveryRedirect(redirect);
        restConnectOptions.discoveryRedirectLocation(location);
        return this.submitRequestForServiceDiscovery(request, restConnectOptions, authTokenInfo, reactorServiceEndpointInfoList, errorInfo);
    }

    public int submitRequestForServiceDiscovery(RestRequest request, final RestConnectOptions restConnectOptions, ReactorAuthTokenInfo authTokenInfo, List<ReactorServiceEndpointInfo> reactorServiceEndpointInfoList, final ReactorErrorInfo errorInfo) {
        if (!this._reactorActive) {
            return RestReactor.populateErrorInfo(errorInfo, -10, "RestReactor.submitRequestForServiceDiscovery", "RestReactor is not active, aborting");
        }
        URIBuilder uriBuilder = null;
        try {
            uriBuilder = new URIBuilder(restConnectOptions.serviceDiscoveryURL());
        }
        catch (Exception e) {
            return RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.submitRequestForServiceDiscovery", "failed to submit a request, exception = " + RestReactor.getExceptionCause(e));
        }
        Map<String, String> queryParameter = request.queryParameter();
        if (queryParameter != null) {
            for (Map.Entry<String, String> entry : queryParameter.entrySet()) {
                uriBuilder.setParameter(entry.getKey(), entry.getValue());
            }
        }
        String url = null;
        try {
            url = restConnectOptions.discoveryRedirect() && restConnectOptions.discoveryRedirectLocation() != null ? restConnectOptions.discoveryRedirectLocation() : uriBuilder.build().toString();
        }
        catch (URISyntaxException e) {
            return RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.submitRequestForServiceDiscovery", "failed to submit a request, exception = " + RestReactor.getExceptionCause(e));
        }
        final HttpGet httpRequest = new HttpGet(url);
        if (request.hasHeaderAttribute()) {
            Map<String, String> headerAttribs = request.headerAttribute();
            for (Map.Entry<String, String> entry : headerAttribs.entrySet()) {
                httpRequest.addHeader(entry.getKey(), entry.getValue());
            }
        }
        String token = authTokenInfo.accessToken();
        httpRequest.setHeader("Authorization", AUTH_BEARER + token);
        final RestHandler restHandler = new RestHandler(this, request, restConnectOptions, authTokenInfo, reactorServiceEndpointInfoList, errorInfo);
        if (restConnectOptions.proxyHost() == null || restConnectOptions.proxyHost().isEmpty() || restConnectOptions.proxyPort() == -1) {
            HttpAsyncRequester requester = new HttpAsyncRequester(HttpProcessorBuilder.create().add((HttpRequestInterceptor)new RequestContent()).add((HttpRequestInterceptor)new RequestTargetHost()).add((HttpRequestInterceptor)new RequestConnControl()).add((HttpRequestInterceptor)new RequestUserAgent(AUTH_REQUEST_USER_AGENT)).add((HttpRequestInterceptor)new RequestExpectContinue(true)).build());
            restHandler.setCurrentRequest((AbstractHttpMessage)httpRequest);
            requester.execute((HttpAsyncRequestProducer)new BasicAsyncRequestProducer(restConnectOptions.serviceDiscoveryHost(), (HttpRequest)httpRequest), (HttpAsyncResponseConsumer)new BasicAsyncResponseConsumer(), (ConnPool)this._pool, (HttpContext)HttpCoreContext.create(), (FutureCallback)restHandler);
        } else {
            final RestProxyAuthHandler proxyAuthHandler = new RestProxyAuthHandler(this, this._sslconSocketFactory);
            new Thread(){

                @Override
                public void run() {
                    HttpHost proxy = new HttpHost(restConnectOptions.proxyHost(), restConnectOptions.proxyPort(), "http");
                    RequestConfig config = RequestConfig.custom().setProxy(proxy).setRedirectsEnabled(false).build();
                    httpRequest.setConfig(config);
                    try {
                        proxyAuthHandler.executeAsync((HttpRequestBase)httpRequest, restConnectOptions, restHandler, errorInfo);
                    }
                    catch (IOException e) {
                        restHandler.failed(e);
                    }
                }
            }.start();
        }
        return 0;
    }

    public int dispatch(ReactorErrorInfo errorInfo) {
        if (!this._reactorActive) {
            return RestReactor.populateErrorInfo(errorInfo, -10, "RestReactor.dispatch", "RestReactor is not active, aborting");
        }
        try {
            this._ioReactor.execute(this._ioEventDispatch);
        }
        catch (InterruptedIOException e) {
            return RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.dispatch", "received Interrupted IOException, exception = " + RestReactor.getExceptionCause(e));
        }
        catch (IOException e) {
            return RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.dispatch", "received IOException, exception = " + RestReactor.getExceptionCause(e));
        }
        this.shutdown(errorInfo);
        return 0;
    }

    public boolean isShutdown() {
        return !this._reactorActive;
    }

    public int shutdown(ReactorErrorInfo errorInfo) {
        if (!this._reactorActive) {
            return 0;
        }
        this._reactorActive = false;
        try {
            this._ioReactor.shutdown(this._restReactorOptions.shutdownGracePeriod());
            this._ioReactor = null;
        }
        catch (IOException e) {
            return RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.shutdown", "received IOException, exception = " + RestReactor.getExceptionCause(e));
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int submitAuthRequestBlocking(RestAuthOptions authOptions, RestConnectOptions restConnectOptions, ReactorAuthTokenInfo authTokenInfo, ReactorErrorInfo errorInfo) throws IOException {
        if (!this._reactorActive) {
            return RestReactor.populateErrorInfo(errorInfo, -10, "RestReactor.submitAuthRequestBlocking", "RestReactor is not active, aborting");
        }
        if (this._sslconSocketFactory == null) {
            return RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.submitAuthRequestBlocking", "failed to initialize the SSLConnectionSocketFactory");
        }
        params = new ArrayList<BasicNameValuePair>(7);
        url = null;
        if (authTokenInfo.tokenVersion() == ReactorAuthTokenInfo.TokenVersion.V1) {
            params.add(new BasicNameValuePair("grant_type", authOptions.grantType()));
            params.add(new BasicNameValuePair("username", authOptions.username()));
            params.add(new BasicNameValuePair("client_id", authOptions.clientId()));
            if (authOptions.grantType().equals("refresh_token")) {
                params.add(new BasicNameValuePair("refresh_token", authTokenInfo.refreshToken()));
            } else {
                params.add(new BasicNameValuePair("takeExclusiveSignOnControl", authOptions.takeExclusiveSignOnControlAsString()));
                params.add(new BasicNameValuePair("scope", authOptions.tokenScope()));
                params.add(new BasicNameValuePair("password", authOptions.password()));
                if (authOptions.hasNewPassword()) {
                    params.add(new BasicNameValuePair("newPassword", authOptions.newPassword()));
                }
                if (authOptions.hasClientSecret()) {
                    params.add(new BasicNameValuePair("client_secret", authOptions.clientSecret()));
                }
                if (authOptions.tokenSession() != null) {
                    authOptions.tokenSession().originalExpiresIn(0);
                }
            }
            if (url == null) {
                url = restConnectOptions.authRedirect() && restConnectOptions.authRedirectLocation() != null ? restConnectOptions.authRedirectLocation() : restConnectOptions.tokenServiceURLV1();
            }
        } else {
            params.add(new BasicNameValuePair("grant_type", "client_credentials"));
            params.add(new BasicNameValuePair("client_id", authOptions.clientId()));
            params.add(new BasicNameValuePair("scope", authOptions.tokenScope()));
            if (authOptions.clientJwk().isEmpty()) {
                params.add(new BasicNameValuePair("client_secret", authOptions.clientSecret()));
            } else {
                jwt = this.getClientJwt(authOptions.clientId(), authOptions.clientJwk(), url, authOptions.audience(), errorInfo);
                if (jwt == null) {
                    return -1;
                }
                params.add(new BasicNameValuePair("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
                params.add(new BasicNameValuePair("client_assertion", jwt));
            }
            if (url == null) {
                url = restConnectOptions.authRedirect() != false && restConnectOptions.authRedirectLocation() != null ? restConnectOptions.authRedirectLocation() : restConnectOptions.tokenServiceURLV2();
            }
        }
        try {
            entity = new UrlEncodedFormEntity(params, Consts.UTF_8);
            if (authOptions.hasHeaderAttribute()) {
                headers = authOptions.headerAttribute();
                if (headers.containsKey("Transfer-Encoding") && headers.get("Transfer-Encoding").contentEquals("chunked")) {
                    entity.setChunked(true);
                }
                if (headers.containsKey("Content-Encoding")) {
                    entity.setContentEncoding(headers.get("Content-Encoding"));
                }
                if (headers.containsKey("Content-Type")) {
                    entity.setContentType(headers.get("Content-Type"));
                }
            }
            restResponse = new RestResponse();
            done = false;
            block12: for (attemptCount = 0; attemptCount <= 1 && !done; ++attemptCount) {
                httppost = new HttpPost(url);
                httppost.setEntity((HttpEntity)entity);
                if (restConnectOptions.proxyHost() != null && !restConnectOptions.proxyHost().isEmpty() && restConnectOptions.proxyPort() != -1) {
                    proxy = new HttpHost(restConnectOptions.proxyHost(), restConnectOptions.proxyPort(), "http");
                    config = RequestConfig.custom().setProxy(proxy).setSocketTimeout(this._restReactorOptions.soTimeout()).setRedirectsEnabled(false).build();
                    httppost.setConfig(config);
                    ret = this._restProxyAuthHandler.executeSync((HttpRequestBase)httppost, restConnectOptions, restResponse, errorInfo);
                    if (ret != 0) return ret;
                    ReactorTokenSession.parseTokenInfomation(restResponse, authTokenInfo);
                    return ret;
                }
                httpClient = HttpClientBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)this._sslconSocketFactory).build();
                config = RequestConfig.custom().setSocketTimeout(this._restReactorOptions.soTimeout()).setRedirectsEnabled(false).build();
                httppost.setConfig(config);
                try {
                    response = this.executeRequest((HttpRequestBase)httppost, restConnectOptions, (HttpClient)httpClient, this.loggerClient);
                    entityFromResponse = response.getEntity();
                    contentString = null;
                    extractingContentException = null;
                    try {
                        contentString = EntityUtils.toString((HttpEntity)entityFromResponse);
                    }
                    catch (Exception e) {
                        extractingContentException = e;
                    }
                    if (this.loggerClient.isTraceEnabled()) {
                        this.loggerClient.trace(this.prepareResponseString(response, contentString, extractingContentException));
                    }
                    statusCode = response.getStatusLine().getStatusCode();
                    switch (statusCode) {
                        case 200: {
                            RestReactor.convertResponse(this, response, restResponse, errorInfo, contentString, extractingContentException);
                            ReactorTokenSession.parseTokenInfomation(restResponse, authTokenInfo);
                            done = true;
                            ** break;
lbl100:
                            // 1 sources

                            continue block12;
                        }
                        case 301: 
                        case 302: 
                        case 307: 
                        case 308: {
                            header = response.getFirstHeader("Location");
                            if (header == null) {
                                RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.submitAuthRequestBlocking", "Failed to request authentication token information with HTTP error " + response.getStatusLine().getStatusCode() + ". Malformed redirection response.");
                                var20_24 = -1;
                                return var20_24;
                            }
                            newHost = header.getValue();
                            if (newHost != null) {
                                url = newHost;
                                if (statusCode == 301 || statusCode == 308) {
                                    newUrl = CodecFactory.createBuffer();
                                    newUrl.data(newHost);
                                    if (authTokenInfo.tokenVersion() == ReactorAuthTokenInfo.TokenVersion.V1) {
                                        restConnectOptions.reactorOptions().tokenServiceURL_V1(newUrl);
                                    } else {
                                        restConnectOptions.reactorOptions().tokenServiceURL_V2(newUrl);
                                    }
                                }
                            }
                            done = false;
                            ** break;
lbl123:
                            // 1 sources

                            continue block12;
                        }
                        default: {
                            RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.submitAuthRequestBlocking", "Failed to request authentication token information with HTTP error " + response.getStatusLine().getStatusCode() + ". Text: " + (Objects.nonNull(contentString) != false ? contentString : ""));
                            var20_25 = -1;
                            return var20_25;
                        }
                    }
                }
                finally {
                    httpClient.close();
                }
            }
            if (attemptCount <= true) return 0;
            if (done != false) return 0;
            RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.submitAuthRequestBlocking", "Failed to request authentication token information. Too many redirect attempts.");
            return -1;
        }
        catch (IOException | ParseException | JSONException e) {
            return RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.submitAuthRequestBlocking", "failed to submit authorization request, exception = " + RestReactor.getExceptionCause((Exception)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int submitServiceDiscoveryRequestBlocking(RestRequest request, RestConnectOptions restConnectOptions, ReactorAuthTokenInfo authTokenInfo, List<ReactorServiceEndpointInfo> reactorServiceEndpointInfoList, ReactorErrorInfo errorInfo) throws IOException {
        if (!this._reactorActive) {
            return RestReactor.populateErrorInfo(errorInfo, -10, "RestReactor.submitServiceDiscoveryRequestBlocking", "RestReactor is not active, aborting");
        }
        if (this._sslconSocketFactory == null) {
            return RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.submitServiceDiscoveryRequestBlocking", "failed to initialize the SSLConnectionSocketFactory");
        }
        url = null;
        url = restConnectOptions.discoveryRedirect() == true ? restConnectOptions.discoveryRedirectLocation() : restConnectOptions.serviceDiscoveryURL();
        try {
            uriBuilder = null;
            token = authTokenInfo.accessToken();
            restResponse = new RestResponse();
            done = false;
            block16: for (attemptCount = 0; attemptCount <= 1 && !done; ++attemptCount) {
                try {
                    uriBuilder = new URIBuilder(url);
                }
                catch (Exception e) {
                    return RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.submitServiceDiscoveryRequestBlocking", "failed to submit a request, exception = " + RestReactor.getExceptionCause(e));
                }
                if (request.hasQueryParameter() && (queryParameter = request.queryParameter()) != null) {
                    for (Map.Entry<String, String> entry : queryParameter.entrySet()) {
                        uriBuilder.setParameter(entry.getKey(), entry.getValue());
                    }
                }
                httpget = new HttpGet(uriBuilder.build());
                if (request.hasHeaderAttribute()) {
                    for (Map.Entry<String, String> entry : request.headerAttribute().entrySet()) {
                        httpget.addHeader(entry.getKey(), entry.getValue());
                    }
                }
                httpget.setHeader("Authorization", "Bearer " + token);
                if (restConnectOptions.proxyHost() != null && !restConnectOptions.proxyHost().isEmpty() && restConnectOptions.proxyPort() != -1) {
                    proxy = new HttpHost(restConnectOptions.proxyHost(), restConnectOptions.proxyPort(), "http");
                    config = RequestConfig.custom().setProxy(proxy).setSocketTimeout(this._restReactorOptions.soTimeout()).setRedirectsEnabled(false).build();
                    httpget.setConfig(config);
                    ret = this._restProxyAuthHandler.executeSync((HttpRequestBase)httpget, restConnectOptions, restResponse, errorInfo);
                    if (ret != 0) return ret;
                    RestClient.parseServiceDiscovery(restResponse, reactorServiceEndpointInfoList);
                    return ret;
                }
                httpClient = HttpClientBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)this._sslconSocketFactory).build();
                config = RequestConfig.custom().setSocketTimeout(this._restReactorOptions.soTimeout()).setRedirectsEnabled(false).build();
                httpget.setConfig(config);
                try {
                    response = this.executeRequest((HttpRequestBase)httpget, restConnectOptions, (HttpClient)httpClient, this.loggerClient);
                    entityFromResponse = response.getEntity();
                    contentString = null;
                    extractingContentException = null;
                    try {
                        contentString = EntityUtils.toString((HttpEntity)entityFromResponse);
                    }
                    catch (Exception e) {
                        extractingContentException = e;
                    }
                    if (this.loggerClient.isTraceEnabled()) {
                        this.loggerClient.trace(this.prepareResponseString(response, contentString, extractingContentException));
                    }
                    statusCode = response.getStatusLine().getStatusCode();
                    switch (statusCode) {
                        case 200: {
                            RestReactor.convertResponse(this, response, restResponse, errorInfo, contentString, extractingContentException);
                            RestClient.parseServiceDiscovery(restResponse, reactorServiceEndpointInfoList);
                            done = true;
                            ** break;
lbl60:
                            // 1 sources

                            continue block16;
                        }
                        case 301: 
                        case 302: 
                        case 307: 
                        case 308: {
                            header = response.getFirstHeader("Location");
                            if (header == null) {
                                RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.submitServiceDiscoveryRequestBlocking", "Failed to request service discovery information. Malformed redirection response.");
                                var21_28 = -1;
                                return var21_28;
                            }
                            newHost = header.getValue();
                            if (newHost != null) {
                                url = newHost;
                                if (statusCode == 301 || statusCode == 308) {
                                    newUrl = CodecFactory.createBuffer();
                                    newUrl.data(newHost);
                                    restConnectOptions.reactorOptions().serviceDiscoveryURL(newUrl);
                                }
                            }
                            done = false;
                            ** break;
lbl79:
                            // 1 sources

                            continue block16;
                        }
                        default: {
                            RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.submitServiceDiscoveryRequestBlocking", "Failed to request service discovery information. Text: " + (Objects.nonNull(contentString) != false ? contentString : ""));
                            var21_29 = -1;
                            return var21_29;
                        }
                    }
                }
                finally {
                    httpClient.close();
                }
            }
            if (attemptCount <= true) return 0;
            if (done != false) return 0;
            RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.submitServiceDiscoveryRequestBlocking", "Failed to request service discovery information. Too many redirect attempts.");
            return -1;
        }
        catch (URISyntaxException e) {
            return RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.submitServiceDiscoveryRequestBlocking", "failed to submit a request, exception = " + RestReactor.getExceptionCause(e));
        }
        catch (ClientProtocolException e) {
            return RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.submitServiceDiscoveryRequestBlocking", "failed to submit a request, exception = " + RestReactor.getExceptionCause((Exception)e));
        }
        catch (IOException e) {
            return RestReactor.populateErrorInfo(errorInfo, -1, "RestReactor.submitServiceDiscoveryRequestBlocking", "failed to submit a request, exception = " + RestReactor.getExceptionCause(e));
        }
    }

    static int convertResponse(RestReactor RestReactor2, HttpResponse response, RestResponse clientResponse, ReactorErrorInfo errorInfo, String entityString, Exception extractingContentException) {
        if (extractingContentException != null) {
            return RestReactor.populateErrorInfo(errorInfo, -1, "RestHandler.handleResponse", "failed to convert entity to json object, exception = " + RestReactor.getExceptionCause(extractingContentException));
        }
        HttpEntity entity = response.getEntity();
        StatusLine statusLine = response.getStatusLine();
        clientResponse.statusCode(statusLine.getStatusCode());
        clientResponse.statusText(statusLine.getReasonPhrase());
        clientResponse.protocolVersion(statusLine.getProtocolVersion());
        HeaderIterator headerIt = response.headerIterator();
        while (headerIt.hasNext()) {
            Header header = headerIt.nextHeader();
            clientResponse.headerAttribute().put(header.getName(), header.getValue());
        }
        if (entity != null) {
            Header contentType = entity.getContentType();
            if (contentType != null) {
                clientResponse.contentType(entity.getContentType().getValue());
            }
            clientResponse.body(entityString, errorInfo);
        }
        return 0;
    }

    static int processResponse(RestReactor restReactor, RestResponse response, RestEvent event) {
        RestResultClosure resultClosure = event.resultClosure();
        resultClosure.restCallback().RestResponseCallback(response, event);
        return 0;
    }

    static String getExceptionCause(Exception e) {
        String cause = e.getLocalizedMessage();
        if (cause == null) {
            cause = " ";
            for (Throwable test = e.getCause(); test != null; test = test.getCause()) {
                cause = cause + test.getLocalizedMessage();
            }
        }
        return cause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String prepareRequestString(AbstractHttpMessage request, RestConnectOptions restConnectOptions) {
        Header[] headers;
        StringBuilder requestLogBuffer = null;
        try {
            this.lock.lock();
            requestLogBuffer = this.extractFromPool();
        }
        finally {
            this.lock.unlock();
        }
        requestLogBuffer.setLength(0);
        requestLogBuffer.append("The next HTTP request was sent\n");
        requestLogBuffer.append(request.toString() + "\n");
        for (Header header : headers = request.getAllHeaders()) {
            requestLogBuffer.append("    " + header.getName());
            requestLogBuffer.append(": ");
            requestLogBuffer.append(header.getValue());
            requestLogBuffer.append("\n");
        }
        if (restConnectOptions.proxyHost() != null) {
            String proxyPassword;
            requestLogBuffer.append("    Proxy:\n");
            requestLogBuffer.append("        Proxy host: " + restConnectOptions.proxyHost());
            requestLogBuffer.append("\n");
            requestLogBuffer.append("        Proxy port: " + restConnectOptions.proxyPort());
            requestLogBuffer.append("\n");
            String proxyUser = restConnectOptions.proxyUserName();
            if (proxyUser != null) {
                requestLogBuffer.append("        Proxy user: " + proxyUser);
                requestLogBuffer.append("\n");
            }
            if ((proxyPassword = restConnectOptions.proxyPassword()) != null) {
                requestLogBuffer.append("        *** proxy password ***" + proxyUser);
                requestLogBuffer.append("\n");
            }
        } else {
            requestLogBuffer.append("    No proxy is used\n");
        }
        HttpEntity entity = null;
        if (HttpEntityEnclosingRequestBase.class.isAssignableFrom(request.getClass())) {
            entity = ((HttpEntityEnclosingRequestBase)request).getEntity();
        }
        if (BasicHttpEntityEnclosingRequest.class.isAssignableFrom(request.getClass())) {
            entity = ((BasicHttpEntityEnclosingRequest)request).getEntity();
        }
        if (entity != null) {
            Header contentEncoding = entity.getContentEncoding();
            if (contentEncoding != null) {
                requestLogBuffer.append("    " + contentEncoding.getName());
                requestLogBuffer.append(": ");
                requestLogBuffer.append(contentEncoding.getValue());
                requestLogBuffer.append("\n");
            }
            requestLogBuffer.append("    ContentLength: " + entity.getContentLength());
            requestLogBuffer.append("\n");
            Header contentType = entity.getContentType();
            if (contentType != null) {
                requestLogBuffer.append("    " + contentType.getName());
                requestLogBuffer.append(": ");
                requestLogBuffer.append(contentType.getValue());
                requestLogBuffer.append("\n");
            }
            String contentString = null;
            boolean parsed = false;
            try {
                contentString = EntityUtils.toString((HttpEntity)entity);
                parsed = true;
            }
            catch (ParseException e) {
                requestLogBuffer.append("    Invalid content of request:\n");
                parsed = false;
            }
            catch (IOException e) {
                requestLogBuffer.append("    Invalid content of request:\n");
                parsed = false;
            }
            if (contentString != null && !contentString.isEmpty() && parsed) {
                String[] contentComponents;
                requestLogBuffer.append("    Content of request:\n");
                for (String component : contentComponents = contentString.split("&")) {
                    String[] nameValue = component.split("=");
                    if (nameValue.length == 2) {
                        if (AUTH_PASSWORD.equals(nameValue[0])) {
                            nameValue[1] = "<*** password ***>";
                        }
                        if (AUTH_NEWPASSWORD.equals(nameValue[0])) {
                            nameValue[1] = "<*** newPassword ***>";
                        }
                        if (AUTH_CLIENT_SECRET.equals(nameValue[0])) {
                            nameValue[1] = "<*** client_secret ***>";
                        }
                        requestLogBuffer.append("        " + nameValue[0] + ": " + nameValue[1]);
                    } else if (nameValue.length == 1) {
                        requestLogBuffer.append("        " + nameValue[0] + ": N/A");
                    }
                    requestLogBuffer.append("\n");
                }
            }
        }
        requestLogBuffer.append("\n");
        String returnString = requestLogBuffer.toString();
        try {
            this.lock.lock();
            this.returnToPool(requestLogBuffer);
        }
        finally {
            this.lock.unlock();
        }
        return returnString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String prepareResponseString(HttpResponse response, String contentString, Exception extractingContentException) {
        Header[] headers;
        StringBuilder responseLogBuffer = null;
        try {
            this.lock.lock();
            responseLogBuffer = this.extractFromPool();
        }
        finally {
            this.lock.unlock();
        }
        responseLogBuffer.setLength(0);
        responseLogBuffer.append("The next HTTP response was received\n");
        responseLogBuffer.append(response.getStatusLine() + "\n");
        for (Header header : headers = response.getAllHeaders()) {
            responseLogBuffer.append("    " + header.getName());
            responseLogBuffer.append(": ");
            responseLogBuffer.append(header.getValue());
            responseLogBuffer.append("\n");
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            if (contentString != null && !contentString.isEmpty()) {
                responseLogBuffer.append("    Content string:\n");
                responseLogBuffer.append("        " + contentString + "\n");
            } else if (extractingContentException == null) {
                responseLogBuffer.append("    Content string is empty\n");
            } else {
                responseLogBuffer.append("    The next exception is thrown while reading content string:\n");
                responseLogBuffer.append("    " + RestReactor.getExceptionCause(extractingContentException));
                responseLogBuffer.append("\n");
            }
        }
        responseLogBuffer.append("\n");
        String returnString = responseLogBuffer.toString();
        try {
            this.lock.lock();
            this.returnToPool(responseLogBuffer);
        }
        finally {
            this.lock.unlock();
        }
        return returnString;
    }

    private StringBuilder extractFromPool() {
        return this.bufferPool.isEmpty() ? new StringBuilder() : this.bufferPool.remove(this.bufferPool.size() - 1);
    }

    private void returnToPool(StringBuilder buffer) {
        if (!this.bufferPool.contains(buffer)) {
            this.bufferPool.add(buffer);
        }
    }

    HttpResponse executeRequest(HttpRequestBase httpRequest, RestConnectOptions connOptions, HttpClient httpClient, Logger loggerClient) throws IOException {
        HttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)httpRequest);
        }
        catch (Exception e) {
            if (loggerClient.isTraceEnabled()) {
                loggerClient.trace(this.prepareRequestString((AbstractHttpMessage)httpRequest, connOptions));
            }
            throw e;
        }
        if (loggerClient.isTraceEnabled()) {
            loggerClient.trace(this.prepareRequestString((AbstractHttpMessage)httpRequest, connOptions));
        }
        return response;
    }
}

