/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.valueadd.reactor.ReactorErrorInfo;
import com.refinitiv.eta.valueadd.reactor.RestConnectOptions;
import com.refinitiv.eta.valueadd.reactor.RestHandler;
import com.refinitiv.eta.valueadd.reactor.RestReactor;
import com.refinitiv.eta.valueadd.reactor.RestResponse;
import com.sun.security.auth.module.Krb5LoginModule;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Objects;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.KerberosSchemeFactory;
import org.apache.http.impl.auth.NTLMSchemeFactory;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RestProxyAuthHandler {
    static final int BASIC = 16;
    static final int NTLM = 32;
    static final int KERBEROS = 64;
    static final int NEGOTIATE = 128;
    private int authSchemeFlag;
    private SSLConnectionSocketFactory _sslconSocketFactory;
    private RestReactor _restReactor;
    private RequestConfig _defaultRequestConfig;
    private Logger loggerClient = null;
    private static String db;
    private static HashMap<String, String> loginConfigOptions;

    RestProxyAuthHandler(RestReactor restReactor, SSLConnectionSocketFactory sslconSocketFactory) {
        this.clear();
        this._sslconSocketFactory = sslconSocketFactory;
        this._restReactor = restReactor;
        this._defaultRequestConfig = RequestConfig.custom().setAuthenticationEnabled(true).build();
        this.loggerClient = LoggerFactory.getLogger(RestReactor.class);
    }

    void clear() {
        this.authSchemeFlag = 0;
    }

    int executeSync(HttpRequestBase httpRequest, RestConnectOptions connOptions, RestResponse restResponse, ReactorErrorInfo errorInfo) throws ClientProtocolException, IOException {
        return this.execute(httpRequest, connOptions, errorInfo, null, restResponse);
    }

    int executeAsync(HttpRequestBase httpRequest, RestConnectOptions connOptions, RestHandler restHandler, ReactorErrorInfo errorInfo) throws ClientProtocolException, IOException {
        return this.execute(httpRequest, connOptions, errorInfo, restHandler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private int execute(HttpRequestBase httpRequest, RestConnectOptions connOptions, ReactorErrorInfo errorInfo, RestHandler restHandler, RestResponse restResponse) throws ClientProtocolException, IOException {
        done = false;
        block19: for (attemptCount = 0; attemptCount <= 1 && !done; ++attemptCount) {
            httpClient = HttpClientBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)this._sslconSocketFactory).build();
            try {
                response = this._restReactor.executeRequest(httpRequest, connOptions, (HttpClient)httpClient, this.loggerClient);
                entityFromResponse = response.getEntity();
                contentString = null;
                extractingContentException = null;
                try {
                    contentString = EntityUtils.toString((HttpEntity)entityFromResponse);
                    if (Objects.nonNull(restHandler)) {
                        restHandler.contentString(contentString);
                    }
                }
                catch (Exception e) {
                    extractingContentException = e;
                }
                if (this.loggerClient.isTraceEnabled()) {
                    this.loggerClient.trace(this._restReactor.prepareResponseString(response, contentString, extractingContentException));
                }
                switch (response.getStatusLine().getStatusCode()) {
                    case 200: {
                        if (restHandler == null) {
                            RestReactor.convertResponse(this._restReactor, response, restResponse, errorInfo, contentString, extractingContentException);
                        } else {
                            restHandler.completed(response);
                        }
                        done = true;
                        ** break;
lbl27:
                        // 1 sources

                        continue block19;
                    }
                    case 301: 
                    case 302: 
                    case 307: 
                    case 308: {
                        if (restHandler == null) {
                            header = response.getFirstHeader("Location");
                            try {
                                if (header != null && header.getValue() != null) {
                                    httpRequest.setURI(new URI(header.getValue()));
                                    done = false;
                                    ** break;
lbl36:
                                    // 1 sources

                                    continue block19;
                                }
                                RestReactor.populateErrorInfo(errorInfo, -1, "RestProxyAuthHandler.execute", "Failed to send request. Malformed redirection response.");
                                var14_20 = -1;
                                return var14_20;
                            }
                            catch (URISyntaxException e) {
                                RestReactor.populateErrorInfo(errorInfo, -1, "RestProxyAuthHandler.execute", "Failed to request authentication token information with HTTP error " + response.getStatusLine().getStatusCode() + ". Incorrect redirecting.");
                                var15_22 = -1;
                                httpClient.close();
                                return var15_22;
                            }
                        }
                        restHandler.completed(response);
                        done = true;
                        ** break;
lbl51:
                        // 1 sources

                        continue block19;
                    }
                    case 407: {
                        this.processProxyAuthResponse(response);
                        if ((this.authSchemeFlag & 128) != 0) {
                            var13_15 = this.sendKerborosRequest(httpRequest, connOptions, errorInfo, restHandler, restResponse);
                            return var13_15;
                        }
                        if ((this.authSchemeFlag & 64) != 0) {
                            var13_16 = this.sendKerborosRequest(httpRequest, connOptions, errorInfo, restHandler, restResponse);
                            return var13_16;
                        }
                        if ((this.authSchemeFlag & 32) != 0) {
                            var13_17 = this.sendNTLMRequest(httpRequest, connOptions, errorInfo, restHandler, restResponse);
                            return var13_17;
                        }
                        if ((this.authSchemeFlag & 16) != 0) {
                            var13_18 = this.sendBasicAuthRequest(httpRequest, connOptions, errorInfo, restHandler, restResponse);
                            return var13_18;
                        }
                        done = true;
                        ** break;
lbl68:
                        // 1 sources

                        continue block19;
                    }
                    default: {
                        if (restHandler == null) {
                            RestReactor.populateErrorInfo(errorInfo, -1, "RestProxyAuthHandler.execute", "Failed to request authentication token information with HTTP error " + response.getStatusLine().getStatusCode() + ". Text: " + (Objects.nonNull(contentString) != false ? contentString : ""));
                            var13_19 = -1;
                            return var13_19;
                        }
                        restHandler.completed(response);
                        done = true;
                        continue block19;
                    }
                }
                {
                    catch (Throwable var16_23) {
                        throw var16_23;
                    }
                }
            }
            finally {
                httpClient.close();
            }
        }
        if (attemptCount > 1 && !done && restHandler == null) {
            RestReactor.populateErrorInfo(errorInfo, -1, "RestProxyAuthHandler.execute", "Failed to send request. Too many redirect attempts.");
            return -1;
        }
        return 0;
    }

    private void processProxyAuthResponse(HttpResponse httpResponse) {
        Header[] headers = httpResponse.getAllHeaders();
        this.authSchemeFlag = 0;
        for (int index = 0; index < headers.length; ++index) {
            if (headers[index].getName().indexOf("Proxy-Authenticate") == -1) continue;
            if (headers[index].getValue().indexOf("Negotiate") != -1) {
                this.authSchemeFlag |= 0x80;
                continue;
            }
            if (headers[index].getValue().indexOf("Kerberos") != -1) {
                this.authSchemeFlag |= 0x40;
                continue;
            }
            if (headers[index].getValue().indexOf("NTLM") != -1) {
                this.authSchemeFlag |= 0x20;
                continue;
            }
            if (headers[index].getValue().indexOf("Basic") == -1) continue;
            this.authSchemeFlag |= 0x10;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int sendBasicAuthRequest(HttpRequestBase httpRequest, RestConnectOptions connOptions, ReactorErrorInfo errorInfo, RestHandler restHandler, RestResponse restResponse) throws ClientProtocolException, IOException {
        Registry authSchemeRegistry = RegistryBuilder.create().register("Basic", (Object)new BasicSchemeFactory()).build();
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(connOptions.proxyUserName(), connOptions.proxyPassword()));
        HttpClientBuilder httpBuilder = HttpClientBuilder.create().useSystemProperties().setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistry).setDefaultCredentialsProvider((CredentialsProvider)credsProvider).setSSLSocketFactory((LayeredConnectionSocketFactory)this._sslconSocketFactory);
        httpRequest.setConfig(this._defaultRequestConfig);
        try (CloseableHttpClient httpClient = httpBuilder.setProxy(new HttpHost(connOptions.proxyHost(), connOptions.proxyPort())).setProxyAuthenticationStrategy((AuthenticationStrategy)ProxyAuthenticationStrategy.INSTANCE).build();){
            HttpResponse response = this._restReactor.executeRequest(httpRequest, connOptions, (HttpClient)httpClient, this.loggerClient);
            HttpEntity entityFromResponse = response.getEntity();
            String contentString = null;
            Exception extractingContentException = null;
            try {
                contentString = EntityUtils.toString((HttpEntity)entityFromResponse);
                if (Objects.nonNull(restHandler)) {
                    restHandler.contentString(contentString);
                }
            }
            catch (Exception e) {
                extractingContentException = e;
            }
            if (this.loggerClient.isTraceEnabled()) {
                this.loggerClient.trace(this._restReactor.prepareResponseString(response, contentString, extractingContentException));
            }
            if (response.getStatusLine().getStatusCode() != 200) {
                if (restHandler == null) {
                    int n = RestReactor.populateErrorInfo(errorInfo, -1, "RestProxyAuthHandler.sendBasicAuthRequest", "Failed to request authentication token information with HTTP error " + response.getStatusLine().getStatusCode() + ". Text: " + (Objects.nonNull(contentString) ? contentString : ""));
                    return n;
                }
                restHandler.completed(response);
                int n = 0;
                return n;
            }
            if (restHandler == null) {
                RestReactor.convertResponse(this._restReactor, response, restResponse, errorInfo, contentString, extractingContentException);
            } else {
                restHandler.completed(response);
            }
            int n = 0;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int sendNTLMRequest(HttpRequestBase httpRequest, RestConnectOptions connOptions, ReactorErrorInfo errorInfo, RestHandler restHandler, RestResponse restResponse) throws ClientProtocolException, IOException {
        Registry authSchemeRegistry = RegistryBuilder.create().register("NTLM", (Object)new NTLMSchemeFactory()).register("Basic", (Object)new BasicSchemeFactory()).build();
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(connOptions.proxyUserName(), connOptions.proxyPassword()));
        credsProvider.setCredentials(AuthScope.ANY, (Credentials)new NTCredentials(connOptions.proxyUserName(), connOptions.proxyPassword(), connOptions.proxyLocalHostName(), connOptions.proxyDomain()));
        HttpClientBuilder httpBuilder = HttpClientBuilder.create().useSystemProperties().setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistry).setDefaultCredentialsProvider((CredentialsProvider)credsProvider).setSSLSocketFactory((LayeredConnectionSocketFactory)this._sslconSocketFactory);
        httpRequest.setConfig(this._defaultRequestConfig);
        try (CloseableHttpClient httpClient = httpBuilder.setProxy(new HttpHost(connOptions.proxyHost(), connOptions.proxyPort())).setProxyAuthenticationStrategy((AuthenticationStrategy)ProxyAuthenticationStrategy.INSTANCE).build();){
            HttpResponse response = this._restReactor.executeRequest(httpRequest, connOptions, (HttpClient)httpClient, this.loggerClient);
            HttpEntity entityFromResponse = response.getEntity();
            String contentString = null;
            Exception extractingContentException = null;
            try {
                contentString = EntityUtils.toString((HttpEntity)entityFromResponse);
                if (Objects.nonNull(restHandler)) {
                    restHandler.contentString(contentString);
                }
            }
            catch (Exception e) {
                extractingContentException = e;
            }
            if (this.loggerClient.isTraceEnabled()) {
                this.loggerClient.trace(this._restReactor.prepareResponseString(response, contentString, extractingContentException));
            }
            if (response.getStatusLine().getStatusCode() != 200) {
                if (restHandler == null) {
                    int n = RestReactor.populateErrorInfo(errorInfo, -1, "RestProxyAuthHandler.sendNTLMRequest", "Failed to request authentication token information with HTTP error " + response.getStatusLine().getStatusCode() + ". Text: " + (Objects.nonNull(contentString) ? contentString : ""));
                    return n;
                }
                restHandler.completed(response);
                int n = 0;
                return n;
            }
            if (restHandler == null) {
                RestReactor.convertResponse(this._restReactor, response, restResponse, errorInfo, contentString, extractingContentException);
            } else {
                restHandler.completed(response);
            }
            int n = 0;
            return n;
        }
    }

    private int sendKerborosRequest(final HttpRequestBase httpRequest, final RestConnectOptions connOptions, final ReactorErrorInfo errorInfo, final RestHandler restHandler, RestResponse restResponse) throws ClientProtocolException, IOException {
        LoginContext loginCOntext;
        System.setProperty("java.security.krb5.conf", connOptions.proxyKRB5ConfigFile());
        RestProxyAuthHandler.loadLoginConfig();
        try {
            loginCOntext = new LoginContext("etaj-restclient-kerberos", new KerberosCallBackHandler(connOptions.proxyUserName(), connOptions.proxyPassword()));
            loginCOntext.login();
        }
        catch (LoginException e) {
            if (restHandler == null) {
                return RestReactor.populateErrorInfo(errorInfo, -1, "RestProxyAuthHandler.sendKerborosRequest", "Failed to request authentication token information. Text: " + e.getMessage());
            }
            restHandler.failed(e);
            return 0;
        }
        Subject serviceSubject = loginCOntext.getSubject();
        Registry authSchemeRegistry = RegistryBuilder.create().register("NTLM", (Object)new NTLMSchemeFactory()).register("Basic", (Object)new BasicSchemeFactory()).register("Negotiate", (Object)new SPNegoSchemeFactory()).register("Kerberos", (Object)new KerberosSchemeFactory()).build();
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(AuthScope.ANY, (Credentials)new NTCredentials(connOptions.proxyUserName(), connOptions.proxyPassword(), connOptions.proxyLocalHostName(), connOptions.proxyDomain()));
        HttpClientBuilder httpBuilder = HttpClientBuilder.create().useSystemProperties().setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistry).setDefaultCredentialsProvider((CredentialsProvider)credsProvider).setSSLSocketFactory((LayeredConnectionSocketFactory)this._sslconSocketFactory);
        final CloseableHttpClient httpClient = httpBuilder.setProxy(new HttpHost(connOptions.proxyHost(), connOptions.proxyPort())).setProxyAuthenticationStrategy((AuthenticationStrategy)ProxyAuthenticationStrategy.INSTANCE).build();
        httpRequest.setConfig(this._defaultRequestConfig);
        HttpResponse response = Subject.doAs(serviceSubject, new PrivilegedAction<HttpResponse>(){

            @Override
            public HttpResponse run() {
                HttpResponse response = null;
                try {
                    response = RestProxyAuthHandler.this._restReactor.executeRequest(httpRequest, connOptions, (HttpClient)httpClient, RestProxyAuthHandler.this.loggerClient);
                }
                catch (IOException e) {
                    if (restHandler == null) {
                        RestReactor.populateErrorInfo(errorInfo, -1, "RestProxyAuthHandler.sendKerborosRequest", "Failed to request authentication token information. Text: " + e.getMessage());
                    } else {
                        restHandler.failed(e);
                    }
                }
                finally {
                    try {
                        httpClient.close();
                    }
                    catch (IOException iOException) {}
                }
                return response;
            }
        });
        if (response != null) {
            HttpEntity entityFromResponse = response.getEntity();
            String contentString = null;
            Exception extractingContentException = null;
            try {
                contentString = EntityUtils.toString((HttpEntity)entityFromResponse);
                if (Objects.nonNull(restHandler)) {
                    restHandler.contentString(contentString);
                }
            }
            catch (Exception e) {
                extractingContentException = e;
            }
            if (this.loggerClient.isTraceEnabled()) {
                this.loggerClient.trace(this._restReactor.prepareResponseString(response, contentString, extractingContentException));
            }
            if (response.getStatusLine().getStatusCode() != 200) {
                if (restHandler == null) {
                    return RestReactor.populateErrorInfo(errorInfo, -1, "RestProxyAuthHandler.sendKerborosRequest", "Failed to request authentication token information with HTTP error " + response.getStatusLine().getStatusCode() + ". Text: " + (Objects.nonNull(contentString) ? contentString : ""));
                }
                restHandler.completed(response);
            } else if (restHandler == null) {
                RestResponse resp = new RestResponse();
                RestReactor.convertResponse(this._restReactor, response, resp, errorInfo, contentString, extractingContentException);
            } else {
                restHandler.completed(response);
            }
        } else {
            return -1;
        }
        try {
            loginCOntext.logout();
        }
        catch (LoginException loginException) {
            // empty catch block
        }
        return 0;
    }

    private static void loadLoginConfig() {
        Configuration.setConfiguration(new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String cname) {
                String name = Krb5LoginModule.class.getName();
                loginConfigOptions.put("com.sun.security.auth.module.Krb5LoginModule", "required");
                String useTC = System.getProperty("krb_login_config_useTicketCache");
                if (useTC != null && useTC.equals("true")) {
                    String TC;
                    loginConfigOptions.put("useTicketCache", "true");
                    String doNotPrompt = System.getProperty("krb_login_config_doNotPrompt");
                    if (doNotPrompt != null && doNotPrompt.equals("true")) {
                        loginConfigOptions.put("doNotPrompt", "true");
                    }
                    if ((TC = System.getProperty("krb_login_config_ticketCache")) != null && !TC.isEmpty()) {
                        loginConfigOptions.put("ticketCache", TC);
                    }
                }
                if ((db = System.getProperty("javax.net.debug")) != null && db.equals("all")) {
                    loginConfigOptions.put("debug", "true");
                }
                AppConfigurationEntry ace = new AppConfigurationEntry(name, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, loginConfigOptions);
                AppConfigurationEntry[] entry = new AppConfigurationEntry[]{ace};
                return entry;
            }
        });
    }

    static {
        loginConfigOptions = new HashMap();
    }

    private static class KerberosCallBackHandler
    implements CallbackHandler {
        private final String user;
        private final String password;

        public KerberosCallBackHandler(String user, String password) {
            this.user = user;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callback;
                    nc.setName(this.user);
                    continue;
                }
                if (!(callback instanceof PasswordCallback)) continue;
                PasswordCallback pc = (PasswordCallback)callback;
                pc.setPassword(this.password.toCharArray());
            }
        }
    }
}

