/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.valueadd.reactor.ReactorConnectInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorWarmStandbyGroup;
import com.refinitiv.eta.valueadd.reactor.ReactorWarmStandbyGroupImpl;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class ReactorConnectOptions {
    private final int DEFAULT_DELAY = 1000;
    List<ReactorConnectInfo> _connectionList;
    int _reconnectAttemptLimit;
    int _reconnectMinDelay = 1000;
    int _reconnectMaxDelay = 1000;
    List<ReactorWarmStandbyGroup> _reactorWarmStandyGroupList = new LinkedList<ReactorWarmStandbyGroup>();

    ReactorConnectOptions() {
        this._connectionList = new ArrayList<ReactorConnectInfo>(10);
    }

    public List<ReactorConnectInfo> connectionList() {
        return this._connectionList;
    }

    public int reconnectAttemptLimit() {
        return this._reconnectAttemptLimit;
    }

    public int reconnectAttemptLimit(int limit) {
        if (limit < -1) {
            return -4;
        }
        this._reconnectAttemptLimit = limit;
        return 0;
    }

    public int reconnectMinDelay() {
        return this._reconnectMinDelay;
    }

    public int reconnectMinDelay(int delay) {
        if (delay < 0) {
            return -4;
        }
        this._reconnectMinDelay = delay < 1000 ? 1000 : delay;
        if (this._reconnectMaxDelay < this._reconnectMinDelay) {
            this._reconnectMaxDelay = this._reconnectMinDelay;
        }
        return 0;
    }

    public int reconnectMaxDelay() {
        return this._reconnectMaxDelay;
    }

    public int reconnectMaxDelay(int delay) {
        if (delay < 0 || delay < this._reconnectMinDelay) {
            return -4;
        }
        this._reconnectMaxDelay = this._reconnectMaxDelay < this._reconnectMinDelay ? this._reconnectMinDelay : delay;
        return 0;
    }

    public void clear() {
        this._connectionList.clear();
        this._reconnectAttemptLimit = 0;
        this._reconnectMinDelay = 1000;
        this._reconnectMaxDelay = 1000;
        this._reactorWarmStandyGroupList.clear();
    }

    public int copy(ReactorConnectOptions destOpts) {
        int i;
        if (destOpts == null) {
            return -1;
        }
        destOpts._connectionList.clear();
        for (i = 0; i < this._connectionList.size(); ++i) {
            ReactorConnectInfo reactorConnectInfo = new ReactorConnectInfo();
            this._connectionList.get(i).copy(reactorConnectInfo);
            destOpts._connectionList.add(reactorConnectInfo);
        }
        destOpts._reactorWarmStandyGroupList.clear();
        for (i = 0; i < this._reactorWarmStandyGroupList.size(); ++i) {
            ReactorWarmStandbyGroupImpl wsbGroup = new ReactorWarmStandbyGroupImpl();
            ((ReactorWarmStandbyGroupImpl)this._reactorWarmStandyGroupList.get(i)).copy(wsbGroup);
            destOpts._reactorWarmStandyGroupList.add(wsbGroup);
        }
        destOpts._reconnectAttemptLimit = this._reconnectAttemptLimit;
        destOpts._reconnectMinDelay = this._reconnectMinDelay;
        destOpts._reconnectMaxDelay = this._reconnectMaxDelay;
        return 0;
    }

    public List<ReactorWarmStandbyGroup> reactorWarmStandbyGroupList() {
        return this._reactorWarmStandyGroupList;
    }
}

